#!/bin/sh 
#
BAVERSION=4.0.1_GOst
BOXTYPE="UFS-910"
#
#

echo "HDMount V.$BAVERSION started"

if [ -f /config/.badevice ]; then
   USB_DEVICE=`cat /config/.badevice` 
else
   USB_DEVICE=/dev/sda1  
fi
USB_DEVICE=`echo "$USB_DEVICE" | sed s/1/""/g`
if [ $USB_DEVICE = "/dev/sda" ]; then
  HDD_DEVICE=/dev/sdb
else
  HDD_DEVICE=/dev/sda
fi  

#
sleep 30
# 

mkdir /data/baroot
mkdir /data/baroot/kathrein
chmod 444 /data/baroot/kathrein

TEST=false
for i in 1 2 3 4 5 6 7 8 9 10; do
  HDROOT=`df | grep $HDD_DEVICE | cut -d % -f 2- | cut -c 2-`
  if [ "$HDROOT" ]; then
    chmod 666 /data/baroot/kathrein
    TEST=true
    break
  fi
  sleep 6  
done
if [ $TEST = "false" ]; then
  echo "record device $HDD_DEVICE not found (TIMEOUT)"
  exit 32
fi  
     
if [ -f `mount -o bind "$HDROOT/kathrein" "/data/baroot/kathrein"` ]; then
  echo "Stick and HD ($HDROOT) successfully linked"
  exit 0
else 
  echo "Recording directory $HDROOT on device $HDD_DEVICE could not be linked"
  chmod 444 /data/baroot/kathrein
  exit 16
fi   
