#!/bin/sh 
# 
# UFS-910 Barry Allen by gutemine
#
# GOst Erweiterung fr AAF-Image 
# 
#
BAVERSION=5.4.5_tested_by_AAF_Team
BOXTYPE="UFS-910"
#
LINE="-----------------------------------------------------"
ECHO="echo -n"
CR="echo"

BALOG=/tmp/ba.log
#

if [ `pwd | grep /var/baroot/ba | wc -l` -lt 1 ]; then

  if [ `df | grep /tmp/usb/XBA | wc -l` -gt 1 ]; then
    echo "mehere Devices mit dem Label XBA... gefunden"
    echo "erlaubt ist ein Device mit dem Label XBA"
    echo "ba.sh wird abgebrochen"
    exit 1
  fi  

  BAROOT=`df | grep /tmp/usb/XBA | cut -d % -f 2- | cut -c 2-`
  if [ ! "$BAROOT" ]; then
    BAROOT=`df | grep /tmp/usb/BA | cut -d % -f 2- | cut -c 2-`
    if [ ! "$BAROOT" ]; then
      echo "error: Barry Allen device not found"
      exit 16
    fi  
  fi  
  #
  USB_DEVICE=`df | grep /tmp/usb/XBA | cut -d " " -f 1`
  if [ ! "$USB_DEVICE" ]; then
    USB_DEVICE=`df | grep /tmp/usb/BA | cut -d " " -f 1`
  fi 
  
else
  BAROOT=/var/baroot
  USB_DEVICE=`df | grep /var/baroot | cut -d " " -f 1` 
fi   
#

BAHOME="$BAROOT/ba"
BAINFO=".bainfo"
BABOOT="$BAHOME/.baboot"
BAIMAGE="$BAROOT/UFS_Images"
BAMAXIMAGES=12
INSTALLDIR=/tmp
BATMP=$INSTALLDIR/.batmp
ERASETMP=/tmp/erase.cmd
TMP=/tmp/bahelp.tmp

#HDROOT="/tmp/usb/Harddisk (1)"
#if [ -f /config/.hddirectory ]; then
#   HDROOT=`cat /config/.hddirectory`
#fi
#HD_DEVICE=/dev/dummy
#if [ -f /config/.hddevice ]; then
#   HD_DEVICE=`cat /config/.hddevice` 
#fi

echo $LINE
if [ -f "$BAHOME/ba.sh" ]; then
   $ECHO "$BOXTYPE Barry Allen Version $BAVERSION running on USB stick"
   $CR
   echo $LINE
else
   if [ $# -gt 0 ]; then
      if [ $1 != "install" -a $1 != "makekit" -a $1 != "update" ]; then
         $ECHO "$BOXTYPE Barry Allen Version $BAVERSION no device found , Sorry"
         $CR
         echo $LINE
         exit 1
      fi
   fi
fi   

#if [ ! -d "$BAROOT/UFS_Images" ]; then
#   $ECHO "UFS_Images will be created on $BAROOT/UFS_Images"
#   $CR
#   echo $LINE
#   mkdir "$BAROOT/UFS_Images" > /dev/null 2>&1
#   BAIMAGE="$BAROOT/UFS_Images"
#fi

case "$1" in
   "start" | "boot")
   if [ $# -lt 2 ]; then
      $ECHO "No Target Image passed  - Flash will be used"
      $CR
      echo $LINE
      TARGET="Flash"
   else
      TARGET=$2
   fi

   if [ $TARGET  != "Flash" ]; then
      if [ ! -d "$BAHOME/ba/$TARGET" ]; then
         $ECHO "ERROR: Target Image Directory $BAHOME/ba/$TARGET is not existing"
         $CR
         echo $LINE
         exit 1
      else
         $ECHO "Barry Allen boots Image $TARGET at $BAHOME/ba/$TARGET next ..."
         $CR
         echo $LINE
         echo "$TARGET" > "$BAHOME/.baboot"
         sleep 2
         sync
         sleep 2
      fi
   else
      echo "$TARGET" > "$BAHOME/.baboot"
      # don't ask why
      echo "$TARGET" > "$BAHOME/.baboot"
      sync > /dev/null 2>&1
      $ECHO "Barry Allen boots $TARGET next ..."
      $CR
      echo $LINE
   fi
   if [ $# -gt 2 ]; then
      if [ $3 = "now" ]; then
         $ECHO "Barry Allen reboots $BOXTYPE now ..."
         $CR
         echo $LINE
         sleep 2
         sync
         sleep 2
         reboot -f > /dev/null 2>&1
         sleep 4
         reboot > /dev/null 2>&1
      fi
   fi
  ;;
  shutdown | halt)
  $ECHO "Barry Allen halts $BOXTYPE now ..."
  $CR
  echo $LINE
  sync > /dev/null 2>&1
  halt > /dev/null 2>&1
  exit 0
  ;;
  reboot)
  $ECHO "Barry Allen reboots $BOXTYPE now ..."
  $CR
  echo $LINE
  sync > /dev/null 2>&1
  reboot -f > /dev/null 2>&1
  reboot > /dev/null 2>&1
  exit 0
  ;;

  imgextract | extract_img )
  BATOOLS="$BAHOME/tools"
  if [ -f /$BAINFO ]; then
     BOOTED=`cat /$BAINFO`
  else
     BOOTED="Flash"
  fi
  if [ $# -lt 2 ]; then
     $ECHO "ERROR: no Image directory name given for extracting from $BAIMAGE"
     $CR
     echo "$LINE"
     exit 1
  else
     SOURCE=$2
     if [ $# -gt 2 ]; then
        TARGET=$3
     else
        TARGET=$2
     fi
  fi
  if [ ! -d "$BAIMAGE/$SOURCE" ]; then
     $ECHO "ERROR: Image directory $BAIMAGE/$SOURCE is not existing"
     $CR
     echo "$LINE"
     exit 1
  fi
  if [ $TARGET = "Flash" ]; then
     $ECHO "ERROR: can't extract to Flash"
     $CR
     echo "$LINE"
     exit 1
  fi
  if [ $BOOTED = $TARGET ]; then
     $ECHO "ERROR: Image $BAHOME/ba/$TARGET currently booted, can't extract there"
     $CR
     echo "$LINE"
     exit 1
  fi
  if [ `ls -1 "$BAHOME/ba" | grep -v Flash | wc -l` -gt `expr $BAMAXIMAGES "-" 1` ]; then
     $ECHO "ERROR: maximum $BAMAXIMAGES images reached"
     $CR
     echo "$LINE"
     exit 1
  fi
  if [ -d "$BAHOME/ba/$TARGET" ]; then
     $ECHO "Target $TARGET already exists, delete first"
     $CR
     echo "$LINE"
     exit 1
  fi

  $ECHO "Extracting to $TARGET from $BAIMAGE/$SOURCE - be patient ..." 
  $CR
  echo "$LINE"
  if [ `cat /proc/meminfo | grep "SwapTotal:           0 kB" | wc -l` -eq 0 ]; then
    $ECHO "Swapfile aktiv"
    $CR
    SSTATUS=true
  else  
    $ECHO "Swapfile started"
    $CR
    echo "$LINE"
    dd if=/dev/zero of="$BAROOT"/swapfile bs=1024 count=16384
    "$BATOOLS/mkswap" "$BAROOT"/swapfile
    "$BATOOLS/swapon" "$BAROOT"/swapfile
    sync
    SSTATUS=false
  fi  
  mkdir -p "$BAHOME/ba/$TARGET"
  #
  $ECHO "Image Extract started"
  $CR
  echo "$LINE"
  #
  IMAGE=`ls "$BAIMAGE/$SOURCE/"*root*.img`
  if [ ! -f "$IMAGE" ]; then 
    IMAGE=`ls "$BAIMAGE/$SOURCE/"*root*.update*`
  fi  
  if [ -f "$IMAGE" ]; then 
     $ECHO "extracting root.img ..."
     $CR
     #dd if="$IMAGE" of="$BAIMAGE/$SOURCE/root_cut.img" bs=16 skip=1 > /dev/null 2>&1
     dd if="$IMAGE" of="/tmp/root_cut.img" bs=16 skip=1 > /dev/null 2>&1
     sync
     $ECHO "trying squashfs filesystem"
     $CR
     #cd "$BAIMAGE/$SOURCE"
     cd /tmp
     "$BATOOLS/unsquashfs-lzma" root_cut.img > /dev/null 2>&1
     sync
     cp -RP squashfs-root/* "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     rm -r squashfs-root > /dev/null 2>&1
     if [ `ls -1 "$BAHOME/ba/$TARGET" | wc -l` -eq 0 ]; then
        $ECHO "trying cramfs filesystem"
        $CR
        cd /tmp
        "$BATOOLS/cramfsck" -x ./cramfs-root root_cut.img
        sync
        cp -RP cramfs-root/* "$BAHOME/ba/$TARGET"
        rm -r cramfs-root > /dev/null 2>&1
        #mkdir "$BAIMAGE/$SOURCE/root" 
        #mount -t cramfs -o loop  "$BAIMAGE/$SOURCE/root_cut.img" "$BAIMAGE/$SOURCE/root"
        #cp -RP "$BAIMAGE/$SOURCE/root/*" "$BAHOME/ba/$TARGET"
        #umount "$BAIMAGE/$SOURCE/root"
        #rm -r  "$BAIMAGE/$SOURCE/root"
     fi
     rm root_cut.img
     
  else
     $ECHO "root.img file not found at $BAIMAGE/$SOURCE"
     $CR
     echo "Kopiere root vom aktiven Image"
     cp -RP /usr "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     cp -RP /sys "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     cp -RP /bin "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     cp -RP /boot "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     cp -RP /share "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     cp -RP /sbin "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     cp -RP /root "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     cp -RP /program "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     cp -RP /misc "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     cp -RP /etc "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     cp -RP /home "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     cp -RP /lib "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     cp -RP /dev_org "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     cp -RP /data "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     cp -RP /config "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     #cp -RP /app "$BAHOME/ba/$TARGET" > /dev/null 2>&1
  fi
  sync
  #
  IMAGE=`ls "$BAIMAGE/$SOURCE/"*conf*.img`
  if [ ! -f "$IMAGE" ]; then 
    IMAGE=`ls "$BAIMAGE/$SOURCE/"*conf*.update*`
  fi  
  if [ -f "$IMAGE" ]; then 
     $ECHO "extracting config.img ..."
     $CR
     #dd if="$IMAGE" of="$BAIMAGE/$SOURCE/config_cut.img" bs=16 skip=1 > /dev/null 2>&1
     dd if="$IMAGE" of="/tmp/config_cut.img" bs=16 skip=1 > /dev/null 2>&1
     sync
     $ECHO "using jffs2 filesystem"
     $CR
     cd "$BAIMAGE/$SOURCE"
#     mkdir "$BAIMAGE/$SOURCE/config"
#    mkfs.jffs2 "$BAIMAGE/$SOURCE/config.jffs2"
#    dd if="$BAIMAGE/$SOURCE/config_cut.img"  of="$BAIMAGE/$SOURCE/config.jffs2"
#     mount -t jffs2 "$BAIMAGE/$SOURCE/config.jffs2"  "$BAIMAGE/$SOURCE/config"
     cd /tmp
     "$BATOOLS/dump" config_cut.img ./config 1234 
     sync
     cp -RP "./config" "$BAHOME/ba/$TARGET" > /dev/null 2>&1
#     umount "$BAIMAGE/$SOURCE/config"
#     rm    "$BAIMAGE/$SOURCE/config.jffs2"
     rm -r "./config" > /dev/null 2>&1
     rm    "config_cut.img" > /dev/null 2>&1
  else
     $ECHO "config.img file not found at $BAIMAGE/$SOURCE"
     $CR
     mkdir "$BAHOME/ba/$TARGET/config"
  fi
  sync
  #    
  IMAGE=`ls "$BAIMAGE/$SOURCE/"*dat*.img` 
  if [ ! -f "$IMAGE" ]; then 
    IMAGE=`ls "$BAIMAGE/$SOURCE/"*dat*.update*`
  fi        
  if [ -f "$IMAGE" ]; then 
     $ECHO "extracting data.img ..."
     $CR
     #dd if="$IMAGE" of="$BAIMAGE/$SOURCE/data_cut.img" bs=16 skip=1 > /dev/null 2>&1
     dd if="$IMAGE" of="/tmp/data_cut.img" bs=16 skip=1 > /dev/null 2>&1
     sync
     $ECHO "using jffs2 filesystem"
     $CR
     cd /tmp
     "$BATOOLS/dump" data_cut.img ./data 1234
     sync
     cp -RP "./data" "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     rm -r "./data" > /dev/null 2>&1
     rm    "data_cut.img" > /dev/null 2>&1
  else
     $ECHO "data.img file not found at $BAIMAGE/$SOURCE"
     $CR
     mkdir "$BAHOME/ba/$TARGET/data"
  fi
  sync
  #
  IMAGE=`ls "$BAIMAGE/$SOURCE/"*var*.img` 
  if [ ! -f "$IMAGE" ]; then 
    IMAGE=`ls "$BAIMAGE/$SOURCE/"*var*.update*`
  fi       
  if [ -f "$IMAGE" ]; then 
     $ECHO "extracting var.img ..."
     $CR
     dd if="$IMAGE" of="/tmp/var_cut.img" bs=16 skip=1 > /dev/null 2>&1
     sync
     $ECHO "using jffs2 filesystem"
     $CR
     cd /tmp
     "$BATOOLS/dump" var_cut.img ./var 1234
     cp -RP "./var" "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     rm -r "./var" > /dev/null 2>&1
     rm    "var_cut.img" > /dev/null 2>&1
  else
     $ECHO "var.img file not found at $BAIMAGE/$SOURCE"
     $CR
     mkdir "$BAHOME/ba/$TARGET/var" > /dev/null 2>&1
  fi
  sync
  #
  IMAGE=`ls "$BAIMAGE/$SOURCE/"*app*.img`
  if [ ! -f "$IMAGE" ]; then 
    IMAGE=`ls "$BAIMAGE/$SOURCE/"*app*.update*`
  fi  
  if [ -f "$IMAGE" ]; then 
     $ECHO "extracting app.img ..."
     $CR
     #dd if="$IMAGE" of="$BAIMAGE/$SOURCE/app_cut.img" bs=16 skip=1 > /dev/null 2>&1
     dd if="$IMAGE" of="/tmp/app_cut.img" bs=16 skip=1 > /dev/null 2>&1
     sync
     $ECHO "trying squashfs filesystem"
     $CR
     #$dd "$BAIMAGE/$SOURCE"
     cd "$BAHOME/ba/$TARGET"
     "$BATOOLS/unsquashfs-lzma" /tmp/app_cut.img > /dev/null 2>&1
     mkdir "$BAHOME/ba/$TARGET/app" > /dev/null 2>&1
     cp -RP squashfs-root/* "$BAHOME/ba/$TARGET/app" > /dev/null 2>&1
     sync
     rm -r squashfs-root > /dev/null 2>&1 
     if [ `ls -1 "$BAHOME/ba/$TARGET/app" | wc -l` -eq 0 ]; then
        $ECHO "trying cramfs filesystem"
        $CR
        cd "$BAHOME/ba/$TARGET"
        rm -r  "./app" > /dev/null 2>&1
        cd /tmp 
        "$BATOOLS/cramfsck" -x "$BAHOME/ba/$TARGET/app" app_cut.img
        sync
        rm -r  "./app" > /dev/null 2>&1
        rm     "app_cut.img" > /dev/null 2>&1
     fi
  else
     $ECHO "app.img file not found at $BAIMAGE/$SOURCE"
     $CR
     mkdir "$BAHOME/ba/$TARGET/app"
  fi
  sync
  
#
# postinstallation directory creation - just to make sure that they exist
#
  mkdir "$BAHOME/ba/$TARGET/var" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/tmp" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/hdd" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/mnt" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/mnt/usb" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/mnt/extern-usb" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/mnt/intern-sata" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/mnt/nfs" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/ramdisk" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/proc" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/dev" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/root" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/devel" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/data/baroot" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/data/baroot/kathrein" > /dev/null 2>&1

  cd "$BAHOME/ba/$TARGET"
  ln -sfn /bin/busybox linuxrc
  ln -sfn "$BAHOME" ba
  cp "$BAHOME/bainit" "$BAHOME/ba/$TARGET/etc/init.d/bainit"
  cp "$BAHOME/checkhdmount.sh" "$BAHOME/ba/$TARGET/data/checkhdmount.sh"
  chmod 755 "$BAHOME/ba/$TARGET/etc/init.d/bainit" > /dev/null 2>&1
  chmod 755 "$BAHOME/ba/$TARGET/config/start.sh" > /dev/null 2>&1
  chmod 755 "$BAHOME/ba/$TARGET/data/checkhdmount.sh" > /dev/null 2>&1
  
  if [ `grep "/dev/mtdblock" "$BAHOME/ba/$TARGET/etc/fstab" | wc -l` -gt 0 ]; then
     grep -v /dev/mtdblock "$BAHOME/ba/$TARGET/etc/fstab"  > $BATMP
     cp $BATMP "$BAHOME/ba/$TARGET/etc/fstab"
  fi
  if [ `grep "ramfs" "$BAHOME/ba/$TARGET/etc/fstab" | wc -l` -gt 0 ]; then
     grep -v "ramfs" "$BAHOME/ba/$TARGET/etc/fstab" > $BATMP
     cp $BATMP "$BAHOME/ba/$TARGET/etc/fstab"
  fi
  if [ -f "$BAHOME/ba/$TARGET/config/start.sh" ]; then
     # remove bainit from start.sh in USB stick to prevent recursive calls !
     grep -v "/config/bainit" "$BAHOME/ba/$TARGET/config/start.sh" > $BATMP
     cp $BATMP "$BAHOME/ba/$TARGET/config/start.sh"
  fi
  if [ -f "$BAROOT/ba/ba/$TARGET/config/start-ext.sh" ]; then
    grep -v "/config/bainit" "$BAROOT/ba/ba/$TARGET/config/start-ext.sh" > $BATMP
    cp $BATMP "$BAROOT/ba/ba/$TARGET/config/start-ext.sh"
  fi
  if [ -f "$BAHOME/ba/$TARGET/etc/init.d/rcS" ]; then
     # get rid of ramfs mounts (will be bind mountet from flash)
     grep -v "/bin/mount -t ramfs" "$BAHOME/ba/$TARGET/etc/init.d/rcS" > $BATMP
     cp $BATMP "$BAHOME/ba/$TARGET/etc/init.d/rcS"
  fi
  if [ -f "$BAHOME/ba/$TARGET/etc/init.d/rc" ]; then
     # get rid of ramfs mounts (will be bind mountet from flash)
     grep -v "/bin/mount -t ramfs" "$BAHOME/ba/$TARGET/etc/init.d/rc" > $BATMP
     cp $BATMP "$BAHOME/ba/$TARGET/etc/init.d/rc"
  fi
  if [ -f "$BAHOME/ba/$TARGET/etc/init.d/pvrinit" ]; then
     grep -v "/bin/mount -t ramfs" "$BAHOME/ba/$TARGET/etc/init.d/pvrinit" > $BATMP
     cp $BATMP "$BAHOME/ba/$TARGET/etc/init.d/pvrinit"
     chmod 755 "$BAHOME/ba/$TARGET/etc/init.d/pvrinit"
  fi

  echo "$TARGET" > "$BAHOME/ba/$TARGET/$BAINFO"
  sleep 2
  sync
  sleep 2
  if [ $SSTATUS = "false" ]; then 
    echo "$LINE"
    $ECHO "Swapfile stopped"
    $CR
    echo "$LINE"
    "$BATOOLS/swapoff"  "$BAROOT"/swapfile
  fi  
  sync
  $ECHO "Image Extract finished"
  $CR
  echo $LINE
  ;;
  
  extract | gzextract | extract_gz | restore | gzrestore | restore_gz )
  if [ -f /$BAINFO ]; then
     BOOTED=`cat /$BAINFO`
  else
     BOOTED="Flash"
  fi
  if [ $# -lt 2 ]; then
     $ECHO "ERROR: no tar.gz filename given for extracting from $BAIMAGE"
     $CR
     echo $LINE
     exit 1
  else
     SOURCE=$2
     if [ $# -gt 2 ]; then
        TARGET=$3
     else
        TARGET=$2
     fi
  fi
  if [ ! -f "$BAIMAGE/$SOURCE.tar.gz" ]; then
     $ECHO "ERROR: Image File $BAIMAGE/$SOURCE.tar.gz is not existing"
     $CR
     echo $LINE
     exit 1
  fi
  if [ $TARGET = "Flash" ]; then
     $ECHO "ERROR: can't extract to Flash"
     $CR
     echo $LINE
     exit 1
  fi
  if [ $BOOTED = $TARGET ]; then
     $ECHO "ERROR: Image $BAHOME/ba/$TARGET currently booted, can't extract there"
     $CR
     echo $LINE
     exit 1
  fi
  if [ `ls -1 "$BAHOME/ba" | grep -v Flash | wc -l` -gt `expr $BAMAXIMAGES "-" 1` ]; then
     $ECHO "ERROR: maximum $BAMAXIMAGES images reached"
     $CR
     echo $LINE
     exit 1
  fi
  if [ -d "$BAHOME/ba/$TARGET" ]; then
     $ECHO "Target $TARGET already exists, delete first"
     $CR
     echo $LINE
     exit 1
  fi

  $ECHO "Extracting to $TARGET from $BAIMAGE/$SOURCE.tar.gz now - be patient ..." 
  $CR
  echo $LINE
  mkdir -p "$BAHOME/ba/$TARGET"
  cd "$BAHOME/ba/$TARGET"
  tar -xzf "$BAIMAGE/$SOURCE.tar.gz"
  mkdir "$BAHOME/ba/$TARGET/var" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/tmp" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/hdd" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/mnt" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/mnt/usb" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/mnt/extern-usb" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/mnt/intern-sata" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/mnt/nfs" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/ramdisk" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/proc" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/dev" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/root" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/devel" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/data/baroot" > /dev/null 2>&1
  mkdir "$BAHOME/ba/$TARGET/data/baroot/kathrein" > /dev/null 2>&1
  cd "$BAHOME/ba/$TARGET"
  ln -sfn /bin/busybox linuxrc
  ln -sfn "$BAHOME" ba
  cp "$BAHOME/checkhdmount.sh" "$BAHOME/ba/$TARGET/data/checkhdmount.sh" > /dev/null 2>&1
  cp "$BAHOME/bainit" "$BAHOME/ba/$TARGET/etc/init.d/bainit"
  chmod 755 "$BAHOME/ba/$TARGET/etc/init.d/bainit" > /dev/null 2>&1
  chmod 755 "$BAHOME/ba/$TARGET/config/start.sh" > /dev/null 2>&1
  chmod 755 "$BAHOME/ba/$TARGET/data/checkhdmount.sh" > /dev/null 2>&1
  
  if [ `grep "/dev/mtdblock" "$BAHOME/ba/$TARGET/etc/fstab" | wc -l` -gt 0 ]; then
     grep -v /dev/mtdblock "$BAHOME/ba/$TARGET/etc/fstab"  > $BATMP
     cp $BATMP "$BAHOME/ba/$TARGET/etc/fstab"
  fi
  if [ `grep "ramfs" "$BAHOME/ba/$TARGET/etc/fstab" | wc -l` -gt 0 ]; then
     grep -v "ramfs" "$BAHOME/ba/$TARGET/etc/fstab" > $BATMP
     cp $BATMP "$BAHOME/ba/$TARGET/etc/fstab"
  fi
  if [ -f "$BAHOME/ba/$TARGET/config/start.sh" ]; then
     # remove bainit from start.sh in USB stick to prevent recursive calls !
     grep -v "/config/bainit" "$BAHOME/ba/$TARGET/config/start.sh" > $BATMP
     cp $BATMP "$BAHOME/ba/$TARGET/config/start.sh"
  fi
  if [ -f "$BAHOME/ba/$TARGET/etc/init.d/rcS" ]; then
     # get rid of ramfs mounts (will be bind mountet from flash)
     grep -v "/bin/mount -t ramfs" "$BAHOME/ba/$TARGET/etc/init.d/rcS" > $BATMP
     cp $BATMP "$BAHOME/ba/$TARGET/etc/init.d/rcS"
  fi
  if [ -f "$BAHOME/ba/$TARGET/etc/init.d/rc" ]; then
     # get rid of ramfs mounts (will be bind mountet from flash)
     grep -v "/bin/mount -t ramfs" "$BAHOME/ba/$TARGET/etc/init.d/rc" > $BATMP
     cp $BATMP "$BAHOME/ba/$TARGET/etc/init.d/rc"
  fi
  if [ -f "$BAHOME/ba/$TARGET/etc/init.d/pvrinit" ]; then
     grep -v "/bin/mount -t ramfs" "$BAHOME/ba/$TARGET/etc/init.d/pvrinit" > $BATMP
     cp $BATMP "$BAHOME/ba/$TARGET/etc/init.d/pvrinit"
     chmod 755 "$BAHOME/ba/$TARGET/etc/init.d/pvrinit"
  fi
  echo $TARGET > "$BAHOME/ba/$TARGET/$BAINFO"
  sleep 2
  sync
  sleep 2
  echo $LINE
  $ECHO "Extract finished"
  $CR
  echo $LINE
  ;;
  imgbackup | backup_img  | imagebackup )
  if [ -f /$BAINFO ]; then
     $ECHO "works only when booted from Flash"
     $CR
     echo $LINE
     exit 1
  fi
  if [ $# -lt 2 ]; then
     $ECHO "ERROR: No target passed"
     $CR
     echo $LINE
     exit 1
  else
     TARGET=$2
  fi
  if [ -d "$BAIMAGE/$TARGET" ]; then
        $ECHO "ERROR: Target Image directoy $BAIMAGE/$TARGET already exists, please rename"
        $CR
        echo $LINE
        exit 1
  else
     mkdir "$BAIMAGE/$TARGET" 
  fi
   
  $ECHO "Dumping from Flash to $BAIMAGE/$TARGET/*.img now - be patient ..." 
  $CR
  echo $LINE
  $ECHO "dumping Kernel ..." 
  $CR
  cat /dev/mtdblock1 > "$BAIMAGE/$TARGET/mtdblock1.img"
  $ECHO "dumping Config ..." 
  $CR
  cat /dev/mtdblock2 > "$BAIMAGE/$TARGET/mtdblock2.img"
  $ECHO "dumping Root ..." 
  $CR
  cat /dev/mtdblock3 > "$BAIMAGE/$TARGET/mtdblock3.img"
  $ECHO "dumping Modules ..." 
  $CR
  cat /dev/mtdblock4 > "$BAIMAGE/$TARGET/mtdblock4.img"
  $ECHO "dumping Emergency Root ..." 
  $CR
  cat /dev/mtdblock5 > "$BAIMAGE/$TARGET/mtdblock5.img"
  $ECHO "dumping Data ..." 
  $CR
  cat /dev/mtdblock6 > "$BAIMAGE/$TARGET/mtdblock6.img"
  echo $LINE
  $ECHO "Flash Image Backup finished"
  $CR
  echo $LINE
  ;;
  backup | gzbackup | backup_gz )
  if [ -f /$BAINFO ]; then
     BOOTED=`cat /$BAINFO`
  else
     BOOTED="Flash"
  fi
  if [ $# -lt 2 ]; then
     $ECHO "ERROR: No source passed"
     $CR
     echo $LINE
     exit 1
  else
     SOURCE=$2
     REALSOURCE="$BAHOME/ba/$SOURCE"
  fi
  if [ $# -gt 2 ]; then
     TARGET=$3
  else
     TARGET=$2
  fi
  if [ $SOURCE = "booted" ]; then
     SOURCE="/"
     REALSOURCE="/"
     if [ $# -lt 3 ]; then
        TARGET="barryallenbackup"
     fi
  else
     if [ ! -d "$BAHOME/ba/$SOURCE" ]; then
        $ECHO "ERROR: Source Image $SOURCE not found"
        $CR
        echo $LINE
        exit 1
     fi
  fi
  if [ -f "$BAIMAGE/$TARGET.tar.gz" ]; then
        $ECHO "ERROR: Target Image $BAIMAGE/$TARGET.tar.gz already exists, please rename"
        $CR
        echo $LINE
        exit 1
  fi
   
  $ECHO "Dumping from $SOURCE to $BAIMAGE/$TARGET.tar.gz now - be patient ..." 
  $CR
  echo $LINE
  cd "$REALSOURCE"
  tar -czvf "$BAIMAGE/$TARGET.tar.gz" *.sh usr bin sbin etc home lib app sys share root program misc dev_org data config boot
  echo $LINE
  $ECHO "Backup finished"
  $CR
  echo $LINE
  ;;
  copy)
  if [ -f /$BAINFO ]; then
     BOOTED=`cat /$BAINFO`
  else
     BOOTED="Flash"
  fi
  if [ $# -lt 3 ]; then
     $ECHO "ERROR: No source and target passed"
     $CR
     echo $LINE
     exit 1
  fi
  SOURCE=$2
  if [ $SOURCE != "booted" ]; then
     if [ ! -d "$BAHOME/ba/$SOURCE" ]; then
        $ECHO "ERROR: Source Image $SOURCE not found"
        $CR
        echo $LINE
        exit 1
    fi
  fi
  TARGET=$3
  if [ $TARGET = "booted" ]; then
     $ECHO "ERROR: can't copy to booted"
     $CR
     echo $LINE
     exit 1
  fi
  if [ $TARGET = "Flash" ]; then
     $ECHO "ERROR: can't copy to Flash"
     $CR
     echo $LINE
     exit 1
  fi
  if [ $BOOTED = $TARGET ]; then
     $ECHO "ERROR: Image $BAHOME/ba/$TARGET currently booted, can't delete"
     $CR
     echo $LINE
     exit 1
  fi
  if [ -d "$BAHOME/ba/$TARGET" ]; then
     $ECHO "Target $TARGET already exists, delete first"
     $CR
     echo $LINE
     exit 1
  fi
     
  $ECHO "Copying Source $SOURCE to Target $TARGET ..."
  $CR
  echo $LINE
  if [ $SOURCE != "booted" ]; then
     du -cs "$BAHOME/ba/$SOURCE" | grep -v total
     echo $LINE
  fi
  $ECHO "Copy takes 2 min, be patient ..."
  $CR
  if [ $SOURCE != "booted" ]; then
     cp -RP "$BAHOME/ba/$SOURCE" "$BAHOME/ba/$TARGET"
  else
     mkdir "$BAHOME/ba/$TARGET" 
     cp /*.sh "$BAHOME/ba/$TARGET" > /dev/null 2>&1
#    cp /.* "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     cp -RP /usr "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     cp -RP /sys "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     cp -RP /bin "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     cp -RP /boot "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     cp -RP /share "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     cp -RP /sbin "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     cp -RP /root "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     cp -RP /program "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     cp -RP /misc "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     cp -RP /etc "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     cp -RP /home "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     cp -RP /lib "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     cp -RP /dev_org "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     cp -RP /data "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     cp -RP /config "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     cp -RP /app "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     sync
     
     if [ -f "$BAHOME/ba/$TARGET/config/start-ext.sh" ]; then
       cp -RP /var "$BAHOME/ba/$TARGET" > /dev/null 2>&1
       sync
       cp -RP /svr "$BAHOME/ba/$TARGET" > /dev/null 2>&1
       sync
       cp -RP /root "$BAHOME/ba/$TARGET" > /dev/null 2>&1
       sync
       cp -RP /dev "$BAHOME/ba/$TARGET" > /dev/null 2>&1
     fi  
     
     mkdir "$BAHOME/ba/$TARGET/var" > /dev/null 2>&1
     mkdir "$BAHOME/ba/$TARGET/tmp" > /dev/null 2>&1
     mkdir "$BAHOME/ba/$TARGET/hdd" > /dev/null 2>&1
     mkdir "$BAHOME/ba/$TARGET/mnt" > /dev/null 2>&1
     mkdir "$BAHOME/ba/$TARGET/mnt/usb" > /dev/null 2>&1
     mkdir "$BAHOME/ba/$TARGET/mnt/extern-usb" > /dev/null 2>&1
     mkdir "$BAHOME/ba/$TARGET/mnt/intern-sata" > /dev/null 2>&1
     mkdir "$BAHOME/ba/$TARGET/mnt/nfs" > /dev/null 2>&1
     mkdir "$BAHOME/ba/$TARGET/ramdisk" > /dev/null 2>&1
     mkdir "$BAHOME/ba/$TARGET/proc" > /dev/null 2>&1
     mkdir "$BAHOME/ba/$TARGET/dev" > /dev/null 2>&1
     mkdir "$BAHOME/ba/$TARGET/root" > /dev/null 2>&1
     mkdir "$BAHOME/ba/$TARGET/devel"> /dev/null 2>&1
     
     if [ -f "$BAHOME/ba/$TARGET/config/start-ext.sh" ]; then
       mkdir "$BAHOME/ba/$TARGET/sys"> /dev/null 2>&1
       mkdir "$BAHOME/ba/$TARGET/rom"> /dev/null 2>&1
       mkdir "$BAHOME/ba/$TARGET/ram"> /dev/null 2>&1
       mkdir "$BAHOME/ba/$TARGET/opt"> /dev/null 2>&1
       mkdir "$BAHOME/ba/$TARGET/media"> /dev/null 2>&1
       mkdir "$BAHOME/ba/$TARGET/jffs"> /dev/null 2>&1
       mkdir "$BAHOME/ba/$TARGET/etc.static"> /dev/null 2>&1
       mkdir "$BAHOME/ba/$TARGET/dev.static"> /dev/null 2>&1
       mkdir "$BAHOME/ba/$TARGET/boot"> /dev/null 2>&1
     fi  
          
     cp "$BAHOME/bainit" "$BAHOME/ba/$TARGET/etc/init.d/bainit" > /dev/null 2>&1
     cp "$BAHOME/checkhdmount.sh" "$BAHOME/ba/$TARGET/data/checkhdmount.sh" > /dev/null 2>&1
     chmod 755 "$BAHOME/ba/$TARGET/etc/init.d/bainit" > /dev/null 2>&1
     chmod 755 "$BAHOME/ba/$TARGET/config/start.sh" > /dev/null 2>&1
     chmod 755 "$BAHOME/ba/$TARGET/config/start-ext.sh" > /dev/null 2>&1
     chmod 755 "$BAHOME/ba/$TARGET/data/checkhdmount.sh" > /dev/null 2>&1
     if [ -f "$BAHOME/ba/$TARGET/config/start.sh" ]; then
        # remove bainit from start.sh in USB stick to prevent recursive calls !
        grep -v "/config/bainit" "$BAHOME/ba/$TARGET/config/start.sh" > $BATMP
        cp $BATMP "$BAHOME/ba/$TARGET/config/start.sh"
     fi
     if [ -f "$BAHOME/ba/$TARGET/config/start-ext.sh" ]; then
        # remove bainit from start-ext.sh in USB stick to prevent recursive calls !
        grep -v "/config/bainit" "$BAHOME/ba/$TARGET/config/start-ext.sh" > $BATMP
        cp $BATMP "$BAHOME/ba/$TARGET/config/start-ext.sh"
     fi
     if [ -f "$BAHOME/ba/$TARGET/etc/init.d/rc" ]; then
        # get rid of ramfs mounts (will be bind mountet from flash)
        grep -v "/bin/mount -t ramfs" "$BAHOME/ba/$TARGET/etc/init.d/rc" > $BATMP
        cp $BATMP "$BAHOME/ba/$TARGET/etc/init.d/rc"
     fi
     if [ -f "$BAHOME/ba/$TARGET/etc/init.d/rcS" ]; then
        # get rid of ramfs mounts (will be bind mountet from flash)
        grep -v "/bin/mount -t ramfs" "$BAHOME/ba/$TARGET/etc/init.d/rcS" > $BATMP
        cp $BATMP "$BAHOME/ba/$TARGET/etc/init.d/rcS"
     fi
     if [ -f "$BAHOME/ba/$TARGET/etc/init.d/pvrinit" ]; then
        grep -v "/bin/mount -t ramfs" "$BAHOME/ba/$TARGET/etc/init.d/pvrinit" > $BATMP
        cp $BATMP "$BAHOME/ba/$TARGET/etc/init.d/pvrinit"
        chmod 755 "$BAHOME/ba/$TARGET/etc/init.d/pvrinit"
     fi
     cd "$BAHOME/ba/$TARGET"
     ln -sfn /bin/busybox linuxrc
     ln -sfn "$BAHOME" ba

     if [ `grep "/dev/mtdblock" "$BAHOME/ba/$TARGET/etc/fstab" | wc -l` -gt 0 ]; then
        grep -v /dev/mtdblock "$BAHOME/ba/$TARGET/etc/fstab" > $BATMP
        cp $BATMP "$BAHOME/ba/$TARGET/etc/fstab"
     fi
     if [ `grep "ramfs" "$BAHOME/ba/$TARGET/etc/fstab" | wc -l` -gt 0 ]; then
        grep -v "ramfs" "$BAHOME/ba/$TARGET/etc/fstab" > $BATMP
        cp $BATMP "$BAHOME/ba/$TARGET/etc/fstab"
     fi
  fi
  echo $LINE
  du -cs "$BAHOME/ba/$TARGET" | grep -v total
  echo $TARGET > "$BAHOME/ba/$TARGET/$BAINFO"
  sync
  echo $LINE
  $ECHO "Finished"
  $CR
  echo $LINE
  exit 0
  ;;
  link)
  if [ $# -lt 2 ]; then
     $ECHO "ERROR: No UFS_Images target passed"
     $CR
     echo $LINE
     $ECHO "$BAROOT/UFS_Images will be used"
     $CR
     echo $LINE
     mkdir -p "$BAROOT/UFS_Images"
     exit 0
  fi
  NEWLINK=$2
  $ECHO "$BAIMAGE will be created on $NEWLINK/UFS_Images"
  $CR
  echo $LINE
  if [ ! -d "$NEWLINK/UFS_Images" ]; then
     mkdir -p "$NEWLINK"
     mkdir -p "$NEWLINK/UFS_Images"
  fi
  ;;
  info  | images | image )
  if [ -f /$BAINFO ]; then
     BOOTED=`cat /$BAINFO`
  else
     BOOTED="Flash"
  fi

  $ECHO "You are booted from: $BOOTED"
  $CR
  echo $LINE
  $ECHO "List of Installed Images at $BAHOME/ba"
  $CR
  echo $LINE
  $ECHO "Size	Name"
  $CR
  echo $LINE
  cd "$BAHOME/ba"
  IMAGES=`ls`
  for IMAGE in $IMAGES; do
     # info file repair from broken backups
     if [ -d "$BAHOME/ba/$IMAGE/boot" -a ! -f "$BAIMAGE/ba/$IMAGE/$BAINFO" -a ! $IMAGE = "Flash" ]; then
         echo $IMAGE > "$BAHOME/ba/$IMAGE/$BAINFO"
         rm "$BAHOME/ba/$IMAGE/$BAINFO.tmp" > /dev/null 2>&1 
     fi
     if [ $1 = "info" ]; then
        if [ $IMAGE != $BOOTED ]; then
           if [ $IMAGE != "Flash" ]; then
               if [ `mount | grep "/ba/$IMAGE/media" | wc -l` -lt 1 ]; then
                cd "$BAHOME/ba"
                BASIZE=`du -cs $IMAGE | grep -v total`
                $ECHO "$BASIZE" 
                $CR
              fi
           fi
        fi
     fi
  done
  cd "$BAHOME"
  if [ $1 = "info" ]; then
     DF=`df | grep "$BAROOT"`
     NUMBER=1
     FREE=0
     SIZE=0
     for ITEM in $DF; do
        if [ $NUMBER = 2 ]; then
           SIZE=$ITEM
        fi
        if [ $NUMBER = 4 ]; then
           FREE=$ITEM
        fi
        NUMBER=`expr $NUMBER "+" 1`
     done
     echo $LINE
     $ECHO "$BAROOT Total: $SIZE Free: $FREE"
     $CR
     echo $LINE
  fi
  ;;
  rename )
  if [ $# -lt 3 ]; then
     $ECHO "no old and new imagename passed for renaming"
     $CR
     echo $LINE
     exit 1
  fi
  SOURCE=$2
  TARGET=$3
  if [ ! -f "$BAIMAGE/$SOURCE.tar.gz" -a ! -d "$BAIMAGE/$SOURCE" ]; then
     $ECHO "old imagename $SOURCE.tar.gz or $SOURCE directory not existing for renaming"
     $CR
     echo $LINE
     exit 1
  fi
  if [ -f "$BAIMAGE/$TARGET.tar.gz" -o -d "$BAIMAGE/$TARGET" ]; then
     $ECHO "Target $TARGET.tar.gz or $TARGET directory already exists, delete first"
     $CR
     echo $LINE
     exit 1
  fi
     
  if [ -d "$BAIMAGE/$SOURCE" ]; then
     mv "$BAIMAGE/$SOURCE" "$BAIMAGE/$TARGET"
     $ECHO "Image backup directory $SOURCE renamed to $TARGET"
  else
     mv "$BAIMAGE/$SOURCE.tar.gz" "$BAIMAGE/$TARGET.tar.gz"
     $ECHO "Image backup $SOURCE.tar.gz renamed to $TARGET.tar.gz"
  fi
  $CR
  echo $LINE
  $CR
  exit 0
  ;;
  name ) 
  if [ $# -lt 3 ]; then
     $ECHO "no old and new imagename passed for naming"
     $CR
     echo $LINE
     exit 1
  fi
  SOURCE=$2
  TARGET=$3
  if [ $SOURCE = "booted" ]; then
     $ECHO "ERROR: can't name booted"
     $CR
     echo $LINE
     exit 1
  fi
  if [ $TARGET = "booted" ]; then
     $ECHO "ERROR: can't name booted"
     $CR
     echo $LINE
     exit 1
  fi
  if [ $TARGET = "Flash" ]; then
     $ECHO "ERROR: can't name Flash"
     $CR
     echo $LINE
     exit 1
  fi
  if [ ! -d "$BAHOME/ba/$SOURCE" ]; then
     $ECHO "old imagename $SOURCE not existing for naming"
     $CR
     echo $LINE
     exit 1
  fi
  if [ -d "$BAHOME/ba/$TARGET" ]; then
     $ECHO "Target $TARGET already exists, delete first"
     $CR
     echo $LINE
     exit 1
  fi
     
  cd "$BAHOME"
  mv "$BAHOME/ba/$SOURCE" "$BAHOME/ba/$TARGET"
  echo $TARGET > "$BAHOME/ba/$TARGET/$BAINFO"
  $ECHO "Image $SOURCE named $TARGET"
  $CR
  echo $LINE
  exit 0
  ;;
  list )
  $ECHO "List of Images at $BAIMAGE"
  $CR
  echo $LINE
  cd "$BAIMAGE"
  ls -al * 
  echo $LINE
  ;;
  remove )
  if [ $# -lt 2 ]; then
     $ECHO "ERROR: no Image name given for remove"
     $CR
     echo $LINE
     exit 1
  else
     SOURCE=$2
  fi
  if [ ! -f "$BAIMAGE/$SOURCE.tar.gz" -a ! -d "$BAIMAGE/$SOURCE" ]; then
     $ECHO "ERROR: Image $SOURCE.tar.gz or $SOURCE directory is not available for remove"
     $CR
     echo $LINE
     exit 1
  fi
  if [ -d "$BAIMAGE/$SOURCE" ]; then
     $ECHO "Removing Backup Image directory $SOURCE"
     rm -r "$BAIMAGE/$SOURCE"
  else
     $ECHO "Removing Backup Image $BAIMAGE/$SOURCE.tar.gz"
     rm "$BAIMAGE/$SOURCE.tar.gz"
  fi
  $CR
  echo $LINE
  $ECHO "Finished"
  $CR
  echo $LINE
  echo 
  ;;
  delete)
  if [ -f /$BAINFO ]; then
     BOOTED=`cat /$BAINFO`
  else
     BOOTED="Flash"
  fi
  if [ $# -lt 2 ]; then
     $ECHO "ERROR: no Image name given for delete"
     $CR
     echo $LINE
     exit 1
  else
     SOURCE=$2
  fi
  if [ $SOURCE = "booted" ]; then
     $ECHO "ERROR: can't delete booted"
     $CR
     echo $LINE
     exit 1
  fi
  if [ ! -d "$BAHOME/ba/$SOURCE" ]; then
     $ECHO "ERROR: Image $BAHOME/ba/$SOURCE is not existing"
     $CR
     echo $LINE
     exit 1
  fi
  if [ $SOURCE = "Flash"  ]; then
     $ECHO "ERROR: can't delete Flash"
     $CR
     echo $LINE
     exit 1
  fi
  if [ $BOOTED = $SOURCE ]; then
     $ECHO "ERROR: Image $BAHOME/ba/$SOURCE currently booted, can't delete"
     $CR
     echo $LINE
     exit 1
  fi
  if [ `mount | grep /ba/$SOURCE/media | wc -l` -gt 0 ]; then
     $ECHO "ERROR: Image $BAHOME/ba/$SOURCE currently booted, can't delete"
     $CR
     echo $LINE
     exit 1
  fi
  $ECHO "Deleting Image $SOURCE"
  $CR
  echo $LINE
  # make sure ...
  cd "$BAHOME"
  rm -r "$BAHOME/ba/$SOURCE" > /dev/null 2>&1
  $ECHO "Finished"
  $CR
  echo $LINE
  $CR
  ;;
  chroot )
    cd "$BAHOME"
    if [ $# -lt 2 ]; then
       $ECHO "No Target Image passed, Sorry !"
       $CR
       echo $LINE
       exit 1
    else
       TARGET=$2
    fi
    if [ $TARGET = "Flash" ]; then
        $ECHO "works not for Flash, sorry"
        $CR
        echo $LINE
        exit 1
    else
       if [ ! -d  "$BAHOME/ba/$TARGET" ]; then
          $ECHO "ERROR: Target Image Directory $BAHOME/ba/$TARGET is not existing"
          $CR
          echo $LINE
          exit 1
       fi
       
    if [ `mount | grep "$TARGET/proc" | wc -l` -lt 1 ]; then
       mount -o bind /proc "$BAHOME/ba/$TARGET/proc"
    fi
    if [ `mount | grep "$TARGET/dev" | wc -l` -lt 1 ]; then
       mount -o bind /dev  "$BAHOME/ba/$TARGET/dev"
    fi
    if [ `mount | grep "$TARGET/var" | wc -l` -lt 1 ]; then
       mount -o bind /var  "$BAHOME/ba/$TARGET/var"
    fi
    if [ `mount | grep "$TARGET/tmp" | wc -l` -lt 1 ]; then
       mount -o bind /tmp  "$BAHOME/ba/$TARGET/tmp"
    fi
    if [ `mount | grep "$TARGET/ramdisk" | wc -l` -lt 1 ]; then
       mount -o bind /ramdisk  "$BAHOME/ba/$TARGET/ramdisk"
    fi
    if [ `mount | grep "$TARGET/$BAROOT" | wc -l` -lt 1 ]; then
       mount -o bind "$BAROOT" "$BAHOME/ba/$TARGET/$BAROOT"
    fi
    if [ -f $HD_DEVICE ]; then
       if [ `mount | grep "$TARGET/$HDROOT" | wc -l` -lt 1 ]; then
          mount -o bind "$HDROOT" "$BAHOME/ba/$TARGET/$HDROOT"
       fi
    fi
    echo "$BAHOME/ba/$TARGET"
    fi
    echo $LINE
    if [ $# -lt 3 ]; then
       $ECHO "chroot now to $TARGET - use exit to return !"
       SCRIPT=""
    else
       SCRIPT=$3
       $ECHO "executing script $SCRIPT in chroot $TARGET !"
    fi
    $CR
    echo $LINE
    chroot "$BAHOME/ba/$TARGET" $SCRIPT
    echo $LINE
    $ECHO "chroot from $TARGET exited !"
    $CR
    echo $LINE
    cd "$BAHOME"

	  CHROOTMOUNTS=`mount | grep /ba/$TARGET | sed "s/ (1/_(1/g" | sed "s/ (2/_(2/g"`                                             
	  
	  ITEM=0            
	  for MOUNTS in $CHROOTMOUNTS;                                                        
	  do                                                     
	    ITEM=`expr $ITEM "+" 1`                                                          
	    if [ $ITEM -eq 3 ]; then
	       echo "$MOUNTS" >> mounts
	    fi                                                                  
	    if [ $ITEM -eq 6 ]; then                                                         
	       ITEM=0                                                                        
	    fi                                                                               
	  done
	  CHROOTMOUNTS=`cat mounts`
	  
	  for MOUNTS in $CHROOTMOUNTS;
	  do
	   #echo "`tail -n 1 mounts | sed "s/_(1/ (1/g" | sed "s/_(2/ (2/g"`"
	   umount "`tail -n 1 mounts | sed "s/_(1/ (1/g" | sed "s/_(2/ (2/g"`"
	   cat mounts | sed '$d' > mounts_temp
	   cp mounts_temp mounts
	  done 
	  
	  rm mounts
	  rm mounts_temp
	  
    $ECHO "Finished chroot"
    $CR
    echo $LINE
  ;;
  "mem" | "free")
   free
   echo $LINE
   cat /proc/swaps
   echo $LINE
  ;;

reinstall | patch )
if [ -f /.*info ]; then
   $ECHO "Barry Allen should be reinstall ONLY when booted from Flash, Sorry !"
   $CR
   echo $LINE
   exit 1
fi
if [ `mount | grep "$BAROOT" | grep $USB_DEVICE | wc -l` -gt 0 ]; then
  $ECHO "Barry Allen found USB Device $USB_DEVICE mounted at $BAROOT"
  $CR
  echo $LINE
  $ECHO "$1 started"
  $CR
  echo $LINE
else
  $ECHO "No usable Barry Allen found, sorry !"
  $CR
  echo $LINE
  exit 1
fi
$ECHO "bainit copied to /config"
$CR
cp "$BAROOT/ba/bainit" /config/bainit
chmod 755 /config/bainit
cp "$BAROOT/ba/tools/tune2fs" /config/tune2fs
chmod 755 /config/tune2fs
echo $USB_DEVICE > /config/.badevice
echo "$BAROOT" > /config/.badirectory
if [ ! -f /config/start.sh ]; then
   cp /app/start.sh /config/start.sh
fi
if [ `grep /config/bainit /config/start.sh | wc -l` -gt 0 ]; then
   $ECHO "bainit already in /config/start.sh"
   $CR
else
   $ECHO "bainit added to /config/start.sh"
   $CR
   echo "#!/bin/sh" > $BATMP
   echo "/config/bainit > $BALOG 2>&1" >> $BATMP
   cat /config/start.sh >> $BATMP
   cp $BATMP /config/start.sh
fi
chmod 755 /config/start.sh
sleep 2
sync
sleep 2
echo $LINE
$ECHO "$1 ended"
$CR
echo $LINE
  ;;  

deinstall | unpatch )
if [ -f /.*info ]; then
   $ECHO "Barry Allen should be deinstall ONLY when booted from Flash, Sorry !"
   $CR
   echo $LINE
   exit 1
fi
$ECHO "$1 started"
$CR
echo $LINE
$ECHO "bainit deleted from /config"
$CR
rm /config/bainit
rm /config/tune2fs
rm /config/.badevice
rm /config/.badirectory
if [ `grep "/config/bainit" "/config/start.sh" | wc -l` -gt 0 ]; then
   $ECHO "bainit deleted from /config/start.sh"
   $CR
   grep -v /config/bainit "/config/start.sh" > $BATMP
   cp $BATMP "/config/start.sh"
fi
sleep 2
sync
sleep 2
echo $LINE
$ECHO "$1 ended"
$CR
echo $LINE
  ;;  

install | update)
if [ -f /.*info ]; then
   $ECHO "Barry Allen should be installed/upgraded ONLY when booted from Flash, Sorry !"
   $CR
   echo $LINE
   exit 1
fi

TOOLDIR=/tmp/ba/tools

echo "d" > $ERASETMP
echo "1" >> $ERASETMP
echo "d" > $ERASETMP
echo "2" >> $ERASETMP
echo "d" > $ERASETMP
echo "3" >> $ERASETMP
echo "d" > $ERASETMP
echo "4" >> $ERASETMP
echo "n" >> $ERASETMP
echo "p" >> $ERASETMP
echo "1" >> $ERASETMP
echo "1" >> $ERASETMP
echo "" >> $ERASETMP
echo "w" >> $ERASETMP

if [ `mount | grep "$BAROOT" | grep $USB_DEVICE | grep ext2 | wc -l` -lt 1 ]; then
if [ `mount | grep "$BAROOT" | grep $USB_DEVICE | grep ext3 | wc -l` -lt 1 ]; then

if [ -f "$BAHOME/ba.sh" -o $1 = "update" ]; then
   $ECHO "Barry Allen already installed, no format needed"
   $CR
   echo $LINE
   $TOOLDIR/bin/busybox e2label $USB_DEVICE XBA
   umount "$BAROOT" > /dev/null 2>&1
   rmdir "$BAROOT" > /dev/null 2>&1
   BAROOT=`echo "$BAROOT" | sed s/"\/BA ("/"\/XBA ("/g`
   BAHOME=`echo "$BAHOME" | sed s/"\/BA ("/"\/XBA ("/g`
   mkdir "$BAROOT" > /dev/null 2>&1
   mount $USB_DEVICE "$BAROOT" > /dev/null 2>&1
   MOUNTED=`mount | grep "$BAROOT" | wc -l`
   if [ $MOUNTED -lt 1 ]; then
      $ECHO "USB device not mountable after rename, sorry"
      $CR
      echo $LINE
      exit 1
   fi
else
 
   if [ `mount | grep "$BAROOT" | grep $USB_DEVICE | wc -l` -gt 0 ]; then
      $ECHO "Barry Allen found USB Device $USB_DEVICE mounted at $BAROOT"
      $CR
      echo $LINE
   else
      $ECHO "No usable USB Device found for Barry Allen, sorry !"
      $CR
      $ECHO "format first USB device (on PC or Reveicer) with label: BA"
      $CR
      echo $LINE
      exit 1
   fi
   FILESYSTEM=ext2
   if [ $# -gt 1 ]; then
      if [ $2 = "ext3" ]; then   
        FILESYSTEM=$2
      else
        if [ $2 = "ext2" ]; then
          FILESYSTEM=$2
        else  
          echo "parameter $2  No longer supported ---> ignored"
          echo "optional parameter is ext2 or ext3"
        fi  
      fi   
   fi
   PARAMETER="nopart"
   if [ $# -gt 2 ]; then
     if [ $3 = "part" ]; then
       PARAMETER="part"
     else
       echo "parameter $3  Not supported ---> terminate"
       PARAMETER="nopart"
       exit 1
     fi
   fi      
   ################### Partitionieren #########################################
   wert="n"
   if [ $PARAMETER = "part" ]; then
     echo " "
     echo "Stick partionieren? (y/n)"
     read wert
   else
     wert="n"
   fi    
   if [ $wert = "y" ]; then
    echo " "
    echo "Achtung --> alle Dateien auf dem Stick gehen verloren"
    echo "weiter machen? (y/n)"
    read wert
    echo " "
    if [ $wert = "y" ]; then
     DF="df"
     COMTEMP="/tmp/cmd"
     FDISKOUT="/tmp/fdisk.out"
     START=1
     USB_PART=`echo "$USB_DEVICE" | sed s/1/""/g`
     echo "USB Device $USB_PART wird partioniert"
  
     MOUNT1=`$DF | grep "$USB_PART"1 | cut -d % -f 2- | cut -c 2-`
     if [ "$MOUNT1" != "" ]; then
       umount "$MOUNT1"
       if [ `mount | grep "$MOUNT1" | wc -l` -gt 0 ]; then
         echo "cann't umount USB Device for formating - maybe standing there in telnet ?"
         exit 1
       fi
       rmdir "$MOUNT1"  
       MOUNT2=`$DF | grep "$USB_PART"2 | cut -d % -f 2- | cut -c 2-`
       if [ "$MOUNT2" != "" ]; then
         umount "$MOUNT2"
         if [ `mount | grep "$MOUNT2" | wc -l` -gt 0 ]; then
           echo "cann't umount USB Device for formating - maybe standing there in telnet ?"
           exit 1
         fi 
         rmdir "$MOUNT2"
         MOUNT3=`$DF | grep "$USB_PART"3 | cut -d % -f 2- | cut -c 2-`
         if [ "$MOUNT3" != "" ]; then
           umount "$MOUNT3"
           if [ `mount | grep "$MOUNT3" | wc -l` -gt 0 ]; then
             echo "cann't umount USB Device for formating - maybe standing there in telnet ?"
             exit 1
           fi
           rmdir "$MOUNT3" 
           MOUNT4=`$DF | grep "$USB_PART"4 | cut -d % -f 2- | cut -c 2-`
           if [ "$MOUNT4" != "" ]; then
             umount "$MOUNT4"
             if [ `mount | grep "$MOUNT4" | wc -l` -gt 0 ]; then
               echo "cann't umount USB Device for formating - maybe standing there in telnet ?"
               exit 1
             fi
             rmdir "$MOUNT4"   
           fi
         fi  
       fi  
     fi  
     
     echo "d" > $COMTEMP
     echo "1" >> $COMTEMP
     echo "d" >> $COMTEMP
     echo "2" >> $COMTEMP
     echo "d" >> $COMTEMP
     echo "3" >> $COMTEMP
     echo "d" >> $COMTEMP
     echo "4" >> $COMTEMP
     echo "w" >> $COMTEMP
     echo "alte Partitionen werden gelscht"
     $TOOLDIR/fdisk < $COMTEMP $USB_PART > /dev/null 2>&1
     sync
     
     echo "p" > $COMTEMP
     echo "q" >> $COMTEMP
     
     echo "Anzahl Cylinder wird ermittelt" 
     $TOOLDIR/fdisk < $COMTEMP $USB_PART > $FDISKOUT
     CYLS=`cat $FDISKOUT | grep "/track" | cut -d " " -f 5`
     #MBYTE=`cat $FDISKOUT | grep "Disk /dev" | cut -d " " -f 3`
     echo "USB Device hat $CYLS Zylinder"
     let PART=$CYLS/4
     #let PART=$MBYTE/4
     ENDE=$PART
     echo "es werden 4 Partitionen mit $PART Cylinder erstellt"

     for i in 1 2 3 4 ; do

       #echo "$i <--"

       echo "Partition $i wird erstellt"
 
       echo "n" > $COMTEMP
       echo "p" >> $COMTEMP
       echo "$i" >> $COMTEMP
       echo "$START" >> $COMTEMP
       echo "$ENDE" >> $COMTEMP
       #echo "+$ENDE""M" >> $COMTEMP
       echo "w" >> $COMTEMP
       cat $COMTEMP
       $TOOLDIR/fdisk < $COMTEMP $USB_PART > /dev/null 2>&1
       sync
    
       if [ $i = "1" ]; then
         echo "Partition $i (XBA) wird formatiert" 
         $TOOLDIR/mkfs.$FILESYSTEM -b 4096 -L "XBA" $USB_PART$i > /dev/null 2>&1
         echo "  "
         sync
       else
         echo "Partition $i (XSYS$i) wird formatiert"
         $TOOLDIR/mkfs.ext2 -b 4096 -L "XSYS$i" $USB_PART$i > /dev/null 2>&1
         echo "  "
         sync
       fi  

       let START=$ENDE+1
       let ENDE=$ENDE+$PART 
     done
  
     if [ $USB_PART = "/dev/sda" ]; then
       DEV="1"
     fi
     if [ $USB_PART = "/dev/sdb" ]; then
       DEV="2"
     fi
     if [ $USB_PART = "/dev/sdc" ]; then
       DEV="3"
     fi  
     BAROOT="/tmp/usb/XBA ($DEV-1)"
     BAHOME="/tmp/usb/XBA ($DEV-1)/ba"
     MOUNT2="/tmp/usb/XSYS2 ($DEV-2)"
     MOUNT3="/tmp/usb/XSYS3 ($DEV-3)"
     MOUNT4="/tmp/usb/XSYS4 ($DEV-4)"
     mkdir "$MOUNT2"
     mkdir "$MOUNT3"
     mkdir "$MOUNT4"
     mount "$USB_PART"2 "$MOUNT2"
     mount "$USB_PART"3 "$MOUNT3"
     mount "$USB_PART"4 "$MOUNT4"
  
    else
     echo "Abbruch durch User"
     exit 1
    fi
   else
   #################### Partitionieren ende ########################################
   
     umount "$BAROOT" > /dev/null 2>&1
     umount "/tmp/usb/BA (1)" > /dev/null 2>&1
     umount "/tmp/usb/BA\ \(1\)" > /dev/null 2>&1
   
     if [ `mount | grep "$BAROOT" | wc -l` -gt 0 ]; then
      $ECHO "cann't umount USB Device for formating - maybe standing there in telnet ?"
      $CR
      echo $LINE
      exit 1
     fi
     USB_DEVICE=`echo "$USB_DEVICE" | sed s/1/""/g`
     $ECHO "Erasing USB Device ..."
     $CR
     echo $LINE
   
     $TOOLDIR/fdisk < $ERASETMP $USB_DEVICE > /dev/null 2>&1 
     $ECHO "Making empty $FILESYSTEM Filesystem ..."
     $CR
     if [ $USB_DEVICE = "/dev/sda" ]; then
       USB_DEVICE=$USB_DEVICE"1"
     else
       if [ $USB_DEVICE = "/dev/sdb" ]; then
         USB_DEVICE=$USB_DEVICE"1"
       fi   
     fi  
     sleep 5
     umount "$BAROOT" > /dev/null 2>&1
   
     $TOOLDIR/mkfs.$FILESYSTEM -b 4096 -L "XBA" $USB_DEVICE
     rmdir "$BAROOT"
     BAROOT=`echo "$BAROOT" | sed s/"\/BA ("/"\/XBA ("/g`
     BAHOME=`echo "$BAHOME" | sed s/"\/BA ("/"\/XBA ("/g`
   fi 
   mkdir "$BAROOT"
   mount $USB_DEVICE "$BAROOT"
   MOUNTED=`mount | grep "$BAROOT" | wc -l`
   if [ $MOUNTED -lt 1 ]; then
      $ECHO "USB device not mountable after formating, sorry"
      $CR
      echo $LINE
      exit 1
   fi
   mkdir "$BAROOT/ba" > /dev/null 2>&1
   mkdir "$BAROOT/ba/ba" > /dev/null 2>&1
  
fi

else
   echo $LINE
   $ECHO "Barry Allen ext. Partition found, no format needed"
   $CR
   echo $LINE
   mkdir "$BAROOT/ba" > /dev/null 2>&1
   mkdir "$BAROOT/ba/ba" > /dev/null 2>&1
fi
else
  echo $LINE
  $ECHO "Barry Allen ext. Partition found, no format needed"
  $CR
  echo $LINE
  mkdir "$BAROOT/ba" > /dev/null 2>&1
  mkdir "$BAROOT/ba/ba" > /dev/null 2>&1 
fi

echo $USB_DEVICE > /config/.badevice
echo "$BAROOT" > /config/.badirectory
echo $USB_DEVICE > "$BAHOME/.badevice"
echo "$BAROOT" > "$BAHOME/.badirectory"
#HDROOT=`df | grep /tmp/usb/H | cut -d % -f 2- | cut -c 2-`
#HDROOT=`df | grep /tmp/usb/$HDL | cut -d % -f 2- | cut -c 2-`
#echo "$HDROOT" > "$BAHOME/.hddirectory"
#echo "$HDROOT" > /config/.hddirectory
#HD_DEVICE=`df | grep /tmp/usb/H | cut -d " " -f 1` 
#HD_DEVICE=`df | grep /tmp/usb/$HDL | cut -d " " -f 1`
#echo "$HD_DEVICE" > "$BAHOME/.hddevice"
#echo "$HD_DEVICE" > /config/.hddevice

$ECHO "Installing Barry Allen binaries ..."
$CR
cd "$BAROOT"
if [ ! -f /tmp/ba/ba.sh ]; then
   $ECHO "Barry Allen ba.sh gone at /tmp/ba, sorry !"
   $CR
   echo $LINE 
   exit 1
else
   # copy 2x and do sync to make sure
   cp -RP /tmp/ba/tools	"$BAHOME"
   cp /tmp/ba/ba.sh "$BAHOME/ba.sh"
   cp /tmp/ba/ba.sh "$BAHOME/ba.sh"
   cp /tmp/ba/checkhdmount.sh "$BAHOME/checkhdmount.sh"
   cp /tmp/ba/checkhdmount.sh "$BAHOME/checkhdmount.sh"
   sync
fi
if [ ! -f /tmp/ba/bainit ]; then
   $ECHO "Barry Allen bainit gone at /tmp/ba, sorry !"
   $CR
   echo $LINE 
   exit 1
else
   # copy 2x and do sync to make sure
   cp /tmp/ba/bainit "$BAHOME/bainit"
   cp /tmp/ba/bainit "$BAHOME/bainit"
   cp /tmp/ba/bainit /config/bainit 
   cp /tmp/ba/bainit /config/bainit 
   cp /tmp/ba/tools/tune2fs /config/tune2fs
   chmod 755 /config/tune2fs
   sync
fi
$ECHO "UFS_Images will be created on USB Device"
$CR
echo $LINE
mkdir "$BAROOT/UFS_Images" > /dev/null 2>&1

if [ ! -f /config/start-ext.sh ]; then
  if [ ! -f /config/start.sh ]; then
     cp /app/start.sh /config/start.sh
  fi 
  if [ `grep /config/bainit /config/start.sh | wc -l` -gt 0 ]; then
     $ECHO "bainit already in /config/start.sh"
     $CR
     echo $LINE
  else
     $ECHO "bainit added to /config/start.sh"
     $CR
     echo $LINE
     echo "#!/bin/sh" > $BATMP
     echo "/config/bainit > $BALOG 2>&1" >> $BATMP
     cat /config/start.sh >> $BATMP
     cp $BATMP /config/start.sh
  fi
else
  if [ `grep /config/bainit /config/start-ext.sh | wc -l` -gt 0 ]; then
     $ECHO "bainit already in /config/start-ext.sh"
     $CR
     echo $LINE
  else
     $ECHO "bainit added to /config/start-ext.sh"
     $CR
     echo $LINE
     echo "#!/bin/sh" > $BATMP
     echo "/config/bainit > $BALOG 2>&1" >> $BATMP
     cat /config/start-ext.sh >> $BATMP
     cp $BATMP /config/start-ext.sh
  fi
fi  
    
chmod 755 /config/start.sh > /dev/null 2>&1
chmod 755 /config/start-ext.sh > /dev/null 2>&1

$ECHO "Migrating existing Images ..."
$CR
echo $LINE

IMAGES=`ls -1 "$BAROOT/ba/ba"`
for TARGET in $IMAGES; do

echo $TARGET > "$BAROOT/ba/ba/$TARGET/.bainfo"
if [ ! -f "$BAROOT/ba/ba/$TARGET/bootp.conf" ]; then
  cp "$BAROOT/ba/bainit" "$BAROOT/ba/ba/$TARGET/etc/init.d/bainit" > /dev/null 2>&1
  cp "$BAROOT/ba/bainit" "$BAROOT/ba/ba/$TARGET/config/bainit" > /dev/null 2>&1
  cp "$BAROOT/ba/checkhdmount.sh" "$BAROOT/ba/ba/$TARGET/data/checkhdmount.sh" > /dev/null 2>&1
  mkdir "$BAROOT/ba/ba/$TARGET/data/baroot" > /dev/null 2>&1
  mkdir "$BAROOT/ba/ba/$TARGET/data/baroot/kathrein" > /dev/null 2>&1

  chmod 755 "$BAROOT/ba/ba/$TARGET/data/checkhdmount.sh"

  if [ `grep "/dev/mtdblock" "$BAROOT/ba/ba/$TARGET/etc/fstab" | wc -l` -gt 0 ]; then
     grep -v /dev/mtdblock "$BAROOT/ba/ba/$TARGET/etc/fstab" > $BATMP
     cp $BATMP "$BAROOT/ba/ba/$TARGET/etc/fstab"
  fi
  if [ `grep "ramfs" "$BAROOT/ba/ba/$TARGET/etc/fstab" | wc -l` -gt 0 ]; then
     grep -v "ramfs" "$BAROOT/ba/ba/$TARGET/etc/fstab" > $BATMP
     cp $BATMP "$BAROOT/ba/ba/$TARGET/etc/fstab"
  fi
  if [ -f "$BAROOT/ba/ba/$TARGET/etc/init.d/pvrmain" ]; then
     if [ `grep "mount -t ramfs" "$BAROOT/ba/ba/$TARGET/etc/init.d/pvrmain" | wc -l` -gt 0 ]; then
        grep -v "mount -t ramfs" "$BAROOT/ba/ba/$TARGET/etc/init.d/pvrmain" > $BATMP
        cp $BATMP "$BAROOT/ba/ba/$TARGET/etc/init.d/pvrmain"
     fi
  fi
  if [ -f "$BAROOT/ba/ba/$TARGET/etc/init.d/rc" ]; then
     if [ `grep "mount -t ramfs" "$BAROOT/ba/ba/$TARGET/etc/init.d/rc" | wc -l` -gt 0 ]; then
        grep -v "mount -t ramfs" "$BAROOT/ba/ba/$TARGET/etc/init.d/rc" > $BATMP
        cp $BATMP "$BAROOT/ba/ba/$TARGET/etc/init.d/rc"
     fi
  fi
  if [ -f "$BAROOT/ba/ba/$TARGET/etc/init.d/rcS" ]; then
     if [ `grep "mount -t ramfs" "$BAROOT/ba/ba/$TARGET/etc/init.d/rcS" | wc -l` -gt 0 ]; then
        grep -v "mount -t ramfs" "$BAROOT/ba/ba/$TARGET/etc/init.d/rcS" > $BATMP
        cp $BATMP "$BAROOT/ba/ba/$TARGET/etc/init.d/rcS"
     fi
  fi
  if [ -f "$BAROOT/ba/ba/$TARGET/config/start.sh" ]; then
     if [ `grep "/config/bainit" "$BAROOT/ba/ba/$TARGET/config/start.sh" | wc -l` -gt 0 ]; then
        grep -v "/config/bainit" "$BAROOT/ba/ba/$TARGET/config/start.sh" > $BATMP
        cp $BATMP "$BAROOT/ba/ba/$TARGET/config/start.sh"
     fi
  fi
  if [ -f "$BAROOT/ba/ba/$TARGET/config/start-ext.sh" ]; then
     if [ `grep "/config/bainit" "$BAROOT/ba/ba/$TARGET/config/start-ext.sh" | wc -l` -gt 0 ]; then
        grep -v "/config/bainit" "$BAROOT/ba/ba/$TARGET/config/start-ext.sh" > $BATMP
        cp $BATMP "$BAROOT/ba/ba/$TARGET/config/start-ext.sh"
     fi
  fi
fi  
done
if [ ! -d "$BAHOME/ba/Flashcopy" ]; then
   $ECHO "Doing Flash copy ..."
   $CR
   $ECHO "Flash copy is used in the installation no longer supported"
   $CR
   $ECHO "you can use - ./ba.sh copy booted Flashcopy - after installation"
   $CR
   #"$BAHOME/ba.sh" copy booted Flashcopy
   #echo "Flashcopy" > "$BAHOME/.baboot"
   #sync
   $ECHO "Flash copy is aborted"
   $CR
fi
echo "Stick is synchronized ---> please wait"
sync
sleep 2
sync
$ECHO "Installation finished"
$CR
echo $LINE
;;

e2ba_extract)
  #
  if [ ! -e "$BAROOT/.multipart" ]; then
    echo "Sorry, you have not installed multipart"
    echo "you must first start multipart with: ./ba.sh start_multipart"
    exit 1
  fi 
  if [ $# -lt 2 ]; then
     $ECHO "ERROR: no tar.gz filename given for extracting from $BAIMAGE"
     $CR
     echo $LINE
     exit 1
  else
     SOURCE=$2
     if [ $# -gt 2 ]; then
        TARGET=$3
     else
        TARGET=$2
     fi
  fi
  if [ ! -f "$BAIMAGE/$SOURCE.tar.gz" ]; then
     $ECHO "ERROR: Image File $BAIMAGE/$SOURCE.tar.gz is not existing"
     $CR
     echo $LINE
     exit 1
  fi
  echo "Image will now be extracted ... Please wait"
  mkdir "$BAHOME/ba/$TARGET"
  tar xzf "$BAIMAGE/$SOURCE.tar.gz" -C "$BAHOME/ba/$TARGET"
  mkdir "$BAHOME/ba/$TARGET/var/baroot" > /dev/null 2>&1
  echo "*"
  echo "bootp.conf is created"
  TYPE=1
  HELPDEV=`echo "$USB_DEVICE" | cut -c1-8`
  HELPPART=`echo "$USB_DEVICE" | cut -c9`
  if [ $HELPDEV = "/dev/sda" ]; then
    DEVID=`echo "0:$HELPPART"`
  fi
  if [ $HELPDEV = "/dev/sdb" ]; then
    DEVID=`echo "1:$HELPPART"`
  fi
  if [ $HELPDEV = "/dev/sdc" ]; then
    DEVID=`echo "2:$HELPPART"`
  fi
  echo "ASSIGNUSBDEVICES=y" > "$BAHOME/ba/$TARGET/bootp2.conf"
  echo "BADEVICE=$USB_DEVICE" > "$BAHOME/ba/$TARGET/bootp2.conf"
  echo "BADEVICE=$USB_DEVICE" > "$BAHOME/ba/$TARGET/bootp.conf"
  echo "BADEVID=$DEVID" >> "$BAHOME/ba/$TARGET/bootp2.conf"
  echo "BADEVID=$DEVID" >> "$BAHOME/ba/$TARGET/bootp.conf"
  if [ $TYPE = "1" ]; then
    echo "/dev/mtd7 0x00000000 0x00010000 0x20000" > /tmp/fw_env.config
    "$BAHOME/tools/fw_printenv" > /tmp/boot1
    ethaddr=`cat "/tmp/boot1" | grep "ethaddr=" | cut -c9-25`
    echo "BOOTCMD=usb reset;usb reset;ext2load usb \$badevid a5000000 /boot/uImage;bootm a5000000" >> "$BAHOME/ba/$TARGET/bootp.conf"
    echo "BOOTARGS=console=ttyAS0,115200 root=\$badevice rw ip=\$ipaddr:\$serverip:\$gateway:255.255.255.0:kathrein:eth0:off mem=64m init=/bin/devinit coprocessor_mem=4m@0x10000000,4m@0x10400000" rootdelay=6 nwhwconf=device:eth0,hwaddr:$ethaddr >> "$BAHOME/ba/$TARGET/bootp.conf"
    echo "BOOTCMD=usb reset;usb reset;ext2load usb \$badevid a5000000 /boot/uImage;bootm a5000000" >> "$BAHOME/ba/$TARGET/bootp2.conf"
    echo "BOOTARGS=console=ttyAS0,115200 root=\$badevice rw ip=\$ipaddr:\$serverip:\$gateway:255.255.255.0:kathrein:eth0:off mem=64m init=/bin/devinit coprocessor_mem=4m@0x10000000,4m@0x10400000" rootdelay=6 nwhwconf=device:eth0,hwaddr:$ethaddr >> "$BAHOME/ba/$TARGET/bootp2.conf"
    echo "IP-address (xxx.xxx.xxx.xxx):"
    read IPADDR
    echo "Gateway (xxx.xxx.xxx.xxx):"
    read GATEWAY
    SERVERIP=$GATEWAY
    echo "IPADDR=$IPADDR" >> "$BAHOME/ba/$TARGET/bootp.conf"
    echo "SERVERIP=$SERVERIP" >> "$BAHOME/ba/$TARGET/bootp.conf"
    echo "GATEWAY=$GATEWAY" >> "$BAHOME/ba/$TARGET/bootp.conf"
    echo "IPADDR=$IPADDR" >> "$BAHOME/ba/$TARGET/bootp2.conf"
    echo "SERVERIP=$SERVERIP" >> "$BAHOME/ba/$TARGET/bootp2.conf"
    echo "GATEWAY=$GATEWAY" >> "$BAHOME/ba/$TARGET/bootp2.conf"
  fi
  sync
  sed -e 's/fsck /#fsck /g' -i "$BAHOME/ba/$TARGET/etc/init.d/mountvirtfs"
  RCS="$BAHOME/ba/$TARGET/etc/init.d/rcS"     
  if [ `grep "Starte chroot" "$RCS" | wc -l` -eq 0 ]; then
    echo "updating $BAHOME/ba/$TARGET/etc/init.d/rcS"
    if [ `grep "#!/bin/sh" "$RCS" | wc -l` -gt 0 ]; then
      sed -e 's*#!/bin/sh*#*g' -i "$RCS"
      echo "#!/bin/sh" > $TMP
      echo "" >> $TMP
      echo "if [ -e /activImage ]; then" >> $TMP
      echo "  echo \"Starte chroot\"" >> $TMP
      #echo "  mount -o bind /baroot /activImage/var/baroot" >> $TMP
      echo "  exec chroot /activImage /etc/init.d/rcS" >> $TMP
      echo "fi" >> $TMP
      echo "" >> $TMP
      cat "$RCS" >> $TMP
      cp $TMP "$RCS"
    else
      echo "ERROR extract not ok"
      exit 1
    fi 
  else
    echo "BA Patch1 is already installed"   
  fi
  sync
  if [ `grep "mount BAROOT" "$RCS" | wc -l` -eq 0 ]; then
    if [ `grep "/etc/init.d/mountvirtfs" "$RCS" | wc -l` -gt 0 ]; then
      grep -n "/etc/init.d/mountvirtfs" "$RCS" > $TMP
      PL=`cut -d: -f1 $TMP`
      sed -e $PL'a\done' "$RCS" |
      sed -e $PL'a\  fi' |
      sed -e $PL'a\    break' |
      sed -e $PL'a\    mount /dev/\$device /var/baroot' |
      sed -e $PL'a\  if [ \`tune2fs -l /dev/\$device | grep XBA | wc -l\` -gt 0 ]; then' |
      sed -e $PL'a\for device in sda1 sda2 sda3 sda4 sdb1 sdb2 sdb3 sdb4 sdc1 sdc2 sdc3 sdc4; do' |
      sed -e $PL'a\#mount BAROOT' > $TMP
      cp $TMP "$RCS"
    fi
  fi
  sync         
      
  echo "extract ended"
  echo " "
;;


start_multipart )
  #
  echo "e2 Image on $BAROOT will be deleted."
  echo "Do they agree? (y/n)"
  read WERT
  if [ $WERT = "y" ]; then
    cd "$BAROOT"
    rm activImage > /dev/null 2>&1
    rm .smb > /dev/null 2>&1
    rm -r backup > /dev/null 2>&1
    rm -r bin > /dev/null 2>&1
    rm -r boot > /dev/null 2>&1
    rm -r dev > /dev/null 2>&1
    rm -r dev.static > /dev/null 2>&1
    rm -r etc > /dev/null 2>&1
    rm -r hdd > /dev/null 2>&1
    rm -r lib > /dev/null 2>&1
    rm -r media > /dev/null 2>&1
    rm -r misc > /dev/null 2>&1
    rm -r mnt > /dev/null 2>&1
    rm -r proc > /dev/null 2>&1
    rm -r ram > /dev/null 2>&1
    rm root > /dev/null 2>&1
    rm -r sbin > /dev/null 2>&1
    rm -r swap > /dev/null 2>&1
    rm -r sys > /dev/null 2>&1
    rm -r tmp > /dev/null 2>&1
    rm -r usr > /dev/null 2>&1
    rm -r var > /dev/null 2>&1
    rm -r epg > /dev/null 2>&1
    
    echo "started" > .multipart
    ln -s ./ba/ba ./activImage > /dev/null 2>&1
    ln -s ./activImage/.smb ./.smb > /dev/null 2>&1
    ln -s ./activImage/backup ./backup > /dev/null 2>&1
    ln -s ./activImage/bin ./bin > /dev/null 2>&1
    ln -s ./activImage/boot ./boot > /dev/null 2>&1
    ln -s ./activImage/dev ./dev > /dev/null 2>&1
    ln -s ./activImage/dev.static ./dev.static > /dev/null 2>&1
    ln -s ./activImage/etc ./etc > /dev/null 2>&1
    ln -s ./activImage/hdd ./hdd > /dev/null 2>&1
    ln -s ./activImage/lib ./lib > /dev/null 2>&1
    ln -s ./activImage/media ./media > /dev/null 2>&1
    ln -s ./activImage/misc ./misc > /dev/null 2>&1
    ln -s ./activImage/mnt ./mnt > /dev/null 2>&1
    ln -s ./activImage/proc ./proc > /dev/null 2>&1
    ln -s ./activImage/ram ./ram > /dev/null 2>&1
    ln -s ./activImage/root ./root > /dev/null 2>&1
    ln -s ./activImage/sbin ./sbin > /dev/null 2>&1
    ln -s ./activImage/swap ./swap > /dev/null 2>&1
    ln -s ./activImage/sys ./sys > /dev/null 2>&1
    ln -s ./activImage/tmp ./tmp > /dev/null 2>&1
    ln -s ./activImage/usr ./usr > /dev/null 2>&1
    ln -s ./activImage/var ./var > /dev/null 2>&1
    sync
    echo "multipart is started"
  fi  
;;
  
stop_multipart )
  #
  echo "ACHTUNG"
  echo "Images installed with e2ba_extract can no longer start"
  echo "This feature allows you to start_multipart again."
  echo "*"
  cd "$BAROOT"
  rm activImage > /dev/null 2>&1
  rm .smb > /dev/null 2>&1
  rm backup > /dev/null 2>&1
  rm bin > /dev/null 2>&1
  rm boot > /dev/null 2>&1
  rm dev > /dev/null 2>&1
  rm dev.static > /dev/null 2>&1
  rm etc > /dev/null 2>&1
  rm hdd > /dev/null 2>&1
  rm lib > /dev/null 2>&1
  rm media > /dev/null 2>&1
  rm misc > /dev/null 2>&1
  rm mnt > /dev/null 2>&1
  rm proc > /dev/null 2>&1
  rm ram > /dev/null 2>&1
  rm root > /dev/null 2>&1
  rm sbin > /dev/null 2>&1
  rm swap > /dev/null 2>&1
  rm sys > /dev/null 2>&1
  rm tmp > /dev/null 2>&1
  rm usr > /dev/null 2>&1
  rm var > /dev/null 2>&1
  rm .multipart > /dev/null 2>&1
  sync
  echo "multipart is stopped"
  
;;


makekit )
echo "creating $BOXTYPE Barry Allen kit Version $BAVERSION"
echo $LINE
cd "$BAHOME"
chmod 755 bainit
chmod 755 ba.sh
chmod 755 checkhdmount.sh
cd "$BAROOT"
tar -czvf /tmp/barry-allen-$BOXTYPE-$BAVERSION.tar.gz ba/ba.sh ba/bainit ba/checkhdmount.sh
echo $LINE
echo "Barry Allen Kit is now at /tmp"
echo $LINE
ls -a /tmp/barry-allen-$BOXTYPE-$BAVERSION.tar.gz
echo $LINE
;;

  *)
    $ECHO "Usage: ba.sh boot imagename | extract imagename | info | list" 
    $CR
    $ECHO "| name oldname newnewname | delete imagename | link | chroot | free"
    $CR
    $ECHO "| rename oldname newnewname | remove imagename | install | makekit"
    $CR
    echo $LINE
    exit 1
  ;;
esac
exit 0
