# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from __future__ import absolute_import
try:
	from enigma import eServiceReference, eUriResolver, StringList
	from .yt_url import youtubeUrl
	from .twagenthelper import twAgentGetPage
	import re

	from Tools.Log import Log

	class MPYoutubeUriResolver(eUriResolver):

		_schemas = ("mp_youtube", "mp_yt")
		instance = None

		def __init__(self):
			eUriResolver.__init__(self, StringList(self._schemas))
			Log.i(self._schemas)

		def resolve(self, service, uri):
			Log.i(uri)
			liveurl = None
			try:
				uri = uri.split("://")[1]
				if '/' in uri:
					uri = uri.split("/")
					if uri[0] == "live":
						if len(uri) > 2:
							if uri[1] == 'channel':
								liveurl = "https://www.youtube.com/channel/%s/live" % uri[2]
							elif uri[1] == 'user':
								liveurl = "https://www.youtube.com/user/%s/live" % uri[2]
							elif uri[1] == 'id':
								liveurl = "https://www.youtube.com/watch?v=%s" % uri[2]
						else:
							if uri[1].startswith('UC'):
								liveurl = "https://www.youtube.com/channel/%s/live" % uri[1]
							else:
								liveurl = "https://www.youtube.com/user/%s/live" % uri[1]
						video_id = None
				else:
					video_id = uri
			except:
				pass
			def onUrlReady(uri, suburi=''):
				try:
					if not service.ptrValid():
						Log.w("Service became invalid!")
						return
					if uri:
						if ".m3u8" in uri:
							if "hls_variant" in uri:
								twAgentGetPage(uri).addCallback(self.parseData, service)
							else:
								service.setResolvedUri(uri, eServiceReference.idGST)
						else:
							if suburi and suburi not in ["yt_dash_audio"]:
								service.setResolvedUri(uri, eServiceReference.idGST, suburi)
							else:
								service.setResolvedUri(uri, eServiceReference.idGST)
					else:
						service.failedToResolveUri()
				except:
					service.failedToResolveUri()

			if video_id:
				y = youtubeUrl(self)
				y.addCallback(onUrlReady)
				y.getVideoUrl(video_id)
			elif liveurl:
				twAgentGetPage(liveurl).addCallback(self.parseLive, service)
			else:
				service.failedToResolveUri()

			return True

		def parseLive(self, data, service):
			data = data.replace('\\/', '/').replace('\\"', '"')
			urls = re.findall('hlsManifestUrl":"(http.*?\.m3u8)"(?:}|,)', data, re.S)
			if urls:
				uri = urls[-1]
				try:
					if not service.ptrValid():
						Log.w("Service became invalid!")
						return
					if uri:
						if "hls_variant" in uri:
							twAgentGetPage(uri).addCallback(self.parseData, service)
						else:
							service.setResolvedUri(uri, eServiceReference.idGST)
					else:
						service.failedToResolveUri()
				except:
					service.failedToResolveUri()
			else:
				service.failedToResolveUri()

		def parseData(self, data, service):
			urls = re.findall('(https://.*?itag\/(\d+)\/.*?)\n', data, re.S)
			if urls:
				uri = urls[-1][0]
				try:
					if not service.ptrValid():
						Log.w("Service became invalid!")
						return
					if uri:
						service.setResolvedUri(uri, eServiceReference.idGST)
					else:
						service.failedToResolveUri()
				except:
					service.failedToResolveUri()
			else:
				service.failedToResolveUri()

except ImportError:
	pass