﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *

agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36'
json_headers = {
	'Accept': 'application/json',
	'Accept-Language': 'de,en-US;q=0.7,en;q=0.3',
	'X-Requested-With': 'XMLHttpRequest',
	'Content-Type': 'application/x-www-form-urlencoded',
	}
default_cover = "file://%s/youjizz.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
cookies=CookieJar()

class youjizzGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("YouJizz.com")
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		url = "https://www.youjizz.com/tags"
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		parse = re.search('class="tags-wrapper(.*?)</ul>', data, re.S)
		if parse:
			Cats = MPfindall(self, 'href="(.*?)(?:1.html|)">(.*?)</a>.*?class="tag-count">\s{0,1}\((\d+)\)', parse.group(1), re.S)
			if Cats:
				for (Url, Title, Count) in Cats:
					Url = "https://www.youjizz.com" + Url
					Count = int(Count.replace(',', ''))
					if Count > 250:
						self._items.append((upperString(Title), Url, default_cover))
		# remove duplicates
		self._items = list(set(self._items))
		self._items.sort()
		self._items.insert(0, ("HD", "https://www.youjizz.com/highdefinition/", default_cover))
		self._items.insert(0, ("Top Rated (All Time)", "https://www.youjizz.com/top-rated/", default_cover))
		self._items.insert(0, ("Top Rated (Monthly)", "https://www.youjizz.com/top-rated-month/", default_cover))
		self._items.insert(0, ("Top Rated (Weekly)", "https://www.youjizz.com/top-rated-week/", default_cover))
		self._items.insert(0, ("Most Popular", "https://www.youjizz.com/most-popular/", default_cover))
		self._items.insert(0, ("Most Recent", "https://www.youjizz.com/newest-clips/", default_cover))
		self._items.insert(0, ("--- Search ---", "callSuchen", default_cover))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		self['name'].setText('')
		cover = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(cover)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		if Name == "--- Search ---":
			self.suchen(suggest_func=self.getSuggestions)
		else:
			self.session.open(youjizzFilmScreen, Link, Name)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '-'))
			self.session.open(youjizzFilmScreen, Link, Name)

	def getSuggestions(self, text, max_res):
		url = "https://www.youjizz.com/searchWords?q=%s" % urllib.parse.quote_plus(text)
		d = twAgentGetPage(url, agent=agent, headers=json_headers, timeout=5)
		d.addCallback(self.gotSuggestions, max_res)
		d.addErrback(self.gotSuggestions, max_res, err=True)
		return d

	def gotSuggestions(self, suggestions, max_res, err=False):
		list = []
		if not err and type(suggestions) in (str, buffer):
			suggestions = json.loads(suggestions)
			for item in suggestions:
				li = item
				list.append(str(li))
				max_res -= 1
				if not max_res: break
		elif err:
			printl(str(suggestions), self, 'E')
		return list

class youjizzFilmScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("YouJizz.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1
		self.keywords = False

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*Search", self.Name):
			url = "https://www.youjizz.com/search/%s-%s.html" % (self.Link, str(self.page))
		else:
			url = self.Link + str(self.page) + ".html"
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		self.data = data
		self.getLastPage(data, 'class="pagination(.*?)</div>')
		Movies = MPfindall(self, 'class="video-thumb".*?href="(.*?)".*?<img.*?data-original="(.*?)".*?class="video-title">.*?>(.*?)</a.*?class="time">(.*?)</span>.*?format-views">(\d+)</span>', data, re.S)
		if Movies:
			for (Url, Image, Title, Runtime, Views) in Movies:
				Url = "https://www.youjizz.com" + Url
				if Image.startswith('//'):
					Image = "https:" + Image
				if not Title:
					Title = urllib.parse.unquote_plus(re.sub('\d+.html', '', Url.split('/videos/')[1].replace('-', ' ').strip()))
				self._items.append((decodeHtml(Title), Url, Image, Runtime, Views))
		if len(self._items) == 0:
			self._items.append((_('No movies found!'), "", None, None, None))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		pic = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][3]
		views = self['liste'].getCurrent()[0][4]
		self['name'].setText(title)
		self['handlung'].setText("Runtime: %s\nViews: %s" % (runtime, views))
		CoverHelper(self['coverArt']).getCover(pic)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		if Link:
			twAgentGetPage(Link, agent=agent, cookieJar=cookies).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		match = MPfindall(self, '"quality":(?:"\d+"|false),(?:"name":"play",|)"filename":"(.{0,4}cdn.*?)"', data, re.S)
		if match:
			url = "http:" + match[-1].replace('\/', '/')
			Title = self['liste'].getCurrent()[0][0]
			mp_globals.player_agent = agent
			self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='youjizz')