﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from builtins import object
from ...plugin import _
from ...resources.imports import *
from ...resources.configlistext import ConfigListScreenExt
from ...resources.keyboardext import VirtualKeyBoardExt
from ...resources.choiceboxext import ChoiceBoxExt
import cookielib

config_mp.mediaportal.xvideos_country = ConfigText(default="de", fixed_size=False)
config_mp.mediaportal.xvideosred_username = ConfigText(default="xvideosredUserName", fixed_size=False)
config_mp.mediaportal.xvideosred_password = ConfigPassword(default="xvideosredPassword", fixed_size=False)

xv_cookies_default = CookieJar()
xv_cookies_red = cookielib.LWPCookieJar(config_mp.mediaportal.watchlistpath.value + "xvideosred.cookie")
xv_cookies = CookieJar()
ck = {}
xvLoggedIn_default = False
xvLoggedIn_red = False
xvLoggedIn = False
agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.141 Safari/537.36'
json_headers = {
	'Accept': 'application/json',
	'Accept-Language': 'de,en-US;q=0.7,en;q=0.3',
	'X-Requested-With': 'XMLHttpRequest',
	'Content-Type': 'application/x-www-form-urlencoded',
	}
headers = {
	'Accept':'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
	'Accept-Encoding':'deflate',
	'Accept-Language':'en-US,en;q=0.9',
	}

class LoginFunc(object):

	def LoginClear(self, callback):
		global headers
		headers.update({'Referer':'https://www.xvideos.red/'})
		headers.update({'Host':'www.xvideos.red'})
		global xvLoggedIn
		if xvLoggedIn:
			callback()
		else:
			self.checkLoggedIn(callback)

	def checkLoggedIn(self, callback):
		loginUrl = "https://www.xvideos.red/"
		print('############loginCheck')
		twAgentGetPage(loginUrl, agent=agent, cookieJar=xv_cookies, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.checkLoggedIn2, callback).addErrback(self.dataError)

	def checkLoggedIn2(self, data, callback):
		if '"is_logged":true' in data:
			print('############loginCheck1')
			global xvLoggedIn
			xvLoggedIn = True
			callback()
		else:
			print('############loginCheck2')
			global xvLoggedIn
			xv_cookies.clear()
			xvLoggedIn = False
			self.Login(callback)

	def Login(self, callback):
		loginUrl = "https://www.xvideos.red/account/signinform"
		loginData = {}
		print('############login1')
		twAgentGetPage(loginUrl, agent=agent, method='POST', postdata=urlencode(loginData), cookieJar=xv_cookies, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.Login2, callback).addErrback(self.dataError)

	def Login2(self, data, callback):
		data = data.replace('\\"', '"')
		print(data)
		token = MPfindall(self, '<input type="hidden" value="([A-Za-z0-9-_=]+)" name="signin-form\[csrf_token\]"', data, re.S)
		pms = MPfindall(self, '<input type="hidden" value="([A-Za-z0-9-_=]+)" name="signin-form\[pms\]"', data, re.S)
		if token and pms:
			if self.username != "xvideosredUserName" and self.password != "xvideosredPassword":
				loginUrl = "https://www.xvideos.red/account/signinform"
				loginData = {
					'signin-form[votes]': '',
					'signin-form[subs]': '',
					'signin-form[post_referer]': 'https://www.xvideos.red/',
					'signin-form[csrf_token]': token[0],
					'signin-form[pms]': pms[0],
					'signin-form[login]': config_mp.mediaportal.xvideosred_username.value,
					'signin-form[password]': config_mp.mediaportal.xvideosred_password.value,
					}
				print('############login2')
				twAgentGetPage(loginUrl, agent=agent, method='POST', postdata=urlencode(loginData), cookieJar=xv_cookies, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.Login3, callback).addErrback(self.dataError)
			else:
				callback()
		else:
			callback()

	def Login3(self, data, callback):
		print('############login3')
		print(data)
		global xvLoggedIn
		user = '"username":"%s"' % self.username
		if "Too fast. Please try again in few seconds." in data:
			self.session.open(MessageBoxExt, _("Too fast. Please try again in few seconds."), MessageBoxExt.TYPE_INFO, timeout=5)
			xvLoggedIn = False
		elif '"is_premium":true' in data:
			xvLoggedIn = True
		else:
			xvLoggedIn = False
		callback()

class xvideosGenreScreen(MPScreen, LoginFunc):

	def __init__(self, session, mode='', Link=None, Name=None):
		self.Link = Link
		self.Name = Name
		self.mode = mode
		global default_cover
		if self.mode == 'red':
			self.portal = "XVideos RED"
			self.baseurl = "https://www.xvideos.red"
			default_cover = "file://%s/xvideosred.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
			self.username = str(config_mp.mediaportal.xvideosred_username.value)
			self.password = str(config_mp.mediaportal.xvideosred_password.value)
			global xv_cookies
			if os.path.exists(config_mp.mediaportal.watchlistpath.value + "xvideosred.cookie"):
				xv_cookies_red.load()
			xv_cookies = xv_cookies_red
			global xvLoggedIn
			xvLoggedIn = xvLoggedIn_red
		else:
			self.portal = "XVideos.com"
			self.baseurl = "https://www.xvideos.com"
			default_cover = "file://%s/xvideos.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
			self.username = ''
			self.password = ''
			global xv_cookies
			xv_cookies = xv_cookies_default
			global xvLoggedIn
			xvLoggedIn = xvLoggedIn_default

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancelSave,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"green" : self.keyCountry,
			"yellow" : self.keyScope,
			"blue": self.keySetup
		}, -1)

		self.scope = 0
		self.scopeText = ['Straight', 'Shemale', 'Gay']
		self.scopeval = ['', 'shemale/', 'gay/']

		self['title'] = Label(self.portal)
		if self.Name:
			self['ContentTitle'] = Label("Genre: %s" % self.Name)
		else:
			self['ContentTitle'] = Label("Genre:")
		if self.Name != "Best Videos":
			self['F3'] = Label(self.scopeText[self.scope])
		if mode == "red":
			self['F4'] = Label(_("Setup"))
		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.country_list = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.checkLogin)

	def checkLogin(self):
		if self.mode == "red":
			self.LoginClear(self.layoutFinished)
		else:
			global headers
			headers.update({'Referer':'https://www.xvideos.com/'})
			headers.update({'Host':'www.xvideos.com'})
			self.layoutFinished()

	def layoutFinished(self):
		self._items = []
		self['name'].setText(_('Please wait...'))
		twAgentGetPage('%s/account/getcountries/en' % self.baseurl, agent=agent, cookieJar=xv_cookies, headers=headers).addCallback(self.parseCountry).addErrback(self.dataError)
		twAgentGetPage('%s/change-country/%s' % (self.baseurl, config_mp.mediaportal.xvideos_country.value), agent=agent, cookieJar=xv_cookies, headers=headers).addCallback(self.layoutFinished2).addErrback(self.dataError)

	def layoutFinished2(self, data):
		self._items = []
		if self.scopeval[self.scope] == '':
			orientation = "straight"
		else:
			orientation = self.scopeval[self.scope]
		twAgentGetPage('%s/switch-sexual-orientation/%s' % (self.baseurl, orientation), agent=agent, cookieJar=xv_cookies, headers=headers).addCallback(self.layoutFinished3).addErrback(self.dataError)

	def layoutFinished3(self, data):
		self.keyLocked = True
		if self.Link:
			self.url = self.Link
		else:
			if self.scopeval[self.scope] == '':
				self.url = self.baseurl + "/lang"
			else:
				self.genreData(data)
				return
		twAgentGetPage(self.url, agent=agent, cookieJar=xv_cookies, headers=headers).addCallback(self.genreData).addErrback(self.dataError)

	def parseCountry(self, data):
		self.country_list = []
		countrydata = re.search('("countries":.*?}})', data, re.S)
		if countrydata:
			countries = MPfindall(self, '"(\w\w)":"(.*?)"', countrydata.group(1))
			if countries:
				for country, name in countries:
					try:
						self.country_list.append([decodeHtml(str(name)), str(country).lower()])
					except:
						continue
				self['F2'].setText(_("Country")+": "+config_mp.mediaportal.xvideos_country.value.upper())
			else:
				self['F2'].setText("")

	def genreData(self, data):
		if self.Name:
			parse = re.search('id="main">(.*?)$', data, re.S)
			if parse:
				Cats = MPfindall(self, '<li(?: class="hidden"|)><a href="(.*?)" class="btn btn-default.*?">(.*?)</a></li>', parse.group(1), re.S)
				if Cats:
					for (Url, Title) in Cats:
						Url = self.baseurl + Url + "/$$PAGE$$"
						self._items.append((Title, Url, default_cover, False))
		else:
			Cats = MPfindall(self, 'class="dyn.*?href="/c/(.*?)".*?>(.*?)</a', data, re.S)
			if Cats:
				for (Url, Title) in Cats:
					Url = self.baseurl + "/c/$$SORT$$$$AGE$$$$DURATION$$$$QUALITY$$" + Url + "/$$PAGE$$"
					self._items.append((Title, Url, default_cover, True))
			Cats = MPfindall(self, 'class="dyn.*?href="/\?k=(.*?)(?:\&top|)".*?>(.*?)</a', data, re.S)
			if Cats:
				for (Url, Title) in Cats:
					Url = self.baseurl + "/?k=%s&p=$$PAGE$$" % Url
					self._items.append((Title, Url, default_cover, True))
			Cats = MPfindall(self, 'li><a href="/lang/(.*?)"\stitle="(.*?)"', data, re.S)
			self._items.sort()
			if self.scopeval[self.scope] == '' and self.mode != "red":
				self._items.append((400 * "—", None, default_cover, False))
				if Cats:
					for (Url, Title) in Cats:
						Url = self.baseurl + "/porn/" + Url + "/$$PAGE$$"
						self._items.append((Title, Url, default_cover, False))
			if self.mode == "red":
				self._items.insert(0, (400 * "—", None, default_cover, False))
				self._items.insert(0, ("History", "%s/history/$$PAGE$$" % self.baseurl, default_cover, False))
				self._items.insert(0, ("Custom Homepage", "%s/feed/$$PAGE$$" % self.baseurl, default_cover, False))
			if self.scopeval[self.scope] == '':
				self._items.insert(0, (400 * "—", None, default_cover, False))
				self._items.insert(0, ("Channels", "%s/channels-index/$$AGE$$$$PAGE$$" % self.baseurl, default_cover, False))
				self._items.insert(0, (400 * "—", None, default_cover, False))
				self._items.insert(0, ("Amateurs", "%s/amateurs-index/$$AGE$$$$PAGE$$" % self.baseurl, default_cover, False))
				self._items.insert(0, ("Erotic Models", "%s/erotic-models-index/$$AGE$$$$PAGE$$" % self.baseurl, default_cover, False))
				self._items.insert(0, ("Cam Girls", "%s/webcam-models-index/$$AGE$$$$PAGE$$" % self.baseurl, default_cover, False))
				self._items.insert(0, ("Porn Actresses", "%s/porn-actresses-index/$$AGE$$$$PAGE$$" % self.baseurl, default_cover, False))
				self._items.insert(0, ("Pornstars", "%s/pornstars-index/$$AGE$$$$PAGE$$" % self.baseurl, default_cover, False))
				self._items.insert(0, (400 * "—", None, default_cover, False))
				self._items.insert(0, ("100% Verified", "%s/verified/videos/$$PAGE$$" % self.baseurl, default_cover, False))
				self._items.insert(0, ("Best Videos", "%s/best" % self.baseurl, default_cover, False))
				self._items.insert(0, ("Newest", "%s/new/$$PAGE$$" % self.baseurl, default_cover, False))
			else:
				self._items.insert(0, (400 * "—", None, default_cover, False))
				self._items.insert(0, ("Channels", "%s/channels-%s/$$AGE$$$$PAGE$$" % (self.baseurl, self.scopeval[self.scope][:-1]), default_cover, False))
				self._items.insert(0, (400 * "—", None, default_cover, False))
				self._items.insert(0, ("Amateurs", "%s/amateurs-index/%s$$AGE$$$$PAGE$$" % (self.baseurl, self.scopeval[self.scope]), default_cover, False))
				self._items.insert(0, ("Porn Actresses", "%s/porn-actresses-index/%s$$AGE$$$$PAGE$$" % (self.baseurl, self.scopeval[self.scope]), default_cover, False))
				self._items.insert(0, ("Pornstars", "%s/pornstars-index/%s$$AGE$$$$PAGE$$" % (self.baseurl, self.scopeval[self.scope]), default_cover, False))
				self._items.insert(0, (400 * "—", None, default_cover, False))
				self._items.insert(0, ("100% Verified", "%s/verified-%s/videos/$$PAGE$$" % (self.baseurl, self.scopeval[self.scope][:-1]), default_cover, False))
				self._items.insert(0, ("Best Videos", "%s/best-of-%s" % (self.baseurl, self.scopeval[self.scope][:-1]), default_cover, False))
				self._items.insert(0, ("Newest", "%s/%s$$PAGE$$" % (self.baseurl, self.scopeval[self.scope]), default_cover, False))
			self._items.insert(0, ("--- Search ---", "callSuchen", default_cover, True))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self['name'].setText('')
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		cover = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(cover)

	def keyOK(self):
		if self.keyLocked:
			return
		if self.mode == "red":
			global xv_cookies_red
			xv_cookies_red = xv_cookies
			xv_cookies_red.save()
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		Sort = self['liste'].getCurrent()[0][3]
		if Name == "--- Search ---":
			self.suchen(suggest_func=self.getSuggestions)
		elif Name == "Best Videos":
			self.session.open(xvideosGenreScreen, self.mode, Link, Name)
		elif Name in ["Pornstars", "Channels", "Amateurs", "Erotic Models", "Cam Girls", "Porn Actresses"]:
			self.session.open(xvideosPornstarsScreen, Link, Name, Sort, Scope=self.scopeval[self.scope][:-1], mode=self.mode)
		elif self.Name and self.Name.endswith("Best Videos"):
			self.session.open(xvideosFilmScreen, Link, Name, Sort, Best=True, mode=self.mode)
		else:
			if Link:
				self.session.open(xvideosFilmScreen, Link, Name, Sort, Scope=self.scopeval[self.scope][:-1], mode=self.mode)

	def keyScope(self):
		if self.keyLocked:
			return
		if self.Name == "Best Videos":
			return
		self._items = []
		if self.scope == 0:
			self.scope = 1
		elif self.scope == 1:
			self.scope = 2
		else:
			self.scope = 0
		self['F3'].setText(self.scopeText[self.scope])
		self.layoutFinished()

	def keyCountry(self):
		if self.keyLocked:
			return
		if self.Name == "Best Videos":
			return
		if len(self.country_list) > 0:
			self.session.openWithCallback(self.keyCountryAction, ChoiceBoxExt, title=_('Select Country'), list=self.country_list, keys=[])

	def keyCountryAction(self, result):
		if result:
			config_mp.mediaportal.xvideos_country.value = result[1]
			config_mp.mediaportal.xvideos_country.save()
			configfile_mp.save()
			self.layoutFinished()

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '+'))
			self.session.open(xvideosFilmScreen, Link, Name, True, Scope=self.scopeval[self.scope][:-1], mode=self.mode)

	def getSuggestions(self, text, max_res):
		url = self.baseurl + "/search-suggest/%s%s" % (self.scopeval[self.scope], urllib.parse.quote_plus(text))
		d = twAgentGetPage(url, agent=agent, cookieJar=xv_cookies, headers=json_headers, timeout=5)
		d.addCallback(self.gotSuggestions, max_res)
		d.addErrback(self.gotSuggestions, max_res, err=True)
		return d

	def gotSuggestions(self, suggestions, max_res, err=False):
		list = []
		if not err and type(suggestions) in (str, buffer):
			suggestions = json.loads(suggestions)
			for item in suggestions["KEYWORDS"]:
				li = item['N']
				list.append(str(li))
				max_res -= 1
				if not max_res: break
		elif err:
			printl(str(suggestions), self, 'E')
		return list

	def keySetup(self):
		if not self.mode == "red":
			return
		self.session.openWithCallback(self.setupCallback, xvideosSetupScreen, self.portal, self.mode, is_dialog=True)

	def setupCallback(self, answer=False):
		if answer:
			xv_cookies.clear()
			requests.cookies.cookiejar_from_dict(ck, cookiejar=xv_cookies)
			global xvLoggedIn
			xvLoggedIn = False
			self.username = str(config_mp.mediaportal.xvideosred_username.value)
			self.password = str(config_mp.mediaportal.xvideosred_password.value)
			self.LoginClear(self.layoutFinished)

	def keyCancelSave(self):
		if self.mode == "red":
			global xv_cookies_red
			xv_cookies_red = xv_cookies
			xv_cookies_red.save()
			global xvLoggedIn_red
			xvLoggedIn_premium = xvLoggedIn
		else:
			global xv_cookies_default
			xv_cookies_default = xv_cookies
			global xvLoggedIn_default
			xvLoggedIn_default = xvLoggedIn
		self.keyCancel()

class xvideosSetupScreen(MPSetupScreen, ConfigListScreenExt):

	def __init__(self, session, portal, mode=''):
		MPSetupScreen.__init__(self, session, skin='MP_PluginSetup')

		self['title'] = Label(portal + " " + _("Setup"))
		self['F4'] = Label('')
		self.setTitle(portal + " " + _("Setup"))

		self.list = []
		ConfigListScreenExt.__init__(self, self.list)

		if mode == "red":
			self.list.append(getConfigListEntry(_("Username:"), config_mp.mediaportal.xvideosred_username))
			self.list.append(getConfigListEntry(_("Password:"), config_mp.mediaportal.xvideosred_password))

		self["config"].setList(self.list)

		self["setupActions"] = ActionMap(["MP_Actions"],
		{
			"ok"    : self.keySave,
			"cancel": self.keyCancel
		}, -1)

	def keySave(self):
		for x in self["config"].list:
			if len(x) > 1:
				x[1].save()
		self.close(True)

class xvideosPornstarsScreen(MPScreen):

	def __init__(self, session, Link, Name, Sort, Scope, mode=''):
		self.Link = Link
		self.Name = Name
		self.Sort = Sort
		self.Scope = Scope
		self.mode = mode
		if mode == "red":
			self.portal = "XVideos RED"
			self.baseurl = "https://www.xvideos.red"
		else:
			self.portal = "XVideos.com"
			self.baseurl = "https://www.xvideos.com"

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber,
			"yellow" : self.keyRegion,
			"blue" : self.keyFilter
		}, -1)

		self['title'] = Label(self.portal)
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))
		self['F3'] = Label(_("Region"))
		self['F4'] = Label(_("Filter"))
		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1
		from ...resources import iso3166
		self.cc = config_mp.mediaportal.xvideos_country.value
		self.cc = str(iso3166.countries.get(self.cc))
		self.cc = re.search('.*?name=u\'(.*?)\'', self.cc, re.S).group(1)
		if self.Name == "Channels":
			self.age = ''
			self.agename = 'Watched recently (%s)' % self.cc
		else:
			self.age = ''
			self.agename = '1 Year (%s)' % self.cc
		self.region = ''
		self.regionname = 'World'

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if self.page > 1:
			page = str(self.page-1)
		else:
			page = ''
		if self.agename == "Newest":
			url = self.Link.replace('$$PAGE$$', page).replace('$$AGE$$', self.age + self.region)
		else:
			url = self.Link.replace('$$PAGE$$', page).replace('$$AGE$$', self.region + self.age)
		twAgentGetPage(url, agent=agent, cookieJar=xv_cookies, headers=headers).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		self.getLastPage(data, 'class="pagination(.*?)</div>')
		Movies = MPfindall(self, 'class="thumb"><a href="(.*?)">.*?<img src="(.*?)".*?(class="profile-name".*?)</p></div>', data, re.S)
		if Movies:
			for (Url, Image, Meta) in Movies:
				Title = MPfindall(self, 'class="profile-name">(?:.*?<a href=".*?">|)(.*?)(?:</a>|</span>)', Meta, re.S)
				if Title:
					Title = stripAllTags(Title[0].replace('&nbsp;',''))
					Title = re.sub(r"\s+", " ", Title).strip()
				else:
					Title = "---"
				if Url.endswith('/shemale'):
					Url = Url.split('/shemale')[0]
					Url = self.baseurl + Url + "/videos/$$PORNSTAR$$/shemale/$$PAGE$$"
				elif Url.endswith('/gay'):
					Url = Url.split('/gay')[0]
					Url = self.baseurl + Url + "/videos/$$PORNSTAR$$/gay/$$PAGE$$"
				else:
					Url = self.baseurl + Url + "/videos/$$PORNSTAR$$/$$PAGE$$"
				Image = Image.replace('img-hw.xvideos-cdn', 'img-egc.xvideos-cdn').replace('thumbs169/', 'thumbs169lll/').replace('thumbs169ll/', 'thumbs169lll/')
				self._items.append((decodeHtml(Title), Url, Image))
		if self.Name == "Channels" and len(self._items) == 0:
				self._items.append((_('No channels found!'), "", None, None, None))
				self._setList('_defaultlistleft', False, mode='list')
		elif len(self._items) == 0:
				self._items.append((_('No pornstars found!'), "", None, None, None))
				self._setList('_defaultlistleft', False, mode='list')
		else:
			self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def keyFilter(self):
		if self.keyLocked:
			return
		if self.Name == "Channels":
			rangelist = [ ['Watched recently (%s)' % self.cc, ''], ['Top rankings (%s)' % self.cc, 'top/'], ['Watched recently (World)', 'from/worldwide/'], ['Top rankings (World)', 'from/worldwide/top/'], ['Newest', 'new/'] ]
		else:
			rangelist = [ ['Ever (%s)' % self.cc, 'ever/'], ['1 Year (%s)' % self.cc, ''], ['3 Months (%s)' % self.cc, '3months/'], ['Ever (World)', 'from/worldwide/ever/'], ['1 Year (World)', 'from/worldwide/'], ['3 Months (World)', 'from/worldwide/3months/'], ['Newest', 'new/'] ]
		self.session.openWithCallback(self.keyFilterAction, ChoiceBoxExt, title=_('Select Action'), list = rangelist)

	def keyFilterAction(self, result):
		if result:
			self.age = result[1]
			self.agename = result[0]
			self.loadPage()

	def keyRegion(self):
		if self.keyLocked:
			return
		rangelist = [ ['World', ''], ['Germany', 'germany/'], ['Europe', 'europe/'], ['North America', 'north_america/'], ['South America', 'latin/'], ['Asia', 'asia/'], ['Africa', 'africa/'] ]
		self.session.openWithCallback(self.keyRegionAction, ChoiceBoxExt, title=_('Select Action'), list = rangelist)

	def keyRegionAction(self, result):
		if result:
			self.region = result[1]
			self.regionname = result[0]
			self.loadPage()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1].replace('/videos/$$PORNSTAR$$/shemale/$$PAGE$$', '').replace('/videos/$$PORNSTAR$$/gay/$$PAGE$$', '').replace('/videos/$$PORNSTAR$$/$$PAGE$$', '')
		self['name'].setText(title)
		twAgentGetPage(Link, agent=agent, cookieJar=xv_cookies, headers=headers).addCallback(self.showInfos2).addErrback(self.dataError)

	def showInfos2(self, data):
		infos = MPfindall(self, 'class="profile-pic">(.*?)class="user-subscribe', data, re.S)
		if infos:
			for meta in infos:
				image = MPfindall(self, '<img src="(.*?)"', meta, re.S)
				if image:
					image = image[0]
				else:
					image = self['liste'].getCurrent()[0][2]
				CoverHelper(self['coverArt']).getCover(image)

				modelinfo = MPfindall(self, 'class="after-aka mobile-hide">(.*?)</small', meta, re.S)
				if modelinfo:
					modelinfo = modelinfo[0].strip()
				else:
					modelinfo = ''

				country = MPfindall(self, 'class="flag.*?title="(.*?)">', meta, re.S)
				if country:
					country = country[0].strip()
				else:
					country = ''

				aka = MPfindall(self, 'class="aka mobile-hide">.*?AKA (.*?)</small', meta, re.S)
				if aka:
					aka = re.sub(r"\s+", " ", stripAllTags(aka[0])).replace(' -', '').strip()
				else:
					aka = ''

				info = ''
				if aka:
					info = "AKA: " + decodeHtml(aka) + "\n"

				if modelinfo:
					info = info + "Info: " + decodeHtml(modelinfo) + "\n"

				if country:
					info = info + "Country: " + decodeHtml(country) + "\n"

				if info:
					info = info + "\n"

				self['extrainfo'].setText("%s: %s / %s: %s" % (_("Date"), self.agename, _("Region"), self.regionname))
				self['handlung'].setText(info)
		else:
			title = self['liste'].getCurrent()[0][0]
			pic = self['liste'].getCurrent()[0][2]
			self['name'].setText(title)
			self['extrainfo'].setText("%s: %s" % (_("Date"), self.agename))
			self['handlung'].setText('')
			CoverHelper(self['coverArt']).getCover(pic)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		self.session.open(xvideosFilmScreen, Link, Name, False, Pornstar=True, Scope=self.Scope, mode=self.mode)

class xvideosFilmScreen(MPScreen, LoginFunc):

	def __init__(self, session, Link, Name, Sort, Related=False, Best=False, Pornstar=False, Scope='', mode=''):
		self.Link = Link
		self.Name = Name
		self.Sort = Sort
		self.Related = Related
		self.Best = Best
		self.Pornstar = Pornstar
		self.mode = mode
		global default_cover
		if self.mode == 'red':
			self.portal = "XVideos RED"
			self.baseurl = "https://www.xvideos.red"
			default_cover = "file://%s/xvideosred.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
			self.username = str(config_mp.mediaportal.xvideosred_username.value)
			self.password = str(config_mp.mediaportal.xvideosred_password.value)
			global xv_cookies
			if os.path.exists(config_mp.mediaportal.watchlistpath.value + "xvideosred.cookie"):
				xv_cookies_red.load()
			xv_cookies = xv_cookies_red
			global xvLoggedIn
			xvLoggedIn = xvLoggedIn_red
		else:
			self.portal = "XVideos.com"
			self.baseurl = "https://www.xvideos.com"
			default_cover = "file://%s/xvideos.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
			self.username = ''
			self.password = ''
			global xv_cookies
			xv_cookies = xv_cookies_default
			global xvLoggedIn
			xvLoggedIn = xvLoggedIn_default
		if Scope == '':
			self.Scope = 'straight'
		else:
			self.Scope = Scope
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancelSave,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"red" : self.keyKeywords,
			"green" : self.keyPageNumber,
			"yellow" : self.keyRelated,
			"blue" : self.keyFilter,
			"debugHelper" : self.debugHelper
		}, -1)

		self['title'] = Label(self.portal)
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))
		self['F3'] = Label(_("Show Related"))
		if self.Sort or self.Pornstar:
			self['F4'].setText(_("More..."))
		elif not self.Related and not self.Best and not self.Sort and self.Name != "Newest" and self.Name != "100% Verified" and not "Porn in" in self.Name and not "$$PORNSTAR$$" in self.Link:
			self['F4'].setText(_("More..."))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1
		if re.match(".*Search", self.Name):
			self.sortname = 'Relevance'
			self.sort = 'relevance'
			self.age = 'all'
			self.agename = 'Anytime'
			self.duration = 'allduration'
			self.durationname = 'All'
			if self.mode == "red":
				self.quality = 'all&premium=1'
				self.qualityname = 'RED All'
			else:
				self.quality = 'all'
				self.qualityname = 'All'
		elif "/?k=" in self.Link:
			self.sortname = 'Newest'
			self.sort = 'uploaddate'
			self.age = 'all'
			self.agename = 'Anytime'
			self.duration = 'allduration'
			self.durationname = 'All'
			if self.mode == "red":
				self.quality = 'all&premium=1'
				self.qualityname = 'RED All'
			else:
				self.quality = 'all'
				self.qualityname = 'All'
		else:
			if "$$SORT$$" in self.Link:
				self.sortname = 'Newest'
				self.sort = 's:uploaddate/'
				self.age = ''
				self.agename = 'Anytime'
				self.duration = ''
				self.durationname = 'All'
				if self.mode == "red":
					self.quality = 'p:1/'
					self.qualityname = 'RED All'
				else:
					self.quality = ''
					self.qualityname = 'All'
			elif self.Sort:
				self.sortname = 'Newest'
				self.sort = 'uploaddate'
				self.age = ''
				self.agename = 'Anytime'
				self.duration = ''
				self.durationname = ''
				self.quality = ''
				self.qualityname = ''
			elif self.Pornstar:
				self.sortname = 'Newest'
				self.sort = 'new'
				self.age = ''
				self.agename = ''
				self.duration = ''
				self.durationname = ''
				self.quality = ''
				self.qualityname = ''
			else:
				self.sortname = ''
				self.sort = ''
				self.age = ''
				self.agename = ''
				self.duration = ''
				self.durationname = ''
				self.quality = ''
				self.qualityname = ''
		self.keywords = False

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.checkLogin)

	def checkLogin(self):
		if self.mode == "red":
			self.LoginClear(self.loadPage)
		else:
			global headers
			headers.update({'Referer':'https://www.xvideos.com/'})
			headers.update({'Host':'www.xvideos.com'})
			self.loadPage()

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if self.Related:
			twAgentGetPage(self.Link, agent=agent, cookieJar=xv_cookies, headers=headers).addCallback(self.genreData).addErrback(self.dataError)
		else:
			if re.match(".*Search", self.Name):
				url = self.baseurl + "/?k=%s&p=%s&sort=%s&datef=%s&durf=%s&quality=%s&typef=%s" % (self.Link, str(self.page-1), self.sort, self.age, self.duration, self.quality, self.Scope)
			elif "/?k=" in self.Link:
				url = self.Link.replace('$$PAGE$$', str(self.page-1)) + "&sort=%s&datef=%s&durf=%s&quality=%s&typef=%s" % (self.sort, self.age, self.duration, self.quality, self.Scope)
			else:
				if self.page == 1 and self.Name == "Newest":
					if self.mode == "red":
						url = self.Link.replace('/new/$$PAGE$$', '/free/$$PAGE$$').replace('/shemale/$$PAGE$$', '/shemale/free/$$PAGE$$').replace('/gay/$$PAGE$$', '/gay/free/$$PAGE$$').replace('$$PAGE$$', '')
					else:
						url = self.Link.replace('/new/$$PAGE$$', '').replace('$$PAGE$$', '')
				elif self.page == 1 and "Porn in" in self.Name:
					url = self.Link.replace('$$PAGE$$', '')
				else:
					if self.page == 1 and "/c/" in self.Link:
						url = self.Link.replace('$$PAGE$$', '')
					else:
						url = self.Link.replace('$$PAGE$$', str(self.page-1))
					url= url.replace('$$SORT$$', self.sort).replace('$$AGE$$', self.age).replace('$$DURATION$$', self.duration).replace('$$QUALITY$$', self.quality)
			if "$$PORNSTAR$$" in url:
				url = url.replace('$$PORNSTAR$$', self.sort)
			if "/feed/" in url:
				postdata = {'view_mode':0, 'sort':0, 'show_free':0, 'premium_min_length':0, 'free_min_length':0, 'quality':'360P'}
				if self.Scope == 'straight':
					orientation = ''
				else:
					orientation = self.Scope
				twAgentGetPage(url, method='POST', agent=agent, postdata=urlencode(postdata), cookieJar=xv_cookies, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.genreData).addErrback(self.dataError)
			elif self.Pornstar:
				postdata = {'main_cats[]': self.Scope}
				twAgentGetPage(url, method='POST', agent=agent, postdata=urlencode(postdata), cookieJar=xv_cookies, headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.genreData).addErrback(self.dataError)
			else:
				twAgentGetPage(url, agent=agent, cookieJar=xv_cookies, headers=headers, timeout=40).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		if self.Related:
			self['page'].setText('1 / 1')
			datarel = MPfindall(self, 'var video_related=(.*?);window.wpn_categories', data, re.S)
			if datarel:
				json_data = json.loads(datarel[0])
				for item in json_data:
					Title = str(item["tf"])
					Url = self.baseurl + str(item["u"])
					Image = str(item["i"])
					Runtime = str(item["d"])
					Views = str(item["n"])
					if item["pm"]:
						premium = True
					else:
						premium = False
					self._items.append((decodeHtml(Title), Url, Image, False, Runtime, Views, '', '', '', premium, 'xv'))
		else:
			self.keyword_list = []
			if re.match(".*Search", self.Name) or "/?k=" in self.Link:
				keydata = re.search('Related searches</strong>(.*?)</div', data, re.S)
				if keydata:
					keywords = MPfindall(self, '<a href="/\?k=(.*?)&amp;related">(.*?)</a>', keydata.group(1), re.S)
					if keywords:
						for keyword in keywords:
							self.keyword_list.append([keyword[1], keyword[0]])
							self['F1'].setText(_("Keywords"))
							self.keywords = True
					else:
						self['F1'].setText("")
						self.keywords = False
				else:
					self['F1'].setText("")
					self.keywords = False
			try:
				json_data = json.loads(data)
				if "html" in json_data:
					data = str(json_data["html"])
					print(data)
			except:
				pass
			self.getLastPage(data, 'class="pagination(.*?)</div>')
			Movies = MPfindall(self, 'id="video_\d+"\s(?:data-id="\d+"\s|)(?:data-is-premium="1"\s|)class="thumb-block\s{0,2}">.*?class="thumb(?: verified-pic|)"><a href="(.*?)"><img src=".*?data-src="(.*?)".*?<a href.*?title="(.*?)">.*?</a></p><p class="metadata">(.*?)</div>', data, re.S)
			if Movies:
				for (Url, Image, Title, Meta) in Movies:
					if 'icf-ticket-red' in Meta:
						premium = True
					else:
						premium = False
					Views = MPfindall(self, 'class="sprfluous"> - </span>\s(.*?)\s<span class="sprfluous">Views</span>', Meta, re.S)
					if Views:
						Views = Views[0]
					else:
						Views = MPfindall(self, '</span>\s(.*?)\s<span class="sprfluous">Views</span>', Meta, re.S)
						if Views:
							Views = Views[0]
						else:
							Views = "0"
					if premium:
						Views = ""
					Runtime = MPfindall(self, 'class="duration">(.*?)</span>', Meta, re.S)
					if Runtime:
						Runtime = Runtime[0]
					else:
						Runtime = "-"
					Url = self.baseurl + Url
					profUrl = None
					profTitle = None
					profiledata = MPfindall(self, 'href="(.*?)".*?>(.*?)</a', Meta, re.S)
					if profiledata:
						for (url, title) in profiledata:
							profUrl = self.baseurl + url + "/videos/$$PORNSTAR$$/$$PAGE$$"
							profTitle = decodeHtml(title)
					if profTitle and self.Name == "100% Verified":
						profTitle = stripAllTags(profTitle)
						Title = profTitle + " - " + decodeHtml(Title)
					Image = Image.replace('img-hw.xvideos-cdn', 'img-egc.xvideos-cdn').replace('thumbs169/', 'thumbs169lll/').replace('thumbs169ll/', 'thumbs169lll/').replace('THUMBNUM.jpg', '15.jpg')
					self._items.append((decodeHtml(Title), Url, Image, False, Runtime, Views, profUrl, profTitle, '', premium, 'xv'))
		if len(self._items) == 0:
			self._items.append((_('No movies found!'), None, None, False, "", "", "", "", "", False, 'xv'))
			self._setList('_defaultlistleft', False, mode='list')
		else:
			self._setList('_defaultlistleftmarkedgrid', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def keyKeywords(self):
		if self.keyLocked:
			return
		if not self.keywords:
			return
		self.session.openWithCallback(self.keyKeywordsAction, ChoiceBoxExt, title=_('Select Action'), list = self.keyword_list)

	def keyKeywordsAction(self, result):
		if result:
			if re.match(".*Search", self.Name):
				self.Link = result[1]
			else:
				self.Link = self.baseurl + "/?k=%s&p=$$PAGE$$" % result[1]
			self.loadPage()

	def keyRelated(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		if Link:
			self.session.open(xvideosFilmScreen, Link, "Related", False, Related=True, mode=self.mode)

	def keyFilter(self):
		if self.keyLocked:
			return
		elif not self.Sort and not self.Pornstar and (self.Name == "Newest" or self.Name == "100% Verified" or "Porn in" in self.Name or "$$PORNSTAR$$" in self.Link):
			return
		if self.Related or self.Best:
			return

		if self.Sort:
			rangelist = [ [_('Sort by'), 'sort'], [_('Date'), 'age'], [_('Runtime'), 'duration'], [_('Video quality'), 'quality'] ]
		elif self.Pornstar:
			rangelist = [ [_('Sort by'), 'sort'] ]
		else:
			rangelist = [ [_('Date'), 'age'] ]
		self.session.openWithCallback(self.keyFilterAction, ChoiceBoxExt, title=_('Select Action'), list = rangelist)

	def keyFilterAction(self, result):
		if result:
			if result[1] == 'sort':
				self.keySort()
			elif result[1] == 'age':
				self.keyAge()
			elif result[1] == 'duration':
				self.keyDuration()
			elif result[1] == 'quality':
				self.keyQuality()

	def keySort(self):
		if self.Sort or self.Pornstar:
			if "$$SORT$$" in self.Link:
				rangelist = [ ['Relevance', ''], ['Newest', 's:uploaddate/'], ['Rating', 's:rating/'], ['Length', 's:length/'], ['Views', 's:views/'] ]
			elif "$$PORNSTAR$$" in self.Link:
				if self.mode == "red":
					rangelist = [ ['RED Watched recently', 'premium'], ['RED Newest', 'premium-new'], ['Regular Watched recently', 'best'], ['Regular Newest', 'new'], ['Regular Most viewed', 'rating'], ['Regular Most commented', 'comments'] ]
				else:
					rangelist = [ ['Watched recently', 'best'], ['Newest', 'new'], ['Most viewed', 'rating'], ['Most commented', 'comments'] ]
			else:
				rangelist = [ ['Relevance', 'relevance'], ['Newest', 'uploaddate'], ['Rating', 'rating'], ['Length', 'length'], ['Views', 'views'] ]
			self.session.openWithCallback(self.keySortAction, ChoiceBoxExt, title=_('Select Action'), list = rangelist)

	def keySortAction(self, result):
		if result:
			self.sort = result[1]
			self.sortname = result[0]
			self.loadPage()

	def keyAge(self):
		if re.match(".*Search", self.Name) or "/?k=" in self.Link:
			rangelist = [ ['Last 3 days', 'today'], ['This week', 'week'], ['This month', 'month'], ['Last 3 month', '3month'], ['Last 6 month', '6month'], ['Anytime', 'allduration'] ]
		else:
			rangelist = [ ['Last 3 days', 'm:today/'], ['This week', 'm:week/'], ['This month', 'm:month/'], ['Last 3 month', 'm:3month/'], ['Last 6 month', 'm:6month/'], ['Anytime', ''] ]
		self.session.openWithCallback(self.keyAgeAction, ChoiceBoxExt, title=_('Select Action'), list = rangelist)

	def keyAgeAction(self, result):
		if result:
			self.age = result[1]
			self.agename = result[0]
			self.loadPage()

	def keyDuration(self):
		if re.match(".*Search", self.Name) or "/?k=" in self.Link:
			rangelist = [ ['Short (1-3min)', '1-3min'], ['Medium (3-10min)', '3-10min'], ['Long (10-20min)', '10-20min'], ['Long (+20min)', '20min_more'], ['All', 'allduration'] ]
		else:
			rangelist = [ ['Short (1-3min)', 'd:1-3min/'], ['Medium (3-10min)', 'd:3-10min/'], ['Long (10-20min)', 'd:10-20min/'], ['Long (+20min)', 'd:20min_more/'], ['All', ''] ]
		self.session.openWithCallback(self.keyDurationAction, ChoiceBoxExt, title=_('Select Action'), list = rangelist)

	def keyDurationAction(self, result):
		if result:
			self.duration = result[1]
			self.durationname = result[0]
			self.loadPage()

	def keyQuality(self):
		if re.match(".*Search", self.Name) or "/?k=" in self.Link:
			if self.mode == "red":
				rangelist = [ ['RED 720p+', 'hd&premium=1'], ['RED All', 'all&premium=1'], ['Regular 720p+', 'hd'], ['Regular All', 'all'] ]
			else:
				rangelist = [ ['720p+', 'hd'], ['All', 'all'] ]
		else:
			if self.mode == "red":
				rangelist = [ ['RED 720p+', 'q:hd/p:1/'], ['RED All', 'p:1/'], ['Regular 720p+', 'q:hd/'], ['Regular All', ''] ]
			else:
				rangelist = [ ['720p+', 'q:hd/'], ['All', ''] ]
		self.session.openWithCallback(self.keyQualityAction, ChoiceBoxExt, title=_('Select Action'), list = rangelist)

	def keyQualityAction(self, result):
		if result:
			self.quality = result[1]
			self.qualityname = result[0]
			self.loadPage()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		pic = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][4]
		views = self['liste'].getCurrent()[0][5]
		self['name'].setText(title)
		if self.agename and self.Name != "Newest" and not self.Best:
			age = "D: %s" % self.agename
			duration = "R: %s" % self.durationname
			quality = "Q: %s" % self.qualityname
		else:
			age = ''
			duration = ''
		if self.sortname:
			sort = "S: %s" % self.sortname
		else:
			sort = ''
		if age and sort:
			self['extrainfo'].setText("%s / %s / %s / %s" % (sort, age, duration, quality))
		elif age:
			self['extrainfo'].setText(age)
		elif sort:
			self['extrainfo'].setText(sort)
		if views:
			views = "\nViews: %s" % views
		else:
			views = ""
		self['handlung'].setText("Runtime: %s%s" % (runtime, views))
		CoverHelper(self['coverArt']).getCover(pic)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		if self.Name == "100% Verified":
			rangelist = [ ['Video', 'video'], ['Profile', 'profile'] ]
			self.session.openWithCallback(self.keyOKAction, ChoiceBoxExt, title=_('Select Action'), list = rangelist)
		elif Link:
			twAgentGetPage(Link, agent=agent, cookieJar=xv_cookies, headers=headers).addCallback(self.parseData).addErrback(self.dataError)

	def keyOKAction(self, result):
		if result:
			if result[1] == "profile":
				Name = self['liste'].getCurrent()[0][7]
				Link = self['liste'].getCurrent()[0][6]
				if Link and Name:
					self.session.open(xvideosFilmScreen, Link, Name, False, Pornstar=True, mode=self.mode)
			else:
				Link = self['liste'].getCurrent()[0][1]
				twAgentGetPage(Link, agent=agent, cookieJar=xv_cookies, headers=headers).addCallback(self.parseData).addErrback(self.dataError)

	def keyCancelSave(self):
		if self.mode == "red":
			global xv_cookies_red
			xv_cookies_red = xv_cookies
			xv_cookies_red.save()
			global xvLoggedIn_red
			xvLoggedIn_premium = xvLoggedIn
		else:
			global xv_cookies_default
			xv_cookies_default = xv_cookies
			global xvLoggedIn_default
			xvLoggedIn_default = xvLoggedIn
		self.keyCancel()

	def parseData(self, data):
		match = MPfindall(self, "setVideo(?:UrlLow|UrlHigh|HLS)\('(.*?)'\);", data)
		if match:
			url = match[-1].replace('\/', '/')
			if "/hls/" in url:
				#if len(url.split('hls.m3u8')[1]) > 0:
				check = MPfindall(self, '.*?(hls.m3u8|hls_premium.*?m3u8)', url, re.S)
				baseurl = url.split(check[0])[0]
				twAgentGetPage(url, agent=agent).addCallback(self.loadplaylist, baseurl).addErrback(self.dataError)
				#else:
				#	if len(match)>1:
				#		url = match[-2].replace('\/','/')
				#		self.playVideo(url)
				#	else:
				#		message = self.session.open(MessageBoxExt, _("Stream not found"), MessageBoxExt.TYPE_INFO, timeout=5)
			else:
				self.playVideo(url)
		else:
			message = self.session.open(MessageBoxExt, _("Stream not found"), MessageBoxExt.TYPE_INFO, timeout=5)

	def loadplaylist(self, data, baseurl):
		self.bandwith_list = []
		match_sec_m3u8=MPfindall(self, 'BANDWIDTH=(\d+).*?NAME="(.*?)".*?\n(.*?m3u8.*?)(?:\n|$)', data, re.S)
		max = 0
		for x in match_sec_m3u8:
			if int(x[0]) > max:
				max = int(x[0])
		videoPrio = int(config_mp.mediaportal.videoquali_others.value)
		if videoPrio == 2:
			bw = max
		elif videoPrio == 1:
			bw = max / 2
		else:
			bw = max / 3
		for each in match_sec_m3u8:
			bandwith, res, url = each
			res = res.replace('p', '').replace('4k', '2160')
			if mp_globals.model in ["one", "two"] or int(res) <= 1080:
				self.bandwith_list.append((int(bandwith), url))
		_x, best = min((abs(int(x[0]) - bw), x) for x in self.bandwith_list)
		url = baseurl + best[1]
		if "vid-egc.xvideos-cdn.com" in url:
			playlist_path = config_mp.mediaportal.storagepath.value+"tmp.m3u8"
			f1 = open(playlist_path, 'w')
			f1.write('#EXTM3U\n#EXT-X-STREAM-INF:PROGRAM-ID=1\n%s' % url)
			f1.close()
			self.playVideo("file:///tmp/tmp.m3u8")
		else:
			self.playVideo(url)

	def playVideo(self, url):
		Title = self['liste'].getCurrent()[0][0]
		mp_globals.player_agent = agent
		self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='xvideos')

	def debugHelper(self):
		if config_mp.mediaportal.debugMode.value == "High":
			_tmp = []
			for i in range(0, len(self._items), 1):
				title = self._items[i][0]
				url = self._items[i][1]
				image = self._items[i][2]
				runtime = self._items[i][4]
				views = self._items[i][5]
				profurl = self._items[i][6]
				proftitle = self._items[i][7]
				_tmp.insert(i, (title, url, image, True, runtime, views, profurl, proftitle, '', True, 'xv'))
			self._items = _tmp
			self._setList('_defaultlistleftmarkedgrid', True)