﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from builtins import map
from ...plugin import _
from ...resources.imports import *
from Tools.BoundFunction import boundFunction
import _thread

BASEURL = "https://stripchat.com/api/front/"

config_mp.mediaportal.stripchat_filter = ConfigText(default="girls", fixed_size=False)
default_cover = "file://%s/stripchat.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36"

class stripchatGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"yellow": self.keyFilter
		}, -1)

		self.filter = config_mp.mediaportal.stripchat_filter.value

		self['title'] = Label("Stripchat.com")
		self['ContentTitle'] = Label("Genre:")
		self['F3'] = Label(self.filter)

		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self._items = []
		self._items.append(("Top Rated", "&sortBy=viewersRating"))
		self._items.append(("Recommended", "&filterGroupTags=%5B%5B%22recommended%22%5D%5D&sortBy=recommendedScore&withMixedTags=true&parentTag=recommended"))
		self._items.append(("New Models", "&filterGroupTags=%5B%5B%22autoTagNew%22%5D%5D&sortBy=trending&withMixedTags=true&parentTag=autoTagNew"))
		if self.filter in ["girls"]:
			self._items.append(("German", "&filterGroupTags=%5B%5B%22tagLanguageGermanSpeaking%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=tagLanguageGermanSpeaking"))
			self._items.append(("Pornstars", "&filterGroupTags=%5B%5B%22pornStar%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=pornStar"))
		if not self.filter in ["men"]:
			self._items.append(("Teen", "&filterGroupTags=%5B%5B%22ageTeen%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=ageTeen"))
		self._items.append(("Young", "&filterGroupTags=%5B%5B%22ageYoung%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=ageYoung"))
		if not self.filter in ["men"]:
			self._items.append(("MILF", "&filterGroupTags=%5B%5B%22ageMilf%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=ageMilf"))
		if not self.filter in ["couples"]:
			self._items.append(("Mature", "&filterGroupTags=%5B%5B%22ageMature%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=ageMature"))
		if self.filter in ["girls"]:
			self._items.append(("Granny", "&filterGroupTags=%5B%5B%22ageOld%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=ageOld"))
		self._items.append(("Arab", "&filterGroupTags=%5B%5B%22ethnicityMiddleEastern%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=ethnicityMiddleEastern"))
		self._items.append(("Asian", "&filterGroupTags=%5B%5B%22ethnicityAsian%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=ethnicityAsian"))
		self._items.append(("Ebony", "&filterGroupTags=%5B%5B%22ethnicityEbony%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=ethnicityEbony"))
		if not self.filter in ["trans"]:
			self._items.append(("Indian", "&filterGroupTags=%5B%5B%22ethnicityIndian%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=ethnicityIndian"))
		self._items.append(("Latina", "&filterGroupTags=%5B%5B%22ethnicityLatino%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=ethnicityLatino"))
		self._items.append(("White", "&filterGroupTags=%5B%5B%22ethnicityWhite%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=ethnicityWhite"))
		if self.filter in ["girls"]:
			self._items.append(("Skinny", "&filterGroupTags=%5B%5B%22bodyTypePetite%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=bodyTypePetite"))
			self._items.append(("Athletic", "&filterGroupTags=%5B%5B%22bodyTypeAthletic%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=bodyTypeAthletic"))
			self._items.append(("Medium", "&filterGroupTags=%5B%5B%22bodyTypeMedium%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=bodyTypeMedium"))
			self._items.append(("Curvy", "&filterGroupTags=%5B%5B%22bodyTypeCurvy%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=bodyTypeCurvy"))
			self._items.append(("BBW", "&filterGroupTags=%5B%5B%22bodyTypeBBW%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=bodyTypeBBW"))
			self._items.append(("Blonde", "&filterGroupTags=%5B%5B%22hairColorBlonde%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=hairColorBlonde"))
			self._items.append(("Brunette", "&filterGroupTags=%5B%5B%22hairColorBlack%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=hairColorBlack"))
			self._items.append(("Redhead", "&filterGroupTags=%5B%5B%22hairColorRed%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=hairColorRed"))
			self._items.append(("Colorful", "&filterGroupTags=%5B%5B%22hairColorColorful%22%5D%5D&sortBy=stripRanking&withMixedTags=true&parentTag=hairColorColorful"))

		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		self.session.open(stripchatFilmScreen, Link, Name)

	def keyFilter(self):
		if self.filter == "girls":
			self.filter = "couples"
			config_mp.mediaportal.stripchat_filter.value = "couples"
		elif self.filter == "couples":
			self.filter = "trans"
			config_mp.mediaportal.stripchat_filter.value = "trans"
		elif self.filter == "trans":
			self.filter = "men"
			config_mp.mediaportal.stripchat_filter.value = "men"
		elif self.filter == "men":
			self.filter = "girls"
			config_mp.mediaportal.stripchat_filter.value = "girls"
		else:
			self.filter = "girls"
			config_mp.mediaportal.stripchat_filter.value = "girls"

		config_mp.mediaportal.stripchat_filter.save()
		configfile_mp.save()
		self['F3'].setText(self.filter)
		self.layoutFinished()

class stripchatFilmScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		self.filter = config_mp.mediaportal.stripchat_filter.value
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions2", "MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"upUp" : self.key_repeatedUp,
			"rightUp" : self.key_repeatedUp,
			"leftUp" : self.key_repeatedUp,
			"downUp" : self.key_repeatedUp,
			"upRepeated" : self.keyUpRepeated,
			"downRepeated" : self.keyDownRepeated,
			"rightRepeated" : self.keyRightRepeated,
			"leftRepeated" : self.keyLeftRepeated,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("Stripchat.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		url = BASEURL + "models?limit=50&offset=%s&primaryTag=%s" % (str((self.page-1)*50), self.filter) + self.Link
		self.filmQ.put(url)
		if not self.eventL.is_set():
			self.eventL.set()
			self.loadPageQueued()

	def loadPageData(self, data):
		self.ml.moveToIndex(0)
		jsondata = json.loads(data)
		lastp = jsondata["filteredCount"]
		lastp = round((float(lastp) / 50) + 0.5)
		self.lastpage = int(lastp)
		self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
		for node in jsondata["models"]:
			Title = str(node["username"])
			Url = str(node["username"])
			Id = str(node["id"])
			Image = str(node["snapshotUrl"])
			Location = str(node["country"])
			from ...resources import iso3166
			try:
				Location = str(iso3166.countries.get(Location))
				Location = re.search('.*?name=u\'(.*?)\'', Location, re.S).group(1)
			except:
				Location = 'unknown'
			Gender = str(node["gender"])
			Preview = str(node["previewUrl"])
			if node["isOnline"] and node["status"] == "public":
				self._items.append((Title, Url, Image, Location, Gender, Preview))
		if len(self._items):
			self._setList('_defaultlistleft', True)
			self.loadPicQueued()
		else:
			self._items.append((_('No livestreams found!'), None, None, None, None, None, None, None))
			self._setList('_defaultlistleft', True)
			if self.filmQ.empty():
				self.eventL.clear()
			else:
				self.loadPageQueued()
		self.keyLocked = False

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		location = self['liste'].getCurrent()[0][3]
		gender = self['liste'].getCurrent()[0][4]
		self['name'].setText(title)
		if gender in ["females", "female"]:
			gender = "female"
		elif gender in ["males", "male"]:
			gender = "male"
		elif gender in ["maleFemale", "females", "males"]:
			gender = "couple"
		elif gender in ["maleTranny", "femaleTranny", "tranny", "trannies"]:
			gender = "transsexual"
		self['handlung'].setText("Gender: %s\nLocation: %s" % (gender, location))

	def loadPic(self):
		if self.picQ.empty():
			self.eventP.clear()
			return
		while not self.picQ.empty():
			self.picQ.get_nowait()
		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		streamPic = self['liste'].getCurrent()[0][2]
		Preview = self['liste'].getCurrent()[0][5]
		self.showInfos()
		self.updateP = 1
		CoverHelper(self['coverArt'], self.ShowCoverFileExit).getCover(streamPic, backup_url=Preview)

	def keyOK(self):
		if self.keyLocked:
			return
		name = self['liste'].getCurrent()[0][0]
		self['name'].setText(_('Please wait...'))
		url = "https://stripchat.com/" + name
		twAgentGetPage(url, agent=agent, headers={'Accept':'text/html,application/xhtml+xml,application/xml'}).addCallback(self.getStream).addErrback(self.dataError)

	def getStream(self, data):
		self.id = MPfindall(self, '"streamName":"(.*?)",', data, re.S)
		sv = MPfindall(self, '"address":"(hls-.*?)",', data, re.S)
		if id and sv:
			self.servers = []
			for item in sv:
				self.servers.append(item)
			_thread.start_new_thread(self.selectServer, ("SelectServer",))
		else:
			self.session.open(MessageBoxExt, _("Cam is currently offline."), MessageBoxExt.TYPE_INFO)

	def selectServer(self, threadName):
		printl("Calling thread: %s" % threadName, self, 'A')
		r = list(range(1, len(self.servers)+1))
		random.shuffle(r)
		vidurl = ''
		for i in r:
			url = "https://b-%s.stripst.com/hls/%s/%s.m3u8" % (self.servers[i-1], self.id[0], self.id[0])
			request = requests.head(url)
			if request.status_code == 200:
				vidurl = url
				break
		reactor.callFromThread(boundFunction(self.playStream, vidurl))

	def playStream(self, url):
		if url:
			title = self['liste'].getCurrent()[0][0]
			self['name'].setText(title)
			mp_globals.player_agent = agent
			self.session.open(SimplePlayer, [(title, url)], showPlaylist=False, ltype='stripchat')
		else:
			self.session.open(MessageBoxExt, _("Cam is currently not available."), MessageBoxExt.TYPE_INFO)