﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.youtubeplayer import YoutubePlayer

agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.97 Safari/537.36'
json_headers = {
	'X-Requested-With': 'XMLHttpRequest',
	'Content-Type': 'application/json',
	}
cookies = CookieJar()
default_cover = "file://%s/daftsex.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
mvtoken = ''

class daftsexGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("DaftSex.com")
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		self['name'].setText(_("Please wait..."))
		url = "https://daftsex.com/categories"
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		Cats = MPfindall(self, 'class="video-item".*?href="(.*?)".*?data-thumb="(.*?)".*?"video-title">(.*?)</div', data, re.S)
		if Cats:
			for (Url, Image, Title) in Cats:
				Url = "https://daftsex.com" + Url
				Image = "https://daftsex.com" + Image
				self._items.append((Title, Url, Image))
		self._items.sort()
		self._items.insert(0, ("Pornstars", "https://daftsex.com/pornstars", default_cover))
		self._items.insert(0, ("Playlists", "https://daftsex.com/browse", default_cover))
		self._items.insert(0, ("Hottest", "https://daftsex.com/hottest", default_cover))
		self._items.insert(0, ("Newest", "https://daftsex.com/video/", default_cover))
		self._items.insert(0, ("--- Search ---", "callSuchen", default_cover))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self['name'].setText('')
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image, agent=agent)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen(suggest_func=self.getSuggestions)
		else:
			Link = self['liste'].getCurrent()[0][1]
			self.session.open(daftsexFilmScreen, Link, Name)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString)
			self.session.open(daftsexFilmScreen, Link, Name)

	def getSuggestions(self, text, max_res):
		url = "https://daftsex.com/"
		postdata = {"act":"suggests","val":text}
		d = twAgentGetPage(url, method='POST', postdata=urlencode(postdata), agent=agent, cookieJar=cookies, headers={'Content-Type':'application/x-www-form-urlencoded','X-Requested-With':'XMLHttpRequest'}, timeout=5)
		d.addCallback(self.gotSuggestions, max_res)
		d.addErrback(self.gotSuggestions, max_res, err=True)
		return d

	def gotSuggestions(self, suggestions, max_res, err=False):
		list = []
		if not err and type(suggestions) in (str, buffer):
			suggestions = json.loads(suggestions)
			for item in suggestions:
				li = item
				list.append(str(li))
				max_res -= 1
				if not max_res: break
		elif err:
			printl(str(suggestions), self, 'E')
		return list

class daftsexFilmScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("DaftSex.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))
		self['Page'] = Label(_("Page:"))

		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*Search", self.Name):
			postdata = {"hd":0,"sort":0,"longer":0,"page":self.page-1}
			url = "https://daftsex.com/video/%s" % self.Link
			twAgentGetPage(url, method='POST', postdata=urlencode(postdata), agent=agent, cookieJar=cookies, headers={'Content-Type':'application/x-www-form-urlencoded','X-Requested-With':'XMLHttpRequest'}).addCallback(self.genreData).addErrback(self.dataError)
		else:
			if "#" in self.Link:
				postdata = {"page":self.page-1}
				url = "https://daftsex.com/video/"
				twAgentGetPage(url, method='POST', postdata=urlencode(postdata), agent=agent, cookieJar=cookies, headers={'Content-Type':'application/x-www-form-urlencoded','X-Requested-With':'XMLHttpRequest'}).addCallback(self.genreData).addErrback(self.dataError)
			elif self.Name in ["Hottest", "Playlists", "Pornstars"] or "/playlist/" in self.Link:
				postdata = {"page":self.page}
				url = self.Link + "?page=" + str(self.page)
				twAgentGetPage(url, method='POST', postdata=urlencode(postdata), agent=agent, cookieJar=cookies, headers={'Content-Type':'application/x-www-form-urlencoded','X-Requested-With':'XMLHttpRequest'}).addCallback(self.genreData).addErrback(self.dataError)
			else:
				postdata = {"hd":0,"sort":0,"longer":0,"page":self.page-1}
				twAgentGetPage(self.Link, method='POST', postdata=urlencode(postdata), agent=agent, cookieJar=cookies, headers={'Content-Type':'application/x-www-form-urlencoded','X-Requested-With':'XMLHttpRequest'}).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		if 'class="pagination"' in data:
			self.getLastPage(data, 'class="pagination(.*?)</ul', '.*>(\d+)<')
		else:
			if 'class="more"' in data:
				self.lastpage = self.page + 1
			if self.lastpage > 1:
				self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
			else:
				self['page'].setText('1 / 1')
		if "/browse" in self.Link:
			playlists = MPfindall(self, 'class="video-item.*?href="(.*?)".*?class="video-img".*?data-thumb="(https://[0-9A-Za-z\/\-\.]+)".*?"video-date">(.*?)(?:</span>|by).*?video-title".*?>(.*?)</div>', data, re.S)
			for (Url, Image, Added, Title) in playlists:
				if Url.startswith('/'):
					Url = "https://daftsex.com" + Url
				self._items.append((decodeHtml(Title), Url, Image, Added, '', ''))
			if len(self._items) == 0:
				self._items.append((_('No playlists found!'), None, None, '', '', ''))
		elif "/pornstars" in self.Link:
			playlists = MPfindall(self, 'class="pornstar".*?href="(.*?)".*?data-thumb="(.*?)".*?<span>(.*?)</span>', data, re.S)
			for (Url, Image, Title) in playlists:
				if Url.startswith('/'):
					Url = "https://daftsex.com" + Url
				if Image.startswith('/'):
					Image = "https://daftsex.com" + Image
				self._items.append((decodeHtml(Title), Url, Image, 'pornstar', '', ''))
			if len(self._items) == 0:
				self._items.append((_('No playlists found!'), None, None, '', '', ''))
		elif "/playlist/" in self.Link:
			vids = MPfindall(self, 'class="video-item.*?href="(.*?)".*?class="video-img".*?data-thumb="(.*?)".*?"video-date">(.*?)</span>.*?"video-time">(.*?)</span>.*?class="video-title".*?>(.*?)</div>', data, re.S)
			for (Url, Image, Added, Runtime, Title) in vids:
				if Url.startswith('/'):
					Url = "https://daftsex.com" + Url
				if not Title:
					Title = urllib.parse.unquote_plus(Url.split('/watch/')[1].replace('-', ' ').strip())
				if "https://vk.com/images/video/thumbs/video_l.png" in Image:
					Image = default_cover
				self._items.append((decodeHtml(Title), Url, Image, Runtime, '', Added))
			if len(self._items) == 0:
				self._items.append((_('No videos found!'), None, None, '', '', ''))
		else:
			vids = MPfindall(self, 'class="video-item.*?href="(.*?)".*?class="video-img".*?data-thumb="(.*?)".*?"video-date">(.*?)</span>.*?"video-view">(.*?)</span>.*?"video-time">(.*?)</span>.*?class="video-title".*?>(.*?)</div>', data, re.S)
			for (Url, Image, Added, Views, Runtime, Title) in vids:
				if Url.startswith('/'):
					Url = "https://daftsex.com" + Url
				if not Title:
					Title = urllib.parse.unquote_plus(Url.split('/watch/')[1].replace('-', ' ').strip())
				if "https://vk.com/images/video/thumbs/video_l.png" in Image:
					Image = default_cover
				self._items.append((decodeHtml(Title), Url, Image, Runtime, Views, Added))
			if len(self._items) == 0:
				self._items.append((_('No videos found!'), None, None, '', '', ''))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		pic = self['liste'].getCurrent()[0][2]
		if "/browse" in self.Link:
			added = self['liste'].getCurrent()[0][3]
			self['handlung'].setText("Added:%s" % (added))
		elif "/playlist/" in self.Link:
			runtime = self['liste'].getCurrent()[0][3]
			added = self['liste'].getCurrent()[0][5]
			self['handlung'].setText("Runtime: %s\nAdded:%s" % (runtime, added))
		elif not "/pornstars" in self.Link:
			runtime = self['liste'].getCurrent()[0][3]
			views = self['liste'].getCurrent()[0][4]
			added = self['liste'].getCurrent()[0][5]
			self['handlung'].setText("Runtime: %s\nViews: %s\nAdded:%s" % (runtime, views, added))
		self['name'].setText(title)
		CoverHelper(self['coverArt']).getCover(pic)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		if Link:
			if "/playlist/" in Link or "pornstar" in self['liste'].getCurrent()[0][3]:
				self.session.open(daftsexFilmScreen, Link, Name)
			else:
				twAgentGetPage(Link, agent=agent, cookieJar=cookies).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		match = MPfindall(self, 'hash:\s"(.*?)",', data)
		if match:
			Link = self['liste'].getCurrent()[0][1]
			url = "https://daxab.com/player/" + match[-1]
			twAgentGetPage(url, agent=agent, headers={'Referer':Link}).addCallback(self.parseVideo).addErrback(self.dataError)

	def parseVideo(self, data):
		import base64
		if "credentials:" in data:
			server = MPfindall(self, 'server:\s{0,1}"(.*?)",', data, re.S)
			token = MPfindall(self, 'access_token:\s{0,1}"(.*?)",', data, re.S)
			id = MPfindall(self, 'id:\s{0,1}"(.*?)",', data, re.S)
			ckey = MPfindall(self, 'c_key:\s{0,1}"(.*?)",', data, re.S)
			credentials = MPfindall(self, 'credentials:\s{0,1}"(.*?)",', data, re.S)
			if server and token and id and ckey and credentials:
				server = list(server[-1])
				server.reverse()
				server = base64.b64decode(str(''.join(server)))
				url = 'https://' + server + "/method/video.get?token=" + token[-1] + "&videos=" + id[-1] + "&ckey=" + ckey[-1] + "&credentials=" + credentials[-1]
				Link = self['liste'].getCurrent()[0][1]
				twAgentGetPage(url, agent=agent, headers={'Referer':Link}).addCallback(self.parseResponse).addErrback(self.dataError)
		else:
			server = MPfindall(self, 'server:\s{0,1}"(.*?)",', data, re.S)
			ids = MPfindall(self, 'id:\s{0,1}"(.*?)_(.*?)".*?":"(\d+)\.([^"]+)"}', data, re.S)
			if not ids:
				ids = MPfindall(self, 'id:\s{0,1}"(.*?)_(.*?)".*"(\d+)":"(.*?)"}', data, re.S)
			if server and ids:
				server = list(server[-1])
				server.reverse()
				server = base64.b64decode(str(''.join(server)))
				(id1, id2, res, extra) =  ids[-1]
				video =  id1 + '/' + id2 + '/' + res + '.mp4?extra=' + extra
				url = 'https://' + server + '/videos/' + video
				Title = self['liste'].getCurrent()[0][0]
				mp_globals.player_agent = agent
				self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='daftsex')

	def parseResponse(self, data):
		json_data = json.loads(data)
		files = json_data["response"]["items"][0]["files"]
		if "hls" in files and str(files["hls"]):
			url = str(files["hls"])
			twAgentGetPage(url, agent=agent).addCallback(self.loadplaylist).addErrback(self.dataError)
		elif "external" in files:
			url = str(files["external"])
			videoPage = MPfindall(self, 'www.youtube.com/(?:watch\?|)(?:v|embed)(?:/|=)(.*?)$', url, re.S)
			if videoPage:
				Title = self['liste'].getCurrent()[0][0]
				self.session.open(YoutubePlayer, [(Title, videoPage[-1], None)], playAll= False, showPlaylist=False, showCover=False)

	def loadplaylist(self, data):
		self.bandwith_list = []
		match_sec_m3u8=MPfindall(self, 'BANDWIDTH=(\d+).*?\n(.*?m3u8.*?)(?:$|\n)', data, re.S)
		if match_sec_m3u8:
			max = 0
			for x in match_sec_m3u8:
				if int(x[0]) > max:
					max = int(x[0])
			videoPrio = int(config_mp.mediaportal.videoquali_others.value)
			if videoPrio == 2:
				bw = max
			elif videoPrio == 1:
				bw = max / 2
			else:
				bw = max / 3
			for each in match_sec_m3u8:
				bandwith, url = each
				self.bandwith_list.append((int(bandwith), url))
			_x, best = min((abs(int(x[0]) - bw), x) for x in self.bandwith_list)
			url = best[1]
			Title = self['liste'].getCurrent()[0][0]
			mp_globals.player_agent = agent
			self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='daftsex')
		else:
			message = self.session.open(MessageBoxExt, _("Stream not found"), MessageBoxExt.TYPE_INFO, timeout=5)