﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.keyboardext import VirtualKeyBoardExt

agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36'
json_headers = {
	'Accept': 'application/json',
	'Accept-Language': 'en,en-US;q=0.7,en;q=0.3',
	'X-Requested-With': 'XMLHttpRequest',
	'Content-Type': 'application/x-www-form-urlencoded',
	}

default_cover = "file://%s/cliphunter.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class cliphunterGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("cliphunter.com")
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		url = "http://www.cliphunter.com/categories/"
		twAgentGetPage(url, agent=agent).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		Cats = MPfindall(self, ' <a href="(/categories/.*?)" title="(.*?)">.*?<img src="(.*?)"/>', data, re.S)
		if Cats:
			for (Url, Title, Image) in Cats:
				Url = 'http://www.cliphunter.com%s/' % Url.replace(' ', '%20')
				if not Title == "All":
					self._items.append((Title, Url, Image))
			self._items.sort()
			self._items.insert(0, ("Pornstars", 'http://www.cliphunter.com/pornstars/top/overview/', default_cover))
			self._items.insert(0, ("Top Year", 'http://www.cliphunter.com/popular/ratings/year/', default_cover))
			self._items.insert(0, ("Top Month", 'http://www.cliphunter.com/popular/ratings/month/', default_cover))
			self._items.insert(0, ("Top Week", 'http://www.cliphunter.com/popular/ratings/week/', default_cover))
			self._items.insert(0, ("Top Yesterday", 'http://www.cliphunter.com/popular/ratings/yesterday/', default_cover))
			self._items.insert(0, ("Top Today", 'http://www.cliphunter.com/popular/ratings/today/', default_cover))
			self._items.insert(0, ("Hall of Fame", 'http://www.cliphunter.com/popular/ratings/all/', default_cover))
			self._items.insert(0, ("Newest", 'http://www.cliphunter.com/categories/All/', default_cover))
			self._items.insert(0, ("--- Search ---", "callSuchen", default_cover))
			self.ml.setList(list(map(self._defaultlistcenter, self._items)))
			self.ml.moveToIndex(0)
			self.keyLocked = False
			self.showInfos()

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		if Name == "--- Search ---":
			self.suchen(suggest_func=self.getSuggestions)
		elif Name == "Pornstars":
			self.session.open(cliphunterPornstarScreen, Link, Name)
		else:
			self.session.open(cliphunterFilmScreen, Link, Name)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '%20'))
			Name = "--- Search ---"
			self.session.open(cliphunterFilmScreen, Link, Name)

	def getSuggestions(self, text, max_res):
		url = "http://www.cliphunter.com/a/autocomplete?type=tag&txt=%s" % urllib.parse.quote_plus(text)
		d = twAgentGetPage(url, agent=agent, headers=json_headers, timeout=5)
		d.addCallback(self.gotSuggestions, max_res)
		d.addErrback(self.gotSuggestions, max_res, err=True)
		return d

	def gotSuggestions(self, suggestions, max_res, err=False):
		list = []
		if not err and type(suggestions) in (str, buffer):
			suggestions = json.loads(suggestions)
			for item in suggestions:
				li = item
				list.append(str(li))
				max_res -= 1
				if not max_res: break
		elif err:
			printl(str(suggestions), self, 'E')
		return list

class cliphunterPornstarScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("cliphunter.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self._items = []
		url = "%s%s" % (self.Link, str(self.page))
		twAgentGetPage(url, agent=agent).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		self.getLastPage(data, '', 'maxPages="(.*?)"')
		Parse = re.search('photoGrid">(.*?)class="clearfix">', data, re.S)
		Cats = MPfindall(self, 'href="(.*?)">.*?src=\'(.*?)\'/>.*?<span>(.*?)</span>', Parse.group(1), re.S)
		if Cats:
			for (Url, Image, Title) in Cats:
				Url = "http://www.cliphunter.com" + Url + "/movies/"
				self._items.append((upperString(Title), Url, Image))
			self._setList('_defaultlistleft', True)
			self.ml.moveToIndex(0)
			self.keyLocked = False
			self.showInfos()

	def showInfos(self):
		Title = self['liste'].getCurrent()[0][0]
		Image = self['liste'].getCurrent()[0][2]
		self['name'].setText(Title)
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		self.session.open(cliphunterFilmScreen, Link, Name)

class cliphunterFilmScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("cliphunter.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*?Search", self.Name):
			url = "http://www.cliphunter.com/search/%s/%s" % (self.Link, str(self.page))
		else:
			url = "%s%s" % (self.Link, str(self.page))
		twAgentGetPage(url, agent=agent).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		self.getLastPage(data, '', 'maxPages="(.*?)"')
		Movies = MPfindall(self, '<li mId="\d+".*?href="(/w/\d+/(.*?))".*?class="i(?: pop-execute|)"\ssrc="(.*?)".*?class="tr(?: pop-execute|)">(.*?)</div>.*?class="info(?: long|)">(.*?)</div', data, re.S)
		if Movies:
			for (Url, Title, Image, Runtime, Views) in Movies:
				Url = "http://www.cliphunter.com" + Url
				Title = Title.replace('_', ' ').strip()
				Views = Views.replace('views', '').replace(',', '').strip()
				self._items.append((Title, Url, Image, Runtime, Views))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), '', None, '', ''))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		pic = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][3]
		views = self['liste'].getCurrent()[0][4]
		self['handlung'].setText("Runtime: %s\nViews: %s" % (runtime, views))
		self['name'].setText(title)
		CoverHelper(self['coverArt']).getCover(pic)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		self.keyLocked = True
		twAgentGetPage(Link, agent=agent).addCallback(self.getVideoPage).addErrback(self.dataError)

	def getVideoPage(self, data):
		url = MPfindall(self, '"url":"(.*?)"}', data, re.S)
		if url:
			if url[-1].startswith('http'):
				url = url[-1]
				url = url.replace('\u0026', '.').replace('\/', '/')
			else:
				url = url[-1]
				url = url.replace('\u0026', '.')
				translation_table = {
				    'a': 'h', 'd': 'e', 'e': 'v', 'f': 'o', 'g': 'f', 'i': 'd', 'l': 'n',
				    'm': 'a', 'n': 'm', 'p': 'u', 'q': 't', 'r': 's', 'v': 'p', 'x': 'r',
				    'y': 'l', 'z': 'i',
				    '$': ':', '&': '.', '(': '=', '^': '&', '=': '/',
				}
				url = ''.join(translation_table.get(c, c) for c in url)
			self.keyLocked = False
			Title = self['liste'].getCurrent()[0][0]
			self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='cliphunter')