﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *

json_headers = {
	'Accept': 'application/json',
	'Accept-Language': 'en,en-US;q=0.7,en;q=0.3',
	'X-Requested-With': 'XMLHttpRequest',
	'Content-Type': 'application/x-www-form-urlencoded',
	}
agent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36'
cookies = CookieJar()

class anypornGenreScreen(MPScreen):

	def __init__(self, session, mode):
		self.mode = mode

		global default_cover
		if self.mode == "anyporn":
			self.portal = "AnyPorn.com"
			self.baseurl = "https://anyporn.com"
			default_cover = "file://%s/anyporn.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "anysex":
			self.portal = "AnySex.com"
			self.baseurl = "https://anysex.com"
			default_cover = "file://%s/anysex.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "sex3":
			self.portal = "Sex3.com"
			self.baseurl = "https://sex3.com"
			default_cover = "file://%s/sex3.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "hellporno":
			self.portal = "HellPorno.com"
			self.baseurl = "https://hellporno.com"
			default_cover = "file://%s/hellporno.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "bravotube":
			self.portal = "BravoTube.net"
			self.baseurl = "https://www.bravotube.net"
			default_cover = "file://%s/bravotube.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "bravoporn":
			self.portal = "BravoPorn.com"
			self.baseurl = "https://www.bravoporn.com"
			default_cover = "file://%s/bravoporn.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "bravoteens":
			self.portal = "BravoTeens.com"
			self.baseurl = "https://www.bravoteens.com"
			default_cover = "file://%s/bravoteens.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "xbabe":
			self.portal = "xBabe.com"
			self.baseurl = "https://xbabe.com"
			default_cover = "file://%s/xbabe.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "hellmoms":
			self.portal = "HellMoms.com"
			self.baseurl = "https://hellmoms.com"
			default_cover = "file://%s/hellmoms.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "xcum":
			self.portal = "xCum.com"
			self.baseurl = "https://xcum.com"
			default_cover = "file://%s/xcum.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label(self.portal)
		self['ContentTitle'] = Label("Genre:")

		self.keyLocked = True
		self.suchString = ''

		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		self['name'].setText(_('Please wait...'))
		if self.mode == "bravoteens":
			url = self.baseurl + "/cats/"
		elif self.mode == "bravoporn":
			url = self.baseurl + "/c/"
		elif self.mode in ["hellmoms", "xcum"]:
			url = self.baseurl
		else:
			url = self.baseurl + "/categories/"
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		if self.mode == "anysex":
			parse = re.search('SEX CATEGORIES</h2>(.*?)</ul>', data, re.S)
			cat = MPfindall(self, 'class="img">.*?href="(.*?)"\s(?:class="popfire" |)title.*?img\sclass="thumb"\ssrc="(.*?)"\salt="(.*?)"', parse.group(1), re.S)
			if cat:
				for (Url, Image, Title) in cat:
					self._items.append((decodeHtml(Title), Url, Image))
			self._items.sort()
			self._items.insert(0, ("Top Rated", "%s/top-rated/" % self.baseurl, default_cover))
			self._items.insert(0, ("Most Popular", "%s/most-popular/" % self.baseurl, default_cover))
			self._items.insert(0, ("Newest", "%s/new-movies/" % self.baseurl, default_cover))
		elif self.mode == "xbabe":
			parse = re.search('All categories</a>(.*?)</header>', data, re.S)
			cat = MPfindall(self, 'href="(.*?)">(.*?)</a>', parse.group(1), re.S)
			if cat:
				for (Url, Title) in cat:
					Title = upperString(Title)
					self._items.append((decodeHtml(Title), Url, default_cover))
			self._items.sort()
			self._items.insert(0, ("Newest", "%s/" % self.baseurl, default_cover))
		elif self.mode == "hellmoms":
			parse = re.search('class="block-menu"(.*?)</div>', data, re.S)
			cat = MPfindall(self, 'href="(.*?)">(.*?)</a>', parse.group(1), re.S)
			if cat:
				for (Url, Title) in cat:
					Title = upperString(Title)
					self._items.append((decodeHtml(Title), Url, default_cover))
			self._items.sort()
			self._items.insert(0, ("Newest", "%s/" % self.baseurl, default_cover))
		elif self.mode == "xcum":
			parse = re.search('class="block-cats(.*?)</div>', data, re.S)
			cat = MPfindall(self, 'href="(.*?)">(.*?)</a>', parse.group(1), re.S)
			if cat:
				for (Url, Title) in cat:
					if Url.startswith('/'):
						Url = self.baseurl + Url
					Title = upperString(stripAllTags(Title))
					self._items.append((decodeHtml(Title), Url, default_cover))
			self._items.sort()
			self._items.insert(0, ("Newest", "%s/" % self.baseurl, default_cover))
		elif self.mode == "hellporno":
			parse = re.search('Top categories</h2>(.*?)class="more"', data, re.S)
			cat = MPfindall(self, 'href="(.*?)">(.*?)</a>', parse.group(1), re.S)
			if cat:
				for (Url, Title) in cat:
					Title = upperString(Title)
					self._items.append((decodeHtml(Title), Url, default_cover))
			self._items.sort()
			self._items.insert(0, ("Newest", "%s/" % self.baseurl, default_cover))
		else:
			parse = re.search('(?:class="tagslist">|class="list-tags">)(.*?)(?:class="footer-margin"|class="footer-box")', data, re.S)
			if parse:
				cat = MPfindall(self, 'a\shref=[\"|\']((?:/categories/|/c/).*?)[\"|\']\stitle="(.*?)"', parse.group(1), re.S)
				if cat:
					for (Url, Title) in cat:
						Url = self.baseurl + Url
						self._items.append((decodeHtml(Title), Url, default_cover))
			else:
				parse = re.search('(?:class="th-wrap">|cat_thumbs|class="thumbs)(.*?)(?:class="headline"|class="heading"|class="clear")', data, re.S)
				cat = MPfindall(self, 'a\shref="((?:/categories/|/cats/).*?)".*?<img src="(.*?)".*?alt="(.*?)"', parse.group(1), re.S)
				if cat:
					for (Url, Image, Title) in cat:
						Url = self.baseurl + Url
						if Image.startswith('//'):
							Image = "https:" + Image
						if Image.startswith('/'):
							Image = self.baseurl + Image
						Title = upperString(Title)
						self._items.append((decodeHtml(Title), Url, Image))
			self._items.sort()
			if self.mode in ["bravotube", "bravoporn", "sex3"]:
				self._items.insert(0, ("Most Viewed", "%s/most-popular/" % self.baseurl, default_cover))
				self._items.insert(0, ("Newest", "%s/latest-updates/" % self.baseurl, default_cover))
			elif self.mode == "bravoteens":
				self._items.insert(0, ("Top Rated", "%s/top/" % self.baseurl, default_cover))
				self._items.insert(0, ("Most Viewed", "%s/popular/" % self.baseurl, default_cover))
				self._items.insert(0, ("Newest", "%s/new/" % self.baseurl, default_cover))
			else:
				self._items.insert(0, ("Most Viewed", "%s/popular/" % self.baseurl, default_cover))
				self._items.insert(0, ("Newest", "%s/newest/" % self.baseurl, default_cover))
		self._items.insert(0, ("--- Search ---", "callSuchen", default_cover))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False
		self['name'].setText('')
		self.showInfos()

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			if self.mode in ["anyporn", "xbabe", "hellmoms"]:
				Link = callback.replace(' ', '-')
			else:
				Link = callback.replace(' ', '+')
			if self.mode == "bravoteens":
				Link = urllib.parse.quote(Link).replace('%2B', '+')
			self.session.open(anypornListScreen, Link, Name, self.portal, self.baseurl)

	def getSuggestions(self, text, max_res):
		if self.mode in ["xbabe", "hellmoms"]:
			url = "%s/s/?term=%s" % (self.baseurl, urllib.parse.quote_plus(text))
		elif self.mode == "xcum":
			url = "%s/suggest/?term=%s" % (self.baseurl, urllib.parse.quote_plus(text))
		elif self.mode == "hellporno":
			url = "%s/20_suggestions_videos.php?term=%s" % (self.baseurl, urllib.parse.quote_plus(text))
		d = twAgentGetPage(url, agent=agent, headers=json_headers, timeout=5)
		d.addCallback(self.gotSuggestions, max_res)
		d.addErrback(self.gotSuggestions, max_res, err=True)
		return d

	def gotSuggestions(self, suggestions, max_res, err=False):
		list = []
		if not err and type(suggestions) in (str, buffer):
			suggestions = json.loads(suggestions)
			for item in suggestions:
				li = item["label"]
				list.append(str(li))
				max_res -= 1
				if not max_res: break
		elif err:
			printl(str(suggestions), self, 'E')
		return list

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			if self.mode in ["hellporno", "xbabe", "hellmoms", "xcum"]:
				self.suchen(suggest_func=self.getSuggestions)
			else:
				self.suchen()
		else:
			Link = self['liste'].getCurrent()[0][1]
			self.session.open(anypornListScreen, Link, Name, self.portal, self.baseurl)

class anypornListScreen(MPScreen):

	def __init__(self, session, Link, Name, portal, baseurl):
		self.Link = Link
		self.Name = Name
		self.portal = portal
		self.baseurl = baseurl

		global default_cover
		if self.portal == "AnyPorn.com":
			default_cover = "file://%s/anyporn.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "AnySex.com":
			default_cover = "file://%s/anysex.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "Sex3.com":
			default_cover = "file://%s/sex3.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "HellPorno.com":
			default_cover = "file://%s/hellporno.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "BravoTube.net":
			default_cover = "file://%s/bravotube.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "BravoPorn.com":
			default_cover = "file://%s/bravoporn.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "BravoTeens.com":
			default_cover = "file://%s/bravoteens.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "xBabe.com":
			default_cover = "file://%s/xbabe.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "HellMoms.com":
			default_cover = "file://%s/hellmoms.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "xCum.com":
			default_cover = "file://%s/xcum.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label(self.portal)
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['name'] = Label(_("Please wait..."))
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))

		self.keyLocked = True
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.page = 1
		self.lastpage = 1
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self._items = []
		if re.match(".*?Search", self.Name):
			if self.portal == "AnyPorn.com":
				url = "%s/search/%s/?mode=async&function=get_block&block_id=list_videos_v2_videos_list_search_result&q=%s&category_ids=&sort_by=&from_videos=%s&from_albums=%s" % (self.baseurl, self.Link, self.Link, str(self.page), str(self.page))
			elif self.portal == "BravoPorn.com":
				url = "%s/s/%s/?q=%s" % (self.baseurl, str(self.page), self.Link)
			elif self.portal in ["HellMoms.com", "xCum.com"]:
				url = "%s/q/%s/%s" % (self.baseurl, self.Link, str(self.page))
			else:
				url = "%s/search/%s/?q=%s" % (self.baseurl, str(self.page), self.Link)
		else:
			if self.page == 1:
				url = self.Link
			else:
				url = "%s%s/" % (self.Link, str(self.page))
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		self.getLastPage(data, '(?:class="pagination\d{0,1}">|class="pagination\d{0,1} nopop">|pagination-holder">|class="pager">|class="pager nopop"|class="pagination pignr")(.*?)</div>')
		movies = MPfindall(self, 'class=[\"|\']item\s{0,2}[\"|\']>.*?href=[\"|\'](.*?)[\"|\'].*?<img\sclass="thumb(?: lazy-load|)"\s{0,1}(?:src|data-original)="(.*?)"\s{0,1}alt="(.*?)".*?(?:class="time">(.*?)</span>|durationid_\d+"\);element.innerHTML = "(.*?)")', data, re.S)
		if movies:
			for (Url, Image, Title, Runtime1, Runtime2) in movies:
				if Url.startswith('/'):
					Url = self.baseurl + Url
				if Image.startswith('//'):
					Image = "https:" + Image
				Runtime = ''
				if Runtime1:
					Runtime = Runtime1
				elif Runtime2:
					Runtime = Runtime2.replace('s', '').replace('m', '').replace('h', '')
				self._items.append((decodeHtml(Title), Url, Image, Runtime))
		else:
			movies = MPfindall(self, '(?:class="fuck|video_block|preview-item)">.*?href="(.*?)".*?img\s(?:class="thumb kt_imgrc" |)src="(.*?)".*?alt="(.*?)".*?class="time">(.*?)(?:</span>|</div>)', data, re.S)
			if movies:
				for (Url, Image, Title, Runtime) in movies:
					if Url.startswith('/'):
						Url = self.baseurl + Url
					if Image.startswith('//'):
						Image = "https:" + Image
					Runtime = Runtime.replace('s', '').replace('m', '').replace('h', '')
					self._items.append((decodeHtml(Title), Url, Image, Runtime))
			else:
				movies = MPfindall(self, 'class="video".*?img\ssrc="(.*?)".*?href="(.*?)".*?><span>(.*?)</span.*?class="duration">(.*?)</span>', data, re.S)
				if movies:
					for (Image, Url, Title, Runtime) in movies:
						if Url.startswith('/'):
							Url = self.baseurl + Url
						if Image.startswith('//'):
							Image = "https:" + Image
						self._items.append((decodeHtml(Title), Url, Image, Runtime))
				else:
					movies = MPfindall(self, 'class="video-thumb".*?href="(.*?)".*?class="time">(.*?)</span>.*?img\salt="(.*?)".*?src="(.*?)"', data, re.S)
					if movies:
						for (Url, Runtime, Title, Image) in movies:
							if Url.startswith('/'):
								Url = self.baseurl + Url
							if Image.startswith('//'):
								Image = "https:" + Image
							self._items.append((decodeHtml(Title), Url, Image, Runtime))
					else:
						if self.portal == "HellMoms.com":
							movies = MPfindall(self, 'class="thumb".*?href="(.*?)".*?data-original="(.*?)".*?class="title">(.*?)</span.*?class="duration">(.*?)</span', data, re.S)
							if movies:
								for (Url, Image, Title, Runtime) in movies:
									if Url.startswith('/'):
										Url = self.baseurl + Url
									if Image.startswith('//'):
										Image = "https:" + Image
									self._items.append((decodeHtml(Title), Url, Image, Runtime))
						elif self.portal == "xCum.com":
							movies = MPfindall(self, 'class="thumb">.*?href="(.*?)".*?data-original="(.*?)".*?(?:<b>|<span class="inf"><span>)(.*?)(?:</b>|</span>).*?(?:class="duration">|<span></span><span>)(.*?)</span', data, re.S)
							if movies:
								for (Url, Image, Title, Runtime) in movies:
									if Url.startswith('/'):
										Url = self.baseurl + Url
									if Image.startswith('//'):
										Image = "https:" + Image
									self._items.append((decodeHtml(Title), Url, Image, Runtime))
						else:
							movies = MPfindall(self, 'class="thumb".*?href="(.*?)".*?class="title">(.*?)</span.*?data-original="(.*?)".*?class="duration">(.*?)</span', data, re.S)
							if movies:
								for (Url, Title, Image, Runtime) in movies:
									if Url.startswith('/'):
										Url = self.baseurl + Url
									if Image.startswith('//'):
										Image = "https:" + Image
									self._items.append((decodeHtml(Title), Url, Image, Runtime))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), None, None, '', ''))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Title = self['liste'].getCurrent()[0][0]
		runtime = self['liste'].getCurrent()[0][3]
		self['handlung'].setText("Runtime: %s" % runtime)
		self['name'].setText(Title)
		coverUrl = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(coverUrl)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		if Link:
			twAgentGetPage(Link, agent=agent, cookieJar=cookies).addCallback(self.getStreamData).addErrback(self.dataError)

	def getStreamData(self, data):
		raw = MPfindall(self, 'source\s(?:id="video_source_\d+"\s|data-fluid-hd\s|)src="(.*?)".*?title="(\d+|LQ|HQ|)(?:p|)"', data, re.S)
		if raw:
			maxres = 0
			for vid in raw:
				if vid[1]:
					if int(vid[1].replace('HQ', '720').replace('LQ', '360')) > maxres:
						url = vid[0]
						maxres = int(vid[1].replace('HQ', '720').replace('LQ', '360'))
				else:
					url = vid[0]
			headers = '&Referer=%s' % self.baseurl
			mp_globals.player_agent = agent
			url = url + '#User-Agent='+mp_globals.player_agent+headers
			self.getStream(url)
		else:
			raw = MPfindall(self, '<source src="(.*?)"', data, re.S)
			if raw:
				url = raw[0]
				headers = '&Referer=%s' % self.baseurl
				mp_globals.player_agent = agent
				url = url + '#User-Agent='+mp_globals.player_agent+headers
				self.getStream(url)

	def getStream(self, url):
		if url.startswith('//'):
			url = 'https:' + url
		title = self['liste'].getCurrent()[0][0]
		mp_globals.player_agent = agent
		self.session.open(SimplePlayer, [(title, url)], showPlaylist=False, ltype='anyporn')