﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.mtvdelink import MTVdeLink

config_mp.mediaportal.mtvquality = ConfigText(default="HD", fixed_size=False)

default_cover = "file://%s/mtvdecharts.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class MTVdeChartsGenreScreen(MPScreen):

	def __init__(self, session):

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"yellow": self.keyQuality
		}, -1)

		self.quality = config_mp.mediaportal.mtvquality.value

		self.keyLocked = True
		self['title'] = Label("MTV Charts")
		self['ContentTitle'] = Label("Charts:")
		self['F3'] = Label(self.quality)

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = [('MTV.de\tHitlist Germany - Top100', "http://www.mtv.de/charts/c6mc86/single-top-100"),
				('MTV.de\tSingle Midweek Charts', "http://www.mtv.de/charts/n91ory/midweek-single-top-100"),
				('MTV.de\tSingle Top20', "http://www.mtv.de/charts/bcgxiq/single-top-20"),
				('MTV.de\tDance Charts', "http://www.mtv.de/charts/2ny5w9/dance-charts"),
				('MTV.de\tSingle Trending', "http://www.mtv.de/charts/9gtiy5/single-trending"),
				('MTV.de\tStreaming Charts', "http://www.mtv.de/charts/h4oi23/top100-music-streaming"),
				('MTV.de\tDeutschsprachige Single Charts Top15', "http://www.mtv.de/charts/jlyhaa/top-15-deutschsprachige-single-charts"),
				('MTV.de\tDownload Charts', "http://www.mtv.de/charts/pcbqpc/downloads-charts-single"),
				('MTV.de\tMost Watched Videos on MTV', "http://www.mtv.de/charts/n2aau3/most-watched-videos"),
				('MTV.de\tTop100 Jahrescharts 2019', "http://www.mtv.de/charts/yrk67s/top-100-jahrescharts-2016"),
				('MTV.de\tTop100 Jahrescharts 2017', "http://www.mtv.de/charts/czzmta/top-100-jahrescharts-2017"),
				('MTV.de\tTop100 Jahrescharts 2015', "http://www.mtv.de/charts/4z2jri/top-100-jahrescharts-2015"),
				('MTV.de\tTop100 Jahrescharts 2014', "http://www.mtv.de/charts/ns9mkd/top-100-jahrescharts-2014"),
				('MTV.de\tMost Wanted 2000s', "http://www.mtv.de/charts/h5hl40/most-wanted-2000"),
				('MTV.de\tMost Wanted 90s', "http://www.mtv.de/charts/xlad55/most-wanted-90"),
				('MTV.co.uk\tSingle Top40', 'http://www.mtv.co.uk/music/charts/the-official-uk-top-40-singles-chart'),
				('MTV.co.uk\tUrban Charts', 'http://www.mtv.co.uk/music/charts/the-official-uk-urban-chart'),
				('MTV.co.uk\tThis Week\'s OMG', 'http://www.mtv.co.uk/music/charts/this-weeks-top-20'),
				('MTV.co.uk\tDownload Charts', 'http://www.mtv.co.uk/music/charts/the-official-uk-top-20-download-chart'),
				('MTV.co.uk\tOfficial Trending Charts', 'http://www.mtv.co.uk/music/charts/the-official-trending-chart'),
				('MTV.co.uk\tOfficial Charts Update', 'http://www.mtv.co.uk/music/charts/the-official-chart-update'),
				('MTV.co.uk\tOfficial UK Audio Streaming Charts', 'http://www.mtv.co.uk/music/charts/the-official-uk-audio-streaming-chart-top-20'),
				('MTV.it\tHitlist Italia - Single Charts', 'https://www.mtv.it/playlist/o104ah/hitlist-italia-classifica-singoli/dq9m0v'),
				('MTV.it\tEuro Top20 Charts', 'https://www.mtv.it/playlist/8xwj2d/euro-top-20-chart-hit-parade-europea/u01ave'),
				('MTV.it\tTop20 Best of', 'https://www.mtv.it/playlist/i15va1/top-20-best-of-classifica-canzoni-2021/y3bm5y'),
				('MTV.it\tDance Top10', 'https://www.mtv.it/playlist/7t27ya/mtv-dance-top-10/7uml75'),
				('MTV.it\tHits Top10', 'https://www.mtv.it/playlist/99erni/classifica-mtv-most-played/73qccm'),
				('MTV.it\tUSA Charts', 'https://www.mtv.it/playlist/0w1eaf/usa-chart-classifica-musica-americana/2kqt3s'),
				('MTV.it\tLatino Charts', 'https://www.mtv.it/playlist/ukheed/classifica-musica-latina/69nss6'),
				('MTV.it\tHip Hop R&B Top10', 'https://www.mtv.it/playlist/42vmmn/mtv-canzoni-rap-trap-hip-hop-rb-top-10/hk22gc')]

		self._setList('_defaultlistleft', True)
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		MTVName = self['liste'].getCurrent()[0][0]
		MTVUrl = self['liste'].getCurrent()[0][1]
		self.session.open(MTVdeChartsSongListeScreen, MTVName, MTVUrl)

	def keyQuality(self):
		if self.quality == "SD":
			self.quality = "HD"
			config_mp.mediaportal.mtvquality.value = "HD"
		elif self.quality == "HD":
			self.quality = "SD"
			config_mp.mediaportal.mtvquality.value = "SD"

		config_mp.mediaportal.mtvquality.save()
		configfile_mp.save()
		self['F3'].setText(self.quality)
		self.loadPage()

class MTVdeChartsSongListeScreen(MPScreen):

	def __init__(self, session, genreName, genreLink):
		self.genreLink = genreLink
		self.genreName = genreName
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self.keyLocked = True
		self['title'] = Label("MTV Charts")
		self['ContentTitle'] = Label("Charts: %s" % self.genreName.replace('\t', ' '))

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.json_url = None
		self.page = 0

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self['name'].setText(_('Please wait...'))
		self.keyLocked = True
		if self.page > 0:
			url = self.json_url + "/" + str(self.page)
		else:
			url = self.genreLink
		headers = {
			'Accept': '*/*',
			'Accept-Encoding': 'deflate',
			'Accept-Language': 'de,en-US;q=0.7,en;q=0.3',
			}
		twAgentGetPage(url, headers=headers).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		if "MTV.de" in self.genreName:
			if not self.json_url:
				jsonurl = MPfindall(self, 'class="module intl_m327" data-tfstatic="true" data-tffeed="(.*?)"', data, re.S)
				if jsonurl:
					self.json_url = jsonurl[0]
				self.page += 1
				self.loadPage()
			else:
				json_data = json.loads(data)
				for item in json_data["result"]["data"]["items"]:
					if 'videoUrl' in item:
						videourl = str(item["videoUrl"])
						pos = str(item["chartPosition"]["current"])
						title = str(item["title"])
						try:
							artist = str(item["artists"][0]["name"])
						except:
							artist = str(item["shortTitle"])
						try:
							image = str(item["images"][0]["url"])
						except:
							image = None

						if "MTV.de" in self.genreName:
							vidtitle = pos + ". " + artist + " - " + title
						else:
							vidtitle = pos + ". " + title
						self._items.append((vidtitle, videourl, image))
				if "nextPageURL" in data:
					self.page += 1
					self.loadPage()
				else:
					self._setList('_defaultlistleft', True)
					self.showInfos()
					self.keyLocked = False
		elif "MTV.co.uk" in self.genreName:
			entity = MPfindall(self, 'entity_uuid" content="(.*?)"', data, re.S)
			parse = MPfindall(self, 'jQuery.extend\(Drupal.settings,\s(.*?)\);', data, re.S)
			if parse and entity:
				try:
					s = requests.session()
					url = "http://media.mtvnservices.com/pmt/e1/access/index.html?uri=mgid:noah:video:mtv.co.uk:%s&configtype=edge" % entity[0]
					page = s.get(url, timeout=15)
					playlist = page.content
					json_pl = json.loads(playlist)
					json_data = json.loads(parse[0], "utf-8")
					items = list(json_data[u"vimn_videoplayer"].keys())[0]
					from collections import OrderedDict
					for key, value in list(json_data[u"vimn_videoplayer"][items][u"playlist_items"].items()):
						if 'playlist_item_index' in value:
							index = int(value["playlist_item_index"])
							pos = str(int(key)+1)
							title = str(value["title"])
							artist = str(value["subtitle"])
							try:
								image = str(json_pl["feed"]["items"][index]["image"]["url"])
							except:
								image = default_cover
							videourl = str(json_pl["feed"]["items"][index]["guid"].split(':')[-1])
							vidtitle = pos + ". " + artist + " - " + title
							self._items.append((vidtitle, videourl, image, int(pos)))
							self._items.sort(key=lambda t : t[3])
					self._setList('_defaultlistleft', True)
					self.showInfos()
					self.keyLocked = False
				except:
					pass
		elif "MTV.it" in self.genreName:
			playlist = MPfindall(self, '"playlist".*?(\[\{.*?\}\])', data, re.S)
			json_pl = json.loads(playlist[0])
			for item in json_pl:
				title = str(item["meta"]["header"]["title"]).split('•')[-1].strip()
				artist = str(item["meta"]["header"]["title"]).split('•')[0].strip()
				try:
					image = str(item["media"]["image"]["url"])
				except:
					image = default_cover
				token = str(item["id"])
				url = str(item["url"])
				videourl = token
				vidtitle = artist + " - " + title
				self._items.append((vidtitle, videourl, image))
			self._setList('_defaultlistleft', True)
			self.showInfos()
			self.keyLocked = False

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		coverUrl = self['liste'].getCurrent()[0][2]
		self['name'].setText(title)
		CoverHelper(self['coverArt']).getCover(coverUrl)

	def keyOK(self):
		if self.keyLocked:
			return
		idx = self['liste'].getSelectedIndex()
		self.session.open(MTVdeChartsPlayer, self._items, int(idx), True, self.genreName)

class MTVdeChartsPlayer(SimplePlayer):

	def __init__(self, session, playList, playIdx=0, playAll=True, listTitle=None):
		SimplePlayer.__init__(self, session, playList, playIdx=playIdx, playAll=playAll, listTitle=listTitle, ltype='mtv')

	def getVideo(self):
		title = self.playList[self.playIdx][self.title_inr]
		token = self.playList[self.playIdx][1]
		imgurl = self.playList[self.playIdx][2]

		artist = ''
		p = title.find(' - ')
		if p > 0:
			artist = title[:p].strip()
			title = title[p+3:].strip()

		MTVdeLink(self.session).getLink(self.playStream, self.dataError, title, artist, token, imgurl)