﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from builtins import map
from builtins import range
from ...plugin import _
from ...resources.imports import *
import base64
default_cover = "file://%s/popcorntimes.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36"
base_url = "https://popcorntimes.tv"

class popcorntimesGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("Popcorntimes")
		self['ContentTitle'] = Label("Genre:")

		self._items = []
		self.suchString = ''
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self._items.append(('Neu im Programm', '/de'))
		self._items.append(('Weitere Neuerscheinungen', '/de/neu'))
		self._items.append(('Top-Filme', '/de/top-filme'))
		self._items.append(('Weitere Top-Filme', '/de/top-filme'))
		self._items.append(('Blast from the Past : Mehr als hundert Jahre alt', '/de/neu'))
		self._items.append(('Blast from the Past : 1910 - 1940', '/de/neu'))
		self._items.append(('Blast from the Past : 1940 - 1960', '/de/neu'))
		self._items.append(('Laurel & Hardy Collection', '/de'))
		self._items.append(('Buster Keaton Collection', '/de'))
		self._items.append(('John Wayne Collection', '/de'))
		self._items.append(('Superman 40s Collection', '/de'))
		self._items.append(('Abenteuer', '/genre/abenteuer'))
		self._items.append(('Action', '/genre/action'))
		self._items.append(('Animation', '/genre/animation'))
		self._items.append(('Bollywood', '/genre/bollywood'))
		self._items.append(('Comedy', '/genre/comedy'))
		self._items.append(('Drama', '/genre/drama'))
		self._items.append(('Familie', '/genre/familie'))
		self._items.append(('Fantasy', '/genre/fantasy'))
		self._items.append(('Geschichte', '/genre/geschichte'))
		self._items.append(('Horror', '/genre/horror'))
		self._items.append(('Klassiker', '/genre/klassiker'))
		self._items.append(('Krieg', '/genre/krieg'))
		self._items.append(('Krimi', '/genre/krimi'))
		self._items.append(('Kurzfilm', '/genre/kurzfilm'))
		self._items.append(('Musik & Musicals', '/genre/musik'))
		self._items.append(('Mystery', '/genre/mystery'))
		self._items.append(('Romantik', '/genre/romantik'))
		self._items.append(('Science Fiction', '/genre/sci-fi'))
		self._items.append(('Sport', '/genre/sport'))
		self._items.append(('Stummfilme', '/genre/stummfilm'))
		self._items.append(('Thriller', '/genre/thriller'))
		self._items.append(('TV-Film', '/genre/tv-film'))
		self._items.append(('Western', '/genre/western'))
		self._items.append(('Gesundheit', '/genre/gesundheit'))
		self._items.append(('Küche und Essen', '/genre/essen'))
		self._items.append(('Reisen', '/genre/reisen'))
		self._items.append(('Technik und Wissenschaft', '/genre/technik-wissenschaft'))
		self._items.append(('Dokumentation', '/genre/doku'))
		self._items.append(('Geschichts-Dokumentationen', '/genre/geschichts-dokus'))
		self._items.append(('Kriegs-Dokumentationen', '/genre/kriegs-dokus'))
		self._items.append(('Musik-Dokumenationen', '/genre/musik-dokus'))
		self._items.append(('Natur-Dokumentation', '/genre/natur-doku'))
		self._items.append(('Sport-Dokumentationen', '/genre/sport-dokus'))
		self._items.append(('Tier-Dokumentationen', '/genre/tier-doku'))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))

	def keyOK(self):
		Name = self['liste'].getCurrent()[0][0]
		Url = self['liste'].getCurrent()[0][1]
		self.session.open(popcorntimesFilmeScreen, Url, Name)

class popcorntimesFilmeScreen(MPScreen):

	def __init__(self, session, Url, Name):
		self.Link = Url
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Popcorntimes")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)

		self.keyLocked = True

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		self['name'].setText(_("Please wait..."))
		url = base_url + self.Link
		twAgentGetPage(url, agent=agent).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		check = re.search('class="pt-section-title">(?:Filme im Genre `|)%s(?:`|)</(.*?)(?:class="pt-section-title">|$)' % self.Name, data, re.S)
		if check:
			data = check.group(1)
			vids = MPfindall(self, '<div class="col-xs.*?<img src="(.*?)".*?href="(.*?)".*?<h\d>(.*?)</h\d>.*?pt-video-time">(.*?)</p>.*?<p>(.*?)</p>', data, re.S)
			if vids:
				for (image, url, title, meta, desc) in vids:
					url = base_url + url
					if image.startswith('//'):
						image = 'https:' + image
					meta = stripAllTags(meta)
					meta = re.sub(r"\s+", " ", meta).strip()
					self._items.append((decodeHtml(title), url, image, desc, meta))
			else:
				vids = MPfindall(self, 'class="pt-movie-tile.*?href="(.*?)".*?<img.*?data-src="(.*?)"\salt="(.*?)".*?.*?pt-video-time">(.*?)</p>', data, re.S)
				if vids:
					for (url, image, title, meta) in vids:
						url = base_url + url
						if image.startswith('//'):
							image = 'https:' + image
						meta = stripAllTags(meta)
						meta = re.sub(r"\s+", " ", meta).strip()
						self._items.append((decodeHtml(title), url, image, '', meta))
		else:
			check = re.search('class="pt-hero(.*?)class="pt-section', data, re.S)
			if check:
				data = check.group(1)
				vids = MPfindall(self, 'class="pt-movie-tile.*?href="(.*?)".*?<img.*?data-src="(.*?)"\salt="(.*?)".*?.*?class="pt-tile-desc">(.*?)</p>.*?pt-video-time">(.*?)</p>', data, re.S)
				if vids:
					for (url, image, title, desc, meta) in vids:
						url = base_url + url
						if image.startswith('//'):
							image = 'https:' + image
						meta = stripAllTags(meta)
						meta = re.sub(r"\s+", " ", meta).strip()
						self._items.append((decodeHtml(title), url, image, desc, meta))
		if len(self._items) == 0:
			self._items.append((_("No videos found!"), None, default_cover, '', ''))
		self._setList('_defaultlistleft', True)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Title = self['liste'].getCurrent()[0][0]
		Image = self['liste'].getCurrent()[0][2]
		Descr = self['liste'].getCurrent()[0][3]
		Meta = self['liste'].getCurrent()[0][4]
		self['name'].setText(Title)
		self['handlung'].setText(Meta + "\n\n" + Descr)
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		if Link:
			twAgentGetPage(Link, agent=agent).addCallback(self.getStream).addErrback(self.dataError)

	def getStream(self, data):
		Title = self['liste'].getCurrent()[0][0]
		Image = self['liste'].getCurrent()[0][2]
		Link = self['liste'].getCurrent()[0][1]
		stream = MPfindall(self, 'var PCTMLOC = "(.*?)";', data, re.S)
		if stream:
			o = stream[0]
			def rep(o):
				if o <= "Z":
					x = 90
				else:
					x = 122
				o = ord(o[0]) + 13
				if x >= o:
					res = o
				else:
					res = o - 26
				return chr(res)
			url = ''
			for i in range(0, len(o)):
				if re.search('[a-zA-Z]', o[i]):
					url += rep(o[i])
				else:
					url += o[i]
			if url:
				url = base64.b64decode(url)
				if url.startswith('//'):
					url = 'https:' + url
				mp_globals.player_agent = agent
				headers = '&Referer=%s' % Link
				url = url + '#User-Agent='+mp_globals.player_agent+headers
				self.session.open(SimplePlayer, [(Title, url, Image)], showPlaylist=False, ltype='popcorntimes', cover=True)
		else:
			self.session.open(MessageBoxExt, _("This video is not available."), MessageBoxExt.TYPE_INFO, timeout=5)