﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from builtins import map
from ...plugin import _
from ...resources.imports import *

basename = "Chefkoch.de"
baseurl ="https://www.chefkoch.de"
securl= "https://www.chefkoch.de/video/artikel/"

default_cover = "file://%s/chefkoch.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class chefkochGenreScreen(MPScreen):

	def __init__(self, session):

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label(basename)
		self['ContentTitle'] = Label("Genre:")
		self['name'] = Label(_("Please wait..."))
		self.keyLocked = True

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		u = "%s/video" % baseurl
		twAgentGetPage(u).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		raw = MPfindall(self, 'class="navigation">(.*?)</ul>', data, re.S)
		if raw:
			parse = MPfindall(self, '<li\sclass="navigation.*?<a href="(.*?)"\sclass="link.*?>(.*?)</a>', raw[0], re.S)
			for (url, title) in parse:
				title = decodeHtml(title).strip()
				if title != "Club of Cooks":
					self._items.append((title, url))
			self.ml.setList(list(map(self._defaultlistcenter, self._items)))
			self.ml.moveToIndex(0)
			self.keyLocked = False
		self['name'].setText('')

	def keyOK(self):
		name = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		if self.keyLocked:
			return
		self.session.open(chefvids, name, url)

class chefvids(MPScreen):

	def __init__(self, session, name, url):
		self.url = url
		self.name = name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self.keyLocked = True
		self['title'] = Label(basename)
		self['ContentTitle'] = Label("Genre: %s" % self.name)
		self['name'] = Label(_("Please wait..."))

		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		twAgentGetPage(self.url).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		self._items = []
		parse = MPfindall(self, 'class="teaser-box.*?href="/video/artikel/(.*?)".*?img\ssrc="(.*?)".*?<h2>(.*?)</h2>', data, re.S)
		if parse:
			for (url, pic, title) in parse:
				self._items.append((decodeHtml(title).strip(), url, pic))
			self._setList('_defaultlistleft', True)
			self.ml.moveToIndex(0)
			self.keyLocked = False
			self.showInfos()

	def showInfos(self):
		self.vid = None
		title = self['liste'].getCurrent()[0][0]
		link = securl + self['liste'].getCurrent()[0][1]
		pic = self['liste'].getCurrent()[0][2]
		self['name'].setText(title)
		CoverHelper(self['coverArt']).getCover(pic)
		twAgentGetPage(link).addCallback(self.showInfos2).addErrback(self.dataError)

	def showInfos2(self, data):
		self.desc = MPfindall(self, '"description":\s"(.*?)",', data, re.S)
		self.runtime = MPfindall(self, 'L.*?nge:\s+<strong>(.*?)</strong', data, re.S)
		self.vid = MPfindall(self, 'contentUrl":\s"(.*?)",', data, re.S)
		if self.desc and self.runtime and self.vid:
			d = "Laufzeit: %s\n\n%s" % (self.runtime[0].strip(), (decodeHtml(self.desc[0])))
		else:
			d = ""
		self['handlung'].setText(d)

	def keyOK(self):
		if self.keyLocked:
			return
		if self.vid:
			self.vid = self.vid[0]
			name = self['liste'].getCurrent()[0][0]
			self.session.open(SimplePlayer, [(name, str(self.vid))], cover=False, showPlaylist=False, ltype='chefkoch', useResume=False)