﻿# -*- coding: utf-8 -*-

from __future__ import absolute_import
from future import standard_library
standard_library.install_aliases()
from builtins import object
from ..plugin import _
import urllib.parse
import _thread
import subprocess
from Tools.BoundFunction import boundFunction
from .messageboxext import MessageBoxExt
from . import mp_globals
from .twagenthelper import TwAgentHelper, twAgentGetPage
from .cvevosignalgoextractor import decryptor
from .imports import *

try:
	from youtube_dl import YoutubeDL
	from youtube_dl.utils import DownloadError
	youtubedl = True
except:
	youtubedl = False

headers = {'Accept-Language': 'en-us,en;q=0.5',
	'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
	'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36',
	}

playing = False

class youtubeUrl(object):

  def __init__(self, session):
	global playing
	self.__callBack = None
	self.errBack = None
	self.session = session
	self.error = ""
	self.yt_dwnld_agent = None
	self.useProxy = (config_mp.mediaportal.sp_use_yt_with_proxy.value == 'proxy') and (config_mp.mediaportal.yt_proxy_host.value != 'example_proxy.com!')
	self.initDownloadAgent()
	self.tw_agent_hlp = TwAgentHelper(gzip_decoding=True, followRedirect=True, headers=headers)
	mp_globals.premiumize = self.useProxy
	playing = False

  def initDownloadAgent(self):
	self.proxyurl = None
	if self.useProxy:
		proxyhost = config_mp.mediaportal.yt_proxy_host.value
		proxyport = config_mp.mediaportal.yt_proxy_port.value
		self.puser = config_mp.mediaportal.yt_proxy_username.value
		self.ppass = config_mp.mediaportal.yt_proxy_password.value

		if '/noconnect' in proxyhost:
			proxyhost, option = proxyhost.split('/')[-2:]
		else:
			option = ''
		if not proxyhost.startswith('http'):
			self.proxyurl = 'http://%s:%s/%s' % (proxyhost, proxyport, option)
		else: self.proxyurl = '%s:%s/%s' % (proxyhost, proxyport, option)
	else:
		self.puser = None
		self.ppass = None

	self.yt_dwnld_agent = TwAgentHelper(proxy_url=self.proxyurl, p_user=self.puser, p_pass=self.ppass, gzip_decoding=True, followRedirect=True, headers=headers)

  def addCallback(self, cbFunc):
	self.__callBack = cbFunc

  def addErrback(self, errFunc):
	self.errBack = errFunc

  def dataError(self, error):
	printl(error, self, "E")

  def errReturn(self, url=None):
	if self.errBack == None:
		self.session.openWithCallback(self.cbYTErr, MessageBoxExt, str(self.error), MessageBoxExt.TYPE_INFO, timeout=10)
	else:
		self.errBack(self.error)

  def cbYTErr(self, res):
	return

  def getVideoUrl(self, url):
	self.video_url = None
	self.audio_url = None
	self.video_id = url
	self.videoPrio = int(config_mp.mediaportal.youtubeprio.value)
	self.dash = config_mp.mediaportal.youtubeenabledash.value

	if not self.__callBack:
		self.error = '[YouTubeURL] ' + _('Error: No callBack set')
		self.errReturn()

	if self.videoPrio == 0: #360p
		self.VIDEO_FMT_PRIORITY_MAP = {
			'18': 1, #MP4 360p
			'34': 2, #FLV 360p
		}
	elif self.videoPrio == 1: #480p
		self.VIDEO_FMT_PRIORITY_MAP = {
			'35': 1, #FLV 480p
			'18': 3, #MP4 360p
			'34': 4, #FLV 360p
		}
		if config_mp.mediaportal.youtubeenabledash480p.value:
			self.VIDEO_FMT_PRIORITY_MAP.update({
			'135': 2, #MP4 480p (DASH)
			})
	elif self.videoPrio == 2: #720p
		self.VIDEO_FMT_PRIORITY_MAP = {
			'22': 1, #MP4 720p
			'35': 3, #FLV 480p
			'18': 5, #MP4 360p
			'34': 6, #FLV 360p
		}
		if config_mp.mediaportal.youtubeenabledash480p.value:
			self.VIDEO_FMT_PRIORITY_MAP.update({
			'135': 4, #MP4 480p (DASH)
			})
		if config_mp.mediaportal.youtubeenabledash720p.value:
			self.VIDEO_FMT_PRIORITY_MAP.update({
			'136': 2, #MP4 720p (DASH)
			})
	elif self.videoPrio == 3: #1080p
		self.VIDEO_FMT_PRIORITY_MAP = {
			'299': 3, #MP4 1080p60 (DASH)
			'137': 4, #MP4 1080p (DASH)
			'22': 5, #MP4 720p
			'35': 7, #FLV 480p
			'18': 9, #MP4 360p
			'34': 10, #FLV 360p
		}
		if config_mp.mediaportal.youtubeenabledash480p.value:
			self.VIDEO_FMT_PRIORITY_MAP.update({
			'135': 8, #MP4 480p (DASH)
			})
		if config_mp.mediaportal.youtubeenabledash720p.value:
			self.VIDEO_FMT_PRIORITY_MAP.update({
			'136': 6, #MP4 720p (DASH)
			})
		if config_mp.mediaportal.youtubeenablevp9.value:
			self.VIDEO_FMT_PRIORITY_MAP.update({
			'303': 1, #VP9 1080p60 (DASH)
			'248': 2, #VP9 1080p (DASH)
			})
	elif self.videoPrio == 4: #1440p
		self.VIDEO_FMT_PRIORITY_MAP = {
			'299': 5, #MP4 1080p60 (DASH)
			'137': 6, #MP4 1080p (DASH)
			'22': 7, #MP4 720p
			'35': 9, #FLV 480p
			'18': 11, #MP4 360p
			'34': 12, #FLV 360p
		}
		if config_mp.mediaportal.youtubeenabledash480p.value:
			self.VIDEO_FMT_PRIORITY_MAP.update({
			'135': 10, #MP4 480p (DASH)
			})
		if config_mp.mediaportal.youtubeenabledash720p.value:
			self.VIDEO_FMT_PRIORITY_MAP.update({
			'136': 8, #MP4 720p (DASH)
			})
		if config_mp.mediaportal.youtubeenablevp9.value:
			self.VIDEO_FMT_PRIORITY_MAP.update({
			'308': 1, #VP9 1440p60 (DASH)
			'271': 2, #VP9 1440p (DASH)
			'303': 3, #VP9 1080p60 (DASH)
			'248': 4, #VP9 1080p (DASH)
			})
	elif self.videoPrio == 5: #2160p
		self.VIDEO_FMT_PRIORITY_MAP = {
			'299': 10, #MP4 1080p60 (DASH)
			'137': 11, #MP4 1080p (DASH)
			'22': 13, #MP4 720p
			'35': 15, #FLV 480p
			'18': 17, #MP4 360p
			'34': 18, #FLV 360p
		}
		if config_mp.mediaportal.youtubeenabledash480p.value:
			self.VIDEO_FMT_PRIORITY_MAP.update({
			'135': 16, #MP4 480p (DASH)
			})
		if config_mp.mediaportal.youtubeenabledash720p.value:
			self.VIDEO_FMT_PRIORITY_MAP.update({
			'136': 14, #MP4 720p (DASH)
			})
		if config_mp.mediaportal.youtubeenablevp9.value:
			self.VIDEO_FMT_PRIORITY_MAP.update({
			'315': 2, #VP9 2160p60 (DASH)
			'313': 3, #VP9 2160p (DASH)
			'308': 5, #VP9 1440p60 (DASH)
			'271': 6, #VP9 1440p (DASH)
			'303': 8, #VP9 1080p60 (DASH)
			'248': 9, #VP9 1080p (DASH)
			})
		if config_mp.mediaportal.youtubeenablevp9.value and config_mp.mediaportal.youtubeenablehdr.value:
			self.VIDEO_FMT_PRIORITY_MAP.update({
			'337': 1, #VP9.2 2160p60 (DASH)
			'336': 4, #VP9.2 1440p60 (DASH)
			'335': 7, #VP9.2 1080p60 (DASH)
			'334': 12, #VP9.2 720p60 (DASH)
			})

	self.AUDIO_FMT_PRIORITY_MAP = {
		'258': 1, #AAC 5.1 384
		'256': 2, #AAC 5.1 192
		'141': 4, #AAC ABR256
		'140': 6, #AAC ABR128
		'139': 8, #AAC ABR48
		'172': 9, #VORBIS 256
		'171': 10, #VORBIS 128
	}
	if config_mp.mediaportal.youtubeenableopus.value and mp_globals.model in ["one", "two", "dm7080", "dm900", "dm920"]:
		self.AUDIO_FMT_PRIORITY_MAP.update({
		'251': 3, #Opus 160
		'250': 5, #Opus 70
		'249': 7, #Opus 50
		})

	# Getting video webpage
	watch_url = 'https://www.youtube.com/watch?v=%s' % self.video_id
	self.error = '[YouTubeURL] ' + _("Error: Unable to retrieve: %s") % watch_url
	self.yt_dwnld_agent.getWebPage(watch_url).addCallback(self.parseVInfo, watch_url).addErrback(self.dataError)

  def parseVInfo(self, videoinfo, watch_url):
	flashvars = self.extractFlashVars(videoinfo, 0)
	if u"url_encoded_fmt_stream_map" not in flashvars:
		self.checkFlashvars(flashvars, videoinfo)
	else:
		links = {}
		audio = {}

		# formats:
		# default \\"itag\\":(\d+),\\"url\\":\\"(.*?)\\",\\"mimeType\\":\\"(video.*?)\\",\\"bitrate\\":(\d+),
		# cipher \\"itag\\":(\d+),\\"mimeType\\":\\"(video.*?)\\",\\"bitrate\\":(\d+),.*?\\"cipher\\":\\"(.*?)\\"

		# adaptiveformats:
		# default video \\"itag\\":(\d+),\\"url\\":\\"(.*?)\\",\\"mimeType\\":\\"(video.*?)\\",\\"bitrate\\":(\d+),\\"width\\":(\d+),\\"height\\":(\d+),\\"initRange\\":{\\"start\\":\\"(\d+)\\",\\"end\\":\\"(\d+)\\"},\\"indexRange\\":{\\"start\\":\\"(\d+)\\",\\"end\\":\\"(\d+)\\"},.*?\\"fps\\":(\d+),
		# cipher video \\"itag\\":(\d+),\\"mimeType\\":\\"(video.*?)\\",\\"bitrate\\":(\d+),\\"width\\":(\d+),\\"height\\":(\d+),\\"initRange\\":{\\"start\\":\\"(\d+)\\",\\"end\\":\\"(\d+)\\"},\\"indexRange\\":{\\"start\\":\\"(\d+)\\",\\"end\\":\\"(\d+)\\"},.*?\\"fps\\":(\d+),.*?\\"cipher\\":\\"(.*?)\\"(?:}|,)
		# default audio \\"itag\\":(\d+),\\"url\\":\\"(.*?)\\",\\"mimeType\\":\\"(audio.*?)\\",\\"bitrate\\":(\d+),\\"initRange\\":{\\"start\\":\\"(\d+)\\",\\"end\\":\\"(\d+)\\"},\\"indexRange\\":{\\"start\\":\\"(\d+)\\",\\"end\\":\\"(\d+)\\"},
		# cipher audio \\"itag\\":(\d+),\\"mimeType\\":\\"(audio.*?)\\",\\"bitrate\\":(\d+),\\"initRange\\":{\\"start\\":\\"(\d+)\\",\\"end\\":\\"(\d+)\\"},\\"indexRange\\":{\\"start\\":\\"(\d+)\\",\\"end\\":\\"(\d+)\\"},.*?\\"cipher\\":\\"(.*?)\\"(?:}|,)


		encoded_url_map = ""
		if self.dash and (self.videoPrio >= 3 or (config_mp.mediaportal.youtubeenabledash480p.value and self.videoPrio >= 1) or (config_mp.mediaportal.youtubeenabledash720p.value and self.videoPrio >= 2)):
			try:
				encoded_url_map += u"," + flashvars.get('adaptive_fmts', [])
			except:
				pass
		encoded_url_map += u"," + flashvars[u"url_encoded_fmt_stream_map"]
		for url_desc in encoded_url_map.split(u","):
			url_desc_map = parse_qs(url_desc)
			if not (u"url" in url_desc_map or u"stream" in url_desc_map):
				continue

			try:
				key = int(url_desc_map[u"itag"][0])
			except ValueError:
				continue

			url = u""
			if u"url" in url_desc_map:
				url = urllib.parse.unquote(url_desc_map[u"url"][0])
			elif u"conn" in url_desc_map and u"stream" in url_desc_map:
				url = urllib.parse.unquote(url_desc_map[u"conn"][0])
				if url.rfind("/") < len(url) -1:
					url = url + "/"
				url = url + urllib.parse.unquote(url_desc_map[u"stream"][0])
			elif u"stream" in url_desc_map and u"conn" not in url_desc_map:
				url = urllib.parse.unquote(url_desc_map[u"stream"][0])

			if u"sig" in url_desc_map:
				url = url + u"&" + url_desc_map[u"sp"][0] + u"=" + url_desc_map[u"sig"][0]
			elif u"s" in url_desc_map:
				sig = url_desc_map[u"s"][0]
				flashvars = self.extractFlashVars(videoinfo, 1)
				signature = decryptor.decryptSignature(sig, flashvars[u"js"])
				if not signature:
					self.error = '[YouTubeURL] ' + _("Error: Cannot decrypt url")
					self.errReturn(None)
					return
				else:
					url += u"&" + url_desc_map[u"sp"][0] + u"=" + signature

			try:
				if "dur=0.000" in url:
					continue
				else:
					links[self.VIDEO_FMT_PRIORITY_MAP[str(key)]] = url
			except KeyError:
				if self.dash and (self.videoPrio >= 3 or (config_mp.mediaportal.youtubeenabledash480p.value and self.videoPrio >= 1) or (config_mp.mediaportal.youtubeenabledash720p.value and self.videoPrio >= 2)):
					try:
						audio[self.AUDIO_FMT_PRIORITY_MAP[str(key)]] = url
					except KeyError:
						continue
				else:
					continue

		hlsdata = videoinfo.replace('\\/', '/').replace('\\"', '"')
		#url = re.findall('dashManifestUrl":"(http.*?)"(?:}|,)', hlsdata, re.S)
		url = re.findall('hlsManifestUrl":"(http.*?\.m3u8)"(?:}|,)', hlsdata, re.S)
		if url:
			links = {}
			links[0] = url[-1]

		#print "#####################################################################################"
		#try:
		#	for i in links:
		#		type = re.search('.*?itag=(\d+)', links[i]).group(1)
		#		print type + "\t" + links[i]
		#except:
		#	pass
		#print "#####################################################################################"
		try:
			self.video_url = links[sorted(links.keys())[0]].encode('utf-8')
			if self.dash:
				try:
					if int(re.search('.*?itag=(\d+)', self.video_url).group(1))>100:
						self.audio_url = audio[sorted(audio.keys())[0]].encode('utf-8')
						#print "#####################################################################################"
						#for i in audio:
						#	type = re.search('.*?itag=(\d+)', audio[i]).group(1)
						#	print type + "\t" + audio[i]
						#print "#####################################################################################"
				except:
					pass

			if "dur=0.000" in self.video_url and self.audio_url:
				self.video_url = self.audio_url
				self.audio_url = "yt_dash_audio"

			if self.audio_url and self.audio_url != "yt_dash_audio" and mp_globals.model in ["one", "two"]:
				info_url = 'https://www.youtube.com/get_video_info'
				params = {'hl': 'en', 'gl': 'US', 'ssl_stream': '1', 'html5': '1'}
				params['video_id'] = self.video_id
				params['eurl'] = 'https://youtube.googleapis.com/v/' + self.video_id
				params['sts'] = ''
				params['c'] = 'WEB'
				params['cver'] = '1.20170712'
				params['cplayer'] = 'UNIPLAYER'
				params['cbr'] = 'Chrome'
				params['cbrver'] = '53.0.2785.143'
				params['cos'] = 'Windows'
				params['cosver'] = '10.0'
				data = self.grabpage(info_url, params)
				params = dict(urllib.parse.parse_qsl(data))
				duration = None
				fmts_list = params.get('adaptive_fmts').split(',')
				data = {}
				for item in fmts_list:
					stream_map = dict(urllib.parse.parse_qsl(item))
					t = stream_map.get('type')
					t = urllib.parse.unquote(t).decode('utf8')
					t = t.split(';')
					mime = t[0]
					i = stream_map.get('itag')
					baseurl = None
					for link in list(links.values()):
						if re.match('.*itag='+str(i)+'&', link):
							baseurl = link.replace("&", "&amp;").encode('utf-8')
						else:
							continue
					if not baseurl:
						for link in list(audio.values()):
							if re.match('.*itag='+str(i)+'&', link):
								baseurl = link.replace("&", "&amp;").encode('utf-8')
							else:
								continue
					if baseurl:
						if mime not in data:
							data[mime] = {}
						data[mime][i] = {}
						data[mime][i]['baseUrl'] = baseurl
						data[mime][i]['codecs'] = t[1][1:]
						data[mime][i]['id'] = i
						s = stream_map.get('size')
						if s:
							s=s.split('x')
							data[mime][i]['width'] = s[0]
							data[mime][i]['height'] = s[1]
						data[mime][i]['bandwidth'] = stream_map.get('bitrate')
						data[mime][i]['frameRate'] = stream_map.get('fps')
						data[mime][i]['indexRange'] = stream_map.get('index')
						data[mime][i]['init'] = stream_map.get('init')
						dur = re.search('dur=(\d+(?:\.\d+|))&', baseurl, re.S)
						if dur:
							duration = str(dur.group(1))
					else:
						continue

				out = '<?xml version="1.0" encoding="UTF-8"?>\n'
				out += '<MPD xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="urn:mpeg:dash:schema:mpd:2011" xmlns:xlink="http://www.w3.org/1999/xlink" xsi:schemaLocation="urn:mpeg:dash:schema:mpd:2011 http://standards.iso.org/ittf/PubliclyAvailableStandards/MPEG-DASH_schema_files/DASH-MPD.xsd" minBufferTime="PT1.5S" mediaPresentationDuration="PT' + duration +'S" type="static" availabilityStartTime="2001-12-17T09:40:57Z" profiles="urn:mpeg:dash:profile:isoff-main:2011">'
				out += '<Period start="PT0S" duration="PT' + duration +'S">\n'
				n = 0
				for mime in data:
					if len(data[mime]) > 0:
						out += '<AdaptationSet id="' + str(n) + '" mimeType="' + mime + '" subsegmentAlignment="true" subsegmentStartsWithSAP="1" bitstreamSwitching="true">\n'
						out += '<Role schemeIdUri="urn:mpeg:DASH:role:2011" value="main"/>\n'
						for i in data[mime]:
							if data[mime][i]['baseUrl']:
								if 'audio' in mime:
									out += '<Representation id="' + i + '" ' + data[mime][i]['codecs'] + ' bandwidth="' + data[mime][i]['bandwidth'] + '">\n'
									out += '<AudioChannelConfiguration schemeIdUri="urn:mpeg:dash:23003:3:audio_channel_configuration:2011" value="2"/>\n'
								else:
									out += '<Representation id="' + i + '" ' + data[mime][i]['codecs'] + ' startWithSAP="1" bandwidth="' + data[mime][i]['bandwidth'] + '" width="' + data[mime][i]['width'] + '" height="' + data[mime][i]['height'] + '" frameRate="' + data[mime][i]['frameRate'] + '">\n'
								out += '<BaseURL>' + data[mime][i]['baseUrl'] + '</BaseURL>\n'
								out += '<SegmentBase indexRange="' + data[mime][i]['indexRange'] + '">\n'
								out += '<Initialization range="' + data[mime][i]['init'] + '" />\n'
								out += '</SegmentBase>\n'
								out += '</Representation>\n'
						out += '</AdaptationSet>\n'
						n = n + 1
				out += '</Period></MPD>\n'

				dash_file = '/tmp/yt_%s_dash.mpd' % self.video_id
				with open(dash_file, 'w') as dash_mpd:
					dash_mpd.write(out)
					dash_mpd.close()
				self.callBack('file://'+dash_file)
			else:
				self.callBack(self.video_url, self.audio_url)
		except (KeyError, IndexError):
			self.error = '[YouTubeURL] ' + _("Error: No video url found")
			self.errReturn(self.video_url)

  def parseVInfo2(self, results):
	links = {}
	audio = {}

	for item in results.get('formats', []):
		try:
			if 'manifest/dash' in str(item["url"]):
				continue
			elif not self.dash and int(re.search('.*?itag=(\d+)', str(item["url"])).group(1))>100:
				continue
			else:
				links[self.VIDEO_FMT_PRIORITY_MAP[str(item["format_id"])]] = str(item["url"])
		except KeyError:
			if self.dash and (self.videoPrio >= 3 or (config_mp.mediaportal.youtubeenabledash480p.value and self.videoPrio >= 1) or (config_mp.mediaportal.youtubeenabledash720p.value and self.videoPrio >= 2)):
				try:
					audio[self.AUDIO_FMT_PRIORITY_MAP[str(item["format_id"])]] = str(item["url"])
				except KeyError:
					continue
			else:
				continue

	try:
		self.video_url = links[sorted(links.keys())[0]].encode('utf-8')
		if self.dash:
			try:
				if int(re.search('.*?itag=(\d+)', self.video_url).group(1))>100:
					self.audio_url = audio[sorted(audio.keys())[0]].encode('utf-8')
			except:
				pass

		if "dur=0.000" in self.video_url and self.audio_url:
			self.video_url = self.audio_url
			self.audio_url = "yt_dash_audio"

		self.callBack(self.video_url, self.audio_url)
	except (KeyError, IndexError):
		self.error = '[YouTubeURL] ' + _("Error: No video url found")
		self.errReturn(self.video_url)

  def checkFlashvars(self, flashvars, videoinfo):
	# Attempt to see if YouTube has issued an error message
	if u"reason" not in flashvars:
		pc = False
		if 'offerButtonText' in videoinfo:
			pc = True
			self.error = '[YouTubeURL] ' + _("Error: Paid Content")

		msg = re.search('reason":{"simpleText":"(.*?)"},', videoinfo, re.S)
		if msg:
			txt = msg.group(1).strip()

			if not pc:
				self.error = '[YouTubeURL] ' + _('Error: %s') % txt
			else:
				self.error += txt
		elif not pc:
			self.error = '[YouTubeURL] ' + _('Error: Unable to extract "url_encoded_fmt_stream_map" parameter for unknown reason')

		if not pc:
			hlsdata = videoinfo.replace('\\/', '/').replace('\\"', '"')
			#url = re.findall('dashManifestUrl":"(http.*?)"(?:}|,)', hlsdata, re.S)
			url = re.findall('hlsManifestUrl":"(http.*?\.m3u8)"(?:}|,)', hlsdata, re.S)
			if url:
				self.callBack(url[-1], None)
				return
			if youtubedl: # fallback to youtubedl resolver
				_thread.start_new_thread(self.get_video, ("GetVideo",))
				return
			else:
				self.error = '[YouTubeURL] ' + _("Error: youtube-dl not found")
	else:
		from .imports import stripAllTags
		reason = unquote_plus(flashvars['reason'][0])
		self.error = '[YouTubeURL] ' + _('Error: YouTube said:\n\n%s') % stripAllTags(str(reason))

	self.errReturn(self.video_url)

  def get_video(self, threadName):
	try:
		printl("Calling thread: %s" % threadName, self, 'A')
		link = "https://www.youtube.com/watch?v=%s" % self.video_id
		results = subprocess.check_output('python /usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/resources/ytdl.py %s' % link, shell=True)
		if 'ERROR:' in str(results):
			if "YouTube said:" in str(results):
				results = _('Error: YouTube said:\n\n%s') % str(results).split('YouTube said:')[-1].replace('Sorry about that.', '').strip()
			self.error = '[YouTubeURL] ' + "%s" % str(results)
			reactor.callFromThread(boundFunction(self.errReturn, self.video_url))
		else:
			results = json.loads(results)
			reactor.callFromThread(boundFunction(self.parseVInfo2, results))
	except:
		self.error = '[YouTubeURL] ' + _("Error: Failed calling youtube-dl")
		reactor.callFromThread(boundFunction(self.errReturn, self.video_url))

  def removeAdditionalEndingDelimiter(self, data):
	pos = data.find("};")
	if pos != -1:
		data = data[:pos + 1]
	return data

  def normalizeUrl(self, url):
	if url[0:2] == "//":
		url = "https:" + url
	return url

  def extractFlashVars(self, data, assets):
	flashvars = {}
	found = False

	for line in data.split("\n"):
		if line.strip().find(";ytplayer.config = ") > 0:
			found = True
			p1 = line.find(";ytplayer.config = ") + len(";ytplayer.config = ") - 1
			p2 = line.rfind(";")
			if p1 <= 0 or p2 <= 0:
				continue
			data = line[p1 + 1:p2]
			break
	data = self.removeAdditionalEndingDelimiter(data)

	if found:
		data = json.loads(data)
		if assets:
			flashvars = data["assets"]
		else:
			flashvars = data["args"]

		for k in ["html", "css", "js"]:
			if k in flashvars:
				flashvars[k] = self.normalizeUrl(flashvars[k])

	return flashvars

  def callBack(self, url, suburi=None):
	if suburi and not '.m3u8' in url:
		self.__callBack(url, suburi=suburi)
	elif url.startswith('file://'):
		self.__callBack(url, None)
	elif url.startswith('http') and not '.m3u8' in url:
		self.error = '[YouTubeURL] ' + _('Playback error:')
		try:
			return self.tw_agent_hlp.getRedirectedUrl(url, True).addCallback(self.getRedirect, url).addErrback(self.dataError)
		except:
			self.__callBack(url)
	else:
		self.yt_dwnld_agent.getWebPage(url).addCallback(self.parseM3U8Playlist).addErrback(self.dataError)

  def parseM3U8Playlist(self, data):
	bandwith_list = []
	match_sec_m3u8=re.findall('BANDWIDTH=(\d+).*?\n(.*?m3u8)', data, re.S)
	if self.videoPrio >= 3:
		bw = int(match_sec_m3u8[-1][0])
	elif self.videoPrio == 2:
		bw = int(match_sec_m3u8[-1][0]) / 2
	elif self.videoPrio == 1:
		bw = int(match_sec_m3u8[-1][0]) / 3
	else:
		bw = int(match_sec_m3u8[-1][0]) / 4
	for each in match_sec_m3u8:
		bandwith, url = each
		bandwith_list.append((int(bandwith), url))
	_x, best = min((abs(int(x[0]) - bw), x) for x in bandwith_list)
	url = best[1]
	self.__callBack(url)

  def getRedirect(self, redir_url, url):
	if 'Forbidden' in redir_url:
		if self.useProxy:
			self.__callBack(url, buffering=True, proxy=(self.proxyurl, self.puser, self.ppass))
		else:
			self.dataError(redir_url)
	else:
		self.__callBack(url)

  def grabpage(self, url, params):
        headers = {'Host': 'www.youtube.com',
                   'Connection': 'keep-alive',
                   'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 Safari/537.36',
                   'Accept': '*/*',
                   'DNT': '1',
                   'Referer': 'https://www.youtube.com/tv',
                   'Accept-Encoding': 'gzip, deflate',
                   'Accept-Language': 'en-US,en;q=0.8,de;q=0.6'}

	s = requests.session()
	page = s.get(url, params=params, headers=headers, allow_redirects=True)
	return page.content