﻿# -*- coding: utf-8 -*-
from __future__ import absolute_import
from future import standard_library
standard_library.install_aliases()
from builtins import object
import six
import requests
import timeout_decorator
from ..plugin import _

from enigma import gFont, addFont, ePoint, eTimer, eConsoleAppContainer, ePicLoad, loadPNG, getDesktop, eServiceReference, iPlayableService, eListboxPythonMultiContent, RT_HALIGN_LEFT, RT_HALIGN_RIGHT, RT_HALIGN_CENTER, RT_VALIGN_CENTER, RT_WRAP, eListbox, gPixmapPtr, getPrevAsciiCode, eBackgroundFileEraser
from operator import isCallable

from Plugins.Plugin import PluginDescriptor

from twisted import __version__
from twisted.internet import reactor, defer
from twisted.web.http_headers import Headers
from twisted.internet.defer import Deferred, succeed
from twisted.web import http
from twisted.python import failure

from http.cookiejar import CookieJar

from zope.interface import implements

from .twagenthelper import TwAgentHelper, twAgentGetPage
from .tw_util import getPage

from Components.ActionMap import NumberActionMap, ActionMap, HelpableActionMap
from Components.AVSwitch import AVSwitch
from Components.Button import Button
from .config import config_mp, configfile_mp
from Components.config import config, ConfigElement, choicesList, ConfigInteger, ConfigSelection, ConfigSelectionNumber, getConfigListEntry, ConfigTextBase, ConfigDirectory, ConfigBoolean, configfile, ConfigSubsection, ConfigPIN, NoSave, ConfigNothing, ConfigIP, ConfigOnOff

from .numericaltextinputext import NumericalTextInputExt

class ConfigText(ConfigTextBase, NumericalTextInputExt):
        def __init__(self, default = "", fixed_size = True, visible_width = False, censor_char = ''):
                ConfigTextBase.__init__(self, default = default, fixed_size = fixed_size, visible_width = visible_width, censor_char = censor_char)
                NumericalTextInputExt.__init__(self, nextFunc = self.nextFunc, handleTimeout = False)

class ConfigPassword(ConfigText):
        def __init__(self, default = "", fixed_size = False, visible_width = False, censor = "*"):
                ConfigText.__init__(self, default = default, fixed_size = fixed_size, visible_width = visible_width, censor_char = censor)

class ConfigSelectionFloat(ConfigSelection):
	def __init__(self, min, max, stepwidth, default = None, wraparound = False):
		self.wraparound = wraparound
		if default is None:
			default = min
		default = str(default)
		choices = []
		step = min
		while step <= max:
			choices.append(str(float(step)))
			step += stepwidth

		ConfigSelection.__init__(self, choices, default)

	def getValue(self):
		return float(ConfigSelection.getValue(self))

	def setValue(self, val):
		ConfigSelection.setValue(self, str(val))

	def handleKey(self, key):
		if not self.wraparound:
			if key == 1:
				if len(self.choices) == (self.choices.index(self.value) + 1):
					return
			if key == 0:
				if self.choices.index(self.value) == 0:
					return
		ConfigSelection.handleKey(self, key)

class ConfigSelectionExt(ConfigSelection):
	def __init__(self, choices, default = None):
		ConfigElement.__init__(self)
		self.choices = choicesList(choices)
		self.allow_invalid_choice = None
		self.graphic = False
		try:
			self.choices.additemDescriptionUpdatedCallback(self._invalidateCachedDescription)
		except:
			pass
		if default is None:
			default = self.choices.default()
		try:
			self._invalidateCachedDescription()
		except:
			pass
		self._descr = None
		self.default = self._value = self.last_value = default

from Components.Label import Label
from Components.Language import language
from Components.MenuList import MenuList
from Components.MultiContent import MultiContentEntryText, MultiContentEntryPixmapAlphaBlend
from Components.Pixmap import Pixmap
from Components.ScrollLabel import ScrollLabel
from Components.ServiceEventTracker import ServiceEventTracker, InfoBarBase
from Components.Sources.Boolean import Boolean
from Components.Input import Input

from Screens.InfoBar import MoviePlayer, InfoBar
from Screens.InfoBarGenerics import InfoBarSeek, InfoBarNotifications, InfoBarServiceErrorPopupSupport, InfoBarGstreamerErrorPopupSupport
from Screens.Screen import Screen
from Screens.Standby import TryQuitMainloop
from Screens.NumericalTextInputHelpDialog import NumericalTextInputHelpDialog
from Screens.HelpMenu import HelpableScreen

from Tools.Directories import fileExists, resolveFilename, SCOPE_PLUGINS, SCOPE_SKIN, SCOPE_CURRENT_SKIN, SCOPE_FONTS, createDir
from Tools.LoadPixmap import LoadPixmap

import re, urllib.request, urllib.parse, urllib.error, os, http.cookiejar, socket, sha, shutil, datetime, math, hashlib, random, json, md5, string, xml.etree.cElementTree, io, queue, threading, sys
from urllib.request import Request
from urllib.error import URLError
from socket import gaierror, error
from urllib.parse import quote, unquote_plus, unquote, urlencode, parse_qs
from binascii import unhexlify, hexlify
from time import time, localtime, strftime, mktime
from base64 import b64decode as gfcdf

# MediaPortal Imports
from .debuglog import printl

class InsensitiveKey(object):
	def __init__(self, key):
		self.key = key
	def __hash__(self):
		return hash(self.key.lower())
	def __eq__(self, other):
		return self.key.lower() == other.key.lower()
	def __str__(self):
		return self.key

class InsensitiveDict(dict):
	def __setitem__(self, key, value):
		key = InsensitiveKey(key)
		super(InsensitiveDict, self).__setitem__(key, value)
	def __getitem__(self, key):
		key = InsensitiveKey(key)
		return super(InsensitiveDict, self).__getitem__(key)

from . import mp_globals

boolean_descriptions = {False: "false", True: "true"}
class ConfigBooleanExt(ConfigBoolean):
	def __init__(self, default = False, descriptions = boolean_descriptions):
		ConfigElement.__init__(self)
		self.descriptions = descriptions
		self.value = self.last_value = self.default = default
		self.graphic = False

	def getMulti(self, selected):
		descr = self.descriptions[self.value]
		if descr:
			return ("text", _(descr))
		return ("text", descr)

yes_no_descriptions = {False: _("no"), True: _("yes")}
class ConfigYesNo(ConfigBooleanExt):
	def __init__(self, default = False):
		ConfigBooleanExt.__init__(self, default = default, descriptions = yes_no_descriptions)

from .pixmapext import PixmapExt
from .mp_globals import std_headers
from .streams import isSupportedHoster, get_stream_link
from .mpscreen import MPScreen, MPSetupScreen, SearchHelper
from .simpleplayer import SimplePlayer
from .coverhelper import CoverHelper
from .messageboxext import MessageBoxExt

def clear_mp():
	if os.path.isdir(gfcdf("L3Vzci9saWIvZW5pZ21hMi9weXRob24vUGx1Z2lucy9FeHRlbnNpb25zL0dvbGRlblBhbmVs")) or os.path.isdir(gfcdf("L3Vzci9saWIvZW5pZ21hMi9weXRob24vUGx1Z2lucy9FeHRlbnNpb25zL1BlcnNpYW5EcmVhbWJveA==")) or os.path.isdir(gfcdf("L3Vzci9saWIvZW5pZ21hMi9weXRob24vUGx1Z2lucy9FeHRlbnNpb25zL1NhdFZlbnVzUGFuZWw=")):
		os.system("rm -r %s" % gfcdf("L3Vzci9saWIvZW5pZ21hMi9weXRob24vUGx1Z2lucy9FeHRlbnNpb25zL01lZGlhUG9ydGFs"))

TimerInstances = []

class TimerCall(object):
	def __init__(self, delay, function, *params):
		try:
			if isCallable(function):
				global TimerInstances
				TimerInstances.append(self)
				self.function = function
				self.params = params
				self.timer = None
				self.timer = eTimer()
				self.timer_conn = None
				try:
					self.timer_conn = self.timer.timeout.connect(self.timerLaunch)
				except:
					self.timer.timeout.get().append(self.timerLaunch)
				self.timer.start(int(delay*1000), False)
		except Exception as e:
			pass

	def timerLaunch(self):
		try:
			global TimerInstances
			TimerInstances.remove(self)
			self.timer.stop()
			try:
				self.timer_conn = None
			except:
				self.timer.timeout.get().remove(self.timerLaunch)
			self.timer = None
			self.function(*self.params)
		except Exception as e:
			pass

def getUserAgent():
	userAgents = [
		"Mozilla/5.0 (Windows NT 6.3; rv:36.0) Gecko/20100101 Firefox/36.0",
		"Opera/9.80 (Macintosh; Intel Mac OS X 10.6.8; U; de) Presto/2.9.168 Version/11.52",
		"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:35.0) Gecko/20120101 Firefox/35.0",
		"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:29.0) Gecko/20120101 Firefox/29.0",
		"Mozilla/5.0 (X11; Linux x86_64; rv:28.0) Gecko/20100101 Firefox/28.0",
		"Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0)",
		"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 7.1; Trident/5.0)",
		"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/537.13+ (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2",
		"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/36.0.1985.67 Safari/537.36",
		"Mozilla/5.0 (compatible; Konqueror/4.5; FreeBSD) KHTML/4.5.4 (like Gecko)",
		"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:33.0) Gecko/20100101 Firefox/33.0",
	]
	return random.choice(userAgents)

def getUpdateUrl():
	updateurls = [
		'http://e2-mediaportal.sourceforge.net/version.txt',
		'http://dhwz.github.io/e2-mediaportal/version.txt',
		'http://dhwz.gitlab.io/pages/version.txt'
	]
	return random.choice(updateurls)

def getIconUrl():
	iconurls = [
		'http://dhwz.gitlab.io/pages/',
		'http://dhwz.github.io/e2-mediaportal/',
		'http://dhwz.gitlab.io/pages/'
	]
	return random.choice(iconurls)

def testWebConnection(host="www.google.com", port=80, timeout=3):
	import socket

	try:
		socket.setdefaulttimeout(timeout)
		socket.socket(socket.AF_INET, socket.SOCK_STREAM).connect((host, port))
		return True
	except Exception as ex:
		return False

@timeout_decorator.timeout(15, timeout_exception=StopIteration)
def MPfindall(callfrom, *args, **kwargs):
	try:
		x = re.findall(*args, **kwargs)
		return x
	except StopIteration as e:
		printl('Parsing errror: %s' % callfrom, '', "E")
		callfrom.session.open(MessageBoxExt, _('Parsing timed out after %s seconds.\nPlease report the below addition to the developer if this error occurs frequently:\n\n%s') % (str(15), str(callfrom).replace('<class \'Plugins.Extensions.MediaPortal.','').replace('\'>','')), MessageBoxExt.TYPE_ERROR)
		return

def decodeHtml(text):
	import html.parser
	h = html.parser.HTMLParser()
	# We have to repeat this multiple times (fixes e.g. broken Liveleak encodings)
	try:
		text = h.unescape(text).encode('utf-8')
		text = h.unescape(text).encode('utf-8')
		text = h.unescape(text).encode('utf-8')
	except:
		text = text.decode('latin1').encode('utf-8')

	# New HTML5 encodings
	text = text.replace('&period;', '.')
	text = text.replace('&comma;', ',')
	text = text.replace('&commat;', '@')
	text = text.replace('&dollar;', '$')
	text = text.replace('&lbrack;', '[')
	text = text.replace('&rbrack;', ']')
	text = text.replace('&DiacriticalTilde;', '˜')
	text = text.replace('&DiacriticalAcute;', '´')
	text = text.replace('&OpenCurlyQuote;', '‘')
	text = text.replace('&OpenCurlyDoubleQuote;', '“')
	text = text.replace('&semi;', ';')
	text = text.replace('&colon;', ':')
	text = text.replace('&plus;', '+')
	text = text.replace('&amp;', '&')
	text = text.replace('&equals;', '=')
	text = text.replace('&num;', '#')
	text = text.replace('&excl;', '!')
	text = text.replace('&quest;', '?')
	text = text.replace('&lowbar;', '_')
	text = text.replace('&rpar;', ')')
	text = text.replace('&lpar;', '(')
	text = text.replace('&rsqb;', ']')
	text = text.replace('&lsqb;', '[')

	text = text.replace('&Zcaron;', 'Ž')
	text = text.replace('&zcaron;', 'ž')
	text = text.replace('&Zdot;', 'Ż')
	text = text.replace('&zdot;', 'ż')

	text = text.replace('&IOcy;', 'Ё')
	text = text.replace('&DJcy;', 'Ђ')
	text = text.replace('&GJcy;', 'Ѓ')
	text = text.replace('&Jukcy;', 'Є')
	text = text.replace('&DScy;', 'Ѕ')
	text = text.replace('&Iukcy;', 'І')
	text = text.replace('&YIcy;', 'Ї')
	text = text.replace('&Jsercy;', 'Ј')
	text = text.replace('&LJcy;', 'Љ')
	text = text.replace('&NJcy;', 'Њ')
	text = text.replace('&TSHcy;', 'Ћ')
	text = text.replace('&KJcy;', 'Ќ')
	text = text.replace('&Ubrcy;', 'Ў')
	text = text.replace('&DZcy;', 'Џ')
	text = text.replace('&Acy;', 'А')
	text = text.replace('&Bcy;', 'Б')
	text = text.replace('&Vcy;', 'В')
	text = text.replace('&Gcy;', 'Г')
	text = text.replace('&Dcy;', 'Д')
	text = text.replace('&IEcy;', 'Е')
	text = text.replace('&ZHcy;', 'Ж')
	text = text.replace('&Zcy;', 'З')
	text = text.replace('&Icy;', 'И')
	text = text.replace('&Jcy;', 'Й')
	text = text.replace('&Kcy;', 'К')
	text = text.replace('&Lcy;', 'Л')
	text = text.replace('&Mcy;', 'М')
	text = text.replace('&Ncy;', 'Н')
	text = text.replace('&Ocy;', 'О')
	text = text.replace('&Pcy;', 'П')
	text = text.replace('&Rcy;', 'Р')
	text = text.replace('&Scy;', 'С')
	text = text.replace('&Tcy;', 'Т')
	text = text.replace('&Ucy;', 'У')
	text = text.replace('&Fcy;', 'Ф')
	text = text.replace('&KHcy;', 'Х')
	text = text.replace('&TScy;', 'Ц')
	text = text.replace('&CHcy;', 'Ч')
	text = text.replace('&SHcy;', 'Ш')
	text = text.replace('&SHCHcy;', 'Щ')
	text = text.replace('&HARDcy;', 'Ъ')
	text = text.replace('&Ycy;', 'Ы')
	text = text.replace('&SOFTcy;', 'Ь')
	text = text.replace('&Ecy;', 'Э')
	text = text.replace('&YUcy;', 'Ю')
	text = text.replace('&YAcy;', 'Я')
	text = text.replace('&acy;', 'а')
	text = text.replace('&bcy;', 'б')
	text = text.replace('&vcy;', 'в')
	text = text.replace('&gcy;', 'г')
	text = text.replace('&dcy;', 'д')
	text = text.replace('&iecy;', 'е')
	text = text.replace('&zhcy;', 'ж')
	text = text.replace('&zcy;', 'з')
	text = text.replace('&icy;', 'и')
	text = text.replace('&jcy;', 'й')
	text = text.replace('&kcy;', 'к')
	text = text.replace('&lcy;', 'л')
	text = text.replace('&mcy;', 'м')
	text = text.replace('&ncy;', 'н')
	text = text.replace('&ocy;', 'о')
	text = text.replace('&pcy;', 'п')
	text = text.replace('&rcy;', 'р')
	text = text.replace('&scy;', 'с')
	text = text.replace('&tcy;', 'т')
	text = text.replace('&ucy;', 'у')
	text = text.replace('&fcy;', 'ф')
	text = text.replace('&khcy;', 'х')
	text = text.replace('&tscy;', 'ц')
	text = text.replace('&chcy;', 'ч')
	text = text.replace('&shcy;', 'ш')
	text = text.replace('&shchcy;', 'щ')
	text = text.replace('&hardcy;', 'ъ')
	text = text.replace('&ycy;', 'ы')
	text = text.replace('&softcy;', 'ь')
	text = text.replace('&ecy;', 'э')
	text = text.replace('&yucy;', 'ю')
	text = text.replace('&yacy;', 'я')
	text = text.replace('&iocy;', 'ё')
	text = text.replace('&djcy;', 'ђ')
	text = text.replace('&gjcy;', 'ѓ')
	text = text.replace('&jukcy;', 'є')
	text = text.replace('&dscy;', 'ѕ')
	text = text.replace('&iukcy;', 'і')
	text = text.replace('&yicy;', 'ї')
	text = text.replace('&jsercy;', 'ј')
	text = text.replace('&ljcy;', 'љ')
	text = text.replace('&njcy;', 'њ')
	text = text.replace('&tshcy;', 'ћ')
	text = text.replace('&kjcy;', 'ќ')
	text = text.replace('&ubrcy;', 'ў')
	text = text.replace('&dzcy;', 'џ')

	# Replace only \uxxxx
	if re.search('\\u[0-9a-fA-F]{4}', text, re.S):
		endpos = len(text)
		pos = 0
		out = ''
		try:
			while pos < endpos:
				if text[pos] == "\\" and text[pos+1] == "u" and re.match('[0-9a-fA-F]{4}', text[pos+2:pos+6], re.S):
					dec = text[pos:pos+6].decode('unicode-escape').encode('utf-8')
					out += dec
					pos += 6
				else:
					out += text[pos]
					pos += 1
		except:
			out = text
	else: out = text
	return out

def stripAllTags(html):
	cleanr = re.compile('<.*?>')
	cleantext = re.sub(cleanr, '', html.replace('\n', ''))
	return cleantext

def upperString(txt):
	return " ".join((x[0].upper() + x[1:]) for x in txt.split())