# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from __future__ import absolute_import
from future import standard_library
standard_library.install_aliases()
from builtins import next
from builtins import map
from builtins import range
from builtins import object
import math
import _thread
from PIL import Image

SHOW_HANG_STAT = False

# General imports
from . import _
from Tools.BoundFunction import boundFunction
from .resources.imports import *
from .resources.update import *
from .resources.simplelist import *
from .resources.simpleplayer import SimplePlaylistIO
from .resources.twagenthelper import twAgentGetPage, twDownloadPage
from .resources.configlistext import ConfigListScreenExt
from .resources.choiceboxext import ChoiceBoxExt
from .resources.pininputext import PinInputExt
from .resources.realdebrid import realdebrid_oauth2

from twisted.internet import task
from .resources.twisted_hang import HangWatcher

CONFIG = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/additions/additions.xml"

desktopSize = getDesktop(0).size()
if desktopSize.width() == 1920:
	mp_globals.videomode = 2
	mp_globals.fontsize = 30
	mp_globals.sizefactor = 3
	mp_globals.plugin_grid_pixmapwidth = 290
	mp_globals.plugin_grid_pixmapheight = 156
	mp_globals.plugin_list_fontsize = 28

from Components.ScreenAnimations import *
sa = ScreenAnimations()
sa.fromXML(resolveFilename(SCOPE_PLUGINS, "Extensions/MediaPortal/resources/animations.xml"))

try:
	from Plugins.Extensions.MediaInfo.plugin import MediaInfo
	MediaInfoPresent = True
except:
	MediaInfoPresent = False

def _downloadPage(url, path):
	agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.82 Safari/537.36"
	return twDownloadPage(url, path, timeout=10, agent=agent)

def grabpage(pageurl, method='GET', postdata={}):
	agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.82 Safari/537.36"
	try:
		import urllib.parse
		s = requests.session()
		url = urllib.parse.urlparse(pageurl)
		if method == 'GET':
			headers = {'User-Agent': agent}
			page = s.get(url.geturl(), headers=headers, timeout=10)
		return page.content
	except:
		return None

from Components.config import ConfigClock, ConfigSequence

class ConfigPORNPIN(ConfigInteger):
	def __init__(self, default, len = 4, censor = ""):
		ConfigSequence.__init__(self, seperator = ":", limits = [(1000, (10**len)-1)], censor_char = censor, default = default)

config_mp.mediaportal = ConfigSubsection()

# Fake entry fuer die Kategorien
config_mp.mediaportal.fake_entry = NoSave(ConfigNothing())

# Allgemein
config_mp.mediaportal.version = NoSave(ConfigText(default="2021050101"))
config_mp.mediaportal.autoupdate = ConfigYesNo(default = True)

config_mp.mediaportal.skinfail = ConfigYesNo(default = False)

config_mp.mediaportal.retries = ConfigSubsection()

config_mp.mediaportal.pincode = ConfigPIN(default = 0000)
config_mp.mediaportal.retries.pincode = ConfigSubsection()
config_mp.mediaportal.retries.pincode.tries = ConfigInteger(default = 3)
config_mp.mediaportal.retries.pincode.time = ConfigInteger(default = 0)

config_mp.mediaportal.adultpincode = ConfigPORNPIN(default = random.randint(1, 999), len = 4)
if config_mp.mediaportal.adultpincode.value < 1:
	config_mp.mediaportal.adultpincode.value = random.randint(1, 999)

config_mp.mediaportal.retries.adultpin = ConfigSubsection()
config_mp.mediaportal.retries.adultpin.tries = ConfigInteger(default = 3)
config_mp.mediaportal.retries.adultpin.time = ConfigInteger(default = 0)

config_mp.mediaportal.showporn = ConfigYesNo(default = False)
config_mp.mediaportal.hideporn_startup = ConfigYesNo(default = True)
config_mp.mediaportal.showuseradditions = ConfigYesNo(default = False)
config_mp.mediaportal.pinuseradditions = ConfigYesNo(default = False)
config_mp.mediaportal.ena_suggestions = ConfigYesNo(default = True)

config_mp.mediaportal.animation_label = ConfigSelectionExt(default = "mp_crossfade_fast", choices = [("mp_crossfade_fast", _("Crossfade (fast)")), ("mp_crossfade_slow", _("Crossfade (slow)"))])

skins = []
if mp_globals.videomode == 2:
	mp_globals.skinsPath = "/skins_1080"
	for skin in os.listdir("/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/skins_1080/"):
		if os.path.isdir(os.path.join("/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/skins_1080/", skin)):
			skins.append(skin)
	config_mp.mediaportal.skin2 = ConfigSelectionExt(default = "clean_fhd", choices = skins)
	mp_globals.skinFallback = "/clean_fhd"
else:
	mp_globals.skinsPath = "/skins_720"
	for skin in os.listdir("/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/skins_720/"):
		if os.path.isdir(os.path.join("/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/skins_720/", skin)):
			if skin != "original":
				skins.append(skin)
	config_mp.mediaportal.skin2 = ConfigSelectionExt(default = "clean_hd", choices = skins)
	mp_globals.skinFallback = "/clean_hd"

config_mp.mediaportal.skin = NoSave(ConfigText(default=config_mp.mediaportal.skin2.value))

config_mp.mediaportal.debugMode = ConfigSelectionExt(default="Silent", choices = ["High", "Normal", "Silent"])

config_mp.mediaportal.viewmode = ConfigSelectionExt(default = "grid", choices = [("grid", _("Grid")), ("liste", _("List"))])
if mp_globals.model in ["one", "two", "dm900", "dm920"]:
	config_mp.mediaportal.plugin_viewmode = ConfigYesNo(default = True)
else:
	config_mp.mediaportal.plugin_viewmode = ConfigYesNo(default = False)
config_mp.mediaportal.storagepath = ConfigText(default="/tmp/mediaportal/tmp/", fixed_size=False)
config_mp.mediaportal.iconcachepath = ConfigText(default="/data/mediaportal/", fixed_size=False)
config_mp.mediaportal.autoplayThreshold = ConfigInteger(default = 50, limits = (1, 100))
config_mp.mediaportal.filter = ConfigSelectionExt(default = "ALL", choices = ["ALL", "Mediathek", "User-additions", "Fun", "NewsDoku", "Sport", "Music", "Porn"])
config_mp.mediaportal.youtubeenablevp9 = ConfigYesNo(default = False)
config_mp.mediaportal.youtubeenabledash = ConfigYesNo(default = True)
config_mp.mediaportal.youtubeenabledash720p = ConfigYesNo(default = False)
config_mp.mediaportal.youtubeenabledash480p = ConfigYesNo(default = False)
config_mp.mediaportal.youtubeenablehdr = ConfigYesNo(default = False)
if mp_globals.model in ["one", "two"]:
	config_mp.mediaportal.youtubeenableopus = ConfigYesNo(default = True)
else:
	config_mp.mediaportal.youtubeenableopus = ConfigYesNo(default = False)
config_mp.mediaportal.youtubeprio = ConfigSelectionExt(default = "3", choices = [("0", "360p"), ("1", "480p"), ("2", "720p"), ("3", "1080p"), ("4", "1440p"), ("5", "2160p")])
config_mp.mediaportal.videoquali_others = ConfigSelectionExt(default = "2", choices = [("0", _("Low")), ("1", _("Medium")), ("2", _("High"))])
config_mp.mediaportal.pornpin = ConfigYesNo(default = True)
config_mp.mediaportal.pornpin_cache = ConfigSelectionExt(default = "0", choices = [("0", _("never")), ("5", _("5 minutes")), ("15", _("15 minutes")), ("30", _("30 minutes")), ("60", _("60 minutes"))])
config_mp.mediaportal.setuppin = ConfigYesNo(default = False)
config_mp.mediaportal.watchlistpath = ConfigText(default="/etc/enigma2/", fixed_size=False)
config_mp.mediaportal.sortplugins = ConfigSelectionExt(default = "default", choices = [("default", "Default"), ("hits", "Hits"), ("abc", "ABC"), ("user", "User")])
config_mp.mediaportal.pagestyle = ConfigSelectionExt(default="Graphic", choices = ["Graphic", "Text"])
config_mp.mediaportal.font = ConfigSelectionExt(default = "1", choices = [("1", "Mediaportal 1")])
config_mp.mediaportal.restorelastservice = ConfigSelectionExt(default = "1", choices = [("1", "SimplePlayer"), ("2", "MediaPortal")])
config_mp.mediaportal.backgroundtv = ConfigYesNo(default = False)
config_mp.mediaportal.minitv = ConfigYesNo(default = True)

# Konfiguration erfolgt in SimplePlayer
config_mp.mediaportal.sp_playmode = ConfigSelectionExt(default = "forward", choices = [("forward", _("Forward")), ("backward", _("Backward")), ("random", _("Random")), ("endless", _("Endless"))])
config_mp.mediaportal.sp_on_movie_stop = ConfigSelectionExt(default = "quit", choices = [("ask", _("Ask user")), ("quit", _("Return to previous service"))])
config_mp.mediaportal.sp_on_movie_eof = ConfigSelectionExt(default = "quit", choices = [("ask", _("Ask user")), ("quit", _("Return to previous service")), ("pause", _("Pause movie at end"))])
config_mp.mediaportal.sp_seekbar_sensibility = ConfigSelectionNumber(default = 10, stepwidth = 1, min = 1, max = 50)
config_mp.mediaportal.sp_infobar_cover_off = ConfigYesNo(default = False)
config_mp.mediaportal.sp_use_number_seek = ConfigYesNo(default = True)
config_mp.mediaportal.sp_pl_number = ConfigInteger(default = 1, limits = (1, 99))
config_mp.mediaportal.sp_use_yt_with_proxy = ConfigSelectionExt(default = "no", choices = [("no", _("No")), ("prz", _("with Premiumize")), ("rdb", _("with Real-Debrid")), ("proxy", _("with a HTTP Proxy"))])
config_mp.mediaportal.sp_on_movie_start = ConfigSelectionExt(default = "start", choices = [("start", _("Start from the beginning")), ("ask", _("Ask user")), ("resume", _("Resume from last position"))])
config_mp.mediaportal.sp_save_resumecache = ConfigYesNo(default = False)
config_mp.mediaportal.sp_radio_cover = ConfigSelectionExt(default = "large", choices = [("large", _("large")), ("small", _("small")), ("off", _("off"))])
config_mp.mediaportal.sp_buffersize = ConfigSelectionFloat(default = 0.0, stepwidth = 0.5, min = 0.0, max = 30.0)
if mp_globals.model in ["dm900", "dm920", "one", "two"]:
	config_mp.mediaportal.sp_radio_visualization = ConfigSelectionExt(default = "1", choices = [("0", _("Off")), ("1", _("Mode 1")), ("2", _("Mode 2")), ("3", _("Mode 3"))])
else:
	config_mp.mediaportal.sp_radio_visualization = ConfigSelectionExt(default = "1", choices = [("0", _("Off")), ("1", _("Mode 1")), ("2", _("Mode 2"))])
config_mp.mediaportal.sp_radio_visualization_gl_mode = ConfigSelection(default = "visGLRandom", choices = [("visGLSinus", _("Sinus")), ("visGLWaves", _("Waves")), ("visGLEclipse", _("Eclipse")), ("visGLBalls", _("Balls")), ("visGLDots", _("Dots")), ("visGLRandom", _("Random"))])
config_mp.mediaportal.sp_radio_bgsaver = ConfigSelectionExt(default = "1", choices = [("0", _("Off")), ("1", _("Ken Burns effect")), ("2", _("Just photos"))])
config_mp.mediaportal.sp_radio_bgsaver_keywords = ConfigText(default="music", fixed_size=False)
config_mp.mediaportal.yt_proxy_username = ConfigText(default="user!", fixed_size=False)
config_mp.mediaportal.yt_proxy_password = ConfigPassword(default="pass!", fixed_size=False)
config_mp.mediaportal.yt_proxy_host = ConfigText(default = "example_proxy.com!", fixed_size = False)
config_mp.mediaportal.yt_proxy_port = ConfigInteger(default = 8080, limits = (0, 65535))

# premiumize.me
config_mp.mediaportal.premiumize_use = ConfigYesNo(default = False)
config_mp.mediaportal.premiumize_password = ConfigPassword(default="pass!", fixed_size=False)

# real-debrid.com
config_mp.mediaportal.realdebrid_use = ConfigYesNo(default = False)
config_mp.mediaportal.realdebrid_accesstoken = ConfigText(default="", fixed_size=False)
config_mp.mediaportal.realdebrid_refreshtoken = ConfigText(default="", fixed_size=False)
config_mp.mediaportal.realdebrid_rclient_id = ConfigText(default="", fixed_size=False)
config_mp.mediaportal.realdebrid_rclient_secret = ConfigText(default="", fixed_size=False)

# Premium Hosters
config_mp.mediaportal.premium_color = ConfigSelectionExt(default="0xFFFF00", choices = [("0xFF0000", _("Red")), ("0xFFFF00", _("Yellow")), ("0x00FF00", _("Green")), ("0xFFFFFF", _("White")), ("0x00ccff", _("Light Blue")), ("0x66ff99", _("Light Green"))])

# Userchannels Help
config_mp.mediaportal.show_userchan_help = ConfigYesNo(default = True)

# SimpleList
config_mp.mediaportal.simplelist_gcoversupp = ConfigYesNo(default = True)

# Radio
config_mp.mediaportal.is_radio = ConfigYesNo(default=False)

# Global variable
autoStartTimer = None
_session = None

# eUriResolvers
from enigma import eUriResolver

from .resources.MPYoutubeUriResolver import MPYoutubeUriResolver
MPYoutubeUriResolver.instance = MPYoutubeUriResolver()
eUriResolver.addResolver(MPYoutubeUriResolver.instance)

from .resources.MPEuronewsUriResolver import MPEuronewsUriResolver
MPEuronewsUriResolver.instance = MPEuronewsUriResolver()
eUriResolver.addResolver(MPEuronewsUriResolver.instance)

from .resources.MPLivestreamcomUriResolver import MPLivestreamcomUriResolver
MPLivestreamcomUriResolver.instance = MPLivestreamcomUriResolver()
eUriResolver.addResolver(MPLivestreamcomUriResolver.instance)

from .resources.MPEarthtvcomUriResolver import MPEarthtvcomUriResolver
MPEarthtvcomUriResolver.instance = MPEarthtvcomUriResolver()
eUriResolver.addResolver(MPEarthtvcomUriResolver.instance)


conf = xml.etree.cElementTree.parse(CONFIG)
for x in conf.getroot():
	if x.tag == "set" and x.get("name") == 'additions':
		root =  x
		for x in root:
			if x.tag == "plugin":
				if x.get("type") == "mod":
					modfile = x.get("modfile")
					if fileExists('/etc/enigma2/mp_override/'+modfile.split('.')[1]+'.py'):
						sys.path.append('/etc/enigma2/mp_override')
						exec("from "+modfile.split('.')[1]+" import *")
					else:
						exec("from .additions."+modfile+" import *")
					exec("config_mp.mediaportal."+x.get("confopt")+" = ConfigYesNo(default = "+x.get("default")+")")

xmlpath = resolveFilename(SCOPE_PLUGINS, "Extensions/MediaPortal/additions/")
for file in os.listdir(xmlpath):
	if file.endswith(".xml") and file != "additions.xml":
		useraddition = xmlpath + file

		conf = xml.etree.cElementTree.parse(useraddition)
		for x in conf.getroot():
			if x.tag == "set" and x.get("name") == 'additions_user':
				root =  x
				for x in root:
					if x.tag == "plugin":
						if x.get("type") == "mod":
							try:
								modfile = x.get("modfile")
								if fileExists('/etc/enigma2/mp_override/'+modfile.split('.')[1]+'.py'):
									sys.path.append('/etc/enigma2/mp_override')
									exec("from "+modfile.split('.')[1]+" import *")
								else:
									exec("from .additions."+modfile+" import *")
								exec("config_mp.mediaportal."+x.get("confopt")+" = ConfigYesNo(default = "+x.get("default")+")")
							except Exception as e:
								printl(e, '', "E")

class CheckPathes(object):

	def __init__(self, session):
		self.session = session
		self.cb = None

	def checkPathes(self, cb):
		self.cb = cb
		res, msg = SimplePlaylistIO.checkPath(config_mp.mediaportal.watchlistpath.value, '', True)
		if not res:
			self.session.openWithCallback(self._callback, MessageBoxExt, msg, MessageBoxExt.TYPE_ERROR)

		res, msg = SimplePlaylistIO.checkPath(config_mp.mediaportal.storagepath.value, '', True)
		if not res:
			self.session.openWithCallback(self._callback, MessageBoxExt, msg, MessageBoxExt.TYPE_ERROR)

		if mp_globals.pluginPath in config_mp.mediaportal.iconcachepath.value:
			config_mp.mediaportal.iconcachepath.value = "/data/mediaportal/"
			config_mp.mediaportal.iconcachepath.save()
			configfile_mp.save()
		elif config_mp.mediaportal.iconcachepath.value.startswith('/tmp/'):
			config_mp.mediaportal.iconcachepath.value = "/data/mediaportal/"
			config_mp.mediaportal.iconcachepath.save()
			configfile_mp.save()
		elif config_mp.mediaportal.iconcachepath.value.startswith('/etc/'):
			config_mp.mediaportal.iconcachepath.value = "/data/mediaportal/"
			config_mp.mediaportal.iconcachepath.save()
			configfile_mp.save()
		elif config_mp.mediaportal.iconcachepath.value.startswith('/usr/lib/enigma2/'):
			config_mp.mediaportal.iconcachepath.value = "/data/mediaportal/"
			config_mp.mediaportal.iconcachepath.save()
			configfile_mp.save()
		elif config_mp.mediaportal.iconcachepath.value.startswith('/var/volatile/'):
			config_mp.mediaportal.iconcachepath.value = "/data/mediaportal/"
			config_mp.mediaportal.iconcachepath.save()
			configfile_mp.save()
		elif config_mp.mediaportal.iconcachepath.value.startswith('/var/share/'):
			config_mp.mediaportal.iconcachepath.value = "/data/mediaportal/"
			config_mp.mediaportal.iconcachepath.save()
			configfile_mp.save()
		elif config_mp.mediaportal.iconcachepath.value.startswith('/usr/share/'):
			config_mp.mediaportal.iconcachepath.value = "/data/mediaportal/"
			config_mp.mediaportal.iconcachepath.save()
			configfile_mp.save()

		res, msg = SimplePlaylistIO.checkPath(config_mp.mediaportal.iconcachepath.value + "icons/", '', True)
		if not res:
			self.session.openWithCallback(self._callback, MessageBoxExt, msg, MessageBoxExt.TYPE_ERROR)

		res, msg = SimplePlaylistIO.checkPath(config_mp.mediaportal.iconcachepath.value + "logos/", '', True)
		if not res:
			self.session.openWithCallback(self._callback, MessageBoxExt, msg, MessageBoxExt.TYPE_ERROR)

	def _callback(self, answer):
		if self.cb:
			self.cb()

class PinCheck(object):

	def __init__(self):
		self.pin_entered = False
		self.timer = eTimer()
		self.timer_conn = self.timer.timeout.connect(self.lock)

	def pinEntered(self):
		self.pin_entered = True
		self.timer.start(60000*int(config_mp.mediaportal.pornpin_cache.value), 1)

	def lock(self):
		self.pin_entered = False

pincheck = PinCheck()

class CheckPremiumize(object):

	def __init__(self, session):
		self.session = session

	def premiumize(self):
		if config_mp.mediaportal.premiumize_use.value:
			papikey = config_mp.mediaportal.premiumize_password.value
			url = "https://www.premiumize.me/api/account/info?apikey=%s" % papikey
			twAgentGetPage(url, method='POST', headers={'Content-Type':'application/x-www-form-urlencoded'}).addCallback(self.premiumizeData).addErrback(self.dataError)
		else:
			self.session.open(MessageBoxExt, _("premiumize.me is not activated."), MessageBoxExt.TYPE_ERROR)

	def premiumizeData(self, data):
		json_data = json.loads(data)
		if json_data["status"] == "success":
			customer_id = str(json_data["customer_id"])
			premium_until = str(json_data["premium_until"])
			limit_used = str(float(json_data["limit_used"]) * 100) + "%"
			deadline = datetime.datetime.fromtimestamp(int(premium_until)).strftime('%Y-%m-%d')
			pmsg = "premiumize.me\n\nUser:\t%s\nExpires:\t%s\nFair use balance:\t%s" % (customer_id, deadline, limit_used)
			self.session.open(MessageBoxExt, pmsg, MessageBoxExt.TYPE_INFO)
		elif json_data["status"] == "error":
			self.session.open(MessageBoxExt, "premiumize: %s" % str(json_data["message"]), MessageBoxExt.TYPE_INFO, timeout=3)

	def dataError(self, error):
		printl(error, self, "E")

class MPSetup(Screen, CheckPremiumize, ConfigListScreenExt):

	def __init__(self, session):

		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/MP_Setup.xml" % (self.skin_path, mp_globals.currentskin)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/MP_Setup.xml"

		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		self["hidePig"] = Boolean()
		self["hidePig"].setBoolean(config_mp.mediaportal.minitv.value)

		Screen.__init__(self, session)

		self.configlist = []

		ConfigListScreenExt.__init__(self, self.configlist, on_change=self._onKeyChange, enableWrapAround=True)

		skins = []
		if mp_globals.videomode == 2:
			mp_globals.skinsPath = "/skins_1080"
			for skin in os.listdir("/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/skins_1080/"):
				if os.path.isdir(os.path.join("/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/skins_1080/", skin)):
					skins.append(skin)
			config_mp.mediaportal.skin2.setChoices(skins, "clean_fhd")
		else:
			mp_globals.skinsPath = "/skins_720"
			for skin in os.listdir("/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/skins_720/"):
				if os.path.isdir(os.path.join("/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/skins_720/", skin)):
					skins.append(skin)
			config_mp.mediaportal.skin2.setChoices(skins, "clean_hd")

		self._getConfig()

		if config_mp.mediaportal.adultpincode.value < 1:
			config_mp.mediaportal.adultpincode.value = random.randint(1, 999)

		self['title'] = Label(_("Setup"))
		self['F1'] = Label("Premium")
		self['F2'] = Label("")
		self['F3'] = Label("")
		self['F4'] = Label("")

		self["actions"] = ActionMap(["MP_Actions2", "MP_Actions"], {
			"ok"    : self.keySave,
			"cancel": self.keyCancel,
			"up": self.keyUp,
			"down": self.keyDown,
			"nextBouquet": self.keyPreviousSection,
			"prevBouquet": self.keyNextSection,
			"red" : self.premium
		}, -1)

		self.onFirstExecBegin.append(self.loadDisplayCover)

	def loadDisplayCover(self):
		self.summaries.updateCover('file:///usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/default_cover.png')

	def _spacer(self):
		self.configlist.append(getConfigListEntry("", config_mp.mediaportal.fake_entry, False))

	def _getConfig(self):
		self.configlist = []
		self.sport = []
		self.music = []
		self.fun = []
		self.newsdoku = []
		self.mediatheken = []
		self.porn = []
		self.useradditions = []
		### Allgemein
		self.configlist.append(getConfigListEntry(_("GENERAL"), ))
		self.configlist.append(getConfigListEntry(_("Automatic Update Check:"), config_mp.mediaportal.autoupdate, False))
		self.configlist.append(getConfigListEntry(_("Mainview Style:"), config_mp.mediaportal.viewmode, True))
		if config_mp.mediaportal.viewmode.value == "grid":
			self.configlist.append(getConfigListEntry(_("Page Display Style:"), config_mp.mediaportal.pagestyle, False))
		self.configlist.append(getConfigListEntry(_('Plugin Grid (switchable anytime with key "5"):'), config_mp.mediaportal.plugin_viewmode, False))
		self.configlist.append(getConfigListEntry(_("Skin:"), config_mp.mediaportal.skin2, False))
		self.configlist.append(getConfigListEntry(_("Disable Background-TV:"), config_mp.mediaportal.backgroundtv, True))
		if not config_mp.mediaportal.backgroundtv.value:
			self.configlist.append(getConfigListEntry(_("Restore last service on exit of:"), config_mp.mediaportal.restorelastservice, False))
			self.configlist.append(getConfigListEntry(_("Disable Mini-TV:"), config_mp.mediaportal.minitv, False))
		self.configlist.append(getConfigListEntry(_("Enable search suggestions:"), config_mp.mediaportal.ena_suggestions, False))
		self.configlist.append(getConfigListEntry(_("Label animation")+":", config_mp.mediaportal.animation_label, False))
		self._spacer()
		self.configlist.append(getConfigListEntry(_("YOUTH PROTECTION"), ))
		self.configlist.append(getConfigListEntry(_("Setup PIN:"), config_mp.mediaportal.pincode, False))
		self.configlist.append(getConfigListEntry(_("Setup PIN Query:"), config_mp.mediaportal.setuppin, False))
		self.configlist.append(getConfigListEntry(_("Adult PIN:"), config_mp.mediaportal.adultpincode, False))
		self.configlist.append(getConfigListEntry(_("Adult PIN Query:"), config_mp.mediaportal.pornpin, False))
		self.configlist.append(getConfigListEntry(_("Remember Adult PIN:"), config_mp.mediaportal.pornpin_cache, False))
		self.configlist.append(getConfigListEntry(_("Auto hide adult section on startup:"), config_mp.mediaportal.hideporn_startup, False))
		self._spacer()
		self.configlist.append(getConfigListEntry(_("OTHER"), ))
		self.configlist.append(getConfigListEntry(_("Temporary Cachepath:"), config_mp.mediaportal.storagepath, False))
		self.configlist.append(getConfigListEntry(_("Icon Cachepath:"), config_mp.mediaportal.iconcachepath, False))
		self.configlist.append(getConfigListEntry(_("Videoquality:"), config_mp.mediaportal.videoquali_others, False))
		self.configlist.append(getConfigListEntry(_("Watchlist/Playlist/Userchan path:"), config_mp.mediaportal.watchlistpath, False))
		self._spacer()
		self.configlist.append(getConfigListEntry(_("YOUTUBE"), ))
		self.configlist.append(getConfigListEntry(_("Highest resolution for playback:"), config_mp.mediaportal.youtubeprio, False))
		if config_mp.mediaportal.youtubeenablevp9.value and mp_globals.model in ["one", "two"]:
			self.configlist.append(getConfigListEntry(_("Enable DASH format:"), config_mp.mediaportal.youtubeenabledash, True))
		else:
			self.configlist.append(getConfigListEntry(_("Enable DASH format (no seeking possible):"), config_mp.mediaportal.youtubeenabledash, True))
		if config_mp.mediaportal.youtubeenabledash.value:
			self.configlist.append(getConfigListEntry(_("Use DASH format for 480p:"), config_mp.mediaportal.youtubeenabledash480p, False))
			self.configlist.append(getConfigListEntry(_("Use DASH format for 720p:"), config_mp.mediaportal.youtubeenabledash720p, False))
			self.configlist.append(getConfigListEntry(_("Enable VP9 codec (required for resolutions >1080p):"), config_mp.mediaportal.youtubeenablevp9, True))
			if config_mp.mediaportal.youtubeenablevp9.value and mp_globals.model in ["one", "two"]:
				self.configlist.append(getConfigListEntry(_("Enable VP9 HDR (only for resolutions 720p and higher):"), config_mp.mediaportal.youtubeenablehdr, False))
			if mp_globals.model in ["one", "two", "dm7080", "dm900", "dm920"]:
				self.configlist.append(getConfigListEntry(_("Enable Opus codec:"), config_mp.mediaportal.youtubeenableopus, False))
		self.configlist.append(getConfigListEntry(_("Show USER-Channels Help:"), config_mp.mediaportal.show_userchan_help, False))
		self.configlist.append(getConfigListEntry(_('Use Proxy:'), config_mp.mediaportal.sp_use_yt_with_proxy, True))
		if config_mp.mediaportal.sp_use_yt_with_proxy.value == "proxy":
			self.configlist.append(getConfigListEntry(_("HTTP-Proxy Host or IP:"), config_mp.mediaportal.yt_proxy_host, False))
			self.configlist.append(getConfigListEntry(_("HTTP-Proxy Port:"), config_mp.mediaportal.yt_proxy_port, False))
			self.configlist.append(getConfigListEntry(_("HTTP-Proxy username:"), config_mp.mediaportal.yt_proxy_username, False))
			self.configlist.append(getConfigListEntry(_("HTTP-Proxy password:"), config_mp.mediaportal.yt_proxy_password, False))
		self._spacer()
		self.configlist.append(getConfigListEntry("PREMIUMIZE.ME", ))
		self.configlist.append(getConfigListEntry(_("Activate premiumize.me:"), config_mp.mediaportal.premiumize_use, True))
		if config_mp.mediaportal.premiumize_use.value:
			self.configlist.append(getConfigListEntry(_("API-Key:"), config_mp.mediaportal.premiumize_password, False))
		self._spacer()
		self.configlist.append(getConfigListEntry("REAL-DEBRID.COM", ))
		self.configlist.append(getConfigListEntry(_("Activate Real-Debrid.com:"), config_mp.mediaportal.realdebrid_use, True))
		if config_mp.mediaportal.premiumize_use.value or config_mp.mediaportal.realdebrid_use.value:
			self._spacer()
			self.configlist.append(getConfigListEntry("PREMIUM", ))
			self.configlist.append(getConfigListEntry(_("Streammarkercolor:"), config_mp.mediaportal.premium_color, False))

		conf = xml.etree.cElementTree.parse(CONFIG)
		for x in conf.getroot():
			if x.tag == "set" and x.get("name") == 'additions':
				root =  x
				for x in root:
					if x.tag == "plugin":
						if x.get("type") == "mod":
							modfile = x.get("modfile")
							gz = x.get("gz")
							if not config_mp.mediaportal.showuseradditions.value and gz == "1":
								pass
							else:
								exec("self."+x.get("confcat")+".append(getConfigListEntry(\""+x.get("name").replace("&amp;", "&")+"\", config_mp.mediaportal."+x.get("confopt")+", False))")

		xmlpath = resolveFilename(SCOPE_PLUGINS, "Extensions/MediaPortal/additions/")
		for file in os.listdir(xmlpath):
			if file.endswith(".xml") and file != "additions.xml":
				useraddition = xmlpath + file

				conf = xml.etree.cElementTree.parse(useraddition)
				for x in conf.getroot():
					if x.tag == "set" and x.get("name") == 'additions_user':
						root =  x
						for x in root:
							if x.tag == "plugin":
								if x.get("type") == "mod":
									try:
										modfile = x.get("modfile")
										gz = x.get("gz")
										if not config_mp.mediaportal.showuseradditions.value and gz == "1":
											pass
										else:
											exec("self."+x.get("confcat")+".append(getConfigListEntry(\""+x.get("name").replace("&amp;", "&")+"\", config_mp.mediaportal."+x.get("confopt")+", False))")
									except Exception as e:
										printl(e, self, "E")
		self._spacer()
		self.configlist.append(getConfigListEntry(_("LIBRARIES"), ))
		self.mediatheken.sort(key=lambda t : t[0].lower())
		for x in self.mediatheken:
			self.configlist.append((_("Show ")+x[0]+":", x[1], False))

		self._spacer()
		self.configlist.append(getConfigListEntry(_("NEWS & DOCUMENTARY"), ))
		self.newsdoku.sort(key=lambda t : t[0].lower())
		for x in self.newsdoku:
			self.configlist.append((_("Show ")+x[0]+":", x[1], False))

		self._spacer()
		self.configlist.append(getConfigListEntry(_("TECH & FUN"), ))
		self.fun.sort(key=lambda t : t[0].lower())
		for x in self.fun:
			self.configlist.append((_("Show ")+x[0]+":", x[1], False))

		self._spacer()
		self.configlist.append(getConfigListEntry(_("SPORTS"), ))
		self.sport.sort(key=lambda t : t[0].lower())
		for x in self.sport:
			self.configlist.append((_("Show ")+x[0]+":", x[1], False))

		self._spacer()
		self.configlist.append(getConfigListEntry(_("MUSIC"), ))
		self.music.sort(key=lambda t : t[0].lower())
		for x in self.music:
			self.configlist.append((_("Show ")+x[0]+":", x[1], False))

		if config_mp.mediaportal.showporn.value:
			self._spacer()
			self.configlist.append(getConfigListEntry(_("PORN"), ))
			self.porn.sort(key=lambda t : t[0].lower())
			for x in self.porn:
				self.configlist.append((_("Show ")+x[0]+":", x[1], False))

		test = resolveFilename(SCOPE_PLUGINS, "Extensions/MediaPortal/additions/useradditions/")

		if len(os.listdir(test)) > 2:
			if config_mp.mediaportal.showuseradditions.value:
				self._spacer()
				self.configlist.append(getConfigListEntry(_("USER-ADDITIONS"), ))
				self.useradditions.sort(key=lambda t : t[0].lower())
				for x in self.useradditions:
					self.configlist.append((_("Show ")+x[0]+":", x[1], False))

		self._spacer()
		self.configlist.append(getConfigListEntry("DEBUG", ))
		self.configlist.append(getConfigListEntry("Debug-Mode:", config_mp.mediaportal.debugMode, False))
		if len(os.listdir(test)) > 2:
			self.configlist.append(getConfigListEntry(_("Activate User-additions:"), config_mp.mediaportal.showuseradditions, False))

		self["config"].list = self.configlist
		self["config"].setList(self.configlist)

	def _onKeyChange(self):
		try:
			cur = self["config"].getCurrent()
			if cur and cur[2]:
				self._getConfig()
		except:
			pass

	def keyOK(self):
		if self["config"].current:
			self["config"].current[1].onDeselect(self.session)
		if config_mp.mediaportal.watchlistpath.value[0] != '/':
			config_mp.mediaportal.watchlistpath.value = '/' + config_mp.mediaportal.watchlistpath.value
		if config_mp.mediaportal.watchlistpath.value[-1] != '/':
			config_mp.mediaportal.watchlistpath.value = config_mp.mediaportal.watchlistpath.value + '/'
		if config_mp.mediaportal.storagepath.value[0] != '/':
			config_mp.mediaportal.storagepath.value = '/' + config_mp.mediaportal.storagepath.value
		if config_mp.mediaportal.storagepath.value[-1] != '/':
			config_mp.mediaportal.storagepath.value = config_mp.mediaportal.storagepath.value + '/'
		if config_mp.mediaportal.storagepath.value[-4:] != 'tmp/':
			config_mp.mediaportal.storagepath.value = config_mp.mediaportal.storagepath.value + 'tmp/'
		if config_mp.mediaportal.storagepath.value == '/tmp/':
			config_mp.mediaportal.storagepath.value = '/tmp/mediaportal/tmp/'
		if config_mp.mediaportal.iconcachepath.value[0] != '/':
			config_mp.mediaportal.iconcachepath.value = '/' + config_mp.mediaportal.iconcachepath.value
		if config_mp.mediaportal.iconcachepath.value[-1] != '/':
			config_mp.mediaportal.iconcachepath.value = config_mp.mediaportal.iconcachepath.value + '/'
		if (config_mp.mediaportal.showporn.value == False and config_mp.mediaportal.filter.value == 'Porn'):
			config_mp.mediaportal.filter.value = 'ALL'
		if (config_mp.mediaportal.showuseradditions.value == False and config_mp.mediaportal.filter.value == 'User-additions'):
			config_mp.mediaportal.filter.value = 'ALL'

		CheckPathes(self.session).checkPathes(self.cb_checkPathes)

		if (config_mp.mediaportal.showuseradditions.value and not config_mp.mediaportal.pinuseradditions.value):
			self.a = str(random.randint(1, 9))
			self.b = str(random.randint(0, 9))
			self.c = str(random.randint(0, 9))
			self.d = str(random.randint(0, 9))
			code = "%s %s %s %s" % (self.a, self.b, self.c, self.d)
			message = _("Some of the plugins may not be legally used in your country!\n\nIf you accept this then enter the following code now:\n\n%s" % (code))
			self.session.openWithCallback(self.keyOK2, MessageBoxExt, message, MessageBoxExt.TYPE_YESNO)
		else:
			if not config_mp.mediaportal.showuseradditions.value:
				config_mp.mediaportal.pinuseradditions.value = False
				config_mp.mediaportal.pinuseradditions.save()
			self.keySave()

	def premium(self):
		if config_mp.mediaportal.realdebrid_use.value:
			self.session.open(realdebrid_oauth2, None, calltype='user', is_dialog=True)
		else:
			self.session.open(MessageBoxExt, _("Real-Debrid.com is not activated."), MessageBoxExt.TYPE_ERROR)
		self.premiumize()

	def cb_checkPathes(self):
		pass

	def keyOK2(self, answer):
		if answer is True:
			self.session.openWithCallback(self.validcode, PinInputExt, pinList = [(int(self.a+self.b+self.c+self.d))], triesEntry = config_mp.mediaportal.retries.pincode, title = _("Please enter the correct code"), windowTitle = _("Enter code"))
		else:
			config_mp.mediaportal.showuseradditions.value = False
			config_mp.mediaportal.showuseradditions.save()
			config_mp.mediaportal.pinuseradditions.value = False
			config_mp.mediaportal.pinuseradditions.save()
			self.keySave()

	def validcode(self, code):
		if code:
			config_mp.mediaportal.pinuseradditions.value = True
			config_mp.mediaportal.pinuseradditions.save()
			self.keySave()
		else:
			config_mp.mediaportal.showuseradditions.value = False
			config_mp.mediaportal.showuseradditions.save()
			config_mp.mediaportal.pinuseradditions.value = False
			config_mp.mediaportal.pinuseradditions.save()
			self.keySave()

	def createSummary(self):
		return MPSummary

class MPGrid(Screen, HelpableScreen):

	def __init__(self, session, lastservice):
		self.lastservice = mp_globals.lastservice = lastservice

		self.icon_url = getIconUrl()
		icons_hashes = grabpage(self.icon_url+"icons/hashes")
		if icons_hashes:
			self.icons_data = re.findall('(.*?)\s\*(.*?\.png)', icons_hashes)
		else:
			self.icons_data = None

		logo_hashes = grabpage(self.icon_url+"logos/hashes")
		if logo_hashes:
			self.logo_data = re.findall('(.*?)\s\*(.*?\.png)', logo_hashes)
		else:
			self.logo_data = None

		self.picload = ePicLoad()

		self.ml = MenuList([], enableWrapAround=True, mode=eListbox.layoutGrid, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.real_all = []
		self.all = []
		self.mediatheken = []
		self.fun = []
		self.music = []
		self.sport = []
		self.newsdoku = []
		self.porn = []
		self.useradditions = []

		self.plugin_liste = []
		plugins_file = config_mp.mediaportal.watchlistpath.value+"mp_pluginlist"
		if fileExists(plugins_file):
			read_pluginliste = open(plugins_file, "r")
			for rawData in read_pluginliste.readlines():
				data = re.findall('"(.*?)" "(.*?)" "(.*?)"', rawData, re.S)
				if data:
					(p_name, p_hits, p_sort) = data[0]
					self.plugin_liste.append(data[0])
			read_pluginliste.close()

		sortval = 0
		defaultval = 0
		conf = xml.etree.cElementTree.parse(CONFIG)
		for x in conf.getroot():
			if x.tag == "set" and x.get("name") == 'additions':
				root =  x
				for x in root:
					if x.tag == "plugin":
						if x.get("type") == "mod":
							modfile = x.get("modfile")
							confcat = x.get("confcat")
							name = x.get("name").replace("&amp;", "&")
							self.real_all.append(name)
							defaultval += 1
							if not config_mp.mediaportal.showporn.value and confcat == "porn":
								pass
							else:
								gz = x.get("gz")
								if not config_mp.mediaportal.showuseradditions.value and gz == "1":
									pass
								else:
									mod = eval("config_mp.mediaportal." + x.get("confopt") + ".value")
									if mod:
										name = x.get("name").replace("&amp;", "&")
										countval = 0
										sortval += 1
										for item in self.plugin_liste:
											if item[0] == name:
												countval = int(item[1])
												sortval = int(item[2])
										filter = x.get("filter")
										#check auf mehrere filter
										if re.search('/', filter):
											mfilter_raw = re.split('/', filter)
											for mfilter in mfilter_raw:
												if mfilter == "Mediathek":
													xfilter = "mediatheken"
												elif mfilter == "User-additions":
													xfilter = "useradditions"
												elif mfilter == "Fun":
													xfilter = "fun"
												elif mfilter == "NewsDoku":
													xfilter = "newsdoku"
												elif mfilter == "Sport":
													xfilter = "sport"
												elif mfilter == "Music":
													xfilter = "music"
												elif mfilter == "Porn":
													xfilter = "porn"
												exec("self."+xfilter+".append(self.hauptListEntry(\""+x.get("name").replace("&amp;", "&")+"\", \""+x.get("icon")+"\", \""+x.get("modfile")+"\", \""+str(countval)+"\", \""+str(sortval)+"\", \""+str(defaultval)+"\"))")
										else:
											exec("self."+x.get("confcat")+".append(self.hauptListEntry(\""+x.get("name").replace("&amp;", "&")+"\", \""+x.get("icon")+"\", \""+x.get("modfile")+"\", \""+str(countval)+"\", \""+str(sortval)+"\", \""+str(defaultval)+"\"))")

		xmlpath = resolveFilename(SCOPE_PLUGINS, "Extensions/MediaPortal/additions/")
		for file in os.listdir(xmlpath):
			if file.endswith(".xml") and file != "additions.xml":
				useraddition = xmlpath + file

				conf = xml.etree.cElementTree.parse(useraddition)
				for x in conf.getroot():
					if x.tag == "set" and x.get("name") == 'additions_user':
						root =  x
						for x in root:
							if x.tag == "plugin":
								if x.get("type") == "mod":
									modfile = x.get("modfile")
									confcat = x.get("confcat")
									name = x.get("name").replace("&amp;", "&")
									self.real_all.append(name)
									defaultval += 1
									if not config_mp.mediaportal.showporn.value and confcat == "porn":
										pass
									else:
										gz = x.get("gz")
										if not config_mp.mediaportal.showuseradditions.value and gz == "1":
											pass
										else:
											mod = eval("config_mp.mediaportal." + x.get("confopt") + ".value")
											if mod:
												name = x.get("name").replace("&amp;", "&")
												countval = 0
												sortval += 1
												for item in self.plugin_liste:
													if item[0] == name:
														countval = int(item[1])
														sortval = int(item[2])
												filter = x.get("filter")
												#check auf mehrere filter
												if re.search('/', filter):
													mfilter_raw = re.split('/', filter)
													for mfilter in mfilter_raw:
														if mfilter == "Mediathek":
															xfilter = "mediatheken"
														elif mfilter == "User-additions":
															xfilter = "useradditions"
														elif mfilter == "Fun":
															xfilter = "fun"
														elif mfilter == "NewsDoku":
															xfilter = "newsdoku"
														elif mfilter == "Sport":
															xfilter = "sport"
														elif mfilter == "Music":
															xfilter = "music"
														elif mfilter == "Porn":
															xfilter = "porn"
														exec("self."+xfilter+".append(self.hauptListEntry(\""+x.get("name").replace("&amp;", "&")+"\", \""+x.get("icon")+"\", \""+x.get("modfile")+"\", \""+str(countval)+"\", \""+str(sortval)+"\", \""+str(defaultval)+"\"))")
												else:
													exec("self."+x.get("confcat")+".append(self.hauptListEntry(\""+x.get("name").replace("&amp;", "&")+"\", \""+x.get("icon")+"\", \""+x.get("modfile")+"\", \""+str(countval)+"\", \""+str(sortval)+"\", \""+str(defaultval)+"\"))")

		self.all_tmp = self.mediatheken + self.fun + self.music + self.sport + self.newsdoku + self.porn + self.useradditions
		lst = []
		for i in self.all_tmp:
			if i[0][0] not in lst:
				self.all.append(i)
				lst.append(i[0][0])
		del lst
		del self.all_tmp

		# Porn
		if (config_mp.mediaportal.showporn.value == False and config_mp.mediaportal.filter.value == 'Porn'):
			config_mp.mediaportal.filter.value = 'ALL'

		# User-additions
		if (config_mp.mediaportal.showuseradditions.value == False and config_mp.mediaportal.filter.value == 'User-additions'):
			config_mp.mediaportal.filter.value = 'ALL'

		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/MP_Grid.xml" % (self.skin_path, mp_globals.currentskin)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/MP_Grid.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		# Page Style
		if config_mp.mediaportal.pagestyle.value == "Graphic":
			skincontent = ""
			self.skin = self.skin.replace('</screen>', '')
			start_pagebar = mp_globals.pagebar_posx
			itemsperpage = mp_globals.grid_itemsperpage
			totalPages = int(math.ceil(float(len(self.all))/float(itemsperpage)))
			for x in range(1, totalPages+1):
				skincontent += "<widget name=\"page_empty" + str(x) + "\" position=\"" + str(start_pagebar) + "," + str(mp_globals.pagebar_posy) + "\" size=\"" + str(mp_globals.pagebar_iconwidth) + "," + str(mp_globals.pagebar_iconheight) + "\" zPosition=\"2\" transparent=\"1\" alphatest=\"on\" scale=\"stretch\" />"
				skincontent += "<widget name=\"page_sel" + str(x) + "\" position=\"" + str(start_pagebar) + "," + str(mp_globals.pagebar_posy) + "\" size=\"" + str(mp_globals.pagebar_iconwidth) + "," + str(mp_globals.pagebar_iconheight) + "\" zPosition=\"2\" transparent=\"1\" alphatest=\"on\" scale=\"stretch\" />"
				start_pagebar += mp_globals.pagebar_iconwidth + mp_globals.pagebar_margin
			self.skin += skincontent
			self.skin += "</screen>"

		self["hidePig"] = Boolean()
		self["hidePig"].setBoolean(config_mp.mediaportal.minitv.value)

		Screen.__init__(self, session)

		if config_mp.mediaportal.backgroundtv.value:
			config_mp.mediaportal.minitv.value = True
			config_mp.mediaportal.minitv.save()
			config_mp.mediaportal.restorelastservice.value = "2"
			config_mp.mediaportal.restorelastservice.save()
			configfile_mp.save()
			session.nav.stopService()
			session.nav.playService(lastservice)
			session.nav.stopService()

		self["actions"] = ActionMap(["MP_Actions"], {
			"up"    : self.keyUp,
			"down"  : self.keyDown,
			"left"  : self.keyLeft,
			"right" : self.keyRight,
			"info"  : self.showPorn,
			"0": boundFunction(self.gotFilter, (_('ALL'), "all")),
			"1": boundFunction(self.gotFilter, (_('Libraries'), "mediatheken")),
			"2": boundFunction(self.gotFilter, (_('Tech & Fun'), "fun")),
			"3": boundFunction(self.gotFilter, (_('Music'), "music")),
			"4": boundFunction(self.gotFilter, (_('Sports'), "sport")),
			"5": boundFunction(self.gotFilter, (_('News & Documentary'), "newsdoku")),
			"6": boundFunction(self.gotFilter, (_('Porn'), "porn")),
			"7": boundFunction(self.gotFilter, (_('User-additions'), "useradditions"))
		}, -1)
		self["MP_Actions"] = HelpableActionMap(self, "MP_Actions", {
			"red": (self.keySimpleList, _("Open SimpleList")),
			"green": (self.chSort, _("Change sort order")),
			"yellow": (self.manuelleSortierung, _("Manual sorting")),
			"blue": (self.startChoose, _("Change filter")),
			"ok": (self.keyOK, _("Open selected Plugin")),
			"cancel": (self.keyCancel, _("Exit MediaPortal")),
			"nextBouquet":	(self.page_next, _("Next page")),
			"prevBouquet":	(self.page_back, _("Previous page")),
			"menu": (self.keySetup, _("MediaPortal Setup")),
		}, -1)

		self['name'] = Label("")
		self['version'] = Label(config_mp.mediaportal.version.value[0:8]+"-py3")
		self['F1'] = Label("SimpleList")
		self['F2'] = Label("")
		self['F3'] = Label(_("Sort"))
		self['F4'] = Label("")
		self['Exit'] = Label(_("Exit"))
		self['Help'] = Label(_("Help"))
		self['Menu'] = Label(_("Menu"))
		self['page'] = Label("")

		if config_mp.mediaportal.pagestyle.value == "Graphic":
			itemsperpage = mp_globals.grid_itemsperpage
			totalPages = int(math.ceil(float(len(self.all))/float(itemsperpage)))
			for x in range(1, totalPages+1):
				self["page_empty"+str(x)] = Pixmap()
				self["page_empty"+str(x)].hide()
				self["page_sel"+str(x)] = Pixmap()
				self["page_sel"+str(x)].hide()

		HelpableScreen.__init__(self)
		self.onLayoutFinish.append(self.layoutFinished)
		self.onFirstExecBegin.append(self.checkPathes)
		self.onFirstExecBegin.append(self.status)
		self.onFirstExecBegin.append(self.loadDisplayCover)

	def loadDisplayCover(self):
		self.summaries.updateCover('file:///usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/default_cover.png')

	def checkPathes(self):
		CheckPathes(self.session).checkPathes(self.cb_checkPathes)

	def cb_checkPathes(self):
		self.session.openWithCallback(self.restart, MPSetup)

	def status(self):
		update_agent = getUserAgent()
		update_url = getUpdateUrl()
		twAgentGetPage(update_url, agent=update_agent, timeout=10).addCallback(self.checkstatus)

	def checkstatus(self, html):
		if re.search(".*?<html", html):
			return
		self.html = html
		tmp_infolines = html.splitlines()
		statusurl = tmp_infolines[7]
		update_agent = getUserAgent()
		twAgentGetPage(statusurl, agent=update_agent, timeout=10).addCallback(_status)

	def manuelleSortierung(self):
		self.session.openWithCallback(self.restart, MPSort, self.real_all, self.currentlist)

	def hit_plugin(self, threadName, pname, hit=False):
		printl("Calling thread: %s" % threadName, self, 'A')
		plugins_file = config_mp.mediaportal.watchlistpath.value+"mp_pluginlist"
		if fileExists(plugins_file):
			read_pluginliste = open(plugins_file, "r")
			read_pluginliste_tmp = open(plugins_file+".tmp", "w")
			tmp = []
			for rawData in read_pluginliste.readlines():
				data = re.findall('"(.*?)" "(.*?)" "(.*?)"', rawData, re.S)
				if data:
					(p_name, p_hits, p_sort) = data[0]
					tmp.append(p_name)
					if pname == p_name and hit:
						p_hits = str(int(p_hits)+1)
					read_pluginliste_tmp.write('"%s" "%s" "%s"\n' % (p_name, p_hits, p_sort))
			for item in self.all:
				p_name = item[0][0]
				p_hits = item[0][3]
				p_sort = item[0][4]
				if not p_name in tmp:
					read_pluginliste_tmp.write('"%s" "%s" "%s"\n' % (p_name, p_hits, p_sort))
			read_pluginliste.close()
			read_pluginliste_tmp.close()
			shutil.move(plugins_file+".tmp", plugins_file)

		else:
			read_pluginliste = open(plugins_file, "w")
			for item in self.all:
				p_name = item[0][0]
				p_hits = item[0][3]
				p_sort = item[0][4]
				read_pluginliste.write('"%s" "%s" "%s"\n' % (p_name, p_hits, p_sort))
			read_pluginliste.close()

		filter = config_mp.mediaportal.filter.value
		if filter == "ALL":
			xfilter = "all"
		elif filter == "Mediathek":
			xfilter = "mediatheken"
		elif filter == "User-additions":
			xfilter = "useradditions"
		elif filter == "Fun":
			xfilter = "fun"
		elif filter == "NewsDoku":
			xfilter = "newsdoku"
		elif filter == "Sport":
			xfilter = "sport"
		elif filter == "Music":
			xfilter = "music"
		elif filter == "Porn":
			xfilter = "porn"

		exec("self."+xfilter+" = []")
		for item in self.currentlist:
			(p_name, p_picname, p_mod, p_hits, p_sort, p_default) = item[0]
			if pname == p_name:
				p_hits = str(int(p_hits) + 1)
			reactor.callFromThread(self.hit_plugin_listEntry, xfilter, p_name, p_picname, p_mod, p_hits, p_sort, p_default)
		exec("self.currentlist = self."+xfilter)
		reactor.callFromThread(self.sortRefresh)

	def hit_plugin_listEntry(self, xfilter, p_name, p_picname, p_mod, p_hits, p_sort, p_default):
		exec("self."+xfilter+".append(self.hauptListEntry(\""+p_name+"\", \""+p_picname+"\", \""+p_mod+"\", \""+p_hits+"\", \""+p_sort+"\", \""+p_default+"\"))")

	def layoutFinished(self):
		_hosters()

		if not mp_globals.start:
			self.close(self.session, True, self.lastservice)
		if config_mp.mediaportal.autoupdate.value:
			checkupdate(self.session).checkforupdate()

		self.chSort(change=False)

		if config_mp.mediaportal.filter.value == "ALL":
			name = _("ALL")
		elif config_mp.mediaportal.filter.value == "Mediathek":
			name = _("Libraries")
		elif config_mp.mediaportal.filter.value == "User-additions":
			name = _("User-additions")
		elif config_mp.mediaportal.filter.value == "Fun":
			name = _("Tech & Fun")
		elif config_mp.mediaportal.filter.value == "NewsDoku":
			name = _("News & Documentary")
		elif config_mp.mediaportal.filter.value == "Music":
			name = _("Music")
		elif config_mp.mediaportal.filter.value == "Sport":
			name = _("Sports")
		elif config_mp.mediaportal.filter.value == "Porn":
			name = _("Porn")
		self['F4'].setText(name)

		filter = config_mp.mediaportal.filter.value
		if filter == "ALL":
			xfilter = "all"
		elif filter == "Mediathek":
			xfilter = "mediatheken"
		elif filter == "User-additions":
			xfilter = "useradditions"
		elif filter == "Fun":
			xfilter = "fun"
		elif filter == "NewsDoku":
			xfilter = "newsdoku"
		elif filter == "Sport":
			xfilter = "sport"
		elif filter == "Music":
			xfilter = "music"
		elif filter == "Porn":
			xfilter = "porn"

		exec("self.currentlist = self."+xfilter)
		if len(self.currentlist) == 0:
			self.chFilter()
			config_mp.mediaportal.filter.save()
			configfile_mp.save()
			self.close(self.session, False, self.lastservice)
		else:
			self.ml.setList(self.currentlist)

		if config_mp.mediaportal.pagestyle.value == "Graphic":
			images_path = "%s/%s/images" % (self.skin_path, mp_globals.currentskin)
			if not fileExists(images_path):
				images_path = self.skin_path + mp_globals.skinFallback + "/images"
			itemsperpage = mp_globals.grid_itemsperpage
			totalPages = int(math.ceil(float(len(self.all))/float(itemsperpage)))
			for x in range(1, totalPages+1):
				poster_path = "%s/page_select.svg" % (images_path)
				if not fileExists(poster_path):
					poster_path = "%s/page_select.png" % (images_path)
					if not fileExists(poster_path):
						poster_path = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/page_select.svg"
				self["page_sel"+str(x)].instance.setPixmap(gPixmapPtr())
				self["page_sel"+str(x)].hide()
				pic = LoadPixmap(cached=True, path=poster_path)
				if pic != None:
					self["page_sel"+str(x)].instance.setPixmap(pic)
					if x == 1:
						self["page_sel"+str(x)].show()
			for x in range(1, totalPages+1):
				poster_path = "%s/page.svg" % (images_path)
				if not fileExists(poster_path):
					poster_path = "%s/page.png" % (images_path)
					if not fileExists(poster_path):
						poster_path = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/page.svg"
				self["page_empty"+str(x)].instance.setPixmap(gPixmapPtr())
				self["page_empty"+str(x)].hide()
				pic = LoadPixmap(cached=True, path=poster_path)
				if pic != None:
					self["page_empty"+str(x)].instance.setPixmap(pic)
					if x > 1:
						self["page_empty"+str(x)].show()
		self.setInfo()
		_thread.start_new_thread(self.hit_plugin, ("HitPlugin", '', False))

	def sortRefresh(self):
		if config_mp.mediaportal.sortplugins.value == "hits":
			self.all.sort(key=lambda x: int(x[0][3]), reverse = True)
			self.mediatheken.sort(key=lambda x: int(x[0][3]), reverse = True)
			self.fun.sort(key=lambda x: int(x[0][3]), reverse = True)
			self.music.sort(key=lambda x: int(x[0][3]), reverse = True)
			self.sport.sort(key=lambda x: int(x[0][3]), reverse = True)
			self.newsdoku.sort(key=lambda x: int(x[0][3]), reverse = True)
			self.porn.sort(key=lambda x: int(x[0][3]), reverse = True)
			self.useradditions.sort(key=lambda x: int(x[0][3]), reverse = True)
			self.ml.setList(self.currentlist)

	def chSort(self, change=True):
		if change:
			if config_mp.mediaportal.sortplugins.value == "default":
				config_mp.mediaportal.sortplugins.value = "abc"
			elif config_mp.mediaportal.sortplugins.value == "abc":
				config_mp.mediaportal.sortplugins.value = "user"
			elif config_mp.mediaportal.sortplugins.value == "user":
				config_mp.mediaportal.sortplugins.value = "hits"
			elif config_mp.mediaportal.sortplugins.value == "hits":
				config_mp.mediaportal.sortplugins.value = "default"
			config_mp.mediaportal.sortplugins.save()
			configfile_mp.save()

		if config_mp.mediaportal.sortplugins.value == "hits":
			self.all.sort(key=lambda x: int(x[0][3]), reverse = True)
			self.mediatheken.sort(key=lambda x: int(x[0][3]), reverse = True)
			self.fun.sort(key=lambda x: int(x[0][3]), reverse = True)
			self.music.sort(key=lambda x: int(x[0][3]), reverse = True)
			self.sport.sort(key=lambda x: int(x[0][3]), reverse = True)
			self.newsdoku.sort(key=lambda x: int(x[0][3]), reverse = True)
			self.porn.sort(key=lambda x: int(x[0][3]), reverse = True)
			self.useradditions.sort(key=lambda x: int(x[0][3]), reverse = True)
		elif config_mp.mediaportal.sortplugins.value == "abc":
			self.all.sort(key=lambda x: x[0][0].lower())
			self.mediatheken.sort(key=lambda x: x[0][0].lower())
			self.fun.sort(key=lambda x: x[0][0].lower())
			self.music.sort(key=lambda x: x[0][0].lower())
			self.sport.sort(key=lambda x: x[0][0].lower())
			self.newsdoku.sort(key=lambda x: x[0][0].lower())
			self.porn.sort(key=lambda x: x[0][0].lower())
			self.useradditions = sorted(self.useradditions, key=lambda x: x[0][0].lower())
		elif config_mp.mediaportal.sortplugins.value == "user":
			self.all.sort(key=lambda x: int(x[0][4]))
			self.mediatheken.sort(key=lambda x: int(x[0][4]))
			self.fun.sort(key=lambda x: int(x[0][4]))
			self.music.sort(key=lambda x: int(x[0][4]))
			self.sport.sort(key=lambda x: int(x[0][4]))
			self.newsdoku.sort(key=lambda x: int(x[0][4]))
			self.porn.sort(key=lambda x: int(x[0][4]))
			self.useradditions.sort(key=lambda x: int(x[0][4]))
		elif config_mp.mediaportal.sortplugins.value == "default":
			self.all.sort(key=lambda x: int(x[0][5]))
			self.mediatheken.sort(key=lambda x: int(x[0][5]))
			self.fun.sort(key=lambda x: int(x[0][5]))
			self.music.sort(key=lambda x: int(x[0][5]))
			self.sport.sort(key=lambda x: int(x[0][5]))
			self.newsdoku.sort(key=lambda x: int(x[0][5]))
			self.porn.sort(key=lambda x: int(x[0][5]))
			self.useradditions.sort(key=lambda x: int(x[0][5]))

		sortplugin = config_mp.mediaportal.sortplugins.value
		if sortplugin == "hits":
			sortplugin = "Hits"
		elif sortplugin == "abc":
			sortplugin = "ABC"
		elif sortplugin == "user":
			sortplugin = "User"
		elif sortplugin == "default":
			sortplugin = "Default"
		self['F2'].setText(sortplugin)

		if change:
			self.ml.setList(self.currentlist)
			self.ml.moveToIndex(0)

	def chFilter(self):
		if config_mp.mediaportal.filter.value == "ALL":
			config_mp.mediaportal.filter.value = "Mediathek"
		elif config_mp.mediaportal.filter.value == "Mediathek":
			config_mp.mediaportal.filter.value = "Fun"
		elif config_mp.mediaportal.filter.value == "Fun":
			config_mp.mediaportal.filter.value = "Music"
		elif config_mp.mediaportal.filter.value == "Music":
			config_mp.mediaportal.filter.value = "Sport"
		elif config_mp.mediaportal.filter.value == "Sport":
			config_mp.mediaportal.filter.value = "NewsDoku"
		elif config_mp.mediaportal.filter.value == "NewsDoku":
			config_mp.mediaportal.filter.value = "Porn"
		elif config_mp.mediaportal.filter.value == "Porn":
			config_mp.mediaportal.filter.value = "User-additions"
		elif config_mp.mediaportal.filter.value == "User-additions":
			config_mp.mediaportal.filter.value = "ALL"
		else:
			config_mp.mediaportal.filter.value = "ALL"

	def hauptListEntry(self, name, icon, modfile=None, count=0, sort=0, default=0):
		res = [(name, icon, modfile, count, sort, default)]
		poster_path = "%s/%s.png" % (config_mp.mediaportal.iconcachepath.value + "icons", icon)
		url = self.icon_url+"icons/" + icon + ".png"
		remote_hash = ""
		ds = defer.DeferredSemaphore(tokens=5)
		if not fileExists(poster_path):
			if self.icons_data:
				for x, y in self.icons_data:
					if y == icon+'.png':
						d = ds.run(_downloadPage, url, poster_path)
			poster_path = "%s/images/comingsoon.png" % mp_globals.pluginPath
		else:
			if self.icons_data:
				for x, y in self.icons_data:
					if y == icon+'.png':
						remote_hash = x
						local_hash = hashlib.md5(open(poster_path, 'rb').read()).hexdigest()
						if remote_hash != local_hash:
							d = ds.run(_downloadPage, url, poster_path)
							poster_path = "%s/images/comingsoon.png" % mp_globals.pluginPath

		logo_path = "%s/%s.png" % (config_mp.mediaportal.iconcachepath.value + "logos", icon)
		url = self.icon_url+"logos/" + icon + ".png"
		if not fileExists(logo_path):
			if self.logo_data:
				for x, y in self.logo_data:
					if y == icon+'.png':
						d = ds.run(_downloadPage, url, logo_path)
		else:
			if self.logo_data:
				for x, y in self.logo_data:
					if y == icon+'.png':
						remote_hash = x
						local_hash = hashlib.md5(open(logo_path, 'rb').read()).hexdigest()
						if remote_hash != local_hash:
							d = ds.run(_downloadPage, url, logo_path)
		pngthumb = ""
		for (name, png) in preload_list:
			preload_icon = icon+'.png'
			if name == preload_icon:
				pngthumb = png
				break
		if not pngthumb:
			scale = AVSwitch().getFramebufferScale()
			if mp_globals.videomode == 2:
				self.picload.setPara((225, 120, scale[0], scale[1], False, 1, "#FF000000"))
			else:
				self.picload.setPara((150, 80, scale[0], scale[1], False, 1, "#FF000000"))
			self.picload.startDecode(poster_path, False)
			pngthumb = self.picload.getData()
		if mp_globals.videomode == 2:
			res.append(MultiContentEntryPixmapAlphaBlend(pos=(0, 0), size=(225, 120), png=pngthumb))
		else:
			res.append(MultiContentEntryPixmapAlphaBlend(pos=(0, 0), size=(150, 80), png=pngthumb))
		return res

	def showPorn(self):
		if config_mp.mediaportal.showporn.value:
			config_mp.mediaportal.showporn.value = False
			if config_mp.mediaportal.filter.value == "Porn":
				config_mp.mediaportal.filter.value = "ALL"
			config_mp.mediaportal.showporn.save()
			config_mp.mediaportal.filter.save()
			configfile_mp.save()
			self.restart()
		else:
			self.session.openWithCallback(self.showPornOK, PinInputExt, pinList = [(config_mp.mediaportal.adultpincode.value)], triesEntry = config_mp.mediaportal.retries.adultpin, title = _("Please enter the correct PIN"), windowTitle = _("Enter adult PIN"))

	def showPornOK(self, pincode):
		if pincode:
			pincheck.pinEntered()
			config_mp.mediaportal.filter.value = "Porn"
			config_mp.mediaportal.filter.save()
			config_mp.mediaportal.showporn.value = True
			config_mp.mediaportal.showporn.save()
			configfile_mp.save()
			self.restart()

	def keySetup(self):
		if config_mp.mediaportal.setuppin.value:
			self.session.openWithCallback(self.pinok, PinInputExt, pinList = [(config_mp.mediaportal.pincode.value)], triesEntry = config_mp.mediaportal.retries.pincode, title = _("Please enter the correct PIN"), windowTitle = _("Enter setup PIN"))
		else:
			self.session.openWithCallback(self.restart, MPSetup)

	def keySimpleList(self):
		mp_globals.activeIcon = "simplelist"
		self.session.open(simplelistGenreScreen)

	def pinok(self, pincode):
		if pincode:
			self.session.openWithCallback(self.restart, MPSetup)

	def keyUp(self):
		self['liste'].up()
		self.setInfo()

	def keyDown(self):
		self['liste'].down()
		self.setInfo()

	def keyLeft(self):
		self['liste'].instance.moveSelection(self['liste'].instance.moveLeft)
		self.setInfo()

	def keyRight(self):
		self['liste'].instance.moveSelection(self['liste'].instance.moveRight)
		self.setInfo()

	def page_next(self):
		self['liste'].pageDown()
		self.setInfo()

	def page_back(self):
		self['liste'].pageUp()
		self.setInfo()

	def keyOK(self):
		if not testWebConnection():
			self.session.open(MessageBoxExt, _('No connection to the Internet available.'), MessageBoxExt.TYPE_INFO, timeout=3)
			return

		exist = self['liste'].getCurrent()
		if exist == None:
			return
		auswahl = self['liste'].getCurrent()[0][0]
		icon = self['liste'].getCurrent()[0][1]
		mp_globals.activeIcon = icon

		self.pornscreen = None
		self.par1 = ""
		self.par2 = ""

		conf = xml.etree.cElementTree.parse(CONFIG)
		for x in conf.getroot():
			if x.tag == "set" and x.get("name") == 'additions':
				root =  x
				for x in root:
					if x.tag == "plugin":
						if x.get("type") == "mod":
							confcat = x.get("confcat")
							if auswahl ==  x.get("name").replace("&amp;", "&"):
								status = [item for item in mp_globals.status if item[0] == x.get("modfile")]
								if status:
									if int(config_mp.mediaportal.version.value) < int(status[0][1]):
										self.session.open(MessageBoxExt, str(status[0][2]), MessageBoxExt.TYPE_INFO)
										return
								param = ""
								param1 = x.get("param1")
								param2 = x.get("param2")
								if param1 != "":
									param = ", \"" + param1 + "\""
									self.par1 = param1
								if param2 != "":
									param = param + ", \"" + param2 + "\""
									self.par2 = param2
								if confcat == "porn":
									exec("self.pornscreen = " + x.get("screen") + "")
								else:
									exec("self.session.open(" + x.get("screen") + param + ")")

		xmlpath = resolveFilename(SCOPE_PLUGINS, "Extensions/MediaPortal/additions/")
		for file in os.listdir(xmlpath):
			if file.endswith(".xml") and file != "additions.xml":
				useraddition = xmlpath + file

				conf = xml.etree.cElementTree.parse(useraddition)
				for x in conf.getroot():
					if x.tag == "set" and x.get("name") == 'additions_user':
						root =  x
						for x in root:
							if x.tag == "plugin":
								if x.get("type") == "mod":
									confcat = x.get("confcat")
									if auswahl ==  x.get("name").replace("&amp;", "&"):
										status = [item for item in mp_globals.status if item[0] == x.get("modfile")]
										if status:
											if int(config_mp.mediaportal.version.value) < int(status[0][1]):
												self.session.open(MessageBoxExt, str(status[0][2]), MessageBoxExt.TYPE_INFO)
												return
										param = ""
										param1 = x.get("param1")
										param2 = x.get("param2")
										if param1 != "":
											param = ", \"" + param1 + "\""
											self.par1 = param1
										if param2 != "":
											param = param + ", \"" + param2 + "\""
											self.par2 = param2
										if confcat == "porn":
											exec("self.pornscreen = " + x.get("screen") + "")
										else:
											exec("self.session.open(" + x.get("screen") + param + ")")

		if self.pornscreen:
			if config_mp.mediaportal.pornpin.value:
				if pincheck.pin_entered == False:
					self.session.openWithCallback(self.pincheckok, PinInputExt, pinList = [(config_mp.mediaportal.adultpincode.value)], triesEntry = config_mp.mediaportal.retries.adultpin, title = _("Please enter the correct PIN"), windowTitle = _("Enter adult PIN"))
				else:
					if self.par1 == "":
						self.session.open(self.pornscreen)
					elif self.par2 == "":
						self.session.open(self.pornscreen, self.par1)
					else:
						self.session.open(self.pornscreen, self.par1, self.par2)
			else:
				if self.par1 == "":
					self.session.open(self.pornscreen)
				elif self.par2 == "":
					self.session.open(self.pornscreen, self.par1)
				else:
					self.session.open(self.pornscreen, self.par1, self.par2)

		_thread.start_new_thread(self.hit_plugin, ("HitPlugin", auswahl, True))

	def pincheckok(self, pincode):
		if pincode:
			pincheck.pinEntered()
			if self.par1 == "":
				self.session.open(self.pornscreen)
			elif self.par2 == "":
				self.session.open(self.pornscreen, self.par1)
			else:
				self.session.open(self.pornscreen, self.par1, self.par2)

	def setInfo(self):
			itemsperpage = mp_globals.grid_itemsperpage
			maxtotalPages = int(math.ceil(float(len(self.all))/float(itemsperpage)))
			curtotalPages = int(math.ceil(float(len(self.currentlist))/float(itemsperpage)))
			currentindex = self['liste'].instance.getCurrentIndex()
			currentPage = int(currentindex) / int(itemsperpage) + 1
			item = self["liste"].getCurrent()
			(p_name, p_picname, p_mod, p_hits, p_sort, p_default) = item[0]
			try:
				self['name'].instance.setShowHideAnimation(config_mp.mediaportal.animation_label.value)
			except:
				pass
			self['name'].setText(p_name)
			if config_mp.mediaportal.pagestyle.value == "Graphic":
				for x in range(1, maxtotalPages+1):
					self["page_empty"+str(x)].hide()
					self["page_sel"+str(x)].hide()
				for x in range(1, curtotalPages+1):
					from enigma import eSize, ePoint
					desktopSize = getDesktop(0).size()
					val = int(math.ceil((float(desktopSize.width()) - float(mp_globals.pagebar_posx)*2.0)/float(curtotalPages)))
					cor = int(math.ceil(float(mp_globals.pagebar_margin)/2.0))
					if curtotalPages > 1:
						if x == currentPage:
							if mp_globals.pagebar_scaletowidth == 1:
								self["page_sel"+str(x)].instance.resize(eSize(val-mp_globals.pagebar_margin,mp_globals.pagebar_iconheight))
								self["page_sel"+str(x)].instance.move(ePoint(cor+mp_globals.pagebar_posx+(x-1)*val, mp_globals.pagebar_posy))
							self["page_sel"+str(x)].show()
						else:
							if mp_globals.pagebar_scaletowidth == 1:
								self["page_empty"+str(x)].instance.resize(eSize(val-mp_globals.pagebar_margin,mp_globals.pagebar_iconheight))
								self["page_empty"+str(x)].instance.move(ePoint(cor+mp_globals.pagebar_posx+(x-1)*val, mp_globals.pagebar_posy))
							self["page_empty"+str(x)].show()
			else:
				pageinfo = _("Page:") + " %s / %s" % (currentPage, curtotalPages)
				self['page'].setText(pageinfo)

	def keyCancel(self):
		config_mp.mediaportal.filter.save()
		config_mp.mediaportal.sortplugins.save()
		configfile_mp.save()
		self.close(self.session, True, self.lastservice)

	def restart(self):
		config_mp.mediaportal.filter.save()
		config_mp.mediaportal.sortplugins.save()
		configfile_mp.save()
		if autoStartTimer is not None:
			autoStartTimer.update()
		self.close(self.session, False, self.lastservice)

	def startChoose(self):
		if not config_mp.mediaportal.showporn.value:
			xporn = ""
		else:
			xporn = _('Porn')
		if not config_mp.mediaportal.showuseradditions.value:
			useradd = ""
		else:
			useradd = _('User-additions')
		rangelist = [[_('ALL'), 'all'], [_('Libraries'), 'mediatheken'], [_('Tech & Fun'), 'fun'], [_('Music'), 'music'], [_('Sports'), 'sport'], [_('News & Documentary'), 'newsdoku'], [xporn, 'porn'], [useradd, 'useradditions']]
		self.session.openWithCallback(self.gotFilter, ChoiceBoxExt, keys=["0", "1", "2", "3", "4", "5", "6", "7"], title=_('Select Filter'), list = rangelist)

	def gotFilter(self, filter):
		if filter:
			if not config_mp.mediaportal.showporn.value and filter[1] == "porn":
				return
			if not config_mp.mediaportal.showuseradditions.value and filter[1] == "useradditions":
				return
			if filter[0] == "":
				return
			elif filter:
				if filter[1] == "all":
					xfilter = "ALL"
				elif filter[1] == "mediatheken":
					xfilter = "Mediathek"
				elif filter[1] == "useradditions":
					xfilter = "User-additions"
				elif filter[1] == "fun":
					xfilter = "Fun"
				elif filter[1] == "newsdoku":
					xfilter = "NewsDoku"
				elif filter[1] == "sport":
					xfilter = "Sport"
				elif filter[1] == "music":
					xfilter = "Music"
				elif filter[1] == "porn":
					xfilter = "Porn"
				config_mp.mediaportal.filter.value = xfilter
				exec("self.currentlist = self."+filter[1])
				if len(self.currentlist) == 0:
					self.chFilter()
					config_mp.mediaportal.filter.save()
					configfile_mp.save()
					self.close(self.session, False, self.lastservice)
				else:
					exec("self.ml.setList(self."+filter[1]+")")
					self['F4'].setText(filter[0])
					self.ml.moveToIndex(0)
					self.setInfo()

	def createSummary(self):
		return MPSummary

class MPList(Screen, HelpableScreen):

	def __init__(self, session, lastservice):
		self.lastservice = mp_globals.lastservice = lastservice

		self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/MP_List.xml" % (self.skin_path, mp_globals.currentskin)
		if not fileExists(path):
			path = self.skin_path + mp_globals.skinFallback + "/MP_List.xml"
		with open(path, "r") as f:
			self.skin = f.read()
			f.close()

		self["hidePig"] = Boolean()
		self["hidePig"].setBoolean(config_mp.mediaportal.minitv.value)

		Screen.__init__(self, session)

		if config_mp.mediaportal.backgroundtv.value:
			config_mp.mediaportal.minitv.value = True
			config_mp.mediaportal.minitv.save()
			config_mp.mediaportal.restorelastservice.value = "2"
			config_mp.mediaportal.restorelastservice.save()
			configfile_mp.save()
			session.nav.stopService()
			session.nav.playService(lastservice)
			session.nav.stopService()

		self["actions"] = ActionMap(["MP_Actions"], {
			"up"    : self.keyUp,
			"down"  : self.keyDown,
			"left"  : self.keyLeft,
			"right" : self.keyRight,
			"info"  : self.showPorn,
			"0": boundFunction(self.gotFilter, (_('ALL'), "all")),
			"1": boundFunction(self.gotFilter, (_('Libraries'), "mediatheken")),
			"2": boundFunction(self.gotFilter, (_('Tech & Fun'), "fun")),
			"3": boundFunction(self.gotFilter, (_('Music'), "music")),
			"4": boundFunction(self.gotFilter, (_('Sports'), "sport")),
			"5": boundFunction(self.gotFilter, (_('News & Documentary'), "newsdoku")),
			"6": boundFunction(self.gotFilter, (_('Porn'), "porn")),
			"7": boundFunction(self.gotFilter, (_('User-additions'), "useradditions"))
		}, -1)
		self["MP_Actions"] = HelpableActionMap(self, "MP_Actions", {
			"blue": (self.startChoose, _("Change filter")),
			"red": (self.keySimpleList, _("Open SimpleList")),
			"ok": (self.keyOK, _("Open selected Plugin")),
			"cancel": (self.keyCancel, _("Exit MediaPortal")),
			"menu": (self.keySetup, _("MediaPortal Setup")),
		}, -1)

		self['title'] = Label("MediaPortal")
		self['version'] = Label(config_mp.mediaportal.version.value[0:8]+"-py3")

		self['name'] = Label("")

		self['F1'] = Label("SimpleList")
		self['F2'] = Label("")
		self['F3'] = Label("")
		self['F4'] = Label("")
		self['Exit'] = Label(_("Exit"))
		self['Help'] = Label(_("Help"))
		self['Menu'] = Label(_("Menu"))

		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.fontsize + 2 * mp_globals.sizefactor))
		if mp_globals.videomode == 2:
			self.ml.l.setItemHeight(96)
		else:
			self.ml.l.setItemHeight(62)
		self['liste'] = self.ml

		self.picload = ePicLoad()

		HelpableScreen.__init__(self)
		self.onLayoutFinish.append(self.layoutFinished)
		self.onFirstExecBegin.append(self.checkPathes)
		self.onFirstExecBegin.append(self.status)
		self.onFirstExecBegin.append(self.loadDisplayCover)

	def loadDisplayCover(self):
		self.summaries.updateCover('file:///usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/default_cover.png')

	def layoutFinished(self):
		_hosters()

		self.icon_url = getIconUrl()
		icons_hashes = grabpage(self.icon_url+"icons/hashes")
		if icons_hashes:
			self.icons_data = re.findall('(.*?)\s\*(.*?\.png)', icons_hashes)
		else:
			self.icons_data = None

		logo_hashes = grabpage(self.icon_url+"logos/hashes")
		if logo_hashes:
			self.logo_data = re.findall('(.*?)\s\*(.*?\.png)', logo_hashes)
		else:
			self.logo_data = None

		if not mp_globals.start:
			self.close(self.session, True, self.lastservice)
		if config_mp.mediaportal.autoupdate.value:
			checkupdate(self.session).checkforupdate()

		self.all = []
		self.mediatheken = []
		self.fun = []
		self.music = []
		self.sport = []
		self.newsdoku = []
		self.porn = []
		self.useradditions = []

		conf = xml.etree.cElementTree.parse(CONFIG)
		for x in conf.getroot():
			if x.tag == "set" and x.get("name") == 'additions':
				root =  x
				for x in root:
					if x.tag == "plugin":
						if x.get("type") == "mod":
							modfile = x.get("modfile")
							confcat = x.get("confcat")
							if not config_mp.mediaportal.showporn.value and confcat == "porn":
								pass
							else:
								gz = x.get("gz")
								if not config_mp.mediaportal.showuseradditions.value and gz == "1":
									pass
								else:
									mod = eval("config_mp.mediaportal." + x.get("confopt") + ".value")
									if mod:
										filter = x.get("filter")
										#check auf mehrere filter
										if re.search('/', filter):
											mfilter_raw = re.split('/', filter)
											for mfilter in mfilter_raw:
												if mfilter == "Mediathek":
													xfilter = "mediatheken"
												elif mfilter == "User-additions":
													xfilter = "useradditions"
												elif mfilter == "Fun":
													xfilter = "fun"
												elif mfilter == "NewsDoku":
													xfilter = "newsdoku"
												elif mfilter == "Sport":
													xfilter = "sport"
												elif mfilter == "Music":
													xfilter = "music"
												elif mfilter == "Porn":
													xfilter = "porn"
												exec("self."+xfilter+".append(self.hauptListEntry(\""+x.get("name").replace("&amp;", "&")+"\", \""+x.get("icon")+"\", \""+x.get("modfile")+"\"))")
										else:
											exec("self."+x.get("confcat")+".append(self.hauptListEntry(\""+x.get("name").replace("&amp;", "&")+"\", \""+x.get("icon")+"\", \""+x.get("modfile")+"\"))")

		xmlpath = resolveFilename(SCOPE_PLUGINS, "Extensions/MediaPortal/additions/")
		for file in os.listdir(xmlpath):
			if file.endswith(".xml") and file != "additions.xml":
				useraddition = xmlpath + file

				conf = xml.etree.cElementTree.parse(useraddition)
				for x in conf.getroot():
					if x.tag == "set" and x.get("name") == 'additions_user':
						root =  x
						for x in root:
							if x.tag == "plugin":
								if x.get("type") == "mod":
									modfile = x.get("modfile")
									confcat = x.get("confcat")
									if not config_mp.mediaportal.showporn.value and confcat == "porn":
										pass
									else:
										gz = x.get("gz")
										if not config_mp.mediaportal.showuseradditions.value and gz == "1":
											pass
										else:
											mod = eval("config_mp.mediaportal." + x.get("confopt") + ".value")
											if mod:
												filter = x.get("filter")
												#check auf mehrere filter
												if re.search('/', filter):
													mfilter_raw = re.split('/', filter)
													for mfilter in mfilter_raw:
														if mfilter == "Mediathek":
															xfilter = "mediatheken"
														elif mfilter == "User-additions":
															xfilter = "useradditions"
														elif mfilter == "Fun":
															xfilter = "fun"
														elif mfilter == "NewsDoku":
															xfilter = "newsdoku"
														elif mfilter == "Sport":
															xfilter = "sport"
														elif mfilter == "Music":
															xfilter = "music"
														elif mfilter == "Porn":
															xfilter = "porn"
														exec("self."+xfilter+".append(self.hauptListEntry(\""+x.get("name").replace("&amp;", "&")+"\", \""+x.get("icon")+"\", \""+x.get("modfile")+"\"))")
												else:
													exec("self."+x.get("confcat")+".append(self.hauptListEntry(\""+x.get("name").replace("&amp;", "&")+"\", \""+x.get("icon")+"\", \""+x.get("modfile")+"\"))")

		self.all_tmp = self.mediatheken + self.fun + self.music + self.sport + self.newsdoku + self.porn + self.useradditions
		lst = []
		for i in self.all_tmp:
			if i[0][0] not in lst:
				self.all.append(i)
				lst.append(i[0][0])
		del lst
		del self.all_tmp
		self.all.sort(key=lambda t : t[0][0].lower())
		self.mediatheken.sort(key=lambda t : t[0][0].lower())
		self.fun.sort(key=lambda t : t[0][0].lower())
		self.music.sort(key=lambda t : t[0][0].lower())
		self.sport.sort(key=lambda t : t[0][0].lower())
		self.newsdoku.sort(key=lambda t : t[0][0].lower())
		self.porn.sort(key=lambda t : t[0][0].lower())
		self.useradditions.sort(key=lambda t : t[0][0].lower())

		if config_mp.mediaportal.filter.value == "ALL":
			name = _("ALL")
		elif config_mp.mediaportal.filter.value == "Mediathek":
			name = _("Libraries")
		elif config_mp.mediaportal.filter.value == "User-additions":
			name = _("User-additions")
		elif config_mp.mediaportal.filter.value == "Fun":
			name = _("Tech & Fun")
		elif config_mp.mediaportal.filter.value == "NewsDoku":
			name = _("News & Documentary")
		elif config_mp.mediaportal.filter.value == "Music":
			name = _("Music")
		elif config_mp.mediaportal.filter.value == "Sport":
			name = _("Sports")
		elif config_mp.mediaportal.filter.value == "Porn":
			name = _("Porn")
		self['F4'].setText(name)

		filter = config_mp.mediaportal.filter.value
		if filter == "ALL":
			xfilter = "all"
		elif filter == "Mediathek":
			xfilter = "mediatheken"
		elif filter == "User-additions":
			xfilter = "useradditions"
		elif filter == "Fun":
			xfilter = "fun"
		elif filter == "NewsDoku":
			xfilter = "newsdoku"
		elif filter == "Sport":
			xfilter = "sport"
		elif filter == "Music":
			xfilter = "music"
		elif filter == "Porn":
			xfilter = "porn"

		try:
			self['name'].instance.setShowHideAnimation(config_mp.mediaportal.animation_label.value)
		except:
			pass

		exec("self.currentlist = self."+xfilter)
		if len(self.currentlist) == 0:
			self.chFilter()
			config_mp.mediaportal.filter.save()
			configfile_mp.save()
			self.close(self.session, False, self.lastservice)
		else:
			exec("self.ml.setList(self."+xfilter+")")
			auswahl = self['liste'].getCurrent()[0][0]
			self['name'].setText(auswahl)

	def chFilter(self):
		if config_mp.mediaportal.filter.value == "ALL":
			config_mp.mediaportal.filter.value = "Mediathek"
		elif config_mp.mediaportal.filter.value == "Mediathek":
			config_mp.mediaportal.filter.value = "Fun"
		elif config_mp.mediaportal.filter.value == "Fun":
			config_mp.mediaportal.filter.value = "Music"
		elif config_mp.mediaportal.filter.value == "Music":
			config_mp.mediaportal.filter.value = "Sport"
		elif config_mp.mediaportal.filter.value == "Sport":
			config_mp.mediaportal.filter.value = "NewsDoku"
		elif config_mp.mediaportal.filter.value == "NewsDoku":
			config_mp.mediaportal.filter.value = "Porn"
		elif config_mp.mediaportal.filter.value == "Porn":
			config_mp.mediaportal.filter.value = "User-additions"
		elif config_mp.mediaportal.filter.value == "User-additions":
			config_mp.mediaportal.filter.value = "ALL"
		else:
			config_mp.mediaportal.filter.value = "ALL"

	def checkPathes(self):
		CheckPathes(self.session).checkPathes(self.cb_checkPathes)

	def cb_checkPathes(self):
		self.session.openWithCallback(self.restart, MPSetup)

	def status(self):
		update_agent = getUserAgent()
		update_url = getUpdateUrl()
		twAgentGetPage(update_url, agent=update_agent, timeout=10).addCallback(self.checkstatus)

	def checkstatus(self, html):
		if re.search(".*?<html", html):
			return
		self.html = html
		tmp_infolines = html.splitlines()
		statusurl = tmp_infolines[7]
		update_agent = getUserAgent()
		twAgentGetPage(statusurl, agent=update_agent, timeout=10).addCallback(_status)

	def hauptListEntry(self, name, icon, modfile=None):
		res = [(name, icon, modfile)]
		poster_path = "%s/%s.png" % (config_mp.mediaportal.iconcachepath.value + "icons", icon)
		url = self.icon_url+"icons/" + icon + ".png"
		remote_hash = ""
		ds = defer.DeferredSemaphore(tokens=5)
		if not fileExists(poster_path):
			if self.icons_data:
				for x, y in self.icons_data:
					if y == icon+'.png':
						d = ds.run(_downloadPage, url, poster_path)
			poster_path = "%s/images/comingsoon.png" % mp_globals.pluginPath
		else:
			if self.icons_data:
				for x, y in self.icons_data:
					if y == icon+'.png':
						remote_hash = x
						local_hash = hashlib.md5(open(poster_path, 'rb').read()).hexdigest()
						if remote_hash != local_hash:
							d = ds.run(_downloadPage, url, poster_path)
							poster_path = "%s/images/comingsoon.png" % mp_globals.pluginPath

		logo_path = "%s/%s.png" % (config_mp.mediaportal.iconcachepath.value + "logos", icon)
		url = self.icon_url+"logos/" + icon + ".png"
		if not fileExists(logo_path):
			if self.logo_data:
				for x, y in self.logo_data:
					if y == icon+'.png':
						d = ds.run(_downloadPage, url, logo_path)
		else:
			if self.logo_data:
				for x, y in self.logo_data:
					if y == icon+'.png':
						remote_hash = x
						local_hash = hashlib.md5(open(logo_path, 'rb').read()).hexdigest()
						if remote_hash != local_hash:
							d = ds.run(_downloadPage, url, logo_path)
		scale = AVSwitch().getFramebufferScale()
		if mp_globals.videomode == 2:
			self.picload.setPara((169, 90, scale[0], scale[1], False, 1, "#FF000000"))
		else:
			self.picload.setPara((109, 58, scale[0], scale[1], False, 1, "#FF000000"))
		self.picload.startDecode(poster_path, False)
		pngthumb = self.picload.getData()
		if mp_globals.videomode == 2:
			res.append(MultiContentEntryPixmapAlphaBlend(pos=(0, 3), size=(169, 90), png=pngthumb))
			res.append(MultiContentEntryText(pos=(180, 0), size=(960, 96), font=0, text=name, flags=RT_HALIGN_LEFT | RT_VALIGN_CENTER))
		else:
			res.append(MultiContentEntryPixmapAlphaBlend(pos=(0, 2), size=(109, 58), png=pngthumb))
			res.append(MultiContentEntryText(pos=(117, 0), size=(640, 62), font=0, text=name, flags=RT_HALIGN_LEFT | RT_VALIGN_CENTER))
		return res

	def showPorn(self):
		if config_mp.mediaportal.showporn.value:
			config_mp.mediaportal.showporn.value = False
			if config_mp.mediaportal.filter.value == "Porn":
				config_mp.mediaportal.filter.value = "ALL"
			config_mp.mediaportal.showporn.save()
			config_mp.mediaportal.filter.save()
			configfile_mp.save()
			self.restart()
		else:
			self.session.openWithCallback(self.showPornOK, PinInputExt, pinList = [(config_mp.mediaportal.adultpincode.value)], triesEntry = config_mp.mediaportal.retries.adultpin, title = _("Please enter the correct PIN"), windowTitle = _("Enter adult PIN"))

	def showPornOK(self, pincode):
		if pincode:
			pincheck.pinEntered()
			config_mp.mediaportal.filter.value = "Porn"
			config_mp.mediaportal.filter.save()
			config_mp.mediaportal.showporn.value = True
			config_mp.mediaportal.showporn.save()
			configfile_mp.save()
			self.restart()

	def keySetup(self):
		if config_mp.mediaportal.setuppin.value:
			self.session.openWithCallback(self.pinok, PinInputExt, pinList = [(config_mp.mediaportal.pincode.value)], triesEntry = config_mp.mediaportal.retries.pincode, title = _("Please enter the correct PIN"), windowTitle = _("Enter setup PIN"))
		else:
			self.session.openWithCallback(self.restart, MPSetup)

	def keySimpleList(self):
		mp_globals.activeIcon = "simplelist"
		self.session.open(simplelistGenreScreen)

	def pinok(self, pincode):
		if pincode:
			self.session.openWithCallback(self.restart, MPSetup)

	def keyUp(self):
		exist = self['liste'].getCurrent()
		if exist == None:
			return
		self['liste'].up()
		auswahl = self['liste'].getCurrent()[0][0]
		self['name'].setText(auswahl)

	def keyDown(self):
		exist = self['liste'].getCurrent()
		if exist == None:
			return
		self['liste'].down()
		auswahl = self['liste'].getCurrent()[0][0]
		self['name'].setText(auswahl)

	def keyLeft(self):
		self['liste'].pageUp()
		auswahl = self['liste'].getCurrent()[0][0]
		self['name'].setText(auswahl)

	def keyRight(self):
		self['liste'].pageDown()
		auswahl = self['liste'].getCurrent()[0][0]
		self['name'].setText(auswahl)

	def keyOK(self):
		if not testWebConnection():
			self.session.open(MessageBoxExt, _('No connection to the Internet available.'), MessageBoxExt.TYPE_INFO, timeout=3)
			return

		exist = self['liste'].getCurrent()
		if exist == None:
			return
		auswahl = self['liste'].getCurrent()[0][0]
		icon = self['liste'].getCurrent()[0][1]
		mp_globals.activeIcon = icon

		self.pornscreen = None
		self.par1 = ""
		self.par2 = ""

		conf = xml.etree.cElementTree.parse(CONFIG)
		for x in conf.getroot():
			if x.tag == "set" and x.get("name") == 'additions':
				root =  x
				for x in root:
					if x.tag == "plugin":
						if x.get("type") == "mod":
							confcat = x.get("confcat")
							if auswahl ==  x.get("name").replace("&amp;", "&"):
								status = [item for item in mp_globals.status if item[0] == x.get("modfile")]
								if status:
									if int(config_mp.mediaportal.version.value) < int(status[0][1]):
										self.session.open(MessageBoxExt, str(status[0][2]), MessageBoxExt.TYPE_INFO)
										return
								param = ""
								param1 = x.get("param1")
								param2 = x.get("param2")
								if param1 != "":
									param = ", \"" + param1 + "\""
									self.par1 = param1
								if param2 != "":
									param = param + ", \"" + param2 + "\""
									self.par2 = param2
								if confcat == "porn":
									exec("self.pornscreen = " + x.get("screen") + "")
								else:
									exec("self.session.open(" + x.get("screen") + param + ")")

		xmlpath = resolveFilename(SCOPE_PLUGINS, "Extensions/MediaPortal/additions/")
		for file in os.listdir(xmlpath):
			if file.endswith(".xml") and file != "additions.xml":
				useraddition = xmlpath + file

				conf = xml.etree.cElementTree.parse(useraddition)
				for x in conf.getroot():
					if x.tag == "set" and x.get("name") == 'additions_user':
						root =  x
						for x in root:
							if x.tag == "plugin":
								if x.get("type") == "mod":
									confcat = x.get("confcat")
									if auswahl ==  x.get("name").replace("&amp;", "&"):
										status = [item for item in mp_globals.status if item[0] == x.get("modfile")]
										if status:
											if int(config_mp.mediaportal.version.value) < int(status[0][1]):
												self.session.open(MessageBoxExt, str(status[0][2]), MessageBoxExt.TYPE_INFO)
												return
										param = ""
										param1 = x.get("param1")
										param2 = x.get("param2")
										if param1 != "":
											param = ", \"" + param1 + "\""
											self.par1 = param1
										if param2 != "":
											param = param + ", \"" + param2 + "\""
											self.par2 = param2
										if confcat == "porn":
											exec("self.pornscreen = " + x.get("screen") + "")
										else:
											exec("self.session.open(" + x.get("screen") + param + ")")

		if self.pornscreen:
			if config_mp.mediaportal.pornpin.value:
				if pincheck.pin_entered == False:
					self.session.openWithCallback(self.pincheckok, PinInputExt, pinList = [(config_mp.mediaportal.adultpincode.value)], triesEntry = config_mp.mediaportal.retries.adultpin, title = _("Please enter the correct PIN"), windowTitle = _("Enter adult PIN"))
				else:
					if self.par1 == "":
						self.session.open(self.pornscreen)
					elif self.par2 == "":
						self.session.open(self.pornscreen, self.par1)
					else:
						self.session.open(self.pornscreen, self.par1, self.par2)
			else:
				if self.par1 == "":
					self.session.open(self.pornscreen)
				elif self.par2 == "":
					self.session.open(self.pornscreen, self.par1)
				else:
					self.session.open(self.pornscreen, self.par1, self.par2)

	def pincheckok(self, pincode):
		if pincode:
			pincheck.pinEntered()
			if self.par1 == "":
				self.session.open(self.pornscreen)
			elif self.par2 == "":
				self.session.open(self.pornscreen, self.par1)
			else:
				self.session.open(self.pornscreen, self.par1, self.par2)

	def keyCancel(self):
		config_mp.mediaportal.filter.save()
		configfile_mp.save()
		self.close(self.session, True, self.lastservice)

	def restart(self):
		config_mp.mediaportal.filter.save()
		configfile_mp.save()
		if autoStartTimer is not None:
			autoStartTimer.update()
		self.close(self.session, False, self.lastservice)

	def startChoose(self):
		if not config_mp.mediaportal.showporn.value:
			xporn = ""
		else:
			xporn = _('Porn')
		if not config_mp.mediaportal.showuseradditions.value:
			useradd = ""
		else:
			useradd = _('User-additions')
		rangelist = [[_('ALL'), 'all'], [_('Libraries'), 'mediatheken'], [_('Tech & Fun'), 'fun'], [_('Music'), 'music'], [_('Sports'), 'sport'], [_('News & Documentary'), 'newsdoku'], [xporn, 'porn'], [useradd, 'useradditions']]
		self.session.openWithCallback(self.gotFilter, ChoiceBoxExt, keys=["0", "1", "2", "3", "4", "5", "6", "7"], title=_('Select Filter'), list = rangelist)

	def gotFilter(self, filter):
		if filter:
			if not config_mp.mediaportal.showporn.value and filter[1] == "porn":
				return
			if not config_mp.mediaportal.showuseradditions.value and filter[1] == "useradditions":
				return
			if filter[0] == "":
				return
			elif filter:
				if filter[1] == "all":
					xfilter = "ALL"
				elif filter[1] == "mediatheken":
					xfilter = "Mediathek"
				elif filter[1] == "useradditions":
					xfilter = "User-additions"
				elif filter[1] == "fun":
					xfilter = "Fun"
				elif filter[1] == "newsdoku":
					xfilter = "NewsDoku"
				elif filter[1] == "sport":
					xfilter = "Sport"
				elif filter[1] == "music":
					xfilter = "Music"
				elif filter[1] == "porn":
					xfilter = "Porn"
				config_mp.mediaportal.filter.value = xfilter
				exec("self.currentlist = self."+filter[1])
				if len(self.currentlist) == 0:
					self.chFilter()
					config_mp.mediaportal.filter.save()
					configfile_mp.save()
					self.close(self.session, False, self.lastservice)
				else:
					exec("self.ml.setList(self."+filter[1]+")")
					self['F4'].setText(filter[0])
					self.ml.moveToIndex(0)
					auswahl = self['liste'].getCurrent()[0][0]
					self['name'].setText(auswahl)

	def createSummary(self):
		return MPSummary

class MPSort(MPScreen):

	def __init__(self, session, real_all, currentlist):
		self.real_all = real_all
		self.currentlist = currentlist

		MPScreen.__init__(self, session, skin='MP_Sort')

		self["hidePig"] = Boolean()
		self["hidePig"].setBoolean(config_mp.mediaportal.minitv.value)

		self['title'] = Label(_("Userdefined Plugin sorting"))
		self.list = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self["liste"] = self.ml
		self.selected = False

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok":	self.select,
			"cancel": self.keyCancel
		}, -1)

		self.plugins_file = config_mp.mediaportal.watchlistpath.value+"mp_pluginlist"
		if fileExists(self.plugins_file):
			self.onLayoutFinish.append(self.readconfig)
		else:
			self.onLayoutFinish.append(self.keyCancel)

	def select(self):
		if not self.selected:
			self.old_plugin_name = self["liste"].getCurrent()[0][0]
			self.old_plugin_hits = self["liste"].getCurrent()[0][1]
			for x in range(0, len(self.config_list_select)):
				if self.config_list_select[x][0] == self.old_plugin_name:
					self.old_idx = x
					break
			self.selected = True
			self.readconfig()
		else:
			self.new_plugin_name = self["liste"].getCurrent()[0][0]
			for x in range(0, len(self.config_list_select)):
				if self.config_list_select[x][0] == self.new_plugin_name:
					self.new_idx = x
					break
			del self.config_list_select[int(self.old_idx)];
			self.config_list_select.insert(int(self.new_idx), (self.old_plugin_name, self.old_plugin_hits, self.new_idx));
			count_move = 0
			config_tmp = open(self.plugins_file+".tmp", "w")
			for (name, hits, msort) in self.config_list_select:
				count_move += 1
				config_tmp.write('"%s" "%s" "%s"\n' % (name, hits, count_move))
			config_tmp.close()
			shutil.move(self.plugins_file+".tmp", self.plugins_file)
			self.selected = False
			self.readconfig()

	def readconfig(self):
		config_read = open(self.plugins_file, "r")
		self.config_list = []
		self.config_list_select = []
		for line in config_read.readlines():
			ok = re.findall('"(.*?)" "(.*?)" "(.*?)"', line, re.S)
			if ok:
				(name, hits, msort) = ok[0]
				found = False
				for x in self.currentlist:
					if x[0][0] == name:
						found = True
						break
				if found:
					self.config_list.append((name, hits, msort))
				if name in self.real_all:
					self.config_list_select.append((name, hits, msort))
		self.config_list.sort(key=lambda x: int(x[2]))
		self.config_list_select.sort(key=lambda x: int(x[2]))
		self.ml.setList(list(map(self.MPSort, self.config_list)))
		config_read.close()

	def keyCancel(self):
		config_mp.mediaportal.sortplugins.value = "user"
		self.close()

class MPSummary(Screen):

	def __init__(self, session, parent):
		try:
			displaysize = getDesktop(1).size()
			if mp_globals.model in ["dm900", "dm920"]:
				disp_id = ' id="3"'
				disp_size = str(displaysize.width()-8) + "," + str(displaysize.height())
				disp_pos = "8,0"
			elif mp_globals.model in ["dm7080"]:
				disp_id = ' id="3"'
				disp_size = str(displaysize.width()) + "," + str(displaysize.height()-14)
				disp_pos = "0,0"
			elif mp_globals.model in ["dm820"]:
				disp_id = ' id="2"'
				disp_size = str(displaysize.width()) + "," + str(displaysize.height())
				disp_pos = "0,0"
			elif mp_globals.model in ["two"]:
				disp_id = ' id="100"'
				disp_size = str(displaysize.width()) + "," + str(displaysize.height())
				disp_pos = "0,0"
			else:
				disp_id = ' id="1"'
				disp_size = str(displaysize.width()) + "," + str(displaysize.height())
				disp_pos = "0,0"

		except:
			disp_size = "1,1"
			disp_id = ' id="1"'
			disp_pos = "0,0"

		self["cover"] = Pixmap()

		self.skin = '''<screen name="MPSummary" backgroundColor="#00000000" position="''' + disp_pos + '''" size="''' + disp_size  + '''"''' + disp_id + '''>
				<widget name="cover" position="center,center" size="''' + disp_size + '''" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/none.png" transparent="1" alphatest="on" />
				</screen>'''

		self.skinName = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(32)])
		Screen.__init__(self, session)

	def updateCover(self, filename):
		CoverHelper(self['cover']).getCover(filename)

def exit(session, result, lastservice):
	global lc_stats
	if not result:
		mp_globals.currentskin = config_mp.mediaportal.skin2.value
		mp_globals.font = 'mediaportal'
		_stylemanager(1)

		if config_mp.mediaportal.viewmode.value == "liste":
			session.openWithCallback(exit, MPList, lastservice)
		elif config_mp.mediaportal.viewmode.value == "grid":
			session.openWithCallback(exit, MPGrid, lastservice)
	else:
		if mp_globals.animationfix:
			getDesktop(0).setAnimationsEnabled(False)
			mp_globals.animationfix = False

		session.nav.playService(lastservice)

		config_mp.mediaportal.skinfail.value = False
		config_mp.mediaportal.skinfail.save()
		configfile_mp.save()

		_stylemanager(0)
		clear_mp()

		reactor.callLater(1, export_lru_caches)
		reactor.callLater(5, clearTmpBuffer)
		reactor.callLater(30, clearFileBuffer)
		watcher.stop()
		if SHOW_HANG_STAT:
			lc_stats.stop()
			del lc_stats

def _stylemanager(mode):
	raisemsg = ''
	desktopSize = getDesktop(0).size()
	if desktopSize.height() == 1080:
		mp_globals.videomode = 2
		mp_globals.fontsize = 30
		mp_globals.sizefactor = 3
		mp_globals.grid_itemsperpage = 48
		mp_globals.pagebar_posx = 15
		mp_globals.pagebar_posy = 1010
		mp_globals.pagebar_margin = 5
		mp_globals.pagebar_iconwidth = 50
		mp_globals.pagebar_iconheight = 5
		mp_globals.pagebar_scaletowidth = 1
		mp_globals.sp_seekbar_factor = 11.62
	else:
		mp_globals.videomode = 1
		mp_globals.fontsize = 23
		mp_globals.sizefactor = 1
		mp_globals.grid_itemsperpage = 48
		mp_globals.pagebar_posx = 10
		mp_globals.pagebar_posy = 673
		mp_globals.pagebar_margin = 4
		mp_globals.pagebar_iconwidth = 33
		mp_globals.pagebar_iconheight = 3
		mp_globals.pagebar_scaletowidth = 1
		mp_globals.sp_seekbar_factor = 7.74
	try:
		from enigma import eWindowStyleManager, eWindowStyleSkinned, eSize, eListboxPythonStringContent, eListboxPythonConfigContent, eWindowStyleScrollbar
		from skin import parseSize, parseFont, parseColor, parseValue
		stylemgr = eWindowStyleManager.getInstance()
		desktop = getDesktop(0)
		styleskinned = eWindowStyleSkinned()

		if mode == 0:
			skin_path = resolveFilename(SCOPE_CURRENT_SKIN) + "skin.xml"
			file_path = resolveFilename(SCOPE_SKIN)
		else:
			addFont(resolveFilename(SCOPE_PLUGINS, "Extensions/MediaPortal/resources/") + "unifont.otf", "Replacement", 100, True)
			skin_path = mp_globals.pluginPath + mp_globals.skinsPath + "/" + mp_globals.currentskin + "/MP_skin.xml"
			if not fileExists(skin_path):
				config_mp.mediaportal.skin2.value = ''
				config_mp.mediaportal.skin2.save()
				configfile_mp.save()
				raisemsg = "Missing MP_skin.xml, this file is mandatory!"
			file_path = mp_globals.pluginPath + "/"

		if fileExists(skin_path):
			conf = xml.etree.cElementTree.parse(skin_path)
			for x in conf.getroot():
				if x.tag == "fonts" and mode == 0:
					fonts = x
					for x in fonts:
						if x.tag == "font":
							replacement = x.get("replacement")
							if replacement == "1":
								filename = x.get("filename")
								name = x.get("name")
								scale = x.get("scale")
								if scale:
									scale = int(scale)
								else:
									scale = 100
								resolved_font = resolveFilename(SCOPE_FONTS, filename, path_prefix='')
								if not fileExists(resolved_font): #when font is not available look at current skin path
									skin_path = resolveFilename(SCOPE_CURRENT_SKIN, filename)
									if fileExists(skin_path):
										resolved_font = skin_path
								addFont(resolved_font, name, scale, True)
				elif x.tag == "windowstylescrollbar":
					stylescrollbar = eWindowStyleScrollbar()
					try:
						id = int(x.get("id"))
					except:
						id = 4
					windowstylescrollbar =  x
					for x in windowstylescrollbar:
						if x.tag == "value":
							if x.get("name") in ("BackgroundPixmapTopHeight", "BackgroundPixmapBeginSize"):
								stylescrollbar.setBackgroundPixmapTopHeight(int(x.get("value")))
							elif x.get("name") in ("BackgroundPixmapBottomHeight", "BackgroundPixmapEndSize"):
								stylescrollbar.setBackgroundPixmapBottomHeight(int(x.get("value")))
							elif x.get("name") in ("ValuePixmapTopHeight", "ValuePixmapBeginSize"):
								stylescrollbar.setValuePixmapTopHeight(int(x.get("value")))
							elif x.get("name") in ("ValuePixmapBottomHeight", "ValuePixmapEndSize"):
								stylescrollbar.setValuePixmapBottomHeight(int(x.get("value")))
							elif x.get("name") == "ScrollbarWidth":
								stylescrollbar.setScrollbarWidth(int(x.get("value")))
							elif x.get("name") == "ScrollbarBorderWidth":
								stylescrollbar.setScrollbarBorderWidth(int(x.get("value")))
						if x.tag == "pixmap":
							if x.get("name") == "BackgroundPixmap":
								stylescrollbar.setBackgroundPixmap(LoadPixmap(file_path + x.get("filename"), desktop))
							elif x.get("name") == "ValuePixmap":
								stylescrollbar.setValuePixmap(LoadPixmap(file_path + x.get("filename"), desktop))
					try:
						stylemgr.setStyle(id, stylescrollbar)
					except:
						pass
				elif x.tag == "windowstyle" and x.get("id") == "0":
					font = gFont("Regular", 20)
					offset = eSize(20, 5)
					windowstyle = x
					for x in windowstyle:
						if x.tag == "title":
							font = parseFont(x.get("font"), ((1, 1), (1, 1)))
							offset = parseSize(x.get("offset"), ((1, 1), (1, 1)))
						elif x.tag == "color":
							colorType = x.get("name")
							color = parseColor(x.get("color"))
							try:
								styleskinned.setColor(eWindowStyleSkinned.__dict__["col" + colorType], color)
							except:
								pass
						elif x.tag == "borderset":
							bsName = str(x.get("name"))
							borderset =  x
							for x in borderset:
								if x.tag == "pixmap":
									bpName = x.get("pos")
									if "filename" in x.attrib:
										try:
											styleskinned.setPixmap(eWindowStyleSkinned.__dict__[bsName], eWindowStyleSkinned.__dict__[bpName], LoadPixmap(file_path + x.get("filename"), desktop))
										except:
											pass
									elif "color" in x.attrib:
										color = parseColor(x.get("color"))
										size = int(x.get("size"))
										try:
											styleskinned.setColorBorder(eWindowStyleSkinned.__dict__[bsName], eWindowStyleSkinned.__dict__[bpName], color, size)
										except:
											pass
						elif x.tag == "listfont":
							fontType = x.get("type")
							fontSize = int(x.get("size"))
							fontFace = x.get("font")
							try:
								styleskinned.setListFont(eWindowStyleSkinned.__dict__["listFont" + fontType], fontSize, fontFace)
							except:
								pass
					try:
						styleskinned.setTitleFont(font)
						styleskinned.setTitleOffset(offset)
					except:
						pass
				elif x.tag == "listboxcontent":
					listboxcontent = x
					for x in listboxcontent:
						if x.tag == "offset":
							name = x.get("name")
							value = x.get("value")
							if name and value:
								try:
									if name == "left":
											eListboxPythonStringContent.setLeftOffset(parseValue(value))
									elif name == "right":
											eListboxPythonStringContent.setRightOffset(parseValue(value))
								except:
									pass
						elif x.tag == "font":
							name = x.get("name")
							font = x.get("font")
							if name and font:
								try:
									if name == "string":
											eListboxPythonStringContent.setFont(parseFont(font, ((1, 1), (1, 1))))
									elif name == "config_description":
											eListboxPythonConfigContent.setDescriptionFont(parseFont(font, ((1, 1), (1, 1))))
									elif name == "config_value":
											eListboxPythonConfigContent.setValueFont(parseFont(font, ((1, 1), (1, 1))))
								except:
									pass
						elif x.tag == "value":
							name = x.get("name")
							value = x.get("value")
							if name and value:
								try:
									if name == "string_item_height":
											eListboxPythonStringContent.setItemHeight(parseValue(value))
									elif name == "config_item_height":
											eListboxPythonConfigContent.setItemHeight(parseValue(value))
								except:
									pass
				elif x.tag == "mediaportal":
					mediaportal = x
					for x in mediaportal:
						if x.tag == "color":
							colorType = x.get("name")
							exec("mp_globals." + x.get("name") + "=\"" + x.get("color") + "\"")
						elif x.tag == "overridefont":
							mp_globals.font = x.get("font")
						elif x.tag == "overridefontsize":
							mp_globals.fontsize = int(x.get("value"))
						elif x.tag == "overridesizefactor":
							mp_globals.sizefactor = int(x.get("value"))
						elif x.tag == "plugin_list_fontsize":
							mp_globals.plugin_list_fontsize = int(x.get("value"))
						elif x.tag == "plugin_list_itemheight":
							mp_globals.plugin_list_itemheight = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapmargin_x":
							mp_globals.plugin_list_pixmapmargin_x = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapwatchedmargin_y":
							mp_globals.plugin_list_pixmapwatchedmargin_y = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapwatchedheight":
							mp_globals.plugin_list_pixmapwatchedheight = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapwatchedwidth":
							mp_globals.plugin_list_pixmapwatchedwidth = int(x.get("value"))
						elif x.tag == "plugin_list_pixmaplivemargin_y":
							mp_globals.plugin_list_pixmaplivemargin_y = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapliveheight":
							mp_globals.plugin_list_pixmapliveheight = int(x.get("value"))
						elif x.tag == "plugin_list_pixmaplivewidth":
							mp_globals.plugin_list_pixmaplivewidth = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapstarmargin_y":
							mp_globals.plugin_list_pixmapstarmargin_y = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapstarheight":
							mp_globals.plugin_list_pixmapstarheight = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapstarwidth":
							mp_globals.plugin_list_pixmapstarwidth = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapredmargin_y":
							mp_globals.plugin_list_pixmapredmargin_y = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapredheight":
							mp_globals.plugin_list_pixmapredheight = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapredwidth":
							mp_globals.plugin_list_pixmapredwidth = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapplaylistmargin_y":
							mp_globals.plugin_list_pixmapplaylistmargin_y = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapplaylistheight":
							mp_globals.plugin_list_pixmapplaylistheight = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapplaylistwidth":
							mp_globals.plugin_list_pixmapplaylistwidth = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapdirectorymargin_y":
							mp_globals.plugin_list_pixmapdirectorymargin_y = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapdirectoryheight":
							mp_globals.plugin_list_pixmapdirectoryheight = int(x.get("value"))
						elif x.tag == "plugin_list_pixmapdirectorywidth":
							mp_globals.plugin_list_pixmapdirectorywidth = int(x.get("value"))
						elif x.tag == "plugin_list_backgroundpicture":
							mp_globals.plugin_list_backgroundpicture = LoadPixmap(file_path + x.get("filename"))
						elif x.tag == "plugin_list_selectionpicture":
							mp_globals.plugin_list_selectionpicture = LoadPixmap(file_path + x.get("filename"))
						elif x.tag == "plugin_grid_fontsize":
							mp_globals.plugin_grid_fontsize = int(x.get("value"))
						elif x.tag == "plugin_grid_margin_x":
							mp_globals.plugin_grid_margin_x = int(x.get("value"))
						elif x.tag == "plugin_grid_margin_y":
							mp_globals.plugin_grid_margin_y = int(x.get("value"))
						elif x.tag == "plugin_grid_itemheight":
							mp_globals.plugin_grid_itemheight = int(x.get("value"))
						elif x.tag == "plugin_grid_itemwidth":
							mp_globals.plugin_grid_itemwidth = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapmargin_x":
							mp_globals.plugin_grid_pixmapmargin_x = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapmargin_y":
							mp_globals.plugin_grid_pixmapmargin_y = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapheight":
							mp_globals.plugin_grid_pixmapheight = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapwidth":
							mp_globals.plugin_grid_pixmapwidth = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapwatchedmargin_x":
							mp_globals.plugin_grid_pixmapwatchedmargin_x = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapwatchedmargin_y":
							mp_globals.plugin_grid_pixmapwatchedmargin_y = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapwatchedheight":
							mp_globals.plugin_grid_pixmapwatchedheight = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapwatchedwidth":
							mp_globals.plugin_grid_pixmapwatchedwidth = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapstarmargin_x":
							mp_globals.plugin_grid_pixmapstarmargin_x = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapstarmargin_y":
							mp_globals.plugin_grid_pixmapstarmargin_y = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapstarheight":
							mp_globals.plugin_grid_pixmapstarheight = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapstarwidth":
							mp_globals.plugin_grid_pixmapstarwidth = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapredmargin_x":
							mp_globals.plugin_grid_pixmapredmargin_x = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapredmargin_y":
							mp_globals.plugin_grid_pixmapredmargin_y = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapredheight":
							mp_globals.plugin_grid_pixmapredheight = int(x.get("value"))
						elif x.tag == "plugin_grid_pixmapredwidth":
							mp_globals.plugin_grid_pixmapredwidth = int(x.get("value"))
						elif x.tag == "plugin_grid_textmargin_x":
							mp_globals.plugin_grid_textmargin_x = int(x.get("value"))
						elif x.tag == "plugin_grid_textmargin_y":
							mp_globals.plugin_grid_textmargin_y = int(x.get("value"))
						elif x.tag == "plugin_grid_textheight":
							mp_globals.plugin_grid_textheight = int(x.get("value"))
						elif x.tag == "plugin_grid_textwidth":
							mp_globals.plugin_grid_textwidth = int(x.get("value"))
						elif x.tag == "plugin_grid_backgroundpicture":
							mp_globals.plugin_grid_backgroundpicture = LoadPixmap(file_path + x.get("filename"))
						elif x.tag == "plugin_grid_selectionpicture":
							mp_globals.plugin_grid_selectionpicture = LoadPixmap(file_path + x.get("filename"))
						elif x.tag == "pagebar_posx":
							mp_globals.pagebar_posx = int(x.get("value"))
						elif x.tag == "pagebar_posy":
							mp_globals.pagebar_posy = int(x.get("value"))
						elif x.tag == "pagebar_margin":
							mp_globals.pagebar_margin = int(x.get("value"))
						elif x.tag == "pagebar_iconwidth":
							mp_globals.pagebar_iconwidth = int(x.get("value"))
						elif x.tag == "pagebar_iconheight":
							mp_globals.pagebar_iconheight = int(x.get("value"))
						elif x.tag == "pagebar_scaletowidth":
							mp_globals.pagebar_scaletowidth = int(x.get("value"))
						elif x.tag == "grid_itemsperpage":
							mp_globals.grid_itemsperpage = int(x.get("value"))
						elif x.tag == "sp_seekbar_factor":
							mp_globals.sp_seekbar_factor = float(x.get("value"))
						elif x.tag == "config_separation_width":
							mp_globals.config_separation_width = int(x.get("value"))
						elif x.tag == "config_divider_height":
							mp_globals.config_divider_height = int(x.get("value"))
						elif x.tag == "sort_select_pixmapmargin_x":
							mp_globals.sort_select_pixmapmargin_x = int(x.get("value"))
						elif x.tag == "sort_select_pixmapmargin_y":
							mp_globals.sort_select_pixmapmargin_y = int(x.get("value"))
						elif x.tag == "sort_select_pixmapheight":
							mp_globals.sort_select_pixmapheight = int(x.get("value"))
						elif x.tag == "sort_select_pixmapwidth":
							mp_globals.sort_select_pixmapwidth = int(x.get("value"))
			stylemgr.setStyle(0, styleskinned)
		else:
			pass
	except:
		config_mp.mediaportal.skin2.value = ''
		config_mp.mediaportal.skin2.save()
		configfile_mp.save()
		raisemsg = "Fatal MP_skin.xml error!"
	if raisemsg != '':
		raise Exception(raisemsg)

def _hosters():
	hosters_file = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/resources/hosters/hosters.xml"
	open_hosters = open(hosters_file)
	data = open_hosters.read()
	open_hosters.close()
	hosters = re.findall('^(?!#)<name>(.*?)</name><hoster>(.*?)</hoster><regex>(.*?)</regex>(?:<premium>(.*?)</premium>|)', data, re.M)
	mp_globals.hosters = ["|".join(["(?P<%s>%s)" % (name, hoster) for name, hoster, regex, premium in hosters])]
	mp_globals.hosters += ["|".join(["(?P<%s>%s)" % (name, regex) for name, hoster, regex, premium in hosters])]
	mp_globals.premium_hosters_prz = ["|".join(["%s" % name.replace('_space_', ' ').replace('_dot_', '.').replace('___', '') for name, hoster, regex, premium in hosters if "p" in premium])]
	mp_globals.premium_hosters_rdb = ["|".join(["%s" % name.replace('_space_', ' ').replace('_dot_', '.').replace('___', '') for name, hoster, regex, premium in hosters if "r" in premium])]

def _status(data):
	statusdata = re.findall('"(.*?)"\s"(.*?)"\s"(.*?)"', data)
	if statusdata:
		mp_globals.status = []
		for (plugin, version, status) in statusdata:
			mp_globals.status.append((plugin, version, status))

from .resources.simple_lru_cache import SimpleLRUCache
mp_globals.lruCache = SimpleLRUCache(50, config_mp.mediaportal.watchlistpath.value + 'mp_lru_cache')
mp_globals.yt_lruCache = SimpleLRUCache(100, config_mp.mediaportal.watchlistpath.value + 'mp_yt_lru_cache')

watcher = None
preload_list = None
lc_stats = None

def export_lru_caches():
	if config_mp.mediaportal.sp_save_resumecache.value:
		mp_globals.lruCache.saveCache()
		mp_globals.yt_lruCache.saveCache()

def import_lru_caches():
	if config_mp.mediaportal.sp_save_resumecache.value:
		mp_globals.lruCache.readCache()
		mp_globals.yt_lruCache.readCache()

def clearTmpBuffer():
	if mp_globals.yt_tmp_storage_dirty:
		mp_globals.yt_tmp_storage_dirty = False
		BgFileEraser = eBackgroundFileEraser.getInstance()
		path = config_mp.mediaportal.storagepath.value
		if os.path.exists(path):
			for fn in next(os.walk(path))[2]:
				BgFileEraser.erase(os.path.join(path, fn))

def clearFileBuffer():
	def clean(hashes, path):
		BgFileEraser = eBackgroundFileEraser.getInstance()
		if os.path.exists(path):
			for fn in next(os.walk(path))[2]:
				local_hash = hashlib.md5(open(os.path.join(path, fn), 'rb').read()).hexdigest()
				if local_hash not in (item[0] for item in hashes):
					BgFileEraser.erase(os.path.join(path, fn))
	icon_url = getIconUrl()
	path = config_mp.mediaportal.iconcachepath.value + "icons"
	icons_hashes = grabpage(icon_url+"icons/hashes")
	if icons_hashes:
		icons_data = re.findall('(.*?)\s\*(.*?\.png)', icons_hashes)
		clean(icons_data, path)
	path = config_mp.mediaportal.iconcachepath.value + "logos"
	logo_hashes = grabpage(icon_url+"logos/hashes")
	if logo_hashes:
		logo_data = re.findall('(.*?)\s\*(.*?\.png)', logo_hashes)
		clean(logo_data, path)

def MPmain(session, **kwargs):
	mp_globals.start = True
	startMP(session)

def startMP(session):
	if not getDesktop(0).isAnimationsEnabled():
		getDesktop(0).setAnimationsEnabled(True)
		mp_globals.animationfix = True

	from .resources.debuglog import printl
	printl('Starting MediaPortal %s-py3' % config_mp.mediaportal.version.value, None, 'H')

	global watcher, lc_stats

	reactor.callLater(2, import_lru_caches)

	addFont(resolveFilename(SCOPE_PLUGINS, "Extensions/MediaPortal/resources/") + "mediaportal1.ttf", "mediaportal", 100, False)
	addFont(resolveFilename(SCOPE_PLUGINS, "Extensions/MediaPortal/resources/") + "mediaportal_clean.ttf", "mediaportal_clean", 100, False)
	addFont(resolveFilename(SCOPE_PLUGINS, "Extensions/MediaPortal/resources/") + "unifont.otf", "Replacement", 100, True)

	if config_mp.mediaportal.skinfail.value:
		config_mp.mediaportal.skin2.value = ''
		config_mp.mediaportal.skin2.save()
	else:
		config_mp.mediaportal.skinfail.value = True
		config_mp.mediaportal.skinfail.save()
	configfile_mp.save()

	mp_globals.currentskin = config_mp.mediaportal.skin2.value
	_stylemanager(1)

	if watcher == None:
		watcher = HangWatcher()
	watcher.start()
	if SHOW_HANG_STAT:
		lc_stats = task.LoopingCall(watcher.print_stats)
		lc_stats.start(60)

	if config_mp.mediaportal.hideporn_startup.value and config_mp.mediaportal.showporn.value:
		config_mp.mediaportal.showporn.value = False
		if config_mp.mediaportal.filter.value == "Porn":
			config_mp.mediaportal.filter.value = "ALL"
		config_mp.mediaportal.showporn.save()
		config_mp.mediaportal.filter.save()
		configfile_mp.save()

	lastservice = session.nav.getCurrentlyPlayingServiceReference()

	if config_mp.mediaportal.viewmode.value == "liste":
		session.openWithCallback(exit, MPList, lastservice)
	elif config_mp.mediaportal.viewmode.value == "grid":
		session.openWithCallback(exit, MPGrid, lastservice)

def autostart(reason, session=None, **kwargs):
	"called with reason=1 to during shutdown, with reason=0 at startup?"
	global _session, watcher, preload_list, _cachingDeferred, _cachingPicload
	if reason == 0:
		if session is not None:
			_session = session
			CheckPathes(session).checkPathes(cb_checkPathes)
		if watcher == None:
			watcher = HangWatcher()
		if preload_list == None:
			preload_list = []
			if config_mp.mediaportal.viewmode.value == "grid":
				_cachingDeferred = defer.DeferredSemaphore(tokens=1)
				_cachingPicload = ePicLoad()
				scale = AVSwitch().getFramebufferScale()
				if mp_globals.videomode == 2:
					_cachingPicload.setPara((225, 120, scale[0], scale[1], False, 1, "#FF000000"))
				else:
					_cachingPicload.setPara((150, 80, scale[0], scale[1], False, 1, "#FF000000"))
				icon_url = getIconUrl()
				path = config_mp.mediaportal.iconcachepath.value + "icons"
				icons_hashes = grabpage(icon_url+"icons/hashes")
				if icons_hashes:
					hashes = re.findall('(.*?)\s\*(.*?\.png)', icons_hashes)
					if hashes and os.path.exists(path):
						i = 0
						for fn in next(os.walk(path))[2]:
							local_hash = hashlib.md5(open(os.path.join(path, fn), 'rb').read()).hexdigest()
							if local_hash in (item[0] for item in hashes):
								_thread.start_new_thread(cacheIcon, ("cacheIcon", fn, i))
								i += 1

def cacheIcon(threadName, fn, index):
	global _cachingDeferred
	#file = '/tmp/.gridIcon%s' % str(index)
	file = "%s/%s" % (config_mp.mediaportal.iconcachepath.value + "icons", fn)
	#im = Image.open("%s/%s" % (config_mp.mediaportal.iconcachepath.value + "icons", fn)).convert('RGBA')
	#im.load()
	#bands = im.split()
	#if mp_globals.videomode == 2:
	#	bands = [b.resize((225, 120), Image.ANTIALIAS) for b in bands]
	#else:
	#	bands = [b.resize((150, 80), Image.ANTIALIAS) for b in bands]
	#im = Image.merge('RGBA', bands)
	#im.save(file, "PNG")
	#import sys
	#sys.setrecursionlimit(4000)
	_cachingDeferred.run(loadIcon, fn, file).addErrback(failIcon)

def loadIcon(fn, file):
	global preload_list, _cachingPicload
	_cachingPicload.startDecode(file, False)
	pngthumb = _cachingPicload.getData()
	preload_list.append((fn, pngthumb))
	#if fileExists(file):
	#	BgFileEraser = eBackgroundFileEraser.getInstance()
	#	BgFileEraser.erase(file)

def failIcon(error):
	from .resources.debuglog import printl
	printl(error, '', "H")

def cb_checkPathes():
	pass

def Plugins(path, **kwargs):
	mp_globals.pluginPath = path
	mp_globals.font = 'mediaportal'

	result = [
		PluginDescriptor(name="MediaPortal", description="MediaPortal", where = [PluginDescriptor.WHERE_AUTOSTART, PluginDescriptor.WHERE_SESSIONSTART], fnc = autostart),
		PluginDescriptor(name="MediaPortal", description="MediaPortal", where = [PluginDescriptor.WHERE_PLUGINMENU, PluginDescriptor.WHERE_EXTENSIONSMENU], icon="plugin.png", fnc=MPmain)
	]
	return result
