﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from builtins import map
from ...plugin import _
from ...resources.imports import *

try:
    from Plugins.GP4.geminibrowser.gbrowserWidget import gMoviePlayer
    GeminiPlayerFound = True
except:
    GeminiPlayerFound = False

default_cover = "file://%s/dazn.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class daznScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"	: self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("DAZN")

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.StartTimer = eTimer()
		self.keyLocked = True

		self.onLayoutFinish.append(self.start)

	def start(self):
		self._items.append(("",))
		if mp_globals.model in ["one", "two"]:
			try:
				self.player_org = config.vod.dazn.player.value
			except:
				pass
			self.StartTimer_conn = self.StartTimer.timeout.connect(self.keyOK)
			self.StartTimer.start(1000, False)
			self._items.append((_("Please wait while DAZN is started..."),))
			self.keyLocked = False
		else:
			self._items.append((_("This plugin is only available for Dreambox One and Two!"),))
			self['handlung'].setText('')
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.ml.moveToIndex(0)
		self.ml.selectionEnabled(False)

	def keyOK(self):
		if self.keyLocked:
			return
		self.StartTimer.stop()
		try:
			from Plugins.Extensions.VOD.plugin import Plugins
			config.vod.dazn.player = ConfigSelection(default='SIMPLE_PL', choices=[('SIMPLE_PL', 'MediaPortal')])
			config.vod.dazn.player.save()
			configfile.save()
			from Plugins.GP4.geminidazn.daznmain import DaznMain
			from ...plugin import _stylemanager
			_stylemanager(0)
			self.session.openWithCallback(self.daznClose, DaznMain)
		except:
			self.session.openWithCallback(self.daznClose, MessageBoxExt, _("Launching DAZN failed!"), MessageBoxExt.TYPE_ERROR, timeout=5)

	def daznClose(self, answer=''):
		from ...plugin import _stylemanager
		_stylemanager(1)
		menu = [('DREAMOS_PL', 'Dreamos'), ('SIMPLE_PL', 'Mediaportal')]
		if GeminiPlayerFound:
			menu.append(('GEMINI_PL', 'Gemini'))
		config.vod.dazn.player = ConfigSelection(default='DREAMOS_PL', choices=menu)
		try:
			config.vod.dazn.player.value = self.player_org
			config.vod.dazn.player.save()
			configfile.save()
		except:
			pass
		self.keyCancel()