﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *

agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.97 Safari/537.36'
json_headers = {
	'X-Requested-With': 'XMLHttpRequest',
	'Content-Type': 'application/json',
	}
cookies = CookieJar()
default_cover = "file://%s/manyvids.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
mvtoken = ''

class manyvidsGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"yellow" : self.keyScope
		}, -1)

		self.scope = 0
		self.scopeText = ['Straight', 'Shemale', 'Gay']
		self.scopeval = ['1', '3', '2']

		self['title'] = Label("ManyVids.com")
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		self['F3'].setText(self.scopeText[self.scope])
		self['name'].setText(_("Please wait..."))
		url = "https://www.manyvids.com"
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.parseToken).addErrback(self.dataError)

	def parseToken(self, data):
		token = MPfindall(self, 'mvtoken="(.*?)"', data, re.S)
		global mvtoken
		mvtoken = token[0]
		postdata = {"mvtoken":mvtoken,"userPreferredContent":self.scopeval[self.scope],"currentLocation":"/Vids/"}
		url = "https://www.manyvids.com/includes/ajax_repository/preferredContent.php"
		twAgentGetPage(url, method='POST', postdata=urlencode(postdata), agent=agent, cookieJar=cookies, headers={'Content-Type':'application/x-www-form-urlencoded','X-Requested-With':'XMLHttpRequest'}).addCallback(self.parseCats).addErrback(self.dataError)

	def parseCats(self, data):
		postdata = {"get-filters":1,"mvtoken":mvtoken}
		postdata = json.dumps(postdata)
		url = "https://www.manyvids.com/api/vids/"
		twAgentGetPage(url, method='POST', postdata=postdata, agent=agent, cookieJar=cookies, headers=json_headers).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		self._items.insert(0, ("--- Search ---", "callSuchen", default_cover))
		json_data = json.loads(data)
		for item in json_data["topBar"]["sorting"]["options"]:
			Title = str(item["label"])
			Id = str(item["id"])
			if not "Most Relevant" in Title:
				self._items.append((Title, Id, "sort"))
		for item in json_data["sideBar"]["categoriesList"]:
			Title = str(item["label"])
			Id = str(item["id"])
			self._items.append((Title, Id, "category"))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self['name'].setText('')
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen(suggest_func=self.getSuggestions)
		else:
			Link = self['liste'].getCurrent()[0][1]
			Type = self['liste'].getCurrent()[0][2]
			Scope = self.scopeval[self.scope]
			self.session.open(manyvidsFilmScreen, Link, Name, Type, Scope)

	def keyScope(self):
		if self.keyLocked:
			return
		self._items = []
		if self.scope == 0:
			self.scope = 1
		elif self.scope == 1:
			self.scope = 2
		else:
			self.scope = 0
		self.layoutFinished()

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString)
			Type = self['liste'].getCurrent()[0][2]
			Scope = self.scopeval[self.scope]
			self.session.open(manyvidsFilmScreen, Link, Name, Type, Scope)

	def getSuggestions(self, text, max_res):
		url = "https://www.manyvids.com/includes/filterSearch.php"
		postdata = {"mvtoken":mvtoken,"type":"search","category":"video","search":text}
		d = twAgentGetPage(url, method='POST', postdata=urlencode(postdata), agent=agent, cookieJar=cookies, headers={'Content-Type':'application/x-www-form-urlencoded','X-Requested-With':'XMLHttpRequest'}, timeout=5)
		d.addCallback(self.gotSuggestions, max_res)
		d.addErrback(self.gotSuggestions, max_res, err=True)
		return d

	def gotSuggestions(self, suggestions, max_res, err=False):
		list = []
		if not err and type(suggestions) in (str, buffer):
			suggestions = json.loads(suggestions)
			for item in suggestions['video']:
				li = item['label']
				list.append(str(li))
				max_res -= 1
				if not max_res: break
		elif err:
			printl(str(suggestions), self, 'E')
		return list

class manyvidsFilmScreen(MPScreen):

	def __init__(self, session, Link, Name, Type, Scope):
		self.Link = Link
		self.Name = Name
		self.Type = Type
		self.Scope = Scope
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber,
			"yellow" : self.keyRelated
		}, -1)

		self['title'] = Label("ManyVids.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))
		if not self.Type == "related":
			self['F3'] = Label(_("Show Related"))

		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*Search", self.Name):
			postdata = {"get-filters":0,"keywords":self.Link,"content_type":self.Scope,"other":"free","search_type":"0","sort":"10","vid_format":".MP4,.M4V,.MOV","page":str(self.page),"mvtoken":mvtoken}
		else:
			if self.Type == "category":
				postdata = {"get-filters":0,"keywords":"","age":"","breast_size":"","category":self.Link,"content_type":self.Scope,"endowment":"","ethnicity":"","intensity":"","other":"free","price_range":"","search_type":0,"type":"video","vid_format":".MP4,.M4V,.MOV","vid_type":"","sort":"1","page":self.page,"mvtoken":mvtoken}
			elif self.Type == "sort":
				postdata = {"get-filters":0,"keywords":"","age":"","breast_size":"","category":"","content_type":self.Scope,"endowment":"","ethnicity":"","intensity":"","other":"free","price_range":"","search_type":0,"type":"video","vid_format":".MP4,.M4V,.MOV","vid_type":"","sort":self.Link,"page":self.page,"mvtoken":mvtoken}
			elif self.Type == "related":
				postdata = {"mvtoken":mvtoken,"category":"all","sort":"8","offset":(self.page-1)*30}
		if self.Type == "related":
			url = "https://www.manyvids.com" + self.Link + "Store/Videos/"
			twAgentGetPage(url, method='POST', postdata=urlencode(postdata), agent=agent, cookieJar=cookies, headers={'Content-Type':'application/x-www-form-urlencoded','X-Requested-With':'XMLHttpRequest'}).addCallback(self.genreData).addErrback(self.dataError)
		else:
			postdata = json.dumps(postdata)
			url = "https://www.manyvids.com/api/vids/"
			twAgentGetPage(url, method='POST', postdata=postdata, agent=agent, cookieJar=cookies, headers=json_headers).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		json_data = json.loads(data)
		if self.Type == "related":
			new = int(json_data["newOffset"])
			total = int(json_data["nbVideoTotal"])
			self.lastpage = int(round((float(total) / 30) + 0.5))
			if self.lastpage > 1:
				self['Page'].setText(_("Page:"))
				self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
			vids = MPfindall(self, '"item-card.*?href="(.*?)".*?js-video-image"\salt="(.*?)".*?data-src="(.*?)".*?vid-length force.*?>(.*?)</div.*?<span title="(.*?)"><i class="icon medium mv-icon-views">', str(json_data["ajaxData"]), re.S)
			for (Url, Title, Image, Runtime, Views) in vids:
				Url = Url.strip()
				if Url.startswith('/'):
					Url = "https://www.manyvids.com" + Url
				if not "javascript" in Url:
					self._items.append((decodeHtml(Title.strip()), Url, Image.strip(), Runtime.strip(), Views.strip(), '', '', '', ''))
		else:
			if 'content' in json_data:
				if 'totalPages' in json_data["content"]:
					self.lastpage = json_data["content"]["totalPages"]
					if self.lastpage > 1:
						self['Page'].setText(_("Page:"))
						self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
				if 'items' in json_data["content"]:
					for item in json_data["content"]["items"]:
						Title = decodeHtml(str(item["video"]["title"]))
						Image = str(item["video"]["videoThumb"])
						Runtime = str(item["video"]["formattedLength"])
						Views = str(item["video"]["views"])
						Likes = str(item["video"]["likes"])
						Rating = str(item["video"]["formattedRating"])
						if Rating == "0.0":
							Rating = ''
						Url = str(item["video"]["preview"]["path"])
						Username = str(item["model"]["avatar"]["stageName"])
						ProfileUrl = str(item["model"]["avatar"]["link"])
						if Url.startswith('/'):
							Url = "https://www.manyvids.com" + Url
						self._items.append((Title, Url, Image, Runtime, Views, Likes, Rating, Username, ProfileUrl))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), "", None, '', '', '', '', '', ''))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		pic = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][3]
		views = self['liste'].getCurrent()[0][4]
		likes = self['liste'].getCurrent()[0][5]
		if likes:
			likes = "\nLikes: %s" % likes
		rating = self['liste'].getCurrent()[0][6]
		if rating:
			rating = "\nRating: %s" % rating
		username = self['liste'].getCurrent()[0][7]
		if username:
			username = "\nUser: %s" % username
		self['name'].setText(title)
		self['handlung'].setText("Runtime: %s\nViews: %s%s%s%s" % (runtime, views, likes, rating, username))
		CoverHelper(self['coverArt']).getCover(pic)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		twAgentGetPage(Link).addCallback(self.parseData).addErrback(self.dataError)

	def keyRelated(self):
		if self.Type == "related":
			return
		Link = self['liste'].getCurrent()[0][8]
		self.session.open(manyvidsFilmScreen, Link, "Related", "related", self.Scope)

	def parseData(self, data):
		Title = self['liste'].getCurrent()[0][0]
		match = MPfindall(self, 'data-video-filepath="(.*?)"', data)
		if match:
			url = match[-1]
			mp_globals.player_agent = agent
			self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='manyvids')