﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.keyboardext import VirtualKeyBoardExt
from ...resources.choiceboxext import ChoiceBoxExt

agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.120 Safari/537.36'
default_cover = "file://%s/lovehomeporn.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
cookies = CookieJar()

class lovehomepornGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("LoveHomePorn.com")
		self['ContentTitle'] = Label("Genre:")

		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		url = "https://lovehomeporn.com/videos"
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		Cats = MPfindall(self, 'class="tag2" href="(.*?)">(.*?)</a></li>', data, re.S)
		if Cats:
			for (Url, Title) in Cats:
				if Title not in ["all", "bigass", "bigboobs"]:
					Url = Url.replace('#menu', '') + "/$$PAGE$$"
					self._items.append((Title.title(), Url, default_cover))
			self._items.sort()
			self._items.insert(0, ("Being Watched", "https://lovehomeporn.com/videos/$$PAGE$$?o=bw", default_cover))
			self._items.insert(0, ("Most Downloaded", "https://lovehomeporn.com/videos/$$PAGE$$?o=md", default_cover))
			self._items.insert(0, ("Most Favorited", "https://lovehomeporn.com/videos/$$PAGE$$?o=tf", default_cover))
			self._items.insert(0, ("Most Viewed", "https://lovehomeporn.com/videos/$$PAGE$$?o=mv", default_cover))
			self._items.insert(0, ("Top Rated", "https://lovehomeporn.com/videos/$$PAGE$$?o=tr", default_cover))
			self._items.insert(0, ("Newest", "https://lovehomeporn.com/videos/$$PAGE$$?o=mr", default_cover))
			self._items.insert(0, ("--- Search ---", "callSuchen", default_cover))
			self.ml.setList(list(map(self._defaultlistcenter, self._items)))
			self.ml.moveToIndex(0)
			self.keyLocked = False
			self.showInfos()

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image, agent=agent, headers={'Referer':'https://lovehomeporn.com/'})

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen()
		else:
			Link = self['liste'].getCurrent()[0][1]
			self.session.open(lovehomepornFilmScreen, Link, Name)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '+'))
			self.session.open(lovehomepornFilmScreen, Link, Name)

class lovehomepornFilmScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("LoveHomePorn.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*?Search", self.Name):
			url = 'https://lovehomeporn.com/search?search_type=videos&search_query=%s&page=%s' % (self.Link, str(self.page))
		else:
			url = self.Link.replace('$$PAGE$$', str(self.page))
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		self.getLastPage(data, 'class="pagination">(.*?)</div>', '.*(?:page=|>)(\d+)(?:"(?! class="prevnext">Next)|<)')
		Movies = MPfindall(self, 'href="https://lovehomeporn.com/video/(\d+)/.*?alt="(.*?)".*?data-original=\'(.*?)\'.*?class="info">(.*?)(?:</div>|<meta).*?class="text">(.*?)</span>.*?class="text".*?>(\d+) views</span>', data, re.S)
		if Movies:
			for (Id, Title, Image, Runtime, Added, Views) in Movies:
				Runtime = Runtime.strip()
				if Image.startswith('//'):
					Image = 'https:' + Image
				if Image.endswith('webp'):
					Image = re.sub(r'/260(.*?)195/', '/260%D1%85195/', Image).replace('webp', 'jpg')
				self._items.append((decodeHtml(Title), Id, Image, Runtime, Views, Added))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), '', None, '', '', ''))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		pic = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][3]
		views = self['liste'].getCurrent()[0][4]
		added = self['liste'].getCurrent()[0][5]
		self['name'].setText(title)
		self['handlung'].setText("Runtime: %s\nAdded: %s\nViews: %s" % (runtime, added, views))
		CoverHelper(self['coverArt']).getCover(pic, agent=agent, headers={'Referer':'https://lovehomeporn.com/'})

	def keyOK(self):
		if self.keyLocked:
			return
		Id = self['liste'].getCurrent()[0][1]
		if Id:
			url = "https://lovehomeporn.com/media/nuevo/config.php?key=%s" % Id
			twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.getVideoPage).addErrback(self.dataError)

	def getVideoPage(self, data):
		videoPage = MPfindall(self, '<file>(.*?)</file>', data, re.S)
		if videoPage:
			Title = self['liste'].getCurrent()[0][0]
			headers = '&Referer=https://lovehomeporn.com/'
			url = videoPage[-1].replace('&amp;', '&') + '#User-Agent='+agent+headers
			mp_globals.player_agent = agent
			self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='lovehomeporn')