﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.keyboardext import VirtualKeyBoardExt

agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36'
json_headers = {
	'Accept': 'application/json',
	'Accept-Language': 'en,en-US;q=0.7,en;q=0.3',
	'X-Requested-With': 'XMLHttpRequest',
	'Content-Type': 'application/x-www-form-urlencoded',
	}

default_cover = "file://%s/ahme.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class ahmeGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"yellow" : self.keyScope
		}, -1)

		self.scope = 0
		self.scopeText = ['Straight', 'Shemale', 'Gay']
		self.scopeval = ['', 'shemale/', 'gay/']

		self['title'] = Label("Ah-Me.com")
		self['ContentTitle'] = Label("Genre:")
		self['F3'] = Label(self.scopeText[self.scope])

		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		self['F3'].setText(self.scopeText[self.scope])
		url = "http://www.ah-me.com/%schannels/" % self.scopeval[self.scope]
		twAgentGetPage(url).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		Cats = MPfindall(self, 'class="moviec.*?<a\shref="(.*?)page1.html".*?="thumb"\ssrc="(.*?)".*?alt="(.*?)"', data, re.S)
		if Cats:
			for (Url, Pic, Title) in Cats:
				self._items.append((decodeHtml(Title), Url, Pic))
			self._items.sort()
		self._items.insert(0, ("High Definition", "http://www.ah-me.com/%shigh-definition/" % self.scopeval[self.scope], default_cover))
		self._items.insert(0, ("Longest", "http://www.ah-me.com/%slong-movies/" % self.scopeval[self.scope], default_cover))
		self._items.insert(0, ("Most Favourited", "http://www.ah-me.com/%smostfavorites/" % self.scopeval[self.scope], default_cover))
		self._items.insert(0, ("Top Rated", "http://www.ah-me.com/%stop-rated/" % self.scopeval[self.scope], default_cover))
		self._items.insert(0, ("Most Recent", "http://www.ah-me.com/%smost-recent/" % self.scopeval[self.scope], default_cover))
		self._items.insert(0, ("--- Search ---", "callSuchen", default_cover))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen(suggest_func=self.getSuggestions)
		else:
			Name = self['liste'].getCurrent()[0][0]
			Link = self['liste'].getCurrent()[0][1]
			self.session.open(ahmeFilmScreen, Link, Name)

	def keyScope(self):
		if self.keyLocked:
			return
		self._items = []
		if self.scope == 0:
			self.scope = 1
		elif self.scope == 1:
			self.scope = 2
		else:
			self.scope = 0
		self.layoutFinished()

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = '%s' % (urllib.parse.quote(self.suchString.replace(' ', '+')))
			self.session.open(ahmeFilmScreen, Link, Name, Scope=self.scopeval[self.scope])

	def getSuggestions(self, text, max_res):
		url = "http://www.ah-me.com/?area=autocomplete&o=%s&q=%s" % (self.scopeText[self.scope].lower(), urllib.parse.quote_plus(text))
		d = twAgentGetPage(url, agent=agent, headers=json_headers, timeout=5)
		d.addCallback(self.gotSuggestions, max_res)
		d.addErrback(self.gotSuggestions, max_res, err=True)
		return d

	def gotSuggestions(self, suggestions, max_res, err=False):
		list = []
		if not err and type(suggestions) in (str, buffer):
			suggestions = json.loads(suggestions)
			for item in suggestions["suggestions"]:
				li = item
				list.append(str(li))
				max_res -= 1
				if not max_res: break
		elif err:
			printl(str(suggestions), self, 'E')
		return list

class ahmeFilmScreen(MPScreen):

	def __init__(self, session, Link, Name, Scope=''):
		self.Link = Link
		self.Name = Name
		self.Scope = Scope
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("Ah-Me.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))

		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*?Search", self.Name):
			url = "http://www.ah-me.com/%ssearch/%s/page%s.html" % (self.Scope, self.Link, str(self.page))
		else:
			url = "%spage%s.html" % (self.Link, str(self.page))
		twAgentGetPage(url).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		self.getLastPage(data, 'class="pages-nav">(.*?)</div>')
		Movies = MPfindall(self, 'class="moviec.*?href="(.*?)".*?src="(.*?)".*?alt="(.*?)".*?class="time">(.*?)</span>', data, re.S)
		if Movies:
			for (Url, Pic, Title, Runtime) in Movies:
				self._items.append((decodeHtml(Title), Url, Pic, Runtime))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), None, None, '', '', ''))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		coverUrl = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][3]
		self['name'].setText(title)
		self['handlung'].setText("Runtime: %s" % (runtime))
		CoverHelper(self['coverArt']).getCover(coverUrl)

	def keyOK(self):
		if self.keyLocked:
			return
		url = self['liste'].getCurrent()[0][1]
		self.keyLocked = True
		if url:
			twAgentGetPage(url).addCallback(self.getVideoPage).addErrback(self.dataError)

	def getVideoPage(self, data):
		videoPage = MPfindall(self, '<video\ssrc="(.*?)"', data, re.S)
		if videoPage:
			self.keyLocked = False
			Title = self['liste'].getCurrent()[0][0]
			mp_globals.player_agent = agent
			import time
			url = videoPage[0] + "?rnd=" + str(int(time.time())) + str(random.randrange(100, 999))
			headers = '#User-Agent='+mp_globals.player_agent+ "&Referer="+self['liste'].getCurrent()[0][1]
			url = url + headers
			self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='ahme')