﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.configlistext import ConfigListScreenExt

default_cover = "file://%s/tunein.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
config_mp.mediaportal.tunein_sort = ConfigYesNo(default=True)
agent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.122 Safari/537.36'
json_headers = {
	'Accept': 'application/json',
	'Accept-Language': 'de,en-US;q=0.7,en;q=0.3',
	'X-Requested-With': 'XMLHttpRequest',
	'Content-Type': 'application/x-www-form-urlencoded',
	}

def check_playlist(url):
	servers = []
	if url.lower().endswith('.m3u'):
		try:
			s = requests.session()
			page = s.get(url, timeout=15)
			data = page.content
			servers = [
				l for l in data.splitlines()
				if l.strip() and not l.strip().startswith('#')
			]
		except:
			pass
	elif url.lower().endswith('.pls'):
		try:
			s = requests.session()
			page = s.get(url, timeout=15)
			data = page.content
			servers = [
				l.split('=')[1] for l in data.splitlines()
				if l.lower().startswith('file')
			]
		except:
			pass
	if servers:
		return random.choice(servers)
	return url

class tuneinGenreScreen(MPScreen):

	def __init__(self, session, subgenre="", url=""):
		self.subgenre = subgenre
		self.url = url

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok": self.keyOK,
			"0": self.closeAll,
			"up": self.keyUp,
			"down": self.keyDown,
			"right": self.keyRight,
			"left": self.keyLeft,
			"cancel": self.keyCancel,
			"green": self.keyAdd,
			"blue": self.keySetup,
		}, -1)

		self.keyLocked = True
		self['title'] = Label("TuneIn")
		self['ContentTitle'] = Label(_("Genre:"))
		self['F2'] = Label(_("Add to Favorites"))
		self['F4'] = Label(_("Setup"))

		self._items = []
		self.suchString = ''
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)
		self.onClose.append(self.restoreRadio)

	def loadPage(self):
		self._items = []
		self['name'].setText(_('Please wait...'))
		self.keyLocked = True
		if self.url:
			url = self.url
		else:
			url = "http://opml.radiotime.com/Browse.ashx"
		if "?" in url:
			url = url + "&render=json"
		else:
			url = url + "?render=json"
		twAgentGetPage(url, agent=agent, headers=json_headers).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		if self.subgenre != '':
			jsondata = json.loads(data)
			catname = ''
			for each in jsondata["body"]:
				if 'children' in each:
					if 'text' in each:
						catname = str(each["text"]) + ": "
					for item in each["children"]:
						if 'formats' in item:
							type = str(item["type"])
							name = str(item["text"])
							if "(" in name:
								name = name.split('(')[0].strip()
							title = name
							name = catname + name
							url = str(item["URL"])
							bitrate = str(item["bitrate"])
							format = str(item["formats"])
							if 'image' in item:
								image = str(item["image"])
							else:
								image = default_cover
							if not "notcompatible" in url:
								self._items.append((name, url, image, title, bitrate, format, type))
						else:
							type = str(item["type"])
							name = str(item["text"])
							title = name
							name = catname + name
							url = str(item["URL"])
							if 'image' in item:
								image = str(item["image"])
							else:
								image = default_cover
							if not "notcompatible" in url:
								self._items.append((name, url, image, title, '', '', type))
				elif 'formats' in each:
					type = str(each["type"])
					name = str(each["text"])
					if "(" in name:
						name = name.split('(')[0].strip()
					title = name
					if 'item' in each and self.subgenre == "search":
						catname = str(each["item"])
						if catname == "station":
							catname = _("Station:") + " "
						elif catname == "show":
							catname = _("Show:") + " "
						elif catname == "topic":
							catname = _("Topic:") + " "
						name = catname + name
					url = str(each["URL"])
					bitrate = str(each["bitrate"])
					format = str(each["formats"])
					if 'image' in each:
						image = str(each["image"])
					else:
						image = default_cover
					self._items.append((name, url, image, title, bitrate, format, type))
				else:
					type = str(each["type"])
					name = str(each["text"])
					title = name
					if 'item' in each and self.subgenre == "search":
						catname = str(each["item"])
						if catname == "station":
							catname = _("Station:") + " "
						elif catname == "show":
							catname = _("Show:") + " "
						elif catname == "topic":
							catname = _("Topic:") + " "
						name = catname + name
					if 'URL' in each:
						url = str(each["URL"])
						if 'image' in each:
							image = str(each["image"])
						else:
							image = default_cover
						if not "notcompatible" in url:
							self._items.append((name, url, image, title, '', '', type))
			if catname:
				self._setList('_defaultlistleft', True)
			else:
				self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		else:
			jsondata = json.loads(data)
			for each in jsondata["body"]:
				type = str(each["type"])
				name = str(each["text"])
				title = name
				url = str(each["URL"])
				self._items.append((name, url, default_cover, title, '', '', type))
			self._items.insert(0, (_("Search"), '', default_cover, '', '', '', "search"))
			self._items.insert(0, (_('Favorites'), '', default_cover, '', '', '', "favorites"))
			self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		if len(self._items) == 0:
			self._items.append((_('No contents / results found!'), '', default_cover, '', '', '', None))
			self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		self['name'].setText(self['liste'].getCurrent()[0][0])
		pic = self['liste'].getCurrent()[0][2]
		bitrate = self['liste'].getCurrent()[0][4]
		format = self['liste'].getCurrent()[0][5]
		CoverHelper(self['coverArt']).getCover(pic)
		if bitrate and format:
			self['handlung'].setText(_("Bitrate")+": "+bitrate+"\n"+_("Format")+": "+format)
			self['F2'].setText(_("Add to Favorites"))
		else:
			self['handlung'].setText('')
			self['F2'].setText('')

	def keyOK(self):
		if self.keyLocked:
			return
		Url = self['liste'].getCurrent()[0][1]
		Type = self['liste'].getCurrent()[0][6]
		if not Type:
			return
		elif Type == "link":
			self.session.open(tuneinGenreScreen, Type, Url)
		elif Type == "audio":
			url = Url
			if "?" in url:
				url = url + "&render=json"
			else:
				url = url + "?render=json"
			twAgentGetPage(url, agent=agent, headers=json_headers).addCallback(self.getStreamData).addErrback(self.dataError)
		elif Type == "favorites":
			self.session.open(tuneinFavoritesScreen)
		elif Type == "search":
			self.suchen()

	def keyAdd(self):
		stationName = self['liste'].getCurrent()[0][3]
		stationId = self['liste'].getCurrent()[0][1]
		if "?id=" in stationId:
			stationId = stationId.split('id=')[-1]
			if "&" in stationId:
				stationId = stationId.split('&')[0]
			if not stationId.startswith('s'):
				return
		else:
			return
		stationLogo = self['liste'].getCurrent()[0][2]
		if self.keyLocked or not stationId:
			return
		fn = config_mp.mediaportal.watchlistpath.value+"mp_tunein_playlist"
		if not fileExists(fn):
			open(fn, "w").close()
		try:
			writePlaylist = open(fn, "a")
			writePlaylist.write('"%s" "%s" "%s"\n' % (stationName, stationId, stationLogo))
			writePlaylist.close()
			message = self.session.open(MessageBoxExt, _("Selection was added to the favorites."), MessageBoxExt.TYPE_INFO, timeout=3)
		except:
			pass

	def getStreamData(self, data):
		title = self['liste'].getCurrent()[0][3]
		jsondata = json.loads(data)
		url = str(jsondata["body"][0]["url"])
		url = check_playlist(url)
		pic = self['liste'].getCurrent()[0][2]
		config_mp.mediaportal.is_radio.value = True
		self.session.open(SimplePlayer, [(title, url, pic)], showPlaylist=False, ltype='tunein', playerMode='RADIO', cover=True)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "Suche"
			self.suchString = callback
			url = "http://opml.radiotime.com/Search.ashx?query=" + urllib.parse.quote(self.suchString)
			self.session.open(tuneinGenreScreen, 'search', url)

	def keySetup(self):
		self.session.openWithCallback(self.setupCallback, tuneinSetupScreen, is_dialog=True)

	def setupCallback(self, answer=False):
		self.loadPage()

	def restoreRadio(self):
		config_mp.mediaportal.is_radio.value = False

class tuneinSetupScreen(MPSetupScreen, ConfigListScreenExt):

	def __init__(self, session):
		MPSetupScreen.__init__(self, session, skin='MP_PluginSetup')

		self['title'] = Label("TuneIn " + _("Setup"))
		self['F4'] = Label('')
		self.setTitle("Radio " + _("Setup"))

		self.list = []
		ConfigListScreenExt.__init__(self, self.list)

		self.list.append(getConfigListEntry(_("Sort Favorites:"), config_mp.mediaportal.tunein_sort))

		self["config"].setList(self.list)

		self["setupActions"] = ActionMap(["MP_Actions"],
		{
			"ok"    : self.keySave,
			"cancel": self.keyCancel
		}, -1)

	def keySave(self):
		for x in self["config"].list:
			if len(x) > 1:
				x[1].save()
		self.close(True)

class tuneinFavoritesScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"cancel": self.keyCancel,
			"red": self.keyDel
		}, -1)

		self.keyLocked = True
		self['title'] = Label("TuneIn")
		self['ContentTitle'] = Label(_("Favorites:"))
		self['F1'] = Label(_("Delete"))

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadStations)

	def loadStations(self):
		self._items = []
		if not fileExists(config_mp.mediaportal.watchlistpath.value+"mp_tunein_playlist"):
			open(config_mp.mediaportal.watchlistpath.value+"mp_tunein_playlist", "w").close()
		if fileExists(config_mp.mediaportal.watchlistpath.value+"mp_tunein_playlist"):
			path = config_mp.mediaportal.watchlistpath.value+"mp_tunein_playlist"

		if fileExists(path):
			readStations = open(path, "r")
			for rawData in readStations.readlines():
				data = MPfindall(self, '"(.*?)" "(.*?)" "(.*?)"', rawData, re.S)
				if data:
					(stationName, stationId, stationLogo) = data[0]
					self._items.append((stationName, stationId, stationLogo))
			if config_mp.mediaportal.tunein_sort.value:
				self._items.sort(key=lambda t : t[0].lower())
			readStations.close()
		if len(self._items) == 0:
			self._items.append((_('No entries found!'), None, default_cover))
		self._setList('_defaultlistleft', True)
		self.keyLocked = False
		self.showInfos()

	def keyOK(self):
		if self.keyLocked:
			return
		stationId = self['liste'].getCurrent()[0][1]
		if not stationId:
			return
		url = "http://opml.radiotime.com/Tune.ashx?id=%s&render=json" % stationId
		twAgentGetPage(url, agent=agent, headers=json_headers).addCallback(self.getStreamURL).addErrback(self.dataError)

	def showInfos(self):
		self['name'].setText(self['liste'].getCurrent()[0][0])
		pic = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(pic)

	def getStreamURL(self, data):
		title = self['liste'].getCurrent()[0][0]
		pic = self['liste'].getCurrent()[0][2]
		jsondata = json.loads(data)
		url = str(jsondata["body"][0]["url"])
		url = check_playlist(url)
		config_mp.mediaportal.is_radio.value = True
		self.session.open(SimplePlayer, [(title, url, pic)], showPlaylist=False, ltype='tunein', playerMode='RADIO', cover=True)

	def keyDel(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return

		i = self['liste'].getSelectedIndex()
		c = j = 0
		l = len(self._items)
		fn = config_mp.mediaportal.watchlistpath.value+"mp_tunein_playlist"
		try:
			f1 = open(fn, 'w')
			while j < l:
				if j != i:
					(stationName, stationId, stationLogo) = self._items[j]
					f1.write('"%s" "%s" "%s"\n' % (stationName, stationId, stationLogo))
				j += 1
			f1.close()
			self.loadStations()
		except:
			pass