﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.configlistext import ConfigListScreenExt

default_cover = "file://%s/radio.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
config_mp.mediaportal.radio_country = ConfigSelectionExt(default = "de", choices = [("de", _("Germany")), ("at", _("Austria")), ("fr", _("France")), ("es", _("Spain")), ("pt", _("Portugal")), ("it", _("Italy")), ("net", _("USA")), ("dk", _("Denmark")), ("se", _("Sweden")), ("pl", _("Poland"))])
config_mp.mediaportal.radio_sort = ConfigYesNo(default=True)
agent = "XBMC Addon Radio"

def check_playlist(url):
	servers = []
	if url.lower().endswith('.m3u'):
		try:
			s = requests.session()
			page = s.get(url, timeout=15)
			data = page.content
			servers = [
				l for l in data.splitlines()
				if l.strip() and not l.strip().startswith('#')
			]
		except:
			pass
	elif url.lower().endswith('.pls'):
		try:
			s = requests.session()
			page = s.get(url, timeout=15)
			data = page.content
			servers = [
				l.split('=')[1] for l in data.splitlines()
				if l.lower().startswith('file')
			]
		except:
			pass
	if servers:
		return random.choice(servers)
	return url

class RadioGenreScreen(MPScreen):

	def __init__(self, session):

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"blue": self.keySetup
		}, -1)

		self.keyLocked = True
		self['title'] = Label("Radio")
		self['ContentTitle'] = Label(_("Genre:"))
		self['F4'] = Label(_("Setup"))

		self._items = []
		self.suchString = ''
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)
		self.onClose.append(self.restoreRadio)

	def loadPage(self):
		country = config_mp.mediaportal.radio_country.value
		self._items = [
			(_('Favorites'), '', ''),
			(_('Search'), '', ''),
			(_('Local Stations'), "https://api.radio.%s/info/v2/search/localstations?sizeperpage=19&pageindex=" % country, ''),
			(_('Top Stations'), "https://api.radio.%s/info/v2/search/topstations?sizeperpage=250&pageindex=" % country, ''),
			(_('Genre'), "https://api.radio.%s/info/v2/search/getgenres" % country, 'stationsbygenre?genre=%%VALUE%%&sorttype=RANK&sizeperpage=19&pageindex='),
			(_('Topic'), "https://api.radio.%s/info/v2/search/gettopics" % country, 'stationsbytopic?topic=%%VALUE%%&sorttype=RANK&sizeperpage=19&pageindex='),
			(_('Country'), "https://api.radio.%s/info/v2/search/getcountries" % country, 'stationsbycountry?country=%%VALUE%%&sorttype=RANK&sizeperpage=19&pageindex='),
			(_('City'), "https://api.radio.%s/info/v2/search/getcities" % country, 'stationsbycity?city=%%VALUE%%&sorttype=RANK&sizeperpage=19&pageindex='),
			(_('Language'), "https://api.radio.%s/info/v2/search/getlanguages" % country, 'stationsbylanguage?language=%%VALUE%%&sorttype=RANK&sizeperpage=19&pageindex=')]
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		Genre = self['liste'].getCurrent()[0][0]
		Url = self['liste'].getCurrent()[0][1]
		SubUrl = self['liste'].getCurrent()[0][2]

		if Genre == _('Search'):
			self.suchen()
		elif Genre == _('Favorites'):
			self.session.open(RadioPlaylist)
		elif Genre == _("Top Stations") or Genre == _("Local Stations"):
			self.session.open(RadioListeScreen, Url)
		else:
			self.session.open(RadioSubValueGenreScreen, Genre, Url, SubUrl)


	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = _('Search')
			self.suchString = callback
			url = "https://api.radio.%s/info/v2/search/stations?query=%s&sizeperpage=19&pageindex=" % (config_mp.mediaportal.radio_country.value, urllib.parse.quote(self.suchString))
			self.session.open(RadioListeScreen, url)

	def keySetup(self):
		self.session.openWithCallback(self.setupCallback, RadioSetupScreen, is_dialog=True)

	def setupCallback(self, answer=False):
		self.loadPage()

	def restoreRadio(self):
		config_mp.mediaportal.is_radio.value = False

class RadioSetupScreen(MPSetupScreen, ConfigListScreenExt):

	def __init__(self, session):
		MPSetupScreen.__init__(self, session, skin='MP_PluginSetup')

		self['title'] = Label("Radio " + _("Setup"))
		self['F4'] = Label('')
		self.setTitle("Radio " + _("Setup"))

		self.list = []
		ConfigListScreenExt.__init__(self, self.list)

		self.list.append(getConfigListEntry(_("Region:"), config_mp.mediaportal.radio_country))
		self.list.append(getConfigListEntry(_("Sort Favorites:"), config_mp.mediaportal.radio_sort))

		self["config"].setList(self.list)

		self["setupActions"] = ActionMap(["MP_Actions"],
		{
			"ok"    : self.keySave,
			"cancel": self.keyCancel
		}, -1)

	def keySave(self):
		for x in self["config"].list:
			if len(x) > 1:
				x[1].save()
		self.close(True)

class RadioSubValueGenreScreen(MPScreen):

	def __init__(self, session, genre, url, suburl):
		self.genre = genre
		self.url = url
		self.suburl = suburl

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self.keyLocked = True
		self['title'] = Label("Radio")
		self['ContentTitle'] = Label(_(self.genre))

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		twAgentGetPage(self.url, agent=agent).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		jsondata = json.loads(data)
		for each in jsondata:
			title = str(each["localized"])
			if not title:
				title = str(each["systemEnglish"])
			val = str(each["systemEnglish"])
			self._items.append((title, val))
		self._items.sort(key=lambda t : t[0].lower())
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		Value = self['liste'].getCurrent()[0][1]
		self.session.open(RadioListeScreen, self.suburl, Value)

class RadioListeScreen(MPScreen):

	def __init__(self, session, url, value=None):
		self.url = url
		self.value = value

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"cancel": self.keyCancel,
			"green": self.keyAdd,
			"yellow" : self.keyPageNumber
		}, -1)

		self.keyLocked = True
		self['title'] = Label("Radio")
		self['ContentTitle'] = Label(_("Stations:"))
		self['F2'] = Label(_("Add to Favorites"))
		self['F3'].setText(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		if self.value:
			url = "https://api.radio.%s/info/v2/search/" % config_mp.mediaportal.radio_country.value + self.url.replace('%%VALUE%%', urllib.parse.quote(self.value)) + str(self.page)
		else:
			url = self.url + str(self.page)
		twAgentGetPage(url, agent=agent).addCallback(self.getStations).addErrback(self.dataError)

	def getStations(self, data):
		self._items = []
		jsondata = json.loads(data)
		if 'numberPages' in jsondata:
			self.lastpage = int(jsondata['numberPages'])
			if self.lastpage > 1:
				self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
			else:
				self['page'].setText('1 / 1')
		for each in jsondata["categories"][0]["matches"]:
			if 'logo300x300' in each:
				logo = str(each['logo300x300'])
			elif 'logo175x175' in each:
				logo = str(each['logo100x100']).replace('c175.png', 'c300.png')
			elif 'logo100x100' in each:
				logo = str(each['logo100x100']).replace('c100.png', 'c300.png')
			self._items.append((str(each['name']['value']).strip(), str(each['id']), logo))
		if len(self._items) == 0:
			self._items.append((_('No stations found!'), None, None))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		self['name'].setText(self['liste'].getCurrent()[0][0])
		stationId = self['liste'].getCurrent()[0][1]
		if stationId:
			url = "https://api.radio.%s/info/v2/search/station?station=%s" % (config_mp.mediaportal.radio_country.value, stationId)
			twAgentGetPage(url, agent=agent).addCallback(self.getInfos).addErrback(self.dataError)

	def keyOK(self):
		if self.keyLocked:
			return
		stationId = self['liste'].getCurrent()[0][1]
		if not stationId:
			return
		url = "https://api.radio.%s/info/v2/search/station?station=%s" % (config_mp.mediaportal.radio_country.value, stationId)
		twAgentGetPage(url, agent=agent).addCallback(self.getStreamURL).addErrback(self.dataError)

	def getInfos(self, data):
		jsondata = json.loads(data)
		image = str(jsondata['logo300x300'])
		CoverHelper(self['coverArt']).getCover(image)
		genre = ''
		for node in jsondata["genres"]:
			genre = genre + ", " + str(node)
		genre = genre.strip(', ')
		if genre == "":
			genre = "---"
		city = str(jsondata["city"])
		if city == "":
			city = "---"
		country = str(jsondata["country"])
		if country == "":
			country = "---"
		descr = str(jsondata["shortDescription"])
		self['handlung'].setText(_("Genre:")+" "+genre+"\n"+_("Country")+": "+country+"\n"+_("City")+": "+city+"\n"+descr)

	def getStreamURL(self, data):
		jsondata = json.loads(data)
		url = str(jsondata['streamUrls'][0]['streamUrl'])
		url = check_playlist(url)
		stationName = self['liste'].getCurrent()[0][0]
		stationCover = str(jsondata['logo300x300'])
		config_mp.mediaportal.is_radio.value = True
		self.session.open(SimplePlayer, [(stationName, url, stationCover)], showPlaylist=False, ltype='radio', playerMode='RADIO', cover=True)

	def keyAdd(self):
		stationName = self['liste'].getCurrent()[0][0]
		stationId = self['liste'].getCurrent()[0][1]
		if self.keyLocked or not stationId:
			return
		fn = config_mp.mediaportal.watchlistpath.value+"mp_radio_playlist"
		if not fileExists(fn):
			open(fn, "w").close()
		try:
			writePlaylist = open(fn, "a")
			writePlaylist.write('"%s" "%s"\n' % (stationName, stationId))
			writePlaylist.close()
			message = self.session.open(MessageBoxExt, _("Selection was added to the favorites."), MessageBoxExt.TYPE_INFO, timeout=3)
		except:
			pass

class RadioPlaylist(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"cancel": self.keyCancel,
			"red": self.keyDel
		}, -1)

		self.keyLocked = True
		self['title'] = Label("Radio")
		self['ContentTitle'] = Label(_("Favorites:"))
		self['F1'] = Label(_("Delete"))

		self.playList = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadStations)

	def loadStations(self):
		self.playList = []
		if not fileExists(config_mp.mediaportal.watchlistpath.value+"mp_radio_playlist"):
			open(config_mp.mediaportal.watchlistpath.value+"mp_radio_playlist", "w").close()
		if fileExists(config_mp.mediaportal.watchlistpath.value+"mp_radio_playlist"):
			path = config_mp.mediaportal.watchlistpath.value+"mp_radio_playlist"

		if fileExists(path):
			readStations = open(path, "r")
			for rawData in readStations.readlines():
				data = MPfindall(self, '"(.*?)" "(.*?)"', rawData, re.S)
				if data:
					(stationName, stationId) = data[0]
					self.playList.append((stationName, stationId))
			if config_mp.mediaportal.radio_sort.value:
				self.playList.sort(key=lambda t : t[0].lower())
			readStations.close()
		if len(self.playList) == 0:
			self.playList.append((_('No entries found!'), None, default_cover))
		self.ml.setList(list(map(self._defaultlistleft, self.playList)))
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		exist = self["liste"].getCurrent()
		if exist:
			self['name'].setText(self['liste'].getCurrent()[0][0])
			stationId = self['liste'].getCurrent()[0][1]
			url = "https://api.radio.%s/info/v2/search/station?station=%s" % (config_mp.mediaportal.radio_country.value, stationId)
			twAgentGetPage(url, agent=agent).addCallback(self.getInfos).addErrback(self.dataError)

	def keyOK(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		stationId = self['liste'].getCurrent()[0][1]
		url = "https://api.radio.%s/info/v2/search/station?station=%s" % (config_mp.mediaportal.radio_country.value, stationId)
		twAgentGetPage(url, agent=agent).addCallback(self.getStreamURL).addErrback(self.dataError)

	def getInfos(self, data):
		jsondata = json.loads(data)
		image = str(jsondata['logo300x300'])
		CoverHelper(self['coverArt']).getCover(image)
		genre = ''
		for node in jsondata["genres"]:
			genre = genre + ", " + str(node)
		genre = genre.strip(', ')
		if genre == "":
			genre = "---"
		city = str(jsondata["city"])
		if city == "":
			city = "---"
		country = str(jsondata["country"])
		if country == "":
			country = "---"
		descr = str(jsondata["shortDescription"])
		self['handlung'].setText(_("Genre:")+" "+genre+"\n"+_("Country")+": "+country+"\n"+_("City")+": "+city+"\n"+descr)

	def getStreamURL(self, data):
		jsondata = json.loads(data)
		url = str(jsondata['streamUrls'][0]['streamUrl'])
		url = check_playlist(url)
		stationName = self['liste'].getCurrent()[0][0]
		stationCover = str(jsondata['logo300x300'])
		config_mp.mediaportal.is_radio.value = True
		self.session.open(SimplePlayer, [(stationName, url, stationCover)], showPlaylist=False, ltype='radio', playerMode='RADIO', cover=True)

	def keyDel(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return

		i = self['liste'].getSelectedIndex()
		c = j = 0
		l = len(self.playList)
		fn = config_mp.mediaportal.watchlistpath.value+"mp_radio_playlist"
		try:
			f1 = open(fn, 'w')
			while j < l:
				if j != i:
					(stationName, stationId) = self.playList[j]
					f1.write('"%s" "%s"\n' % (stationName, stationId))
				j += 1
			f1.close()
			self.loadStations()
		except:
			pass