﻿# -*- coding: utf-8 -*-
from builtins import map
from os.path import exists
import base64
from ...plugin import _
from ...resources.imports import *
from .youtube import YT_ListScreen
default_cover = "file://%s/youtube.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class show_USER_Genre(MPScreen):

	def __init__(self, session):

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"	: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"green"	: self.keyGreen
		}, -1)

		self['title'] = Label("YouTube")
		self['ContentTitle'] = Label(_("User Channels"))
		self['name'] = Label(_("Selection:"))
		self['F2'] = Label(_("Load"))

		self.user_path = config_mp.mediaportal.watchlistpath.value + "mp_userchan.xml"
		self.show_help = config_mp.mediaportal.show_userchan_help.value
		self.keyLocked = True
		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		if not exists(self.user_path):
			self.getUserFile(fInit=True)

		if self.show_help:
			self._items.append((_("With this extension you can add your favorite YouTube channels themselves."), ""))
			self._items.append(("", ""))
			self._items.append((_("For each channel, only two entries are added:"), ""))
			self._items.append((_("'<name> channel name </name>' and '<user> owner name </user>'"), ""))
			self._items.append(("", ""))
			self._items.append((_("With the 'Green' button the user file:"), ""))
			self._items.append((_("'%s' is loaded.") % self.user_path, ""))
			self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		else:
			self.getUserFile()

	def getUserFile(self, fInit=False):
		fname = mp_globals.pluginPath + "/resources/mp_userchan.xml"
		try:
			if fInit:
				shutil.copyfile(fname, self.user_path)
				return
			fp = open(self.user_path)
			data = fp.read()
			fp.close()
		except IOError as e:
			self._items = []
			self._items.append((str(e), ""))
			self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		else:
			clist = MPfindall(self, '<name>(.*?)</name>.*?<user>(.*?)</user>', data, re.S)
			self._items = []
			if clist:
				for (name, user) in clist:
					if base64.b64decode("VUM0dGVPeVFOWHpNSDk0WU1ZeVNsOW1B") in user:
						continue
					else:
						self._items.append((name.strip(), '/'+user.strip()))
				self.keyLocked = False
			else:
				self._items.append((_("No channels found!"), ""))
			self.ml.setList(list(map(self._defaultlistcenter, self._items)))

	def keyGreen(self):
		self.getUserFile()

	def keyOK(self):
		if self.keyLocked:
			return

		genre = self['liste'].getCurrent()[0][0]
		stvLink = self['liste'].getCurrent()[0][1]
		if stvLink == '/':
			return
		url = "gdata.youtube.com/feeds/api/users"+stvLink+"/uploads?"
		mp_globals.activeIcon = "youtube"
		self.session.open(YT_ListScreen, url, genre, title="YouTube")