from Components.Converter.Converter import Converter
from Components.Element import cached, ElementError
from Tools.Directories import fileExists
from Tools.LoadPixmap import LoadPixmap
from Plugins.Extensions.MediaPortal.resources import mp_globals

class MPValueToPixmap(Converter, object):
        LANGUAGE_CODE = 0
        PATH = 1

        def __init__(self, type):
                Converter.__init__(self, type)
                if type == "LanguageCode":
                        self.type = self.LANGUAGE_CODE
                elif type == "Path":
                        self.type = self.PATH
                else:
                        raise ElementError("'%s' is not <LanguageCode|Path> for MPValueToPixmap converter" % type)

        @cached
        def getPixmap(self):
                if self.source is not None:
                        val = self.source.text
                        if val in (None, ""):
                                return None
                if self.type == self.PATH:
                        return LoadPixmap(val)
                if self.type == self.LANGUAGE_CODE:
                        code = val[3:].upper()
			skin_path = mp_globals.pluginPath + mp_globals.skinsPath
			filepath = "%s/%s/images/countries/%s.png" % (skin_path, mp_globals.currentskin, code)
			if not fileExists(filepath):
				filepath = "%s/%s/images/countries/%s.png" % (skin_path, mp_globals.skinFallback, code)
				if not fileExists(filepath):
					filepath = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/countries/%s.png" % code
                        flag = LoadPixmap(cached=False, path=filepath)
                        return flag
                return None

        pixmap = property(getPixmap)