﻿# -*- coding: utf-8 -*-
from __future__ import print_function
from __future__ import absolute_import
from future import standard_library
standard_library.install_aliases()
from builtins import map
from builtins import range
from builtins import object
from ..plugin import _
from .imports import *
from .keyboardext import VirtualKeyBoardExt
from Tools.BoundFunction import boundFunction
import queue
import threading
from .coverhelper import CoverHelper
from .messageboxext import MessageBoxExt
from .twagenthelper import twDownloadPage
from twisted.web.client import HTTPConnectionPool
from PIL import Image
from . import imagesize

screenList = []

watched = None
watched_grid = None
star = None
star_grid = None
red = None
red_grid = None

class SearchHelper(object):

	def __init__(self):
		self.lastSearchNum = -1
		self.searchKey = None
		self["suchtitel"] = Label(_("Search char."))
		self["suchhinweis"] = Label(_("A-Z search"))
		self["suche"] = Label("")
		self["bg_search"] = Label("")
		self["suche"].hide()
		self["suchtitel"].hide()
		self["suchhinweis"].hide()
		self["bg_search"].hide()

		self.numericalTextInput = NumericalTextInputExt()
		self.numericalTextInput.setUseableChars(u'1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ')
		self.numericalTextInput.timer_conn = self.numericalTextInput.timer.timeout.connect(self.doSearch)

		self["search_numberactions"] = NumberActionMap(["MP_NumberActions"], {
			"1": self.goToNumber,
			"2": self.goToNumber,
			"3": self.goToNumber,
			"4": self.goToNumber,
			"5": self.goToNumber,
			"6": self.goToNumber,
			"7": self.goToNumber,
			"8": self.goToNumber,
			"9": self.goToNumber
		}, -2)

		self["search_keyactions"] = ActionMap(["MP_KeyActions"], {
			"0": boundFunction(self.goToLetter, "0"),
			"1": boundFunction(self.goToLetter, "1"),
			"2": boundFunction(self.goToLetter, "2"),
			"3": boundFunction(self.goToLetter, "3"),
			"4": boundFunction(self.goToLetter, "4"),
			"5": boundFunction(self.goToLetter, "5"),
			"6": boundFunction(self.goToLetter, "6"),
			"7": boundFunction(self.goToLetter, "7"),
			"8": boundFunction(self.goToLetter, "8"),
			"9": boundFunction(self.goToLetter, "9"),
			"a": boundFunction(self.goToLetter, "a"),
			"b": boundFunction(self.goToLetter, "b"),
			"c": boundFunction(self.goToLetter, "c"),
			"d": boundFunction(self.goToLetter, "d"),
			"e": boundFunction(self.goToLetter, "e"),
			"f": boundFunction(self.goToLetter, "f"),
			"g": boundFunction(self.goToLetter, "g"),
			"h": boundFunction(self.goToLetter, "h"),
			"i": boundFunction(self.goToLetter, "i"),
			"j": boundFunction(self.goToLetter, "j"),
			"k": boundFunction(self.goToLetter, "k"),
			"l": boundFunction(self.goToLetter, "l"),
			"m": boundFunction(self.goToLetter, "m"),
			"n": boundFunction(self.goToLetter, "n"),
			"o": boundFunction(self.goToLetter, "o"),
			"p": boundFunction(self.goToLetter, "p"),
			"q": boundFunction(self.goToLetter, "q"),
			"r": boundFunction(self.goToLetter, "r"),
			"s": boundFunction(self.goToLetter, "s"),
			"t": boundFunction(self.goToLetter, "t"),
			"u": boundFunction(self.goToLetter, "u"),
			"v": boundFunction(self.goToLetter, "v"),
			"w": boundFunction(self.goToLetter, "w"),
			"x": boundFunction(self.goToLetter, "x"),
			"y": boundFunction(self.goToLetter, "y"),
			"z": boundFunction(self.goToLetter, "z"),
			"space": boundFunction(self.goToLetter, " "),
			"back": boundFunction(self.goToLetter, "")
		}, -3)

	def goToNumber(self, num):
		pass

	def goToLetter(self, key):
		pass

	def showSearchkey(self, num):
		self.searchKey = self.numericalTextInput.mapping[num][self.numericalTextInput.pos]
		self['suche'].setText(str(self.searchKey))
		if self.lastSearchNum == -1:
			self['suche'].show()
			self["suchtitel"].show()
			self["bg_search"].show()
		self.lastSearchNum = num

	def showSearchWord(self):
		self['suche'].setText(str(self.keyword))
		self['suche'].show()
		self["suchtitel"].show()
		self["bg_search"].show()

	def doSearch(self):
		self.lastSearchNum = -1
		self['suche'].hide()
		self["suchtitel"].hide()
		self["bg_search"].hide()
		self.showInfos()

class MPSetupScreen(Screen):

	def __init__(self, session, parent=None, skin=None, default_cover='file:///usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/default_cover.png', *ret_args):
		self.default_cover = default_cover
		self.skinmsg = ''
		if skin:
			self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
			path = "%s/%s/%s.xml" % (self.skin_path, mp_globals.currentskin, skin)
			if not fileExists(path):
				path = self.skin_path + mp_globals.skinFallback + "/%s.xml" % skin
				self.skinmsg = skin
			with open(path, "r") as f:
				self.skin = f.read()
				f.close()

		self.skinName = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(32)])

		Screen.__init__(self, session, parent)
		screenList.append((self, ret_args))

		self.onFirstExecBegin.append(self.skinMessage)
		self.onFirstExecBegin.append(self.loadDisplayCover)
		self.onFirstExecBegin.append(self.skinMessage)

	def loadDisplayCover(self):
		self.summaries.updateCover(self.default_cover)

	def skinMessage(self):
		if self.skinmsg != '':
			self.session.open(MessageBoxExt, _("Mandatory skin file %s is missing!" % self.skinmsg), MessageBoxExt.TYPE_ERROR)

	def createSummary(self):
		return MPScreenSummary

class MPScreen(Screen, HelpableScreen):

	def __init__(self, session, parent=None, skin=None, widgets=None, default_cover='file:///usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/default_cover.png', grid_referer=None, *ret_args):

		global watched
		watched = None
		global watched_grid
		watched_grid = None
		global star
		star = None
		global star_grid
		star_grid = None
		global red
		red = None
		global red_grid
		red_grid = None

		self.default_cover = default_cover
		self.grid_referer = grid_referer
		self.skinmsg = ''
		if skin:
			self.skin_path = mp_globals.pluginPath + mp_globals.skinsPath
			path = "%s/%s/%s.xml" % (self.skin_path, mp_globals.currentskin, skin)
			if not fileExists(path):
				path = self.skin_path + mp_globals.skinFallback + "/%s.xml" % skin
				self.skinmsg = skin
			with open(path, "r") as f:
				self.skin = f.read()
				f.close()

			if widgets:
				self.skin = self.skin.replace('</screen>', '')
				for wf in widgets:
					path = "%s/%s/%s.xml" % (self.skin_path, mp_globals.currentskin, wf)
					if not fileExists(path):
						path = self.skin_path + mp_globals.skinFallback + "/%s.xml" % wf
						self.skinmsg = wf
					f = open(path, "r")
					for widget in f:
						self.skin += widget
					f.close()
				self.skin += '</screen>'

		self.skinName = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(32)])

		Screen.__init__(self, session, parent)
		screenList.append((self, ret_args))
		self["hidePig"] = Boolean()
		self["hidePig"].setBoolean(config_mp.mediaportal.minitv.value)
		self["mp_specActions"]  = ActionMap(["MP_SpecialActions"], {
			"specTv": self.mp_showHide
		}, -2)

		self["mp_specActions2"] = HelpableActionMap(self, "MP_SpecialActions", {
			"specTmdb" : (self.mp_tmdb, _("Show TMDb info"))
		}, -1)

		self["MP_Actions"] = HelpableActionMap(self, "MP_Actions", {
			"5" : (self.keySwitchGrid, _("Switch list mode")),
			"deleteBackward" : (self.keyTxtPageUp, _("Scroll description backward")),
			"deleteForward"  : (self.keyTxtPageDown, _("Scroll description forward"))
		}, -1)

		HelpableScreen.__init__(self)

		self['title'] = Label("")
		self['ContentTitle'] = Label("")
		self['name'] = Label("")
		self['F1'] = Label("")
		self['F2'] = Label("")
		self['F3'] = Label("")
		self['F4'] = Label("")
		if mp_globals.model in ["one", "two", "dm900", "dm920", "dm7080", "dm820"]:
			self['coverArt'] = PixmapExt()
		else:
			self['coverArt'] = Pixmap()
		self['Page'] = Label("")
		self['page'] = Label("")
		self['handlung'] = ScrollLabel("")
		self['extrainfo'] = Label("")

		self.filmQ = queue.Queue(0)
		self.hanQ = queue.Queue(0)
		self.picQ = queue.Queue(0)
		self.updateP = 0
		self.eventL = threading.Event()
		self.eventP = threading.Event()

		scale = AVSwitch().getFramebufferScale()
		self._picload = ePicLoad()
		self._picload.setPara((mp_globals.plugin_grid_pixmapwidth, mp_globals.plugin_grid_pixmapheight, scale[0], scale[1], False, 1, '#FF000000'))
		self._picload_conn = self._picload.PictureData.connect(self._onDefaultPixmapReady)

		self.pool = HTTPConnectionPool(reactor)
		self.deferreds = []
		if mp_globals.model in ["one", "two", "dm900", "dm920"]:
			tokens = 10
		else:
			tokens = 4
		self._cachingDeferred = defer.DeferredSemaphore(tokens=tokens)
		self._defaultPixmap = None
		self._picloads = {}
		self._picload_conns = {}
		self._picload_result = {}
		self._loadDefaultPixmap()
		self._pixmapCache = {}
		self._currentEntry = 0
		self._endEntry = 0
		self._items = []
		self.buildfunc = ''
		self.gridview = False
		self.gridmode = 'list'
		self.gridvalidate = False
		if mp_globals.model in ["one", "two", "dm900", "dm920", "dm7080", "dm820"]:
			self.gridswitch = config_mp.mediaportal.plugin_viewmode.value
		else:
			self.gridswitch = False

		self.langoffset = 0
		self.keyword = ''
		self.keyLocked = False
		self.keytimer = eTimer()
		self.keytimer_conn = self.keytimer.timeout.connect(self.cleankeyword)

		self.onLayoutFinish.append(self._animation)
		self.onLayoutFinish.append(self.loadDefaultCover)
		self.onFirstExecBegin.append(self.loadDisplayCover)
		self.onFirstExecBegin.append(self.skinMessage)

		self.onClose.append(self._deferCanceler)

	def _deferCanceler(self):
		for items in self.deferreds:
			items.cancel()

	def _setList(self, buildfunc='_defaultlistleft', validateCache=False, mode='grid'):
		self.buildfunc = buildfunc
		self.gridvalidate = validateCache
		self.gridmode = mode
		if mode == 'list':
			self.gridswitch = False
		exec("self.ml.setList(list(map(self."+buildfunc+", self._items)))")
		if validateCache and self.gridswitch and mp_globals.model in ["one", "two", "dm900", "dm920", "dm7080", "dm820"]:
			self.validateCache(True)

	def validateCache(self, clear=False):
		if not self.ml.instance:
			return
		if clear:
			self._pixmapCache = {}
		self._currentEntry = -1
		self._endEntry = len(self._items) - 1
		printl('currentEntry: '+str(self._currentEntry)+' _endEntry: '+str(self._endEntry), self, "H")
		if self._endEntry < 400:
			self._nextForCache()

	def _nextForCache(self):
		self._currentEntry += 1
		if self._currentEntry > self._endEntry:
			return
		printl('currentEntry: '+str(self._currentEntry)+' _endEntry: '+str(self._endEntry), self, "H")
		if self._currentEntry < len(self._items):
			entry = self._items[self._currentEntry]
			if len(entry) > 2 and entry[2] and entry[2].startswith('http'):
				item = self._items[self._currentEntry][2]
				self._loadPixmapForCache(self._currentEntry, item)
			else:
				self._nextForCache()

	def _loadPixmapForCache(self, index, url):
		d = self._cachingDeferred.run(twDownloadPage, url, '/tmp/.gridIcon%s' % str(index), pool=self.pool, grid_referer=self.grid_referer).addCallback(self._onDownloadPageBody, index, url).addErrback(self._errorPixmapForCache, index)
		self.deferreds.append(d)
		self._nextForCache()

	def _onDownloadPageBody(self, data, index, url):
		width, height = imagesize.get('/tmp/.gridIcon%s' % str(index))
		if width > 1920:
			printl('Large picture! Resizing .gridIcon%s' % str(index), self, "W")
			im = Image.open('/tmp/.gridIcon%s' % str(index)).convert('RGB')
			im.thumbnail((mp_globals.plugin_grid_pixmapwidth, mp_globals.plugin_grid_pixmapheight), Image.NEAREST)
			im.save('/tmp/.gridIcon%s' % str(index), "JPEG")
		reactor.callFromThread(boundFunction(self._gotPixmapForCache, index, url))

	def _gotPixmapForCache(self, index, url):
		callback = boundFunction(self._decodedPixmapForCache, index, url)
		scale = AVSwitch().getFramebufferScale()
		self._picloads[index] = ePicLoad()
		self._picloads[index].setPara((mp_globals.plugin_grid_pixmapwidth, mp_globals.plugin_grid_pixmapheight, scale[0], scale[1], False, 1, '#FF000000'))
		self._picload_conns[index] = self._picloads[index].PictureData.connect(callback)
		self._picload_result[index] = self._picloads[index].startDecode('/tmp/.gridIcon%s' % str(index))
		if self._picload_result[index]:
			printl('Failed loading image .gridIcon%s!' % str(index), self, "W")
			self._pixmapCache[url] = self._defaultPixmap
			try:
				exec("self._setList('"+self.buildfunc+"', False)")
			except Exception as e:
				printl(e, self, "E")
			del self._picloads[index]
			del self._picload_conns[index]

	def _decodedPixmapForCache(self, index, url, picInfo=None):
		ptr = self._picloads[index].getData()
		if ptr != None:
			self._pixmapCache[url] = ptr
		try:
			exec("self._setList('"+self.buildfunc+"', False)")
		except Exception as e:
			printl(e, self, "E")
		del self._picloads[index]
		del self._picload_conns[index]
		file = '/tmp/.gridIcon%s' % str(index)
		if fileExists(file):
			BgFileEraser = eBackgroundFileEraser.getInstance()
			BgFileEraser.erase(file)

	def _errorPixmapForCache(self, error, index):
		printl(error, self, "H")

	def _loadDefaultPixmap(self):
		self._picload.startDecode(self.default_cover.replace('file://', ''))

	def _onDefaultPixmapReady(self, picInfo=None):
		self._defaultPixmap = self._picload.getData()

	def keySwitchGrid(self):
		if not self.buildfunc:
			return
		if not mp_globals.model in ["one", "two", "dm900", "dm920", "dm7080", "dm820"]:
			return
		if self.gridswitch:
			self.gridswitch = False
		else:
			self.gridswitch = True
		self._setList(self.buildfunc, self.gridvalidate, self.gridmode)

	def skinMessage(self):
		if self.skinmsg != '':
			self.session.open(MessageBoxExt, _("Mandatory skin file %s is missing!" % self.skinmsg), MessageBoxExt.TYPE_ERROR)

	def loadDisplayCover(self):
		self.summaries.updateCover(self.default_cover)

	def loadDefaultCover(self):
		CoverHelper(self['coverArt']).getCover(self.default_cover)

	def _animation(self):
		#try:
			#self['title'].instance.setShowHideAnimation(config_mp.mediaportal.animation_label.value)
			#self['ContentTitle'].instance.setShowHideAnimation(config_mp.mediaportal.animation_label.value)
			#self['name'].instance.setShowHideAnimation(config_mp.mediaportal.animation_label.value)
			#self['coverArt'].instance.setShowHideAnimation(config_mp.mediaportal.animation_coverart.value)
		#except:
			pass

	def mp_showHide(self):
		if not mp_globals.mp_hide:
			mp_globals.mp_hide = True
			self.hide()
			self.session.nav.playService(mp_globals.lastservice)
			self.summaries.updateCover(None)
		else:
			mp_globals.mp_hide = False
			self.show()
			if config_mp.mediaportal.restorelastservice.value == "1" and not config_mp.mediaportal.backgroundtv.value:
				self.session.nav.playService(mp_globals.lastservice)
			else:
				self.session.nav.stopService()
			self.summaries.updateCover(self.default_cover)

	def close(self, *args):
		if mp_globals.mp_hide:
			return
		Screen.close(self, *args)
		from . import coverhelper
		coverhelper.glob_last_crossfade = ''
		if len(screenList):
			screenList.pop()

	def mp_close(self, *args):
		Screen.close(self, *args)
		from . import coverhelper
		coverhelper.glob_last_crossfade = ''

	def showInfos(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return
		title = self['liste'].getCurrent()[0][0]
		if not re.match('.*?---------------', title):
			if not re.match('.*?———————————————', title):
				self['name'].setText(title)
			else:
				self['name'].setText('')
		else:
			self['name'].setText('')

	def mp_tmdb(self):
		if mp_globals.mp_hide:
			return
		if self.keyLocked:
			return
		from .tmdb import MediaPortalTmdbScreen
		try:
			movie_title = self['liste'].getCurrent()[0][0]
			self.session.open(MediaPortalTmdbScreen, movie_title)
		except:
			try:
				movie_title = self.thumbfilmliste[self.section * self.thumbsC + self.index][0]
				self.session.open(MediaPortalTmdbScreen, movie_title)
			except:
				pass

	def loadPageQueued(self, headers={}):
		self['name'].setText(_('Please wait...'))
		while not self.filmQ.empty():
			url = self.filmQ.get_nowait()
		twAgentGetPage(url, headers=headers).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPic(self):
		if self.picQ.empty():
			self.eventP.clear()
			return
		while not self.picQ.empty():
			self.picQ.get_nowait()
		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		streamPic = self['liste'].getCurrent()[0][2]
		self.showInfos()
		self.updateP = 1
		CoverHelper(self['coverArt'], self.ShowCoverFileExit).getCover(streamPic)

	def ShowCoverFileExit(self):
		self.updateP = 0;
		self.keyLocked	= False
		if not self.filmQ.empty():
			self.loadPageQueued()
		else:
			self.eventL.clear()
			self.loadPic()

	def loadPicQueued(self):
		self.picQ.put(None)
		if not self.eventP.is_set():
			self.eventP.set()
		self.loadPic()

	def getLastPage(self, data, paginationregex, pageregex='.*>(\d+)<'):
		if paginationregex == '':
			lastp = re.search(pageregex, data, re.S)
			if lastp:
				lastp = lastp.group(1).replace(",", "").replace('.', '').replace(' ', '').strip()
				self.lastpage = int(lastp)
			else:
				self.lastpage = 1
		else:
			lastpparse = re.search(paginationregex, data, re.S)
			if lastpparse:
				lastp = re.search(pageregex, lastpparse.group(1), re.S)
				if lastp:
					lastp = lastp.group(1).replace(",", "").replace('.', '').replace(' ', '').strip()
					self.lastpage = int(lastp)
				else:
					self.lastpage = 1
			else:
				self.lastpage = 1
		self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))

	def keyPageNumber(self):
		if mp_globals.mp_hide:
			return
		self.session.openWithCallback(self.callbackkeyPageNumber, VirtualKeyBoardExt, title = (_("Enter page number")), text = str(self.page), is_dialog=True)

	def callbackkeyPageNumber(self, answer):
		if answer is not None:
			answer = re.findall('\d+', answer)
		else:
			return
		if answer:
			if int(answer[0]) < self.lastpage + 1:
				self.page = int(answer[0])
				self.loadPage()
			else:
				self.page = self.lastpage
				self.loadPage()

	def suchen(self, auto_text_init=False, suggest_func=None):
		if mp_globals.mp_hide:
			return
		self.session.openWithCallback(self.SuchenCallback, VirtualKeyBoardExt, title = (_("Enter search criteria")), text = self.suchString, is_dialog=True, auto_text_init=auto_text_init, suggest_func=suggest_func)

	def keyUpRepeated(self):
		if mp_globals.mp_hide:
			return
		if self.keyLocked:
			return
		self['liste'].up()

	def keyDownRepeated(self):
		if mp_globals.mp_hide:
			return
		if self.keyLocked:
			return
		self['liste'].down()

	def keyLeftRepeated(self):
		if mp_globals.mp_hide:
			return
		if self.keyLocked:
			return
		self['liste'].pageUp()

	def keyRightRepeated(self):
		if mp_globals.mp_hide:
			return
		if self.keyLocked:
			return
		self['liste'].pageDown()

	def key_repeatedUp(self):
		if mp_globals.mp_hide:
			return
		if self.keyLocked:
			return
		self.loadPicQueued()

	def keyPageDown(self):
		if mp_globals.mp_hide:
			return
		if self.keyLocked:
			return
		if not self.page < 2:
			self.page -= 1
			self.loadPage()

	def keyPageUp(self):
		if mp_globals.mp_hide:
			return
		if self.keyLocked:
			return
		if self.page < self.lastpage:
			self.page += 1
			self.loadPage()

	def keyLeft(self):
		if mp_globals.mp_hide:
			return
		if self.keyLocked:
			return
		if self.gridswitch:
			self['liste'].instance.moveSelection(self['liste'].instance.moveLeft)
		else:
			self['liste'].pageUp()
		self.showInfos()

	def keyRight(self):
		if mp_globals.mp_hide:
			return
		if self.keyLocked:
			return
		if self.gridswitch:
			self['liste'].instance.moveSelection(self['liste'].instance.moveRight)
		else:
			self['liste'].pageDown()
		self.showInfos()

	def keyUp(self):
		if mp_globals.mp_hide:
			return
		if self.keyLocked:
			return
		self['liste'].up()
		self.showInfos()

	def keyDown(self):
		if mp_globals.mp_hide:
			return
		if self.keyLocked:
			return
		self['liste'].down()
		self.showInfos()

	def keyTxtPageUp(self):
		if mp_globals.mp_hide:
			return
		self['handlung'].pageUp()

	def keyTxtPageDown(self):
		if mp_globals.mp_hide:
			return
		self['handlung'].pageDown()

	def keyCancel(self):
		if mp_globals.mp_hide:
			return
		self.close()

	def keyLetterGlobal(self, key, list):
		if key == "":
			self.keyword = self.keyword[:-1]
		else:
			self.keyword = self.keyword + key

		self.showSearchWord()
		self.getListIndex(self.keyword, list)
		self.keytimer.start(1500, 1)

	def cleankeyword(self):
		self.keyword = ''
		self.doSearch()

	def keyNumberGlobal(self, key, list):
		unichar = self.numericalTextInput.getKey(key)
		charstr = unichar.encode("utf-8")
		if len(charstr) == 1:
			print("keyNumberGlobal:", charstr[0])
			self.getListIndex(charstr[0], list)

	def getListIndex(self, letter, list):
		if len(list) > 0:
			countIndex = -1
			found = False
			for x in list:
				countIndex += 1
				f = len(letter)
				if f == 1:
					if x[0][0].lower() == letter.lower():
						found = True
						break
				elif f > 1:
					if x[0][:f].lower() == letter.lower():
						found = True
						break
					elif letter.lower() in x[0].lower():
						found = True
						break
			print("index:", countIndex)
			if found:
				self['liste'].moveToIndex(countIndex)

	def dataError(self, error):
		from .debuglog import printl
		printl(error, self, "E")

	@staticmethod
	def closeAll():
		if mp_globals.mp_hide:
			return
		i = len(screenList)
		while i > 0:
			screen, args = screenList.pop()
			screen.mp_close(*args)
			i -= 1

	def createSummary(self):
		return MPScreenSummary

####### defaults

	def _defaultlistleft(self, entry):
		if self.gridswitch and (self.gridview or (len(entry) > 2 and entry[2] and entry[2].startswith('http'))):
			self.gridview = True
			self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_grid_fontsize))
			self['liste'].instance.setMode(eListbox.layoutGrid)
			self['liste'].instance.setItemHeight(mp_globals.plugin_grid_itemheight)
			self['liste'].instance.setItemWidth(mp_globals.plugin_grid_itemwidth)
			self['liste'].instance.setBackgroundPicture(mp_globals.plugin_grid_backgroundpicture)
			self['liste'].instance.setSelectionPicture(mp_globals.plugin_grid_selectionpicture)
			self['liste'].instance.setMargin(ePoint(mp_globals.plugin_grid_margin_x,mp_globals.plugin_grid_margin_y))
			pixmap = self._pixmapCache.get(entry[2], self._defaultPixmap)
			res = [entry]
			res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_grid_pixmapmargin_x, mp_globals.plugin_grid_pixmapmargin_y, mp_globals.plugin_grid_pixmapwidth, mp_globals.plugin_grid_pixmapheight, pixmap))
			res.append((eListboxPythonMultiContent.TYPE_TEXT, mp_globals.plugin_grid_textmargin_x, mp_globals.plugin_grid_textmargin_y, mp_globals.plugin_grid_textwidth, mp_globals.plugin_grid_textheight, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER | RT_WRAP, entry[0]))
		else:
			self['liste'].instance.setMode(eListbox.layoutVertical)
			self['liste'].instance.setItemHeight(mp_globals.plugin_list_itemheight)
			if mp_globals.plugin_list_backgroundpicture:
				self['liste'].instance.setBackgroundPicture(mp_globals.plugin_list_backgroundpicture)
			else:
				self['liste'].instance.setBackgroundPicture(gPixmapPtr())
			if mp_globals.plugin_list_selectionpicture:
				self['liste'].instance.setSelectionPicture(mp_globals.plugin_list_selectionpicture)
			else:
				self['liste'].instance.setSelectionPicture(gPixmapPtr())
			self['liste'].instance.setMargin(ePoint(0,0))
			self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
			width = self['liste'].instance.size().width()
			res = [entry]
			res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, width, mp_globals.plugin_list_itemheight, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]))
		return res

	def _defaultlistcenter(self, entry):
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		self['liste'].instance.setItemHeight(mp_globals.plugin_list_itemheight)
		width = self['liste'].instance.size().width()
		res = [entry]
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, width, mp_globals.plugin_list_itemheight, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0]))
		return res

	def _defaultlistleftmarkedgrid(self, entry):
		skin_path = mp_globals.pluginPath + mp_globals.skinsPath

		global watched
		if not watched:
			path = "%s/%s/images/watched.svg" % (skin_path, mp_globals.currentskin)
			if not fileExists(path):
				path = "%s/%s/images/watched.png" % (skin_path, mp_globals.currentskin)
				if not fileExists(path):
					path = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/watched.svg"
			watched = LoadPixmap(path)

		global watched_grid
		if not watched_grid:
			path = "%s/%s/images/watched_grid.svg" % (skin_path, mp_globals.currentskin)
			if not fileExists(path):
				path = "%s/%s/images/watched_grid.png" % (skin_path, mp_globals.currentskin)
				if not fileExists(path):
					path = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/watched_grid.svg"
			watched_grid = LoadPixmap(path)

		global star
		if not star:
			path = "%s/%s/images/star.svg" % (skin_path, mp_globals.currentskin)
			if not fileExists(path):
				path = "%s/%s/images/star.png" % (skin_path, mp_globals.currentskin)
				if not fileExists(path):
					path = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/star.svg"
			star = LoadPixmap(path)

		global star_grid
		if not star_grid:
			path = "%s/%s/images/star_grid.svg" % (skin_path, mp_globals.currentskin)
			if not fileExists(path):
				path = "%s/%s/images/star_grid.png" % (skin_path, mp_globals.currentskin)
				if not fileExists(path):
					path = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/star_grid.svg"
			star_grid = LoadPixmap(path)

		global red
		if not red:
			path = "%s/%s/images/red.svg" % (skin_path, mp_globals.currentskin)
			if not fileExists(path):
				path = "%s/%s/images/red.png" % (skin_path, mp_globals.currentskin)
				if not fileExists(path):
					path = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/red.svg"
			red = LoadPixmap(path)

		global red_grid
		if not red_grid:
			path = "%s/%s/images/red_grid.svg" % (skin_path, mp_globals.currentskin)
			if not fileExists(path):
				path = "%s/%s/images/red_grid.png" % (skin_path, mp_globals.currentskin)
				if not fileExists(path):
					path = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/red_grid.svg"
			red_grid = LoadPixmap(path)

		if self.gridswitch and (self.gridview or (len(entry) > 2 and entry[2] and entry[2].startswith('http'))):
			self.gridview = True
			self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_grid_fontsize))
			self['liste'].instance.setMode(eListbox.layoutGrid)
			self['liste'].instance.setItemHeight(mp_globals.plugin_grid_itemheight)
			self['liste'].instance.setItemWidth(mp_globals.plugin_grid_itemwidth)
			self['liste'].instance.setBackgroundPicture(mp_globals.plugin_grid_backgroundpicture)
			self['liste'].instance.setSelectionPicture(mp_globals.plugin_grid_selectionpicture)
			self['liste'].instance.setMargin(ePoint(mp_globals.plugin_grid_margin_x,mp_globals.plugin_grid_margin_y))
			pixmap = self._pixmapCache.get(entry[2], self._defaultPixmap)
			res = [entry]

			res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_grid_pixmapmargin_x, mp_globals.plugin_grid_pixmapmargin_y, mp_globals.plugin_grid_pixmapwidth, mp_globals.plugin_grid_pixmapheight, pixmap))
			if len(entry)>8:
				if entry[3]:
					res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_grid_pixmapwatchedmargin_x, mp_globals.plugin_grid_pixmapwatchedmargin_y, mp_globals.plugin_grid_pixmapwatchedwidth, mp_globals.plugin_grid_pixmapwatchedheight, watched_grid))
			if len(entry)>9:
				if entry[9] and entry[10] == "xv":
					res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_grid_pixmapredmargin_x, mp_globals.plugin_grid_pixmapredmargin_y, mp_globals.plugin_grid_pixmapredwidth, mp_globals.plugin_grid_pixmapredheight, red_grid))
				elif entry[9]:
					res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_grid_pixmapstarmargin_x, mp_globals.plugin_grid_pixmapstarmargin_y, mp_globals.plugin_grid_pixmapstarwidth, mp_globals.plugin_grid_pixmapstarheight, star_grid))
			elif entry[3]:
				res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_grid_pixmapwatchedmargin_x, mp_globals.plugin_grid_pixmapwatchedmargin_y, mp_globals.plugin_grid_pixmapwatchedwidth, mp_globals.plugin_grid_pixmapwatchedheight, watched_grid))

			res.append((eListboxPythonMultiContent.TYPE_TEXT, mp_globals.plugin_grid_textmargin_x, mp_globals.plugin_grid_textmargin_y, mp_globals.plugin_grid_textwidth, mp_globals.plugin_grid_textheight, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER | RT_WRAP, entry[0]))
		else:
			self['liste'].instance.setMode(eListbox.layoutVertical)
			self['liste'].instance.setItemHeight(mp_globals.plugin_list_itemheight)
			if mp_globals.plugin_list_backgroundpicture:
				self['liste'].instance.setBackgroundPicture(mp_globals.plugin_list_backgroundpicture)
			else:
				self['liste'].instance.setBackgroundPicture(gPixmapPtr())
			if mp_globals.plugin_list_selectionpicture:
				self['liste'].instance.setSelectionPicture(mp_globals.plugin_list_selectionpicture)
			else:
				self['liste'].instance.setSelectionPicture(gPixmapPtr())
			self['liste'].instance.setMargin(ePoint(0,0))
			self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
			width = self['liste'].instance.size().width()
			res = [entry]

			iconoffset = mp_globals.plugin_list_pixmapwatchedwidth + mp_globals.plugin_list_pixmapmargin_x
			if len(entry)>8:
				if entry[3]:
					res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_list_pixmapmargin_x, mp_globals.plugin_list_pixmapwatchedmargin_y, mp_globals.plugin_list_pixmapwatchedwidth, mp_globals.plugin_list_pixmapwatchedheight, watched))
				iconoffset = mp_globals.plugin_list_pixmapwatchedwidth + mp_globals.plugin_list_pixmapmargin_x
			if len(entry)>9:
				if entry[9] and entry[10] == "xv":
					res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_list_pixmapmargin_x, mp_globals.plugin_list_pixmapredmargin_y, mp_globals.plugin_list_pixmapredwidth, mp_globals.plugin_list_pixmapredheight, red))
				elif entry[9]:
					res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_list_pixmapwatchedwidth+2*mp_globals.plugin_list_pixmapmargin_x, mp_globals.plugin_list_pixmapstarmargin_y, mp_globals.plugin_list_pixmapstarwidth, mp_globals.plugin_list_pixmapstarheight, star))
				if entry[10] == "xv":
					iconoffset = mp_globals.plugin_list_pixmapmargin_x + mp_globals.plugin_list_pixmapredwidth
				else:
					iconoffset = mp_globals.plugin_list_pixmapwatchedwidth + 2*mp_globals.plugin_list_pixmapmargin_x + mp_globals.plugin_list_pixmapstarwidth
			elif entry[3]:
				res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_list_pixmapmargin_x, mp_globals.plugin_list_pixmapwatchedmargin_y, mp_globals.plugin_list_pixmapwatchedwidth, mp_globals.plugin_list_pixmapwatchedheight, watched))

			res.append((eListboxPythonMultiContent.TYPE_TEXT, iconoffset+mp_globals.plugin_list_pixmapmargin_x+self.langoffset, 0, width, mp_globals.plugin_list_itemheight, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]))
		return res

	def _defaultlistleftmarked(self, entry):
		try:
			if self.mpscreen_premium:
				premium = True
			else:
				premium = False
		except:
			premium = False
		self['liste'].instance.setItemHeight(mp_globals.plugin_list_itemheight)
		width = self['liste'].instance.size().width()
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		res = [entry]

		skin_path = mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/images/watched.svg" % (skin_path, mp_globals.currentskin)
		if not fileExists(path):
			path = "%s/%s/images/watched.png" % (skin_path, mp_globals.currentskin)
			if not fileExists(path):
				path = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/watched.svg"
		watched = LoadPixmap(path)

		path = "%s/%s/images/live.svg" % (skin_path, mp_globals.currentskin)
		if not fileExists(path):
			path = "%s/%s/images/live.png" % (skin_path, mp_globals.currentskin)
			if not fileExists(path):
				path = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/live.svg"
		live = LoadPixmap(path)

		path = "%s/%s/images/star.svg" % (skin_path, mp_globals.currentskin)
		if not fileExists(path):
			path = "%s/%s/images/star.png" % (skin_path, mp_globals.currentskin)
			if not fileExists(path):
				path = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/star.svg"
		star = LoadPixmap(path)

		path = "%s/%s/images/red.svg" % (skin_path, mp_globals.currentskin)
		if not fileExists(path):
			path = "%s/%s/images/red.png" % (skin_path, mp_globals.currentskin)
			if not fileExists(path):
				path = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/red.svg"
		red = LoadPixmap(path)

		iconoffset = mp_globals.plugin_list_pixmapwatchedwidth + mp_globals.plugin_list_pixmapmargin_x
		if len(entry)>8:
			if entry[2]:
				res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_list_pixmapmargin_x, mp_globals.plugin_list_pixmapwatchedmargin_y, mp_globals.plugin_list_pixmapwatchedwidth, mp_globals.plugin_list_pixmapwatchedheight, watched))
			iconoffset = mp_globals.plugin_list_pixmapwatchedwidth + mp_globals.plugin_list_pixmapmargin_x
		if len(entry)>9:
			if entry[9] and entry[10] == "xv":
				res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_list_pixmapmargin_x, mp_globals.plugin_list_pixmapredmargin_y, mp_globals.plugin_list_pixmapredwidth, mp_globals.plugin_list_pixmapredheight, red))
			elif entry[9]:
				res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_list_pixmapwatchedwidth+2*mp_globals.plugin_list_pixmapmargin_x, mp_globals.plugin_list_pixmapstarmargin_y, mp_globals.plugin_list_pixmapstarwidth, mp_globals.plugin_list_pixmapstarheight, star))
			if entry[10] == "xv":
				iconoffset = mp_globals.plugin_list_pixmapmargin_x + mp_globals.plugin_list_pixmapredwidth
			else:
				iconoffset = mp_globals.plugin_list_pixmapwatchedwidth + 2*mp_globals.plugin_list_pixmapmargin_x + mp_globals.plugin_list_pixmapstarwidth
		elif len(entry)>7 and entry[7]:
			if entry[7] == 'Live':
				res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_list_pixmapmargin_x, mp_globals.plugin_list_pixmaplivemargin_y, mp_globals.plugin_list_pixmaplivewidth, mp_globals.plugin_list_pixmapliveheight, live))
			iconoffset = mp_globals.plugin_list_pixmapwatchedwidth + mp_globals.plugin_list_pixmapmargin_x
		elif entry[2]:
			res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_list_pixmapmargin_x, mp_globals.plugin_list_pixmapwatchedmargin_y, mp_globals.plugin_list_pixmapwatchedwidth, mp_globals.plugin_list_pixmapwatchedheight, watched))

		try:
			if entry[3]:
				iconlng = ''
				if entry[3] == '1':
					iconlng = 'DE'
				elif entry[3] == '2':
					iconlng = 'EN'
				elif entry[3] == '5':
					iconlng = 'ES'
				elif entry[3] == '6':
					iconlng = 'FR'
				elif entry[3] == '7':
					iconlng = 'TR'
				elif entry[3] == '8':
					iconlng = 'JP'
				elif entry[3] == '11':
					iconlng = 'IT'
				elif entry[3] == '15':
					iconlng = 'ENDE'
				elif entry[3] == '17':
					iconlng = 'KR'
				elif entry[3] == '24':
					iconlng = 'GR'
				elif entry[3] == '25':
					iconlng = 'RU'
				elif entry[3] == '26':
					iconlng = 'IN'
				else:
					if re.search('^([A-Z]{2,4})$', entry[3]):
						iconlng = entry[3]
					else:
						iconlng = ''

				if iconlng:
					path = "%s/%s/images/countries/%s.png" % (skin_path, mp_globals.currentskin, iconlng)
					if not fileExists(path):
						path = "%s/%s/images/countries/%s.png" % (skin_path, mp_globals.skinFallback, iconlng)
						if not fileExists(path):
							path = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/countries/%s.png" % iconlng

					llang = LoadPixmap(path)
					lwidth = llang.size().width()
					lheight = llang.size().height()
					if lheight > (mp_globals.plugin_list_fontsize):
						lratio = float(lwidth / lheight)
						lheight = mp_globals.plugin_list_fontsize
						lwidth = int(lheight * lratio)
					vpos = round(float((mp_globals.plugin_list_itemheight-lheight) / 2))
					res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, iconoffset+mp_globals.plugin_list_pixmapmargin_x, vpos, lwidth, lheight, llang))
					self.langoffset = lwidth+mp_globals.plugin_list_pixmapmargin_x
				else:
					self.langoffset = 0
		except:
			pass

		if premium and ((config_mp.mediaportal.premiumize_use.value and re.search(mp_globals.premium_hosters_prz[0], entry[0], re.S|re.I)) or (config_mp.mediaportal.realdebrid_use.value and re.search(mp_globals.premium_hosters_rdb[0], entry[0], re.S|re.I))):
			premiumFarbe = int(config_mp.mediaportal.premium_color.value, 0)
			res.append((eListboxPythonMultiContent.TYPE_TEXT, iconoffset+mp_globals.plugin_list_pixmapmargin_x+self.langoffset, 0, width, mp_globals.plugin_list_itemheight, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0], premiumFarbe))
		else:
			res.append((eListboxPythonMultiContent.TYPE_TEXT, iconoffset+mp_globals.plugin_list_pixmapmargin_x+self.langoffset, 0, width, mp_globals.plugin_list_itemheight, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]))

		return res

	def _defaultlisthoster(self, entry):
		self['liste'].instance.setItemHeight(mp_globals.plugin_list_itemheight)
		width = self['liste'].instance.size().width()
		height = self['liste'].l.getItemSize().height()
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		res = [entry]
		if (config_mp.mediaportal.premiumize_use.value and re.search(mp_globals.premium_hosters_prz[0], entry[0], re.S|re.I)) or (config_mp.mediaportal.realdebrid_use.value and re.search(mp_globals.premium_hosters_rdb[0], entry[0], re.S|re.I)):
			premiumFarbe = int(config_mp.mediaportal.premium_color.value, 0)
			res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, width, height, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0], premiumFarbe))
		else:
			res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, width, height, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0]))
		return res

	def MPLog(self, entry):
		width = self['mplog'].instance.size().width()
		height = self['mplog'].l.getItemSize().height()
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		res = [entry]
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, width, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]))
		return res

	def MPSort(self, entry):
		width = self['liste'].instance.size().width()
		height = self['liste'].l.getItemSize().height()
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		res = [entry]
		skin_path = mp_globals.pluginPath + mp_globals.skinsPath
		path = "%s/%s/images/select.svg" % (skin_path, mp_globals.currentskin)
		if not fileExists(path):
			path = "%s/%s/images/select.png" % (skin_path, mp_globals.currentskin)
			if not fileExists(path):
				path = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/select.svg"
		select = LoadPixmap(path)
		if self.selected and entry[0] == self.old_plugin_name:
			res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.sort_select_pixmapmargin_x, mp_globals.sort_select_pixmapmargin_y, mp_globals.sort_select_pixmapwidth, mp_globals.sort_select_pixmapheight, select))
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 2*mp_globals.sort_select_pixmapmargin_x+mp_globals.sort_select_pixmapwidth, 0, width, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]))
		return res

##################

####### simplelist
	@staticmethod
	def getIconPath(icon_name):
		skin_path = mp_globals.pluginPath + mp_globals.skinsPath

		path = "%s/%s/images/%s.svg" % (skin_path, mp_globals.currentskin, icon_name)
		if not fileExists(path):
			path = "%s/%s/images/%s.png" % (skin_path, mp_globals.currentskin, icon_name)
			if not fileExists(path):
				path = "/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/%s.svg" % icon_name
		return path

	def simplelistListEntry(self, entry):
		self['liste'].instance.setItemHeight(mp_globals.plugin_list_itemheight)
		width = self['liste'].instance.size().width()
		height = self['liste'].l.getItemSize().height()
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		res = [entry]
		if entry[0] in ('1', '4', '5', '6', '7', '8', '9'):
			icon_name = "directory"
		else:
			icon_name = "playlist"
		path = self.getIconPath(icon_name)
		icon = LoadPixmap(path)
		if icon_name == "directory":
			res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_list_pixmapmargin_x, mp_globals.plugin_list_pixmapdirectorymargin_y, mp_globals.plugin_list_pixmapdirectorywidth, mp_globals.plugin_list_pixmapdirectoryheight, icon))
			res.append((eListboxPythonMultiContent.TYPE_TEXT, 2*mp_globals.plugin_list_pixmapmargin_x+mp_globals.plugin_list_pixmapdirectorywidth, 0, width, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[1]))
		else:
			res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, mp_globals.plugin_list_pixmapmargin_x, mp_globals.plugin_list_pixmapplaylistmargin_y, mp_globals.plugin_list_pixmapplaylistwidth, mp_globals.plugin_list_pixmapplaylistheight, icon))
			res.append((eListboxPythonMultiContent.TYPE_TEXT, 2*mp_globals.plugin_list_pixmapmargin_x+mp_globals.plugin_list_pixmapplaylistwidth, 0, width, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[1]))
		return res

	# simplelist - iptv
	def simpleListTVGListEntry(self, entry):
		self['liste'].instance.setItemHeight(mp_globals.plugin_list_itemheight)
		width = self['liste'].instance.size().width()
		height = self['liste'].l.getItemSize().height()
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		self.ml.l.setFont(1, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		res = [entry]
		color = int(entry[3][-1], 0) if entry[3] else 0xD3D3D3
		event = ""
		fhdoffset = 140 if mp_globals.videomode == 2 else 0
		width2 = 190+fhdoffset if event else width+fhdoffset
		icon_name = entry[2]
		iconwidth = 0
		if icon_name:
			if icon_name[:4] not in ('http', 'file'):
				path = self.getIconPath(icon_name)
				icon = LoadPixmap(path)
				pwidth = icon.size().width()
				pheight = icon.size().height()
				vpos = round(float((height-pheight) / 2))
				res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHABLEND, 25, vpos, pwidth, pheight, icon))
				iconwidth = pwidth+50

		res.append((eListboxPythonMultiContent.TYPE_TEXT, iconwidth, 0, width2, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0], color))
		if event:
			x_ofs2 = width2+iconwidth+10
			width2 = width-x_ofs2-100
			res.append((eListboxPythonMultiContent.TYPE_TEXT, x_ofs2, 0, width2, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, event))
			x_ofs2 += width2+5
			width2 = 75
			res.append((eListboxPythonMultiContent.TYPE_TEXT, x_ofs2, 0, width2, height, 1, RT_HALIGN_RIGHT | RT_VALIGN_CENTER, r_tm))
		return res
##################

####### twitch
	def twitchListEntry(self, entry):
		self['liste'].instance.setItemHeight(mp_globals.plugin_list_itemheight)
		width = self['liste'].instance.size().width()
		height = self['liste'].l.getItemSize().height()
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		res = [entry]
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, 110, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[1]))
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 120, 0, width - 120, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]))
		return res

####### pornhub
	def pornhubPlayListEntry(self, entry):
		self['liste'].instance.setItemHeight(mp_globals.plugin_list_itemheight)
		width = self['liste'].instance.size().width()
		height = self['liste'].l.getItemSize().height()
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		res = [entry]
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, width - 210, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]))
		res.append((eListboxPythonMultiContent.TYPE_TEXT, width - 200, 0, 200, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, "Videos: " + entry[1]))
		return res

	def pornhubPornstarListEntry(self, entry):
		self['liste'].instance.setItemHeight(mp_globals.plugin_list_itemheight)
		width = self['liste'].instance.size().width()
		height = self['liste'].l.getItemSize().height()
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		res = [entry]
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, 170, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, "Rank: " + entry[3]))
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 180, 0, width - 370, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]))
		res.append((eListboxPythonMultiContent.TYPE_TEXT, width - 200, 0, 200, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, "Videos: " + entry[4]))
		return res
##################

####### kinox

	def kxStreamListEntry(self, entry):
		self['liste'].instance.setItemHeight(mp_globals.plugin_list_itemheight)
		width = self['liste'].instance.size().width()
		height = self['liste'].l.getItemSize().height()
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		res = [entry]
		if (config_mp.mediaportal.premiumize_use.value and re.search(mp_globals.premium_hosters_prz[0], entry[0], re.S|re.I)) or (config_mp.mediaportal.realdebrid_use.value and re.search(mp_globals.premium_hosters_rdb[0], entry[0], re.S|re.I)):
			premiumFarbe = int(config_mp.mediaportal.premium_color.value, 0)
			res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, 250, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0], premiumFarbe))
			res.append((eListboxPythonMultiContent.TYPE_TEXT, 260, 0, 150, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[2], premiumFarbe))
			res.append((eListboxPythonMultiContent.TYPE_TEXT, width - 340, 0, 150, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[3], premiumFarbe))
			res.append((eListboxPythonMultiContent.TYPE_TEXT, width - 180, 0, 180, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[4], premiumFarbe))
		else:
			res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, 250, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]))
			res.append((eListboxPythonMultiContent.TYPE_TEXT, 260, 0, 150, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[2]))
			res.append((eListboxPythonMultiContent.TYPE_TEXT, width - 340, 0, 150, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[3]))
			res.append((eListboxPythonMultiContent.TYPE_TEXT, width - 180, 0, 180, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[4]))
		return res

	def kxListSearchEntry(self, entry):
		self['liste'].instance.setItemHeight(mp_globals.plugin_list_itemheight)
		width = self['liste'].instance.size().width()
		height = self['liste'].l.getItemSize().height()
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		res = [entry]
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, 120, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[3]))
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 130, 0, width - 130, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]))
		return res
##################

####### ddl.me
	def DDLME_FilmListEntry(self, entry):
		self['liste'].instance.setItemHeight(mp_globals.plugin_list_itemheight)
		width = self['liste'].instance.size().width()
		height = self['liste'].l.getItemSize().height()
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		res = [entry]
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, width - 210, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]))
		res.append((eListboxPythonMultiContent.TYPE_TEXT, width - 200, 0, 200, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[4]))
		return res

	def DDLMEStreamListEntry(self, entry):
		self['liste'].instance.setItemHeight(mp_globals.plugin_list_itemheight)
		width = self['liste'].instance.size().width()
		height = self['liste'].l.getItemSize().height()
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		res = [entry]
		if (config_mp.mediaportal.premiumize_use.value and re.search(mp_globals.premium_hosters_prz[0], entry[0], re.S|re.I)) or (config_mp.mediaportal.realdebrid_use.value and re.search(mp_globals.premium_hosters_rdb[0], entry[0], re.S|re.I)):
			premiumFarbe = int(config_mp.mediaportal.premium_color.value, 0)
			res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, width, height, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0] + entry[2], premiumFarbe))
		else:
			res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, width, height, 0, RT_HALIGN_CENTER | RT_VALIGN_CENTER, entry[0] + entry[2]))
		return res

	def DDLMEStreamListEntry2(self, entry):
		self['liste'].instance.setItemHeight(mp_globals.plugin_list_itemheight)
		width = self['liste'].instance.size().width()
		height = self['liste'].l.getItemSize().height()
		self.ml.l.setFont(0, gFont(mp_globals.font, mp_globals.plugin_list_fontsize))
		res = [entry]
		if (config_mp.mediaportal.premiumize_use.value and re.search(mp_globals.premium_hosters_prz[0], entry[0], re.S|re.I)) or (config_mp.mediaportal.realdebrid_use.value and re.search(mp_globals.premium_hosters_rdb[0], entry[0], re.S|re.I)):
			premiumFarbe = int(config_mp.mediaportal.premium_color.value, 0)
			res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, 220, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0], premiumFarbe))
			res.append((eListboxPythonMultiContent.TYPE_TEXT, 260, 0, width - 720, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[2], premiumFarbe))
			res.append((eListboxPythonMultiContent.TYPE_TEXT, width - 450, 0, 450, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[3], premiumFarbe))
		else:
			res.append((eListboxPythonMultiContent.TYPE_TEXT, 0, 0, 250, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[0]))
			res.append((eListboxPythonMultiContent.TYPE_TEXT, 260, 0, width - 720, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[2]))
			res.append((eListboxPythonMultiContent.TYPE_TEXT, width - 450, 0, 450, height, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, entry[3]))
		return res
##################

class MPScreenSummary(Screen):

	def __init__(self, session, parent):
		try:
			displaysize = getDesktop(1).size()
			if mp_globals.model in ["dm900", "dm920"]:
				disp_id = ' id="3"'
				disp_size = str(displaysize.width()-8) + "," + str(displaysize.height())
				disp_pos = "8,0"
			elif mp_globals.model in ["dm7080"]:
				disp_id = ' id="3"'
				disp_size = str(displaysize.width()) + "," + str(displaysize.height()-14)
				disp_pos = "0,0"
			elif mp_globals.model in ["dm820"]:
				disp_id = ' id="2"'
				disp_size = str(displaysize.width()) + "," + str(displaysize.height())
				disp_pos = "0,0"
			elif mp_globals.model in ["two"]:
				disp_id = ' id="100"'
				disp_size = str(displaysize.width()) + "," + str(displaysize.height())
				disp_pos = "0,0"
			else:
				disp_id = ' id="1"'
				disp_size = str(displaysize.width()) + "," + str(displaysize.height())
				disp_pos = "0,0"

		except:
			disp_size = "1,1"
			disp_id = ' id="1"'
			disp_pos = "0,0"

		self["cover"] = Pixmap()

		self.skin = '''<screen name="MPScreenSummary" backgroundColor="#00000000" position="''' + disp_pos + '''" size="''' + disp_size  + '''"''' + disp_id + '''>
				<widget name="cover" position="center,center" size="''' + disp_size + '''" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/none.png" transparent="1" alphatest="on" />
				</screen>'''

		self.skinName = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(32)])
		Screen.__init__(self, session)

	def updateCover(self, filename):
		CoverHelper(self['cover']).getCover(filename)