# -*- coding: utf-8 -*-
from __future__ import absolute_import
from builtins import object
from .imports import *
from .twagenthelper import twDownloadPage

glob_screensaver_num = 0
glob_icon_num = 0
glob_last_cover = [None, None]
glob_last_crossfade = ''

class CoverHelper(object):

	def __init__(self, cover, callback=None, nc_callback=None):
		self._cover = cover
		self.picload = ePicLoad()
		self._callback = callback
		self._nc_callback = nc_callback
		self.downloadPath = None
		self.err_nocover = True
		self.url = None
		self.cookieJar = None
		self.agent = None
		self.headers = None
		self.download_cb = None

	def downloadPage(self, url, path, agent=None, cookieJar=None, headers=None):
		if not agent:
			agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36"
		return twDownloadPage(url, path, timeout=20, agent=agent, cookieJar=cookieJar, headers=headers)

	def closeFile(self, result, f):
		f.close()
		return result

	def checkFilesize(self, data):
		if not data:
			raise Exception("Size error")
		else:
			return data

	def getCover(self, url, download_cb=None, agent=None, cookieJar=None, backup_url=False, screensaver=False, bgcover=False, headers=None, default_cover=None, ltype=None):
		self.bgcover = bgcover
		self.screensaver = screensaver
		self.ltype = ltype
		if "PixmapExt" in str(self._cover):
			self.crossfade = True
		else:
			self.crossfade = False
		if self.screensaver:
			self.COVER_PIC_PATH = "/tmp/.Screensaver%d"
			self.NO_COVER_PIC_PATH = "/images/none.png"
			self._no_picPath = "%s%s" % (mp_globals.pluginPath, self.NO_COVER_PIC_PATH)
		else:
			self.COVER_PIC_PATH = "/tmp/.Icon%d"
			if self.bgcover:
				self.NO_COVER_PIC_PATH = "/images/none.png"
				self._no_picPath = "%s%s" % (mp_globals.pluginPath, self.NO_COVER_PIC_PATH)
			elif default_cover:
				self._no_picPath = default_cover
			else:
				self.NO_COVER_PIC_PATH = "/images/default_cover.png"
				self._no_picPath = "%s%s" % (mp_globals.pluginPath, self.NO_COVER_PIC_PATH)
		global glob_screensaver_num
		global glob_icon_num
		global glob_last_cover
		if url:
			if url.startswith('http'):
				if glob_last_cover[0] == url and glob_last_cover[1] and not self.screensaver:
					self.showCoverFile(glob_last_cover[1])
					if download_cb:
						download_cb(glob_last_cover[1])
				else:
					if self.screensaver:
						glob_screensaver_num = (glob_screensaver_num + 1) % 2
						self.downloadPath = self.COVER_PIC_PATH % glob_screensaver_num
					else:
						glob_icon_num = (glob_icon_num + 1) % 2
						glob_last_cover[0] = url
						glob_last_cover[1] = None
						self.downloadPath = self.COVER_PIC_PATH % glob_icon_num
					if 'phncdn.com/pics' in url:
						self.url = url
						self.cookieJar = cookieJar
						self.agent = agent
						self.headers = headers
						self.download_cb = download_cb
						url = re.sub('\(m=\w+\)', '', url)
					elif backup_url:
						self.url = backup_url
						self.cookieJar = cookieJar
						self.agent = agent
						self.headers = headers
						self.download_cb = download_cb
					d = self.downloadPage(url, self.downloadPath, agent=agent, cookieJar=cookieJar, headers=headers)
					d.addCallback(self.showCover)
					if download_cb:
						d.addCallback(self.cb_getCover, download_cb)
					d.addErrback(self.dataErrorP)
			elif url.startswith('file://'):
				logopath = (config_mp.mediaportal.iconcachepath.value + "logos")
				self.showCoverFile(url[7:])
				if download_cb:
					download_cb(url[7:])
			else:
				self.showCoverNone()
				if download_cb:
					download_cb(self._no_picPath)
		else:
			self.showCoverNone()
			if download_cb:
				download_cb(self._no_picPath)

	def cb_getCover(self, result, download_cb):
		download_cb(result)

	def dataErrorP(self, error):
		printl(error, self, 'E')
		self.showCoverNone()

	def showCover(self, picfile):
		if self.url and not picfile:
			d = self.downloadPage(self.url, self.downloadPath, agent=self.agent, cookieJar=self.cookieJar, headers=self.headers)
			d.addCallback(self.showCover)
			if self.download_cb:
				d.addCallback(self.cb_getCover, self.download_cb)
			d.addErrback(self.dataErrorP)
			self.url = None
		elif self.url and fileExists(picfile) and os.path.getsize(picfile) < 100:
			d = self.downloadPage(self.url, self.downloadPath, agent=self.agent, cookieJar=self.cookieJar, headers=self.headers)
			d.addCallback(self.showCover)
			if self.download_cb:
				d.addCallback(self.cb_getCover, self.download_cb)
			d.addErrback(self.dataErrorP)
			self.url = None
		else:
			if picfile == 'cancelled':
				return self.dataErrorP(picfile)
			else:
				self.showCoverFile(picfile)
			if not self.screensaver:
				glob_last_cover[1] = picfile
			return picfile

	def showCoverNone(self):
		if not self.err_nocover:
			return
		else:
			self.err_nocover = False

		if self._nc_callback:
			self._cover.hide()
			self._nc_callback()
		else:
			if self._no_picPath.startswith('file://'):
				self.showCoverFile(self._no_picPath[7:])
			else:
				self.showCoverFile(self._no_picPath)

		return(self._no_picPath)

	def showCoverFile(self, picPath, showNoCoverart=True):
		if fileExists(picPath):
			try:
				if not self.crossfade:
					self._cover.instance.setPixmap(gPixmapPtr())
				scale = AVSwitch().getFramebufferScale()
				size = self._cover.instance.size()
				self.picload.setPara((size.width(), size.height(), scale[0], scale[1], False, 1, "#FF000000"))
				global glob_last_crossfade
				from . import mpscreen
				check = hashlib.md5(open(picPath, 'rb').read()).hexdigest() + hashlib.md5(str(mpscreen.screenList)).hexdigest()
				if self.crossfade and check != glob_last_crossfade:
					self.updateCover(picPath)
					glob_last_crossfade = check
				elif not self.crossfade:
					self.updateCover(picPath)
			except AttributeError:
				pass
		else:
			printl("Coverfile not found: %s" % picPath, self, "E")
			if showNoCoverart and picPath != self._no_picPath:
				self.showCoverFile(self._no_picPath)

		if self._callback:
			self._callback()

	def updateCover(self, picPath):
		res = self.picload.startDecode(picPath, False)

		if not res:
			ptr = self.picload.getData()
			if ptr != None:
				w = ptr.size().width()
				h = ptr.size().height()
				ratio = float(w) / float(h)
				if self._nc_callback and ratio > 1.78 and self.ltype == "disney":
					self.showCoverNone()
				elif self._nc_callback and ratio > 1.35 and self.ltype == "amazon":
					self.showCoverNone()
				elif self._nc_callback and ratio > 1.05 and self.ltype not in ["amazon", "disney"]:
					self.showCoverNone()
				else:
					self._cover.instance.setPixmap(ptr)
					if not self.bgcover:
						self._cover.show()
				return

		self.showCoverNone()