﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.keyboardext import VirtualKeyBoardExt
from ...resources.choiceboxext import ChoiceBoxExt

agent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36'
default_cover = None
cookies = CookieJar()

class xxxdanGenreScreen(MPScreen):

	def __init__(self, session, mode):
		self.mode = mode

		global default_cover
		if self.mode == "xxxdan":
			self.portal = "XXXDan.com"
			self.baseurl = "https://xxxdan.com"
			default_cover = "file://%s/xxxdan.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "wankgalore":
			self.portal = "WankGalore.com"
			self.baseurl = "https://wankgalore.com"
			default_cover = "file://%s/wankgalore.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "jizzbunker":
			self.portal = "JizzBunker.com"
			self.baseurl = "https://jizzbunker.com"
			default_cover = "file://%s/jizzbunker.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label(self.portal)
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		url = "%s/channels" % self.baseurl
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		Cats = MPfindall(self, '<figure>.*?href="(.*?)".*?img\sclass="lazy"\sdata-original="(.*?)"\salt="(.*?)"', data, re.S)
		if Cats:
			for (Url, Image, Title) in Cats:
				Title = upperString(Title)
				self._items.append((Title, Url, Image))
		self._items.sort()
		self._items.insert(0, ("Longtest", "%s/longest" % self.baseurl, default_cover))
		self._items.insert(0, ("Trending", "%s/trending" % self.baseurl, default_cover))
		self._items.insert(0, ("Most Popular", "%s/popular" % self.baseurl, default_cover))
		self._items.insert(0, ("Newest", "%s/newest" % self.baseurl, default_cover))
		self._items.insert(0, ("--- Search ---", "callSuchen", default_cover))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen()
		else:
			Link = self['liste'].getCurrent()[0][1]
			self.session.open(xxxdanFilmScreen, Link, Name, self.portal, self.baseurl)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '+'))
			self.session.open(xxxdanFilmScreen, Link, Name, self.portal, self.baseurl)

class xxxdanFilmScreen(MPScreen):

	def __init__(self, session, Link, Name, portal, baseurl):
		self.Link = Link
		self.Name = Name
		self.portal = portal
		self.baseurl = baseurl

		global default_cover
		if self.portal == "XXXDan.com":
			default_cover = "file://%s/xxxdan.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "WankGalore.com":
			default_cover = "file://%s/wankgalore.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "JizzBunker.com":
			default_cover = "file://%s/jizzbunker.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber,
			"blue" : self.keyFilter
		}, -1)

		self['title'] = Label(self.portal)
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))
		if ("/channel/" in self.Link) or ("/popular" in self.Link):
			self['F4'] = Label(_("Filter"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1
		if ("/channel/" in self.Link) or ("/popular" in self.Link):
			self.filter = ''
			self.filtertext = 'All time'
		else:
			self.filter = ''
			self.filtertext = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*?Search", self.Name):

			url = "%s/search?query=%s&page=%s" % (self.baseurl, self.Link, str(self.page))
		else:
			filterpart = MPfindall(self, '^(.*?)\?order=(.*?)$', self.Link)
			if filterpart:
				self.Link = filterpart[0][0]
				self.filter = filterpart[0][1]
			url = "%s/%s" % (self.Link, str(self.page))
			url = url.replace('/channel/', '/channel%s/' % self.filter)
			url = url.replace('/popular/', '/popular%s/' % self.filter)
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		self.getLastPage(data, '(?:paging|pagination)">(.*?)(?:</ul>|</div>)')
		parse = re.search('class="gallery" id="(?:g1|gsearch)">(.*?)$', data, re.S)
		if parse:
			Movies = MPfindall(self, '<figure>.*?href="(.*?)".*?img\sclass="lazy"\sdata-original="(.*?)"\salt="(.*?)".*?class="dur"><time datetime=".*?">(.*?)</time>', parse.group(1), re.S)
			if Movies:
				for (Url, Image, Title, Runtime) in Movies:
					self._items.append((decodeHtml(Title), Url, Image, Runtime))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), None, None, ''))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.showInfos()
		self.keyLocked = False

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		pic = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][3]
		self['name'].setText(title)
		if ("/channel/" in self.Link) or ("/popular" in self.Link):
			self['handlung'].setText("%s: %s\nRuntime: %s" % (_("Filter"), self.filtertext, runtime))
		else:
			self['handlung'].setText("Runtime: %s" % runtime)
		CoverHelper(self['coverArt']).getCover(pic)

	def keyFilter(self):
		if self.keyLocked:
			return
		if ("/channel/" in self.Link) or ("/popular" in self.Link):
			rangelist = [['All time', ''], ['30 days', '30'], ['7 days', '7'], ['1 days', '1']]
			self.session.openWithCallback(self.keyFilterAction, ChoiceBoxExt, title=_('Select Action'), list = rangelist)

	def keyFilterAction(self, result):
		if result:
			self.filter = result[1]
			self.filtertext = result[0]
			self.loadPage()

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		self.keyLocked = True
		twAgentGetPage(Link, agent=agent, cookieJar=cookies).addCallback(self.getVideoUrl).addErrback(self.dataError)

	def getVideoUrl(self, data):
		videoUrl = MPfindall(self, "type:'video/mp4',src:'(.*?)',", data, re.S)
		if videoUrl:
			self.keyLocked = False
			url = videoUrl[-1]
			Title = self['liste'].getCurrent()[0][0]
			mp_globals.player_agent = agent
			self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='xxxdan')