﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.twagenthelper import TwAgentHelper

agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36'
json_headers = {
	'Accept': 'application/json',
	'Accept-Language': 'en-US;q=0.7,en;q=0.3',
	'X-Requested-With': 'XMLHttpRequest',
	'Content-Type': 'application/x-www-form-urlencoded',
	}
default_cover = "file://%s/xfreehd.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class xfreehdGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("XFreeHD.com")
		self['ContentTitle'] = Label("Genre:")

		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		url = "https://www.xfreehd.com/categories"
		twAgentGetPage(url, agent=agent).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		parse = re.search('<h4>Categories</h4>(.*?)$', data, re.S)
		if parse:
			Cats = MPfindall(self, 'class="col-xs-6.*?href="(.*?)".*?data-src="(.*?)"\stitle="(.*?)"', parse.group(1), re.S)
			if Cats:
				for (Url, Image, Title) in Cats:
					Url = "https://www.xfreehd.com" + Url + "?type=public&page="
					Image = "https://www.xfreehd.com" + Image
					Title = Title.strip()
					self._items.append((decodeHtml(Title), Url, Image))
		self._items.sort()
		self._items.insert(0, ("Longest", "https://www.xfreehd.com/videos?type=public&o=lg&page=", default_cover))
		self._items.insert(0, ("Most Commented", "https://www.xfreehd.com/videos?type=public&o=md&page=", default_cover))
		self._items.insert(0, ("Top Favorites", "https://www.xfreehd.com/videos?type=public&o=tf&page=", default_cover))
		self._items.insert(0, ("Top Rated", "https://www.xfreehd.com/videos?type=public&o=tr&page=", default_cover))
		self._items.insert(0, ("Most Viewed", "https://www.xfreehd.com/videos?type=public&o=mv&page=", default_cover))
		self._items.insert(0, ("Most Recent", "https://www.xfreehd.com/videos?type=public&o=mr&page=", default_cover))
		self._items.insert(0, ("--- Search ---", "callSuchen", default_cover))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image, agent=agent)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen(suggest_func=self.getSuggestions)
		else:
			Link = self['liste'].getCurrent()[0][1]
			self.session.open(xfreehdFilmScreen, Link, Name)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = urllib.parse.quote(callback).replace(' ', '+')
			self.session.open(xfreehdFilmScreen, Link, Name)

	def getSuggestions(self, text, max_res):
		url = "https://www.xfreehd.com/ajax/search_suggest"
		postdata = {'search_query':text, 'search_type':'videos'}
		d = twAgentGetPage(url, method='POST', postdata=urlencode(postdata), agent=agent, headers=json_headers, timeout=5)
		d.addCallback(self.gotSuggestions, max_res)
		d.addErrback(self.gotSuggestions, max_res, err=True)
		return d

	def gotSuggestions(self, suggestions, max_res, err=False):
		list = []
		if not err and type(suggestions) in (str, buffer):
			suggestions = MPfindall(self, '<li id="sugg_0">(.*?)</li>', suggestions.replace('\\"', '"').replace('\/', '/'), re.S)
			for item in suggestions:
				li = item
				list.append(str(li))
				max_res -= 1
				if not max_res: break
		elif err:
			printl(str(suggestions), self, 'E')
		return list

class xfreehdFilmScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("XFreeHD.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*?Search", self.Name):
			url = "https://www.xfreehd.com/search?search_query=%s&search_type=videos&type=public&page=%s" % (self.Link, str(self.page))
		else:
			url = "%s%s" % (self.Link, str(self.page))
		twAgentGetPage(url, agent=agent).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		self.getLastPage(data, 'class="pagination(.*?)</div>')
		parse = re.search('class="well-sm(.*?)$', data, re.S)
		if parse:
			Movies = MPfindall(self, 'class="col-xs-6.*?href="(.*?)".*?data-src="(.*?)"\stitle="(.*?)".*?class="duration-new">(.*?)</div.*?class="video-views.*?>(.*?)</div', parse.group(1), re.S)
			if Movies:
				for (Url, Image, Title, Runtime, Views) in Movies:
					Url = "https://www.xfreehd.com" + Url
					Runtime = Runtime.strip()
					Views = stripAllTags(Views).strip()
					self._items.append((decodeHtml(Title), Url, Image, Runtime, Views))
		if len(self._items) == 0:
			self._items.append((_('No movies found!'), None, None, None, None))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Url = self['liste'].getCurrent()[0][1]
		if Url == None:
			return
		title = self['liste'].getCurrent()[0][0]
		pic = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][3]
		views = self['liste'].getCurrent()[0][4]
		self['name'].setText(title)
		self['handlung'].setText("Runtime: %s\nViews: %s" % (runtime, views))
		CoverHelper(self['coverArt']).getCover(pic, agent=agent)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		if Link == None:
			return
		self.keyLocked = True
		twAgentGetPage(Link, agent=agent).addCallback(self.getVideoPage).addErrback(self.dataError)

	def getVideoPage(self, data):
		videoPage = MPfindall(self, 'source src="(.*?)"', data, re.S)
		if videoPage:
			self.keyLocked = False
			Title = self['liste'].getCurrent()[0][0]
			url = videoPage[-1]
			mp_globals.player_agent = agent
			self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='xfreehd')