﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
import base64

agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.108 Safari/537.36'
json_headers = {
	'Accept': 'application/json',
	'Accept-Language': 'de,en-US;q=0.7,en;q=0.3',
	'X-Requested-With': 'XMLHttpRequest',
	'Content-Type': 'application/x-www-form-urlencoded',
	}
cookies = CookieJar()

class txxxGenreScreen(MPScreen):

	def __init__(self, session, mode, cat="categories", scope=0):
		self.mode = mode

		global default_cover
		if self.mode == "txxx":
			self.portal = "TXXX.com"
			self.baseurl = "https://txxx.com"
			default_cover = "file://%s/txxx.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "hclips":
			self.portal = "HClips.com"
			self.baseurl = "https://hclips.com"
			default_cover = "file://%s/hclips.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "voyeurhit":
			self.portal = "VoyeurHit.com"
			self.baseurl = "https://voyeurhit.com"
			default_cover = "file://%s/voyeurhit.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "tubepornclassic":
			self.portal = "TubePornClassic.com"
			self.baseurl = "https://tubepornclassic.com"
			default_cover = "file://%s/tubepornclassic.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "shemalez":
			self.portal = "ShemaleZ.com"
			self.baseurl = "https://shemalez.com"
			default_cover = "file://%s/shemalez.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "vjav":
			self.portal = "VJAV.com"
			self.baseurl = "https://vjav.com"
			default_cover = "file://%s/vjav.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "upornia":
			self.portal = "Upornia.com"
			self.baseurl = "https://upornia.com"
			default_cover = "file://%s/upornia.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "hotmovs":
			self.portal = "HotMovs.com"
			self.baseurl = "https://hotmovs.com"
			default_cover = "file://%s/hotmovs.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

		self.cat = cat
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber_,
			"yellow" : self.keyScope
		}, -1)

		if self.mode in ["shemalez"]:
			self.scope = 1
		else:
			self.scope = scope
		self.scopeText = ['Straight', 'Shemale', 'Gay']
		self.scopeval = ['str', 'she', 'gay']

		self['title'] = Label(self.portal)
		self['ContentTitle'] = Label("Genre:")
		if self.cat in ["pornstars", "channels", "playlists"]:
			self['F2'] = Label(_("Page"))
			self['Page'] = Label(_("Page:"))
		if self.cat == "categories" and self.mode in ["txxx", "hclips", "upornia", "hotmovs"]:
			self['F3'] = Label(self.scopeText[self.scope])

		self.page = 1
		self.lastpage = 1
		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self._items = []
		if self.cat == "categories":
			if self.mode in ["txxx", "hclips", "upornia", "hotmovs"]:
				self['F3'].setText(self.scopeText[self.scope])
			url = "%s/api/json/categories/14400/%s.all.json" % (self.baseurl, self.scopeval[self.scope])
		elif self.cat == "pornstars":
			url = "%s/api/json/models/86400/%s/filt........../most-popular/22/%s.json" % (self.baseurl, self.scopeval[self.scope], str(self.page))
		elif self.cat == "channels":
			url = "%s/api/json/channels/86400/%s/latest-updates/22/..%s.json" % (self.baseurl, self.scopeval[self.scope], str(self.page))
		elif self.cat == "playlists":
			url = "%s/api/json/playlists/86400/latest-updates/22/all.%s.%s..json" % (self.baseurl, str(self.page), self.scopeval[self.scope])
		elif self.cat == "popular_in":
			self.genreData('')
			return
		twAgentGetPage(url, agent=agent, cookieJar=cookies, headers={'Referer':self.baseurl}).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		if self.cat != "popular_in":
			json_data = json.loads(data)
		if self.cat == "categories":
			for item in json_data["categories"]:
				Count = int(item["total_videos"])
				Title = str(item["title"])
				Url = "cat#%s" % str(item["dir"])
				if Count > 5:
					self._items.append((Title, Url, default_cover))
			self._items.sort()
			self._items.insert(0, (400 * "—", None, default_cover))
			if self.mode in ["txxx", "tubepornclassic", "shemalez", "vjav", "upornia", "hotmovs"]:
				self._items.insert(0, ("Playlists", "playlists", default_cover))
			if self.mode in ["txxx", "hclips", "shemalez", "upornia", "hotmovs"]:
				self._items.insert(0, ("Channels", "channels", default_cover))
			if self.mode in ["txxx", "tubepornclassic", "shemalez", "vjav", "upornia", "hotmovs"]:
				self._items.insert(0, ("Pornstars", "pornstars", default_cover))
				self._items.insert(0, (400 * "—", None, default_cover))
			self._items.insert(0, ("Popular in...", "popular_in", default_cover))
			self._items.insert(0, ("Longest", "main#longest", default_cover))
			self._items.insert(0, ("Most Commented", "main#most-commented", default_cover))
			self._items.insert(0, ("Most Popular", "main#most-popular", default_cover))
			self._items.insert(0, ("Top Rated", "main#top-rated", default_cover))
			self._items.insert(0, ("Newest", "main#latest-updates", default_cover))
			self._items.insert(0, ("--- Search ---", "callSuchen", default_cover))
		elif self.cat == "pornstars":
			if "total_count" in json_data:
				count = int(json_data["total_count"])
				lastp = round((count / 22) + 0.5)
				self.lastpage = int(lastp)
				self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
			for item in json_data["models"]:
				Title = str(item["title"])
				Url = "pornstar#%s" % str(item["dir"])
				Image = str(item["img"])
				self._items.append((Title, Url, Image))
		elif self.cat == "channels":
			if "total_count" in json_data:
				count = int(json_data["total_count"])
				lastp = round((count / 22) + 0.5)
				self.lastpage = int(lastp)
				self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
			for item in json_data["channels"]:
				Title = str(item["title"])
				Url = "channel#%s" % str(item["dir"])
				Image = str(item["img"])
				self._items.append((Title, Url, Image))
		elif self.cat == "playlists":
			if "total_count" in json_data:
				count = int(json_data["total_count"])
				lastp = round((count / 22) + 0.5)
				self.lastpage = int(lastp)
				self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
			else:
				self.lastpage = 430
				self['page'].setText(str(self.page))
			for item in json_data["playlists"]:
				Title = str(item["title"])
				Url = "playlist#%s" % str(item["playlist_id"])
				Image = str(item["thumbs"][0])
				self._items.append((Title, Url, Image))
		elif self.cat == "popular_in":
			cc = ["us", "de", "in", "ru", "fr", "jp", "kr", "gb", "es", "pl", "it", "ca", "nl", "sg", "ua", "tw", "mx", "be", "th", "br", "au", "dz", "eg", "gr", "cz", "hu", "ph", "ch", "ro", "at", "vn", "se", "eu", "pk", "hk", "ar", "il", "dk", "lk", "iq", "my", "bg", "fi", "co", "id", "rs", "no", "za", "sk", "pt", "by", "pe", "mn", "ie", "cl", "hr", "nz", "cn", "ma", "jo", "az", "md", "lt", "si", "lb", "ba", "lv", "lu", "tn", "ec", "mm", "ee", "ge", "kh", "bo", "cr", "sy", "do", "am", "pa", "mk", "kg", "pr", "cw", "cy", "gt", "ng", "uy", "sv", "uz", "ps", "hn", "ke", "al", "mo", "mu", "tt", "ni", "ve"]
			names = {"ad":"Andorra","ae":"United Arab Emirates","af":"Afghanistan","ag":"Antigua and Barbuda","ai":"Anguilla","al":"Albania","am":"Armenia","ao":"Angola","aq":"Antarctica","ar":"Argentina","as":"American Samoa","at":"Austria","au":"Australia","aw":"Aruba","ax":"Aland Islands","az":"Azerbaijan","ba":"Bosnia and Herzegovina","bb":"Barbados","bd":"Bangladesh","be":"Belgium","bf":"Burkina Faso","bg":"Bulgaria","bh":"Bahrain","bi":"Burundi","bj":"Benin","bl":"Saint Barthelemy","bm":"Bermuda","bn":"Brunei Darussalam","bo":"Bolivia","br":"Brazil","bs":"Bahamas","bt":"Bhutan","bw":"Botswana","by":"Belarus","bz":"Belize","ca":"Canada","cc":"Cocos Islands","cd":"Congo, Democratic Republic","cf":"Central African Republic","cg":"Congo","ch":"Switzerland","ci":"CÃ´te D\'ivoire","ck":"Cook Islands ","cl":"Chile","cm":"Cameroon","cn":"China","co":"Colombia","cr":"Costa Rica","cu":"Cuba","cv":"Guinea-Bissau","cw":"Curacao","cx":"Christmas Island","cy":"Cyprus","cz":"Czech Republic","de":"Germany","dj":"Djibouti","dk":"Denmark","dm":"Dominica","do":"Dominican Republic","dz":"Algeria","ec":"Ecuador","ee":"Estonia","eg":"Egypt","eh":"Western Sahara","er":"Eritrea","es":"Spain","et":"Ethiopia","eu":"Europe","fi":"Finland","fj":"Fiji","fk":"Falkland Islands","fm":"Micronesia","fo":"Faroe Islands","fr":"France","ga":"Gabon","gb":"United Kingdom","gd":"Grenada","ge":"Georgia","gf":"French Guiana","gh":"Ghana","gi":"Gibraltar","gl":"Greenland","gm":"Gambia","gn":"Guinea","gp":"Guadeloupe","gq":"Equatorial Guinea","gr":"Greece","gs":"South Georgia and the South sandwich Islands","gt":"Guatemala","gu":"GUAM","gw":"Guinea-Bissau","gy":"Guyana","hk":"Hong Kong","hm":"The heard island and MacDonald island","hn":"Honduras","hr":"Croatia","ht":"Haiti","hu":"Hungary","id":"Indonesia","ie":"Ireland","il":"Israel","in":"India","io":"British Indian Ocean Territory ","iq":"Iraq","ir":"Iran","is":"Iceland","it":"Italy","jm":"Jamaica","jo":"Jordan","jp":"Japan","ke":"Kenya","kg":"Kyrgyzstan","kh":"Cambodia","ki":"Kiribati","km":"Comoros","kn":"Saint Kitts and Nevis","kp":"The DPRK","kr":"The Republic Of Korea","kw":"Kuwait","ky":"Cayman Islands","kz":"Kazakhstan","la":"Loss","lb":"Lebanon","lc":"Saint Lucia","li":"Liechtenstein","lk":"Sri Lanka","lr":"Liberia","ls":"Lesotho","lt":"Lithuania","lu":"Luxembourg","lv":"Latvia","ly":"Libya","ma":"Morocco","mc":"Monaco","md":"Moldova, Republic Of","me":"Montenegro","mg":"Madagascar","mh":"Marshall Islands","mk":"Macedonia","ml":"Mali","mm":"Myanmar","mn":"Mongolia","mo":"Macau","mp":"Northern Mariana Islands","mq":"Martinique","mr":"Mauritania","ms":"Montserrat","mt":"Malta","mu":"Mauritius","mv":"The Maldives","mw":"Malawi","mx":"Mexico","my":"Malaysia","mz":"Mozambique","na":"Namibia","nc":"New Caledonia","ne":"Niger","nf":"Norfolk Island ","ng":"Nigeria","ni":"Nicaragua","nl":"Netherlands","no":"Norway","np":"Nepal","nr":"Nauru","nu":"Niue","nz":"New Zealand","om":"Oman","pa":"Panama","pe":"Peru","pf":"French Polynesia","pg":"Papua New Guinea","ph":"Philippines","pk":"Pakistan","pl":"Poland","pm":"Saint Pierre and Miquelon","pn":"Pitcairn","pr":"Puerto Rico","ps":"Palestinian Territory, Occupied","pt":"Portugal","pw":"Palau","py":"Paraguay","qa":"Qatar","re":"Reunion","ro":"Romania","rs":"Serbia","ru":"Russia","rw":"Rwanda","sa":"Saudi Arabia","sb":"Solomon Islands","sc":"Seychelles","sd":"Sudan","se":"Sweden","sg":"Singapore","sh":"Helena","si":"Slovenia","sj":"Svalbard and Jan Mayen","sk":"Slovakia","sl":"Sierra Leone","sm":"San Marino","sn":"Senegal","so":"Somalia","sr":"Suriname","ss":"South Sudan","st":"Sao Tome and Principe","sv":"Salvador","sy":"Syrian Arab Republic","sz":"Swaziland","tc":"Turks and Caicos Islands","td":"Chad","tf":"French Southern Territories","tg":"That","th":"Thailand","tj":"Tajikistan","tk":"Tokelau","tl":"East Timor","tm":"Turkmenistan","tn":"Tunisia","to":"Tonga","tr":"Turkey","tt":"Trinidad and Tobago","tv":"Tuvalu","tw":"Taiwan, province of China","tz":"Tanzania","ua":"Ukraine","ug":"Uganda","um":"Minor outlying Islands USA","us":"USA","uy":"Uruguay","uz":"Uzbekistan","va":"The Vatican","vc":"Saint Vincent and the Grenadines","ve":"Venezuela","vg":"Virgin Islands, British","vi":"Virgin Islands, USA","vn":"Vietnam","vu":"Vanuatu","wf":"Wallis and Futuna","ws":"Samoa","ye":"Yemen","yt":"Mayotte","za":"South Africa","zm":"Zambia","zw":"Zimbabwe"}
			for item in cc:
				Title = names[item]
				Url = "country#%s" % item
				Image = "%s/static/images/flags/%s.svg" % (self.baseurl, item)
				self._items.append((Title, Url, Image))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen(suggest_func=self.getSuggestions)
		elif Name == "Pornstars":
			self.session.open(txxxGenreScreen, self.mode, cat="pornstars", scope=self.scope)
		elif Name == "Channels":
			self.session.open(txxxGenreScreen, self.mode, cat="channels", scope=self.scope)
		elif Name == "Playlists":
			self.session.open(txxxGenreScreen, self.mode, cat="playlists", scope=self.scope)
		elif Name == "Popular in...":
			self.session.open(txxxGenreScreen, self.mode, cat="popular_in", scope=self.scope)
		else:
			Link = self['liste'].getCurrent()[0][1]
			if Link:
				self.session.open(txxxFilmScreen, Link, Name, self.portal, self.baseurl, self.scopeval[self.scope])

	def keyScope(self):
		if not self.mode in ["txxx", "hclips", "upornia", "hotmovs"]:
			return
		if self.cat != "categories":
			return
		if self.keyLocked:
			return
		self._items = []
		if self.scope == 0:
			self.scope = 1
		elif self.scope == 1:
			self.scope = 2
		else:
			self.scope = 0
		self.loadPage()

	def keyPageNumber_(self):
		if self.cat in ["pornstars", "channels", "playlists"]:
			self.keyPageNumber()

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '+'))
			self.session.open(txxxFilmScreen, Link, Name, self.portal, self.baseurl, self.scopeval[self.scope])

	def getSuggestions(self, text, max_res):
		url = "%s/api/suggester.php?c=%s" % (self.baseurl, urllib.parse.quote_plus(text))
		json_headers.update({'Referer':self.baseurl})
		d = twAgentGetPage(url, agent=agent, headers=json_headers, timeout=5)
		d.addCallback(self.gotSuggestions, max_res)
		d.addErrback(self.gotSuggestions, max_res, err=True)
		return d

	def gotSuggestions(self, suggestions, max_res, err=False):
		list = []
		if not err and type(suggestions) in (str, buffer):
			suggestions = json.loads(suggestions)
			for item in suggestions["keywords"]:
				li = item
				list.append(str(li))
				max_res -= 1
				if not max_res: break
		elif err:
			printl(str(suggestions), self, 'E')
		return list

class txxxFilmScreen(MPScreen):

	def __init__(self, session, Link, Name, portal, baseurl, scope='str'):
		self.Link = Link
		self.Name = Name
		self.portal = portal
		self.baseurl = baseurl
		if self.portal in ["ShemaleZ.com"]:
			self.scope = "she"
		else:
			self.scope = scope

		global default_cover
		if self.portal == "TXXX.com":
			default_cover = "file://%s/txxx.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "HClips.com":
			default_cover = "file://%s/hclips.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "VoyeurHit.com":
			default_cover = "file://%s/voyeurhit.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "TubePornClassic.com":
			default_cover = "file://%s/tubepornclassic.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "ShemaleZ.com":
			default_cover = "file://%s/shemalez.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "VJAV.com":
			default_cover = "file://%s/vjav.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "Upornia.com":
			default_cover = "file://%s/upornia.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "HotMovs.com":
			default_cover = "file://%s/hotmovs.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label(self.portal)
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*Search", self.Name):
			url = "%s/api/videos.php?params=86400/%s/relevance/60/search..%s.all..day&s=%s" % (self.baseurl, self.scope, str(self.page), self.Link)
		else:
			if self.Link.split('#')[0] == "main":
				url = "%s/api/json/videos/86400/%s/%s/60/..%s.all..all.json" % (self.baseurl, self.scope, self.Link.split('#')[-1], str(self.page))
			elif self.Link.split('#')[0] == "cat":
				url = "%s/api/json/videos/86400/%s/latest-updates/60/categories.%s.%s.all..day.json" % (self.baseurl, self.scope, self.Link.split('#')[-1], str(self.page))
			elif self.Link.split('#')[0] == "country":
				url = "%s/api/json/videos/86400/%s/latest-updates/60/top-country.%s.%s.all..day.json" % (self.baseurl, self.scope, self.Link.split('#')[-1], str(self.page))
			elif self.Link.split('#')[0] == "pornstar":
				url = "%s/api/json/videos/86400/%s/latest-updates/60/model.%s.%s.all...json" % (self.baseurl, self.scope, self.Link.split('#')[-1], str(self.page))
			elif self.Link.split('#')[0] == "channel":
				url = "%s/api/json/videos/86400/%s/latest-updates/60/channel.%s.%s.all...json" % (self.baseurl, self.scope, self.Link.split('#')[-1], str(self.page))
			elif self.Link.split('#')[0] == "playlist":
				url = "%s/api/json/videos/86400/%s/latest-updates/60/playlist.%s.%s.all...json" % (self.baseurl, self.scope, self.Link.split('#')[-1], str(self.page))
		twAgentGetPage(url, agent=agent, cookieJar=cookies, headers={'Referer':self.baseurl}).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		json_data = json.loads(data)
		if "total_count" in json_data:
			count = int(json_data["total_count"])
			lastp = round((count / 60) + 0.5)
			self.lastpage = int(lastp)
			self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
		if "videos" in json_data:
			for item in json_data["videos"]:
				title = str(item["title"])
				url = "%s/api/videofile.php?video_id=%s&lifetime=8640000" % (self.baseurl, str(item["video_id"]))
				image = str(item["scr"])
				duration = str(item["duration"])
				added = str(item["post_date"])
				views = str(item["video_viewed"])
				self._items.append((title, url, image, duration, views, added))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), None, None, '', '', ''))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		pic = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][3]
		views = self['liste'].getCurrent()[0][4]
		added = self['liste'].getCurrent()[0][5]
		self['name'].setText(title)
		self['handlung'].setText("Runtime: %s\nViews: %s\nAdded: %s" % (runtime, views, added))
		CoverHelper(self['coverArt']).getCover(pic)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		if Link:
			self.keyLocked = True
			twAgentGetPage(Link, agent=agent, cookieJar=cookies, headers={'Referer':self.baseurl}).addCallback(self.playVideo).addErrback(self.dataError)

	def playVideo(self, data):
		video = MPfindall(self, '"video_url":"(.*?)",', data, re.S)
		self.keyLocked = False
		if video:
			url = video[0]
			chr = {'A':'\u0410', 'B':'\u0412', 'C':'\u0421', 'E':'\u0415', 'M':'\u041c', '/':',', '+':'.', '=':'~'}
			for i in chr:
				url = url.replace(chr[i], i)
			url = base64.b64decode(url)
			if url.startswith('//'):
				url = 'https:' + url
			if url.startswith('/'):
				url = self.baseurl + url
			Title = self['liste'].getCurrent()[0][0]
			mp_globals.player_agent = agent
			self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='txxx')