﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.configlistext import ConfigListScreenExt

agent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.167 Safari/537.36'
base_url = "https://www.sextvx.com"
default_cover = "file://%s/sextvx.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class sextvxGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Sextvx.com")
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		url = base_url + "/en/categories/"
		twAgentGetPage(url, agent=agent).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		dupe = []
		parse = re.search('class="panes ptube carousel">(.*?)</html>', data, re.S)
		if parse:
			Cats = MPfindall(self, 'class="video_thumb".*?href="(.*?)".*?img.*?data-src="(.*?)".*?alt="(.*?)"', parse.group(1), re.S)
			if Cats:
				for (Url, Image, Title) in Cats:
					if Url.startswith('/'):
						Url = base_url + Url
					if Image == "":
						Image = default_cover
					elif Image.startswith('//'):
						Image = 'https:' + Image
					Title = decodeHtml(upperString(Title.replace('-', ' ')))
					dupe.append(Title)
					self._items.append((Title, Url, Image))
		parse = re.search('class="categories-title"(.*?)</ul>', data, re.S)
		if parse:
			Cats = MPfindall(self, '<li>.*?href="(.*?)"\stitle="(.*?)".*?</li>', parse.group(1), re.S)
			if Cats:
				for (Url, Title) in Cats:
					if Url.startswith('/'):
						Url = base_url + Url
					Title = decodeHtml(upperString(Title.replace('-', ' ')))
					if Title not in dupe:
						self._items.append((Title, Url, default_cover))
		self._items.sort()
		self._items.insert(0, ("HD", '%s/en/hd_porn' % base_url, default_cover))
		self._items.insert(0, ("Most Popular", '%s/en/popular' % base_url, default_cover))
		self._items.insert(0, ("Most Recent", '%s/en/recent' % base_url, default_cover))
		self._items.insert(0, ("--- Search ---", "callSuchen", default_cover))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen()
		else:
			Link = self['liste'].getCurrent()[0][1]
			self.session.open(sextvxFilmScreen, Link, Name)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = urllib.parse.quote(callback).replace(' ', '+')
			self.session.open(sextvxFilmScreen, Link, Name)

class sextvxFilmScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("Sextvx.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*?Search", self.Name):
			url = "%s/en/results?search_query=%s&search_duration=&uploaded=&sortby=&is_hd=&page=%s" % (base_url, self.Link, str(self.page))
		else:
			url = "%s/%s" % (self.Link, str(self.page))
		twAgentGetPage(url, agent=agent).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		self.getLastPage(data, 'pagination-centered">(.*?)</ul>')
		parse = re.search('class="panes ptube carousel">(.*?)</html>', data, re.S)
		if parse:
			Movies = MPfindall(self, 'class="video_thumb".*?href="(.*?)".*?img.*?(?:src|data-src)="(.*?)".*?alt="(.*?)".*?title="duration">.*?</span>(.*?)</span>', parse.group(1), re.S)
			if Movies:
				for (Url, Image, Title, Runtime) in Movies:
					if Url.startswith('/'):
						Url = base_url + Url
					if Image.startswith('//'):
						Image = 'https:' + Image
					Runtime = Runtime.strip()
					self._items.append((decodeHtml(Title), Url, Image, Runtime))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), None, None, ''))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		pic = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][3]
		self['handlung'].setText("Runtime: %s" % (runtime))
		self['name'].setText(title)
		CoverHelper(self['coverArt']).getCover(pic)

	def keyOK(self):
		if self.keyLocked:
			return
		url = self['liste'].getCurrent()[0][1]
		twAgentGetPage(url, agent=agent).addCallback(self.getVideoPage).addErrback(self.dataError)

	def getVideoPage(self, data):
		vidurl = None
		url = MPfindall(self, "<source src='(.*?)' title='\d+p'", data, re.S)
		if url:
			vidurl = url[-1]
		if vidurl:
			Title = self['liste'].getCurrent()[0][0]
			self.session.open(SimplePlayer, [(Title, vidurl)], showPlaylist=False, ltype='sextvx')