﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *

agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36'

class pornicomGenreScreen(MPScreen):

	def __init__(self, session, mode):
		self.mode = mode

		global default_cover
		if self.mode == "pornicom":
			self.portal = "Pornicom.com"
			self.baseurl = "https://www.pornicom.com"
			default_cover = "file://%s/pornicom.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "vikiporn":
			self.portal = "VikiPorn.com"
			self.baseurl = "http://www.vikiporn.com"
			default_cover = "file://%s/vikiporn.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "sleazyneasy":
			self.portal = "SleazyNEasy.com"
			self.baseurl = "https://www.sleazyneasy.com"
			default_cover = "file://%s/sleazyneasy.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "katestube":
			self.portal = "KatesTube.com"
			self.baseurl = "https://www.katestube.com"
			default_cover = "file://%s/katestube.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "pervclips":
			self.portal = "PervClips.com"
			self.baseurl = "https://www.pervclips.com/tube"
			default_cover = "file://%s/pervclips.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "wankoz":
			self.portal = "Wankoz.com"
			self.baseurl = "https://www.wankoz.com"
			default_cover = "file://%s/wankoz.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "pornwhite":
			self.portal = "PornWhite.com"
			self.baseurl = "https://www.pornwhite.com"
			default_cover = "file://%s/pornwhite.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "sheshaft":
			self.portal = "Sheshaft.com"
			self.baseurl = "https://www.sheshaft.com"
			default_cover = "file://%s/sheshaft.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "fetishshrine":
			self.portal = "FetishShrine.com"
			self.baseurl = "https://www.fetishshrine.com"
			default_cover = "file://%s/fetishshrine.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label(self.portal)
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True

		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		self.keyLocked = True
		url = "%s/categories/" % self.baseurl
		twAgentGetPage(url, agent=agent).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		parse = re.search('(?:class="thumbs-holder"|class="categories-thumbs"|class="thumbs-list")(.*?)(?:class="thumb_spots|class="bottom-banners")', data, re.S)
		if parse:
			Cats = MPfindall(self, 'class="(?:item|thumb)">.*?href="(.*?)".*?(?:data-original|src)=[\'\"]([A-Za-z0-9_:.,-=\/\?]+[^placeholder]\.(?:jpg|png))[\'\"\?].*?alt="(.*?)"', parse.group(1), re.S)
			if Cats:
				for (Url, Image, Title) in Cats:
					if Url.startswith('/'):
						Url = self.baseurl + Url
					self._items.append((upperString(Title), Url, Image.replace(' ', '%20')))
				self._items.sort()
		self._items.insert(0, ("Top Rated", "%s/top-rated/" % self.baseurl, default_cover))
		self._items.insert(0, ("Most Popular", "%s/most-popular/" % self.baseurl, default_cover))
		self._items.insert(0, ("Newest", "%s/latest-updates/" % self.baseurl, default_cover))
		self._items.insert(0, ("--- Search ---", "callSuchen", default_cover))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		cover = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(cover)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		if Name == "--- Search ---":
			self.suchen()
		elif Link:
			self.session.open(pornicomFilmScreen, Link, Name, self.portal, self.baseurl)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '+'))
			self.session.open(pornicomFilmScreen, Link, Name, self.portal, self.baseurl)

class pornicomFilmScreen(MPScreen):

	def __init__(self, session, Link, Name, portal, baseurl):
		self.Link = Link
		self.Name = Name
		self.portal = portal
		self.baseurl = baseurl

		global default_cover
		if self.portal == "Pornicom.com":
			default_cover = "file://%s/pornicom.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "VikiPorn.com":
			default_cover = "file://%s/vikiporn.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "SleazyNEasy.com":
			default_cover = "file://%s/sleazyneasy.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "KatesTube.com":
			default_cover = "file://%s/katestube.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "PervClips.com":
			default_cover = "file://%s/pervclips.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "Wankoz.com":
			default_cover = "file://%s/wankoz.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "PornWhite.com":
			default_cover = "file://%s/pornwhite.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "Sheshaft.com":
			default_cover = "file://%s/sheshaft.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "FetishShrine.com":
			default_cover = "file://%s/fetishshrine.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label(self.portal)
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*Search", self.Name):
			url = "%s/search/%s/?q=%s" % (self.baseurl, str(self.page), self.Link)
		else:
			url = "%s%s/" % (self.Link, str(self.page))
		twAgentGetPage(url, agent=agent).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		self.getLastPage(data, '(?:class="pagination"|class="pager"|class="paging-area")(.*?)</ul>', '.*>(\d+)<')
		parse = re.search('(?:class="thumbs-holder"|class="thumbs-list")(.*?)(?:class="thumb_spots|class="bottom-banners")', data, re.S)
		if parse:
			data = parse.group(1)
			if 'class="item video-thumb' in data:
				data = data.split('class="item video-thumb')
			elif 'class="item thumb' in data:
				data = data.split('class="item thumb')
			elif 'class="thumb"' in data:
				data = data.split('class="thumb"')
			for item in data:
				Url = MPfindall(self, "href=[\'\"]([^\"\']+?)[\'\"]", item, re.S)
				Url = Url[0] if Url else ''
				Title = MPfindall(self, "alt=[\'\"](.*?)[\'\"](?:\s|>)", item, re.S)
				Title = Title[0] if Title else ''
				Image = MPfindall(self, "<img.*?(?:src|data-original)=[\'\"]([A-Za-z0-9_:.,-=\/\?]+[^placeholder]\.(?:jpg|png))['\"\?]", item, re.S)
				Image = Image[0] if Image else ''
				Runtime = MPfindall(self, '"duration"(?:\scontent=|\sclass="length"|)[\'\">]([^\"\']+?)(?:</i|</span|</div|\'|\")', item, re.S)
				Runtime = stripAllTags(Runtime[0]).strip() if Runtime else ''
				Views = MPfindall(self, 'class="(?:icon-eye|views)"(?:>Views|).*?>(.*?)</span', item, re.S)
				Views = stripAllTags(Views[0]).strip() if Views else ''
				Age = ''
				if "|" in Views:
					Age = Views.split("|")[1].strip()
					Views = Views.split("|")[0].replace('Views', '').strip()
				Rating = MPfindall(self, 'class="(?:icon-like|item-rating)"(?:>Porn Rating|>Porn rating|).*?(?:<span|)>(.*?)</span', item, re.S)
				Rating = stripAllTags(Rating[0]).strip() if Rating else ''
				if Url and Title and Image:
					if Url.startswith('/'):
						Url = self.baseurl + Url
					self._items.append((decodeHtml(Title), Url, Image, Runtime, Views, Rating, Age))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), None, None, '', '', ''))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		pic = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][3]
		runtime = "Runtime: %s\n" % runtime if runtime else ''
		views = self['liste'].getCurrent()[0][4]
		views = "Views: %s\n" % views if views else ''
		rated = self['liste'].getCurrent()[0][5]
		rated = "Rating: %s\n" % rated if rated else ''
		age = self['liste'].getCurrent()[0][6]
		age = "Added: %s\n" % age if age else ''
		self['name'].setText(title)
		self['handlung'].setText("%s%s%s%s" % (runtime, age, views, rated))
		CoverHelper(self['coverArt']).getCover(pic)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		if Link:
			self['name'].setText(_('Please wait...'))
			twAgentGetPage(Link, agent=agent).addCallback(self.parseVideo).addErrback(self.dataError)

	def parseVideo(self, data):
		Title = self['liste'].getCurrent()[0][0]
		mp_globals.player_agent = agent
		license = MPfindall(self, 'license_code:\s\'(.*?)\',', data, re.S)
		url = MPfindall(self, 'video_(?:alt_|)url\d{0,1}:\s\'(.*?)\'.*?video_(?:alt_|)url\d{0,1}_text:\s\'(\d+)(?:p|)(?: HD|)\',', data, re.S)
		if not url:
			url = MPfindall(self, 'video_(?:alt_|)url\d{0,1}:\s\'(.*?)\'', data, re.S)
		if license and url:
			try:
				max = 0
				for vid in url:
					if int(vid[1]) > max and not "login" in vid[0]:
						max = int(vid[1])
						url = vid[0]
			except:
				url = url[-1]
			if 'function/0/' in url:
				from ...resources.decrypt import decrypturl
				url = decrypturl(url, license[0])
			self['name'].setText(Title)
			self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='pornicom')