﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.keyboardext import VirtualKeyBoardExt
from ...resources.choiceboxext import ChoiceBoxExt

agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36'
default_cover = "file://%s/porndoe.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

ck = {}
cookies = CookieJar()

class porndoeGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Porndoe.com")
		self['ContentTitle'] = Label("Genre:")

		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		ck.update({'__language':'en'})
		requests.cookies.cookiejar_from_dict(ck, cookiejar=cookies)
		url = "https://porndoe.com/categories"
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		data = re.search('class="categories-listing">(.*?)footer', data, re.S).group(1)
		Cats = MPfindall(self, 'class="item">.*?href="(.*?)".*?data-src="(.*?)".*?class="txt">(.*?)(?:</span|<span)', data, re.S)
		if Cats:
			for (Url, Image, Title) in Cats:
				Url = "https://porndoe.com" + Url
				if Image.startswith('//'):
					Image = 'https:' + Image
				self._items.append((Title.replace('&amp;', '&').strip(), Url, Image, True))
			self._items.sort()
			self._items.insert(0, ("Longest", "https://porndoe.com/videos?sort=duration-down", default_cover, False))
			self._items.insert(0, ("Most Viewed", "https://porndoe.com/videos?sort=views-down", default_cover, False))
			self._items.insert(0, ("Most Popular", "https://porndoe.com/videos?sort=popular-down", default_cover, False))
			self._items.insert(0, ("Top Rated", "https://porndoe.com/videos?sort=likes-down", default_cover, False))
			self._items.insert(0, ("Newest", "https://porndoe.com/videos", default_cover, False))
			self._items.insert(0, ("--- Search ---", "callSuchen", default_cover, False))
			self.ml.setList(list(map(self._defaultlistcenter, self._items)))
			self.ml.moveToIndex(0)
			self.keyLocked = False
			self.showInfos()
		self['name'].setText('')

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image, agent=agent, headers={'Referer':'https://porndoe.com'})

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen()
		else:
			Link = self['liste'].getCurrent()[0][1]
			Sort = self['liste'].getCurrent()[0][3]
			self.session.open(porndoeFilmScreen, Link, Name, Sort)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '+'))
			self.session.open(porndoeFilmScreen, Link, Name, False)

class porndoeFilmScreen(MPScreen):

	def __init__(self, session, Link, Name, Sort):
		self.Link = Link
		self.Name = Name
		self.Sort = Sort
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber,
			"yellow" : self.keySort
		}, -1)

		self['title'] = Label("Porndoe.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))
		if self.Sort:
			self['F3'] = Label(_("Sort"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		if not self.Sort:
			self.sort = ''
			self.sortname = ''
		else:
			self.sort = ''
			self.sortname = 'Date'

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*?Search", self.Name):
			url = 'https://porndoe.com/search?keywords=%s&page=%s' % (self.Link, str(self.page))
		else:
			if '?' in self.Link or '?' in self.sort:
				delim = '&'
			else:
				delim = '?'
			url = "%s%s%spage=%s" % (self.Link, self.sort, delim, str(self.page))
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		self.getLastPage(data, 'class="paginator"(.*?)</ul>', '.*(?:page=|<span>)(\d+)(?:"|</span>)')
		if 'class="videos-listing">' in data:
			data = re.search('class="videos-listing">(.*?)footer', data, re.S).group(1)
		else:
			data = re.search('<body(.*?)footer', data, re.S).group(1)
		Movies = MPfindall(self, 'class="video-item-media".*?data-src="(.*?)".*?href="(.*?)".*?class="item-stat right duration (?:star|)".*?txt">(.*?)</span.*?video-item-title".*?aria-label="(.*?)".*?class="item-stat views".*?txt">(.*?)</span', data, re.S)
		if Movies:
			for (Image, Url, Runtime, Title, Views) in Movies:
				Url = "https://porndoe.com" + Url
				if Image.startswith('//'):
					Image = 'http:' + Image
				Runtime = Runtime.strip()
				Views = Views.strip()
				self._items.append((decodeHtml(Title.strip()), Url, Image, Runtime, Views))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), '', None, '', ''))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		pic = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][3]
		views = self['liste'].getCurrent()[0][4]
		self['name'].setText(title)
		self['handlung'].setText("Runtime: %s\nViews: %s" % (runtime, views))
		self['extrainfo'].setText("%s: %s" % (_("Sort order"), self.sortname))
		CoverHelper(self['coverArt']).getCover(pic, agent=agent, headers={'Referer':'https://porndoe.com'})

	def keySort(self):
		if self.keyLocked:
			return
		if not self.Sort:
			return
		rangelist = [['Date', ''], ['Views', '?sort=views-down'], ['Likes', '?sort=likes-down'], ['Duration', '?sort=duration-down']]
		self.session.openWithCallback(self.keySortAction, ChoiceBoxExt, title=_('Select Action'), list = rangelist)

	def keySortAction(self, result):
		if result:
			self.sort = result[1]
			self.sortname = result[0]
			self.loadPage()

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		twAgentGetPage(Link, agent=agent, cookieJar=cookies).addCallback(self.getId).addErrback(self.dataError)

	def getId(self, data):
		id = MPfindall(self, '"id": "(\d+)"', data, re.S)
		if id:
			url = "https://porndoe.com/service/index?device=desktop&page=video&id=" + id[0]
			ref = self['liste'].getCurrent()[0][1]
			twAgentGetPage(url, agent=agent, cookieJar=cookies, headers={'Referer':ref}).addCallback(self.getVideoPage).addErrback(self.dataError)

	def getVideoPage(self, data):
		Title = self['liste'].getCurrent()[0][0]
		self['name'].setText(Title)
		videoPage = MPfindall(self, '"(\d+)":{"type":"video".*?"url":"(.*?)"', data, re.S)
		self.keyLocked = False
		if videoPage:
			maxres = 0
			for (res, vidurl) in videoPage:
				if int(res) > maxres:
					maxres = int(res)
					url = vidurl.replace('\/', '/')
			if url.startswith('//'):
				url = 'http:' + url
			headers = '&Referer=' + self['liste'].getCurrent()[0][1]
			url = url + '#User-Agent='+agent+headers
			mp_globals.player_agent = agent
			self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='porndoe')