# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
import subprocess
from pornhub import pornhubResolver

json_headers = {
	'Accept':'application/json, text/plain, */*',
	'Accept-Encoding':'deflate',
	'Accept-Language':'de,en-US;q=0.7,en;q=0.3',
	'Content-Type':'application/json;charset=utf-8'
	}
agent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.102 Safari/537.36'
default_cover = "file://%s/hotscope.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

BASE_URL = 'https://api.hotscope.tv/'

class hotscopeGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Hotscope.tv")
		self['ContentTitle'] = Label("Genre:")

		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		url = "https://hotscope.tv/categories"
		twAgentGetPage(url, agent=agent).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		Cats = MPfindall(self, '<a.*?href="/category/(.*?)".*?data-src="(.*?)"', data, re.S)
		if Cats:
			for (Url, Image) in Cats:
				Title = Url.title()
				Url = BASE_URL + "videos/category?category=" + Url + "&page="
				self._items.append((Title, Url, Image))
			self._items.sort()
			self._items.insert(0, ("Porn", BASE_URL + "videos/group?group=other&page=", default_cover))
			self._items.insert(0, ("Snapchat", BASE_URL + "videos/group?group=snapchat&page=", default_cover))
			self._items.insert(0, ("Periscope", BASE_URL + "videos/group?group=periscope&page=", default_cover))
			self._items.insert(0, ("Most Viewed", BASE_URL + "videos/sortBy?sort=-views&page=", default_cover))
			self._items.insert(0, ("Most Recent", BASE_URL + "videos/sortBy?sort=-date&page=", default_cover))
			self._items.insert(0, ("--- Search ---", "callSuchen", default_cover))
			self.ml.setList(list(map(self._defaultlistcenter, self._items)))
			self.ml.moveToIndex(0)
			self.keyLocked = False
			self.showInfos()

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen()
		else:
			Link = self['liste'].getCurrent()[0][1]
			self.session.open(hotscopeFilmScreen, Link, Name)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '%20'))
			self.session.open(hotscopeFilmScreen, Link, Name)

class hotscopeFilmScreen(MPScreen, pornhubResolver):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("Hotscope.tv")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 999

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*Search", self.Name):
			url = BASE_URL + "videos/search?search=%s&page=%s" % (self.Link, str(self.page))
		else:
			url = self.Link + str(self.page)
		twAgentGetPage(url, agent=agent).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		json_data = json.loads(data)
		self['page'].setText(str(self.page))
		if json_data:
			for item in json_data:
				title = str(item['title'])
				image = str(item['image'])
				id = str(item['id'])
				group = str(item['group'])
				self._items.append((decodeHtml(title), group, image, id))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), None, None, None))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		pic = self['liste'].getCurrent()[0][2]
		self['name'].setText(title)
		CoverHelper(self['coverArt']).getCover(pic)

	def keyOK(self):
		if self.keyLocked:
			return
		group = self['liste'].getCurrent()[0][1]
		id = self['liste'].getCurrent()[0][3]
		if group and id:
			if group == "other":
				url = "https://hotscope.tv/snapchat/%s" % id
			else:
				url = "https://hotscope.tv/%s/%s" % (group, id)
			twAgentGetPage(url, agent=agent).addCallback(self.getVideoPage).addErrback(self.dataError)

	def getVideoPage(self, data):
		video = MPfindall(self, '<video preload.*?src="(.*?)"', data, re.S)
		if video:
			url = video[-1]
			Title = self['liste'].getCurrent()[0][0]
			self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='hotscope')
		else:
			embedurl = MPfindall(self, '"embedURL":"https://\w+.pornhub.com/embed/(.*?)",', data.replace('\u002F', '/'), re.S)
			if embedurl:
				self['name'].setText(_('Please wait...'))
				url = "https://www.pornhub.com/view_video.php?viewkey=" + embedurl[0]
				twAgentGetPage(url, agent=agent).addCallback(self.parseVideo).addErrback(self.dataError)