﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *

agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36'
default_cover = "file://%s/faapy.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
cookies = CookieJar()

class faapyGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Faapy.com")
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		url = "https://faapy.com/categories/"
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		parse = re.search('class="thumbs channels"(.*?)class="navigation', data, re.S)
		Cats = MPfindall(self, 'class="channel" href="(.*?)" title="(.*?)"', parse.group(1), re.S)
		if Cats:
			for (Url, Title) in Cats:
				self._items.append((Title, Url))
			self._items.sort()
		self._items.insert(0, ("Channels", "https://faapy.com/channels"))
		self._items.insert(0, ("Top Rated (All Time)", "https://faapy.com/top-rated/"))
		self._items.insert(0, ("Top Rated (Monthly)", "https://faapy.com/top-rated/month/"))
		self._items.insert(0, ("Top Rated (Weekly)", "https://faapy.com/top-rated/week/"))
		self._items.insert(0, ("Top Rated (Daily)", "https://faapy.com/top-rated/today/"))
		self._items.insert(0, ("Most Popular (All Time)", "https://faapy.com/most-popular/"))
		self._items.insert(0, ("Most Popular (Monthly)", "https://faapy.com/most-popular/month/"))
		self._items.insert(0, ("Most Popular (Weekly)", "https://faapy.com/most-popular/week/"))
		self._items.insert(0, ("Most Popular (Daily)", "https://faapy.com/most-popular/today/"))
		self._items.insert(0, ("Latest", "https://faapy.com/"))
		self._items.insert(0, ("--- Search ---", "callSuchen"))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen()
		elif Name == "Channels":
			Link = self['liste'].getCurrent()[0][1]
			self.session.open(faapyChannelsScreen, Link, Name)
		else:
			Link = self['liste'].getCurrent()[0][1]
			self.session.open(faapyFilmScreen, Link, Name)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '+'))
			self.session.open(faapyFilmScreen, Link, Name)

class faapyChannelsScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("Faapy.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)

		self.keyLocked = True
		self.page = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self['F2'].setText(_("Page"))
		self['Page'].setText(_("Page:"))

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		url = self.Link + "/%s/" % self.page
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		self.getLastPage(data, 'class="pagination"(.*?)class="footer"')
		parse = re.search('class="thumbs channels">(.*?)class="footer', data, re.S)
		Movies = MPfindall(self, 'class="thumb".*?href="(.*?/)"\stitle="(.*?)">.*?img\ssrc="(.*?)"', parse.group(1), re.S)
		if Movies:
			for (Url, Title, Image) in Movies:
				if Image.startswith('//'):
					Image = "https:" + Image
				self._items.append((decodeHtml(Title), Url, Image))
		if len(self._items) == 0:
			self._items.append((_('Parsing error!'), None))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.ml.moveToIndex(0)
		self.showInfos()
		self.keyLocked = False

	def showInfos(self):
		Title = self['liste'].getCurrent()[0][0]
		Image = self['liste'].getCurrent()[0][2]
		self['name'].setText(Title)
		CoverHelper(self['coverArt']).getCover(Image, headers={'Referer':'https://faapy.com'})

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		self.session.open(faapyFilmScreen, Link, Name)

class faapyFilmScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("Faapy.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*?Search", self.Name):
			url = "https://faapy.com/search/%s/?q=%s" % (str(self.page), self.Link)
		else:
			url = "%s%s/" % (self.Link, str(self.page))
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		self.getLastPage(data, 'class="pagination"(.*?)class="footer"')
		Movies = MPfindall(self, 'class="item thumb.*?class="th"\shref="(.*?)"\stitle="(.*?)".*?data-original="(.*?)".*?class="icon-eye"></i>.{0,75}<span>(.*?)</span>', data, re.S)
		if Movies:
			for (Url, Title, Image, Views) in Movies:
				if Image.startswith('//'):
					Image = "https:" + Image
				self._items.append((decodeHtml(Title), Url, Image, Views))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), '', None, ''))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.showInfos()
		self.keyLocked = False

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		pic = self['liste'].getCurrent()[0][2]
		views = self['liste'].getCurrent()[0][3]
		self['name'].setText(title)
		self['handlung'].setText("Views: %s\n" % views)
		CoverHelper(self['coverArt']).getCover(pic, headers={'Referer':'https://faapy.com'})

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		if Link:
			self['name'].setText(_('Please wait...'))
			twAgentGetPage(Link, agent=agent, cookieJar=cookies).addCallback(self.parseVideo).addErrback(self.dataError)

	def parseVideo(self, data):
		Title = self['liste'].getCurrent()[0][0]
		mp_globals.player_agent = agent
		license = MPfindall(self, 'license_code:\s\'(.*?)\',', data, re.S)
		url = MPfindall(self, 'video_(?:alt_|)url\d{0,1}:\s\'(.*?)\'.*?video_(?:alt_|)url\d{0,1}_text:\s\'(\d+)(?:p|)(?: HD|)\',', data, re.S)
		if not url:
			url = MPfindall(self, 'video_(?:alt_|)url\d{0,1}:\s\'(.*?)\'', data, re.S)
		if license and url:
			try:
				max = 0
				for vid in url:
					if int(vid[1]) > max and not "login" in vid[0]:
						max = int(vid[1])
						url = vid[0]
			except:
				if not "login" in url[-1]:
					url = url[-1]
				else:
					url = url[-2]
			if 'function/0/' in url:
				from ...resources.decrypt import decrypturl
				url = decrypturl(url, license[0])
			if url:
				tw_agent_hlp = TwAgentHelper(cookieJar=cookies)
				tw_agent_hlp.getRedirectedUrl(url).addCallback(self.getStream).addErrback(self.dataError)
		else:
			message = self.session.open(MessageBoxExt, _("Stream not found"), MessageBoxExt.TYPE_INFO, timeout=5)

	def getStream(self, url):
		Title = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		self['name'].setText(Title)
		ck = requests.utils.dict_from_cookiejar(cookies)
		headers = '&Cookie=%s' % ','.join(['%s=%s' % (key, urllib.parse.quote_plus(ck[key])) for key in ck])
		headers = headers + '&Referer=%s' % Link
		if url.startswith('//'):
			url = 'https:' + url
		url = url + '#User-Agent='+agent+headers
		mp_globals.player_agent = agent
		self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='faapy')