﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.twagenthelper import twAgentGetPage

IPhone5Agent = 'Mozilla/5.0 (iPhone; CPU iPhone OS 5_0 like Mac OS X) AppleWebKit/534.46 (KHTML, like Gecko) Version/5.1 Mobile/9A334 Safari/7534.48.3'
MyHeaders= {'Accept':'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
			'Accept-Language':'en-US,en;q=0.5'}
default_cover = "file://%s/beeg.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

beeg_apikey = ''

class beegGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("beeg.com")
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.getApiKeys)

	def getApiKeys(self):
		url = "https://beeg.com/"
		twAgentGetPage(url, agent=IPhone5Agent, headers=MyHeaders).addCallback(self.getApiKeys2).addErrback(self.dataError)

	def getApiKeys2(self, data):
		js = MPfindall(self, '<script src=(?:"|)(?:https://beeg.com|)(/js/app\.[a-zA-Z0-9]+\.js)(?:"|)>', data, re.S)
		url = "https://beeg.com" + js[0]
		twAgentGetPage(url, agent=IPhone5Agent, headers=MyHeaders).addCallback(self.getApiKeys3).addErrback(self.dataError)

	def getApiKeys3(self, data):
		cpl = MPfindall(self, ',r="(\d+)",c', data, re.S)
		global beeg_apikey
		beeg_apikey = cpl[0]
		url = "https://beeg.com/api/v6/%s/index/main/0/mobile" % beeg_apikey
		twAgentGetPage(url, agent=IPhone5Agent, headers=MyHeaders).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		json_data = json.loads(data)
		for node in json_data["tags"]:
			if int(node["videos"]) > 50:
				Url = 'https://beeg.com/api/v6/%s/index/tag/$PAGE$/mobile?tag=%s' % (beeg_apikey, urllib.parse.quote_plus(str(node["tag"])))
				Title = str(node["tag"]).title()
				self._items.append((Title, Url))
		self._items.sort()
		self._items.insert(0, ("Newest", "https://beeg.com/api/v6/%s/index/main/$PAGE$/mobile" % beeg_apikey))
		self._items.insert(0, ("--- Search ---", "callSuchen"))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen()
		else:
			Link = self['liste'].getCurrent()[0][1]
			self.session.open(beegFilmScreen, Link, Name)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '+'))
			Name = "--- Search ---"
			self.session.open(beegFilmScreen, Link, Name)

class beegFilmScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("beeg.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))

		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*Search", self.Name):
			url = 'https://beeg.com/api/v6/%s/index/search/$PAGE$/mobile?query=%s' % (beeg_apikey, self.Link)
			url = url.replace('$PAGE$', '%s' % str(self.page-1))
		else:
			url = self.Link.replace('$PAGE$', '%s' % str(self.page-1))
		twAgentGetPage(url, agent=IPhone5Agent, headers=MyHeaders).addCallback(self.loadData).addErrback(self.dataError)

	def loadData(self, data):
		self.getLastPage(data, '', '"pages":(.*?),')
		json_data = json.loads(data)
		for node in json_data["videos"]:
			title = str(node["title"])
			if not title:
				title = str(node["ps_name"])
			elif title.strip() == "-":
				title = str(node["ps_name"])
			try:
				image = 'https://img.beeg.com/800x450/%s' % str(node["thumbs"][0]["image"])
			except:
				image = default_cover
			try:
				svid = str(node["svid"])
				pid = str(node["thumbs"][0]["pid"])
				start = str(node["thumbs"][0]["start"])
				end = str(node["thumbs"][0]["end"])
			except:
				continue
			url = 'https://beeg.com/api/v6/%s/video/%s?v=2&p=%s&s=%s&e=%s' % (beeg_apikey, svid, pid, start, end)
			duration = str(node["duration"])
			added = str(node["datetime"])
			self._items.append((title, url, image, duration, added))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), '', None, None, None))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		pic = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][3]
		date = self['liste'].getCurrent()[0][4]
		self['name'].setText(title)
		if runtime:
			m, s = divmod(int(runtime), 60)
			runtime = "Runtime: " + "%02d:%02d\n" % (m, s)
		else:
			runtime = ""
		if date:
			date = MPfindall(self, '(\d{4})-(\d{2})-(\d{2})\s(.*?)$', date)
			date = date[0][2] + "." + date[0][1] + "." + date[0][0]
			date = "Added: " + date
		else:
			date = ""
		self['handlung'].setText(runtime+date)
		CoverHelper(self['coverArt']).getCover(pic, headers={'Referer':'https://beeg.com'})

	def keyOK(self):
		if self.keyLocked:
			return
		url = self['liste'].getCurrent()[0][1]
		twAgentGetPage(url, agent=IPhone5Agent, headers=MyHeaders).addCallback(self.getVideoPage).addErrback(self.dataError)

	def getVideoPage(self, data):
		if mp_globals.model in ["one", "two"]:
			streamlinks = MPfindall(self, '(?:240|480|720|1080|2160)p":"(.*?)"', data, re.S)
		else:
			streamlinks = MPfindall(self, '(?:240|480|720|1080)p":"(.*?)"', data, re.S)
		if streamlinks:
			streamlink = streamlinks[-1].replace('/{DATA_MARKERS}/', '/data=pc_XX__%s/' % beeg_apikey)
			if streamlink.startswith('//'):
				streamlink = "http:" + streamlink
			Title = self['liste'].getCurrent()[0][0]
			Cover = self['liste'].getCurrent()[0][2]
			mp_globals.player_agent = IPhone5Agent
			self.session.open(SimplePlayer, [(Title, streamlink, Cover)], showPlaylist=False, ltype='beeg', cover=True)
		else:
			message = self.session.open(MessageBoxExt, _("Stream not found"), MessageBoxExt.TYPE_INFO, timeout=3)