﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *

agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36'
cookies = CookieJar()
default_cover = "file://%s/focus.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class focusGenre(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("Focus.de")
		self['ContentTitle'] = Label("Genre:")

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self._items.append(("Neueste", "newest"))
		self._items.append(("Meistgesehen", "bookmarks_most-viewed"))
		self._items.append(("Meistkommentiert", "bookmarks_most-commented"))
		self._items.append(("Bestbewertet", "bookmarks_most-rated"))
		self._items.append(("Politik", "4178"))
		self._items.append(("Finanzen", "4343"))
		self._items.append(("Wissen", "5200"))
		self._items.append(("Gesundheit", "4707"))
		self._items.append(("Kultur", "5417"))
		self._items.append(("Panorama", "5603"))
		self._items.append(("Sport", "5731"))
		self._items.append(("Digital", "6392"))
		self._items.append(("Reisen", "6568"))
		self._items.append(("Auto", "6167"))
		self._items.append(("Regional", "7302"))
		self._items.append(("Immobilien", "6767"))
		self._items.append(("Familie", "15310"))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))

	def keyOK(self):
		Name = self['liste'].getCurrent()[0][0]
		Url = 'https://www.focus.de/ajax/video/videoplaylist/?playlist_name=' + self['liste'].getCurrent()[0][1]
		self.session.open(focus, Url, Name)

class focus(MPScreen):

	def __init__(self, session, streamGenreLink, Name):
		self.streamGenreLink = streamGenreLink
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Focus.de")
		self['ContentTitle'] = Label("%s" %self.Name)


		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self._items = []
		self['name'].setText(_('Please wait...'))
		twAgentGetPage(self.streamGenreLink, agent=agent, cookieJar=cookies).addCallback(self.pageData).addErrback(self.dataError)

	def pageData(self, data):
		focusVideos = MPfindall(self, '<img.*?[rel|src]="(.*?[jpg|png].*?&hash=[0-9a-f]+)".*?<a\shref="(.*?)"\stitle="(.*?)".*?>(.*?)</a', data, re.S|re.I)
		if focusVideos:
			for (Image, Link, Name, Desc) in focusVideos:
				Image = Image.replace('" src="', '')
				self._items.append((decodeHtml(Name), Link, Image, Desc))
			self._setList('_defaultlistleft', True)
			self.keyLocked = False
			self.showInfos()

	def showInfos(self):
		Title = self['liste'].getCurrent()[0][0]
		Image = self['liste'].getCurrent()[0][2]
		Link = self['liste'].getCurrent()[0][1]
		Desc = self['liste'].getCurrent()[0][3]
		self['name'].setText(Title)
		self['handlung'].setText(Desc)
		CoverHelper(self['coverArt']).getCover(Image)

	def handlungData(self, data):
		handlung = MPfindall(self, 'og:description"\scontent="(.*?)"', data, re.S)
		if handlung:
			self['handlung'].setText(decodeHtml(handlung[0]))
		else:
			self['handlung'].setText('')

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		twAgentGetPage(Link, agent=agent, cookieJar=cookies).addCallback(self.searchStream).addErrback(self.dataError)

	def searchStream(self, data):
		Title = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		streamUrl = MPfindall(self, '"videoUrl":\s"(.*?)"', data, re.S)
		if streamUrl:
			url = streamUrl[0]
			ck = requests.utils.dict_from_cookiejar(cookies)
			headers = '&Cookie=%s' % ','.join(['%s=%s' % (key, urllib.parse.quote_plus(ck[key])) for key in ck])
			headers = headers + '&Referer=%s' % Link
			url = url + '#User-Agent='+agent+headers
			mp_globals.player_agent = agent
			self.session.open(SimplePlayer, [(Title, url)], showPlaylist=False, ltype='focus')