﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.choiceboxext import ChoiceBoxExt
from ...resources.configlistext import ConfigListScreenExt

default_cover = "file://%s/shoutcast.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
BASE_URL = "https://directory.shoutcast.com/"

config_mp.mediaportal.shoutcast_sort = ConfigYesNo(default=True)

agent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36'

json_headers = {
	'Accept': 'application/json',
	'Accept-Language': 'de,en-US;q=0.7,en;q=0.3',
	'X-Requested-With': 'XMLHttpRequest',
	'Content-Type': 'application/x-www-form-urlencoded',
	}

class ShoutcastGenreScreen(MPScreen):

	def __init__(self, session, subgenre=""):
		self.subgenre = subgenre

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"blue": self.keySetup
		}, -1)

		self.keyLocked = True
		self['title'] = Label("shoutcast")
		self['ContentTitle'] = Label(_("Genre:"))
		self['F4'] = Label(_("Setup"))

		self._items = []
		self.suchString = ''
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)
		self.onClose.append(self.restoreRadio)

	def loadPage(self):
		self._items = []
		self['name'].setText(_('Please wait...'))
		self.keyLocked = True
		twAgentGetPage(BASE_URL, agent=agent, timeout=40).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		if self.subgenre != "":
			preparse = re.search('class="main-genre.*?name=%s"(.*?)</ul' % self.subgenre, data, re.S)
			if preparse:
				genres = MPfindall(self, 'class="sub-genre.*?name=(.*?)"', preparse.group(1), re.S)
				for genre in genres:
					self._items.append((genre.replace('%20', ' ').replace('%26', '&'), genre.replace('%20', ' ').replace('%26', '&'), "sub"))
				self._items.sort(key=lambda t : t[0].lower())
				self._items.insert(0, (_("All Stations"), self.subgenre.replace('%20', ' ').replace('%26', '&'), "sub"))
		else:
			genres = MPfindall(self, 'class="main-genre.*?name=(.*?)"', data, re.S)
			for genre in genres:
				self._items.append((genre.replace('%20', ' ').replace('%26', '&'), genre, "main"))
			self._items.sort(key=lambda t : t[0].lower())
			self._items.insert(0, (_("Top Stations"), _("Top Stations"), "top"))
			self._items.insert(0, (_("Search"), _("Search"), "search"))
			self._items.insert(0, (_('Favorites'), _('Favorites'), "favorites"))

		if len(self._items) == 0:
			self._items.append((_('No genres found!'), None, None))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False
		self['name'].setText('')

	def keyOK(self):
		if self.keyLocked:
			return
		Genre = self['liste'].getCurrent()[0][0]
		Id = self['liste'].getCurrent()[0][1]
		Type = self['liste'].getCurrent()[0][2]
		if not Type:
			return
		elif Type == "main":
			self.session.open(ShoutcastGenreScreen, Id)
		elif Type == "sub":
			self.session.open(ShoutcastStationsScreen, Genre, Id, Type)
		elif Type == "top":
			self.session.open(ShoutcastStationsScreen, Genre, Id, Type)
		elif Type == "favorites":
			self.session.open(ShoutcastFavoritesScreen)
		elif Type == "search":
			self.suchen()

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "Suche"
			self.suchString = callback
			self.session.open(ShoutcastStationsScreen, _("Search"), self.suchString, "search")

	def keySetup(self):
		self.session.openWithCallback(self.setupCallback, ShoutcastSetupScreen, is_dialog=True)

	def setupCallback(self, answer=False):
		self.loadPage()

	def restoreRadio(self):
		config_mp.mediaportal.is_radio.value = False

class ShoutcastSetupScreen(MPSetupScreen, ConfigListScreenExt):

	def __init__(self, session):
		MPSetupScreen.__init__(self, session, skin='MP_PluginSetup')

		self['title'] = Label("shoutcast " + _("Setup"))
		self['F4'] = Label('')
		self.setTitle("Radio " + _("Setup"))

		self.list = []
		ConfigListScreenExt.__init__(self, self.list)

		self.list.append(getConfigListEntry(_("Sort Favorites:"), config_mp.mediaportal.shoutcast_sort))

		self["config"].setList(self.list)

		self["setupActions"] = ActionMap(["MP_Actions"],
		{
			"ok"    : self.keySave,
			"cancel": self.keyCancel
		}, -1)

	def keySave(self):
		for x in self["config"].list:
			if len(x) > 1:
				x[1].save()
		self.close(True)

class ShoutcastStationsScreen(MPScreen):

	def __init__(self, session, genre, id, type):
		self.genre = genre
		self.id = id
		self.type = type

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok": self.keyOK,
			"0": self.closeAll,
			"up": self.keyUp,
			"down": self.keyDown,
			"right": self.keyRight,
			"left": self.keyLeft,
			"cancel": self.keyCancel,
			"green": self.keyAdd,
			"yellow": self.keySort,
		}, -1)

		self.keyLocked = True
		self['title'] = Label("shoutcast")
		self['ContentTitle'] = Label(_("Stations:"))
		self['F2'] = Label(_("Add to Favorites"))
		self['F3'] = Label(_("Sort"))

		self.sort = "listeners"
		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		self['name'].setText(_('Please wait...'))
		self.keyLocked = True
		if self.type == "top":
			url = BASE_URL + "/Home/Top"
			postdata = {'genrename': ''}
		elif self.type == "search":
			url = BASE_URL + "/Search/UpdateSearch"
			postdata = {'query': self.id}
		else:
			url = BASE_URL + "/Home/BrowseByGenre"
			postdata = {'genrename': self.id}
		twAgentGetPage(url, method='POST', postdata=urlencode(postdata), agent=agent, headers=json_headers, timeout=40).addCallback(self.getStations).addErrback(self.dataError)

	def getStations(self, data):
		jsondata = json.loads(data)
		for each in jsondata:
			name = str(each["Name"])
			id = str(each["ID"])
			bitrate = str(each["Bitrate"])
			genre = str(each["Genre"])
			listeners = str(each["Listeners"])
			format = str(each["Format"])
			if format == "audio/mpeg":
				format = "MP3"
			elif format == "audio/aacp":
				format = "AAC"
			self._items.append((name, id, bitrate, genre, listeners, format))
		if self.sort == "station":
			self._items.sort(key=lambda t : t[0])
		elif self.sort == "listeners":
			self._items.sort(key=lambda t : int(t[4]), reverse=True)
		elif self.sort == "genre":
			self._items.sort(key=lambda t : t[3])
		elif self.sort == "bitrate":
			self._items.sort(key=lambda t : int(t[2]), reverse=True)
		elif self.sort == "format":
			self._items.sort(key=lambda t : t[5])
		if len(self._items) == 0:
			self._items.append((_('No stations found!'), None, "", "", "", ""))
		self._setList('_defaultlistleft', True)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		self['name'].setText(self['liste'].getCurrent()[0][0])
		bitrate = self['liste'].getCurrent()[0][2]
		genre = self['liste'].getCurrent()[0][3]
		listeners = self['liste'].getCurrent()[0][4]
		format = self['liste'].getCurrent()[0][5]
		self['handlung'].setText(_("Genre:")+" "+genre+"\n"+_("Listeners")+": "+listeners+"\n"+_("Bitrate")+": "+bitrate+"\n"+_("Format")+": "+format)

	def keySort(self):
		if self.keyLocked:
			return
		rangelist = [[_('Station'), 'station'], [_('Listeners'), 'listeners'], [_('Genre'), 'genre'], [_('Bitrate'), 'bitrate'], [_('Format'), 'format']]
		self.session.openWithCallback(self.keySortAction, ChoiceBoxExt, title=_('Select Action'), list = rangelist)

	def keySortAction(self, result):
		if result:
			self.sort = result[1]
			self.loadPage()

	def keyOK(self):
		if self.keyLocked:
			return
		stationId = self['liste'].getCurrent()[0][1]
		if not stationId:
			return
		url = BASE_URL + "/Player/GetStreamUrl"
		postdata = {'station': stationId}
		twAgentGetPage(url, method='POST', postdata=urlencode(postdata), agent=agent, headers=json_headers, timeout=40).addCallback(self.getStreamURL).addErrback(self.dataError)

	def getStreamURL(self, data):
		name = self['liste'].getCurrent()[0][0]
		url = data[1:-1]
		config_mp.mediaportal.is_radio.value = True
		self.session.open(SimplePlayer, [(name, url, 'file:///usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/none.png')], showPlaylist=False, ltype='shoutcast', playerMode='RADIO', cover=True)

	def keyAdd(self):
		stationName = self['liste'].getCurrent()[0][0]
		stationId = self['liste'].getCurrent()[0][1]
		if self.keyLocked or not stationId:
			return
		fn = config_mp.mediaportal.watchlistpath.value+"mp_shoutcast_playlist"
		if not fileExists(fn):
			open(fn, "w").close()
		try:
			writePlaylist = open(fn, "a")
			writePlaylist.write('"%s" "%s"\n' % (stationName, stationId))
			writePlaylist.close()
			message = self.session.open(MessageBoxExt, _("Selection was added to the favorites."), MessageBoxExt.TYPE_INFO, timeout=3)
		except:
			pass

class ShoutcastFavoritesScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"cancel": self.keyCancel,
			"red": self.keyDel
		}, -1)

		self.keyLocked = True
		self['title'] = Label("shoutcast")
		self['ContentTitle'] = Label(_("Favorites:"))
		self['F1'] = Label(_("Delete"))

		self.playList = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadStations)

	def loadStations(self):
		self.playList = []
		if not fileExists(config_mp.mediaportal.watchlistpath.value+"mp_shoutcast_playlist"):
			open(config_mp.mediaportal.watchlistpath.value+"mp_shoutcast_playlist", "w").close()
		if fileExists(config_mp.mediaportal.watchlistpath.value+"mp_shoutcast_playlist"):
			path = config_mp.mediaportal.watchlistpath.value+"mp_shoutcast_playlist"

		if fileExists(path):
			readStations = open(path, "r")
			for rawData in readStations.readlines():
				data = MPfindall(self, '"(.*?)" "(.*?)"', rawData, re.S)
				if data:
					(stationName, stationId) = data[0]
					self.playList.append((stationName, stationId))
			if config_mp.mediaportal.shoutcast_sort.value:
				self.playList.sort(key=lambda t : t[0].lower())
			readStations.close()
		if len(self.playList) == 0:
			self.playList.append((_('No entries found!'), None, default_cover))
		self.ml.setList(list(map(self._defaultlistleft, self.playList)))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		stationId = self['liste'].getCurrent()[0][1]
		if not stationId:
			return
		url = BASE_URL + "/Player/GetStreamUrl"
		postdata = {'station': stationId}
		twAgentGetPage(url, method='POST', postdata=urlencode(postdata), agent=agent, headers=json_headers, timeout=40).addCallback(self.getStreamURL).addErrback(self.dataError)

	def getStreamURL(self, data):
		name = self['liste'].getCurrent()[0][0]
		url = data[1:-1]
		config_mp.mediaportal.is_radio.value = True
		self.session.open(SimplePlayer, [(name, url, 'file:///usr/lib/enigma2/python/Plugins/Extensions/MediaPortal/images/none.png')], showPlaylist=False, ltype='shoutcast', playerMode='RADIO', cover=True)

	def keyDel(self):
		exist = self['liste'].getCurrent()
		if self.keyLocked or exist == None:
			return

		i = self['liste'].getSelectedIndex()
		c = j = 0
		l = len(self.playList)
		fn = config_mp.mediaportal.watchlistpath.value+"mp_shoutcast_playlist"
		try:
			f1 = open(fn, 'w')
			while j < l:
				if j != i:
					(stationName, stationId) = self.playList[j]
					f1.write('"%s" "%s"\n' % (stationName, stationId))
				j += 1
			f1.close()
			self.loadStations()
		except:
			pass