﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
default_cover = "file://%s/audionow.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36"

class audionowGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("AudioNOW")
		self['ContentTitle'] = Label("Genre:")

		self._items = []
		self.suchString = ''
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self._items.append(('Suche', 'search'))
		self._items.append(('Entdecken', 'explore'))
		self._items.append(('Kategorien', 'cats'))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))

	def keyOK(self):
		Name = self['liste'].getCurrent()[0][0]
		genreID = self['liste'].getCurrent()[0][1]
		if Name == "Suche":
			self.suchen()
		else:
			self.session.open(audionowSubGenreScreen, genreID, Name)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "Suche"
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '+'))
			self.session.open(audionowSubGenreScreen, Link, Name)

class audionowSubGenreScreen(MPScreen):

	def __init__(self, session, genreID, Name, Type='', Cover=default_cover):
		self.genreID = genreID
		self.Name = Name
		self.Type = Type
		self.Cover = Cover
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self['title'] = Label("AudioNOW")
		self['ContentTitle'] = Label(_("Selection:") + " " + self.Name)

		self.keyLocked = True

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.page = 1
		self.lastpage = 1

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		self.keyLocked = True
		self['name'].setText(_("Please wait..."))
		if self.Name == "Suche":
			url = "https://api-v4.audionow.de/api/v4/search.json?section=podcast&q=%s&page=%s" % (self.genreID, str(self.page))
			twAgentGetPage(url, agent=agent, headers={'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest', 'Origin': 'https://www.audionow.de/', 'Referer': 'https://www.audionow.de/'}, timeout=40).addCallback(self.genreData).addErrback(self.dataError)
		else:
			if self.genreID in ["cats", "explore", "subcats"]:
				url = "https://api-v4.audionow.de/api/v4/app.json"
				twAgentGetPage(url, agent=agent, headers={'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest', 'Origin': 'https://www.audionow.de/', 'Referer': 'https://www.audionow.de/'}, timeout=40).addCallback(self.genreData).addErrback(self.dataError)
			elif self.Type == "category":
				url = "https://api-v4.audionow.de/api/v4/category/%s/media.json?page=%s&format=json" % (self.genreID, str(self.page))
				twAgentGetPage(url, agent=agent, headers={'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest', 'Origin': 'https://www.audionow.de/', 'Referer': 'https://www.audionow.de/'}, timeout=40).addCallback(self.genreData).addErrback(self.dataError)
			elif self.Type == "podcast":
				url = "https://api-v4.audionow.de/api/v4/podcast/%s/episodes.json?page=%s&format=json" % (self.genreID, str(self.page))
				twAgentGetPage(url, agent=agent, headers={'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest', 'Origin': 'https://www.audionow.de/', 'Referer': 'https://www.audionow.de/'}, timeout=40).addCallback(self.genreData).addErrback(self.dataError)
			elif self.Type in ["slider", "sliderBlock"]:
				self.genreData(self.genreID)

	def genreData(self, data):
		if self.Type in ["slider", "sliderBlock"]:
			json_data = data
		else:
			json_data = json.loads(data)
		if 'meta' in json_data:
			if 'pagination' in json_data["meta"]:
				if int(json_data["meta"]["pagination"]["total_pages"])>1:
					self.lastpage = int(json_data["meta"]["pagination"]["total_pages"])
					self['Page'].setText(_("Page:"))
					self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
		if self.Type in ["slider", "sliderBlock"]:
			for node in json_data:
				if str(node["type"]) == "podcast":
					Title = str(node["podcast"]["title"])
					Url = str(node["podcast"]["uid"])
					Image = str(node["podcast"]["imageInfo"]["url"]["768"]).replace('.webp', '.jpeg')
					Descr = decodeHtml(str(node["podcast"]["subtitle"]))
					if 'episodes' in node["podcast"]:
						episodes = str(node["podcast"]["episodes"])
						Descr = "Episoden: " + episodes + "\n\n" + Descr
					Type = str(node["type"])
					self._items.append((Title, Url, Image, Descr, Type))
				else:
					printl('Unknown type:'+str(node["type"]), self, "E")
		if self.Type == "podcast":
			for node in json_data["data"]:
				Title = str(node["title"])
				Url = str(node["mediaURL"])
				Image = self.Cover
				Descr = decodeHtml(str(node["subtitle"]))
				if 'duration' in node:
					m, s = divmod(node['duration'], 60)
					Runtime = "%02d:%02d" % (m, s)
					Descr = "Laufzeit: " + Runtime + "\n\n" + Descr
				if 'publicationDate' in node:
					date = str(node['publicationDate']).split('T')[0].split('-')
					Date = "%s.%s.%s" % (date[2], date[1], date[0])
					Descr = "Datum: " + Date + "\n" + Descr
				Type = "audioStream"
				self._items.append((Title, Url, Image, Descr, Type))
		elif self.Name == "Suche":
			for node in json_data["data"]:
				if str(node["type"]) == "podcast":
					Title = str(node["title"])
					Url = str(node["uid"])
					Image = str(node["imageInfo"]["url"]["768"]).replace('.webp', '.jpeg')
					Descr = decodeHtml(str(node["subtitle"]))
					if 'episodes' in node:
						episodes = str(node["episodes"])
						Descr = "Episoden: " + episodes + "\n\n" + Descr
					Type = str(node["type"])
					self._items.append((Title, Url, Image, Descr, Type))
				else:
					printl('Unknown type:'+str(node["type"]), self, "E")
		elif self.Type == "category":
			for node in json_data["data"]:
				if str(node["type"]) == "podcast":
					Title = str(node["podcast"]["title"])
					print(Title)
					Url = str(node["podcast"]["uid"])
					if node["podcast"]["imageInfo"]:
						Image = str(node["podcast"]["imageInfo"]["url"]["768"]).replace('.webp', '.jpeg')
					else:
						Image = default_cover
					Descr = decodeHtml(str(node["podcast"]["subtitle"]))
					if 'episodes' in node["podcast"]:
						episodes = str(node["podcast"]["episodes"])
						Descr = "Episoden: " + episodes + "\n\n" + Descr
					Type = str(node["type"])
					self._items.append((Title, Url, Image, Descr, Type))
				elif str(node["type"]) == "audioStream":
					Title = str(node["audioStream"]["title"])
					Url = str(node["audioStream"]["mediaURLs"]["high"])
					Image = str(node["audioStream"]["imageInfo"]["url"]["768"]).replace('.webp', '.jpeg')
					Descr = decodeHtml(str(node["audioStream"]["subtitle"]))
					Type = str(node["type"])
					self._items.append((Title, Url, Image, Descr, Type))
				else:
					printl('Unknown type:'+str(node["type"]), self, "E")
		elif self.genreID == "cats":
			json_data = json_data["items"][1]["searchPage"]
			for node in json_data:
				Title = str(node["title"])
				Url = "subcats"
				Image = self.Cover
				Descr = ""
				Type = ""
				self._items.append((Title, Url, Image, Descr, Type))
		elif self.genreID == "explore":
			json_data = json_data["items"][0]["explorePage"]["content"]
			for node in json_data:
				for subnode in node["section"]:
					if str(subnode["type"]) == "hero":
						if str(subnode["hero"]["type"]) == "podcast":
							Title = str(subnode["hero"]["podcast"]["title"])
							Url = str(subnode["hero"]["podcast"]["uid"])
							Image = str(subnode["hero"]["podcast"]["imageInfo"]["url"]["768"]).replace('.webp', '.jpeg')
							Descr = decodeHtml(str(subnode["hero"]["podcast"]["subtitle"]))
							Type = str(subnode["hero"]["type"])
							self._items.append((Title, Url, Image, Descr, Type))
					elif str(subnode["type"]) == "slider":
						Title = str(subnode["title"])
						Url = subnode["slider"]
						Image = self.Cover
						Descr = ""
						Type = str(subnode["type"])
						self._items.append((Title, Url, Image, Descr, Type))
					elif str(subnode["type"]) == "sliderBlock":
						Title = str(subnode["title"])
						Url = subnode["sliderBlock"]
						Image = self.Cover
						Descr = ""
						Type = str(subnode["type"])
						self._items.append((Title, Url, Image, Descr, Type))
					else:
						printl('Unknown type:'+str(subnode["type"]), self, "E")
		elif self.genreID == "subcats":
			json_data = json_data["items"][1]["searchPage"]
			for node in json_data:
				if not str(node["title"]) == self.Name:
					continue
				else:
					json_data = node["categories"]
					for node in json_data:
						Title = str(node["title"])
						Url = str(node["uid"])
						Image = str(node["imageInfo"]["url"]["768"]).replace('.webp', '.jpeg')
						Descr = ""
						Type = "category"
						self._items.append((Title, Url, Image, Descr, Type))
		if len(self._items) == 0:
			self._items.append((_("No entries found!"), None, default_cover, "", ""))
		if self.genreID == "cats":
			self._setList('_defaultlistcenter', True)
		else:
			self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Title = self['liste'].getCurrent()[0][0]
		Image = self['liste'].getCurrent()[0][2]
		Descr = self['liste'].getCurrent()[0][3]
		self['name'].setText(Title)
		self['handlung'].setText(Descr)
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		Title = self['liste'].getCurrent()[0][0]
		Image = self['liste'].getCurrent()[0][2]
		Type = self['liste'].getCurrent()[0][4]
		if Link:
			if Link == "subcats" or Type in ["slider", "sliderBlock", "category", "podcast"]:
				self.session.open(audionowSubGenreScreen, Link, Title, Type, Image)
			elif Type == "audioStream":
				self.session.open(SimplePlayer, [(Title, Link, Image)], showPlaylist=False, ltype='audionow', playerMode='RADIO', cover=True)