﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from builtins import map
from ...plugin import _
from ...resources.imports import *

default_cover = "file://%s/srg.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class SRGGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("SRG Play Channels")
		self['ContentTitle'] = Label("Auswahl des Senders")

		self._items = []
		self.keyLocked = True
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		self._items.append(('SRF', ''))
		self._items.append(('RTS', ''))
		self._items.append(('RTR', ''))
		self._items.append(('RSI', ''))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		channel = self['liste'].getCurrent()[0][0]
		self.session.open(SRGListScreen, channel)

class SRGListScreen(MPScreen):

	def __init__(self, session, channel):
		self.channel = channel
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Play %s" % self.channel)
		self['ContentTitle'] = Label("Auswahl der Sendung")

		self._items = []
		self.keyLocked = True
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		url = "https://www.srf.ch/play/v3/api/%s/production/shows" % self.channel.lower()
		twAgentGetPage(url, gzip_decoding=True).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		self._items = []
		json_data = json.loads(data)
		try:
			for node in json_data["data"]:
				title = str(node["title"])
				id = str(node["id"])
				try:
					image = str(node['imageUrl'])
					image = image.replace('/16x9', '')
				except:
					image = default_cover
				try:
					handlung = str(node["description"])
				except:
					handlung = ""
				self._items.append((decodeHtml(title), id, image, handlung))
		except:
			pass
		self._items.sort(key=lambda t : t[0].lower())
		self._setList('_defaultlistleft', True)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		streamHandlung = self['liste'].getCurrent()[0][3]
		self['handlung'].setText(decodeHtml(streamHandlung))
		streamPic = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(streamPic)

	def keyOK(self):
		if self.keyLocked:
			return
		title = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		self.session.open(SRGFilmeListeScreen, url, title, self.channel)

class SRGFilmeListeScreen(MPScreen):

	def __init__(self, session, streamGenreLink, serie, channel):
		self.streamGenreLink = streamGenreLink
		self.serie = serie
		self.channel = channel
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("Play %s" % self.channel)
		self['ContentTitle'] = Label("Folgen Auswahl")
		self['F2'] = Label(_("Page"))

		self.keyLocked = True
		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.page = 1
		self.lastpage = 1
		self.pages = ['',]

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		url = "https://www.srf.ch/play/v3/api/%s/production/videos-by-show-id?showId=%s&next=%s" % (self.channel.lower(), self.streamGenreLink, self.pages[self.page-1])
		twAgentGetPage(url, gzip_decoding=True).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		self._items = []
		try:
			json_data = json.loads(data)
			if 'next' in json_data["data"]:
				next = str(json_data["data"]["next"])
				if not next in self.pages:
					self.pages.append(next)
					self.lastpage += 1
			else:
				next = ''
			if next or self.lastpage > 1:
				self['Page'].setText(_("Page:"))
				self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
			for node in json_data["data"]["data"]:
					try:
						title = str(node["title"])
						url = str(node["id"])
						try:
							desc = str(node["lead"]).strip()
						except:
							desc = ""
						try:
							desc = desc + " " + str(node["description"])
						except:
							pass
						try:
							image = str(node["imageUrl"])
						except:
							image = default_cover
						if 'duration' in node:
							m, s = divmod(node['duration']/1000, 60)
							Runtime = _("Runtime:") + " %02d:%02d\n\n" % (m, s)
						else:
							Runtime = ""
						if 'date' in node and node['date']:
							date = str(node['date'])
							date = MPfindall(self, '(\d{4})-(\d{2})-(\d{2})T(.*?)\+', date)
							date = _("Date:") + " " + date[0][2] + "." + date[0][1] + "." + date[0][0] + ", " + date[0][3] + "\n"
						else:
							date = ""
							
						handlung = "%s%s%s" % (date, Runtime, desc)
						self._items.append((decodeHtml(title), url, image, handlung))
					except:
						pass
		except:
			pass
		if len(self._items) == 0:
			self._items.append(('Keine Sendungen gefunden.', None, None, ''))
			self._setList('_defaultlistleft', False, mode='list')
		else:
			self.keyLocked = False
		self._setList('_defaultlistleft', True)
		self.showInfos()

	def showInfos(self):
		streamName = self['liste'].getCurrent()[0][0]
		self['name'].setText(streamName)
		streamHandlung = self['liste'].getCurrent()[0][3]
		self['handlung'].setText(streamHandlung)
		streamPic = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(streamPic)

	def keyOK(self):
		if self.keyLocked:
			return
		staffel = self['liste'].getCurrent()[0][0]
		urlid = self['liste'].getCurrent()[0][1]
		if urlid:
			self.session.open(SRGStreamScreen, self.serie, staffel, urlid, self.channel)

class SRGStreamScreen(MPScreen):

	def __init__(self, session, serie, staffel, urlid, channel):
		self.serie = serie
		self.staffel = staffel
		self.urlid = urlid
		self.channel = channel
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Play %s" % self.channel)
		self['ContentTitle'] = Label("Auswahl des Streams - %s" % self.staffel)

		self._items = []
		self.keyLocked = True
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		url = 'http://il.srf.ch/integrationlayer/1.0/ue/%s/video/play/%s.json' % (self.channel.lower(), self.urlid)
		twAgentGetPage(url, gzip_decoding=True).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		self._items = []
		try:
			json_data = json.loads(data)
			try:
				streamurl = json_data["Video"]["Downloads"]["Download"]
				for playlist in streamurl:
					protoname = playlist['@protocol'].encode("utf-8")
					for urldata in playlist["url"]:
						myurl = urldata["text"].encode("utf-8")
						quali = urldata['@quality'].encode("utf-8")
						self._items.append(('%s %s' % (protoname, quali), myurl))
			except:
				pass
			try:
				streamurl = json_data["Video"]["Playlists"]['Playlist']
				for playlist in streamurl:
					protoname = playlist['@protocol'].encode("utf-8")
					if protoname == "HTTP-HLS":
						for urldata in playlist["url"]:
							myurl = urldata["text"].encode("utf-8")
							quali = urldata['@quality'].encode("utf-8")
							self._items.append(('%s %s' % (protoname, quali), myurl))
			except:
				pass
		except:
			pass
		if len(self._items) == 0:
			self._items.append(('Keine Sendungen gefunden.', ''))
		self._items.sort()
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		url = self['liste'].getCurrent()[0][1]
		if '.m3u8' in url:
			twAgentGetPage(url, gzip_decoding=True).addCallback(self.loadplaylist).addErrback(self.dataError)
		else:
			self.session.open(SimplePlayer, [(self.serie, url)], showPlaylist=False, ltype='srg')

	def loadplaylist(self, data):
		try:
			bandwith_list = []
			match_sec_m3u8=MPfindall(self, 'BANDWIDTH=(\d+).*?\n(.*?m3u8)', data, re.S)
			videoPrio = int(config_mp.mediaportal.videoquali_others.value)
			if videoPrio == 2:
				bw = int(match_sec_m3u8[-2][0])
			elif videoPrio == 1:
				bw = int(match_sec_m3u8[-2][0]) / 2
			else:
				bw = int(match_sec_m3u8[-2][0]) / 3
			for each in match_sec_m3u8:
				bandwith, url = each
				bandwith_list.append((int(bandwith), url))
			_x, best = min((abs(int(x[0]) - bw), x) for x in bandwith_list)
			url = best[1]

			self.session.open(SimplePlayer, [(self.serie, url)], showPlaylist=False, ltype='srg')
		except:
			url = self['liste'].getCurrent()[0][1].replace("srfvodhd-vh.akamaihd", "hdvodsrforigin-f.akamaihd")
			twAgentGetPage(url, gzip_decoding=True).addCallback(self.loadplaylist).addErrback(self.dataError)