﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from builtins import map
from ...plugin import _
from ...resources.imports import *

baseurl = "https://www.servustv.com"
stvAgent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.75 Safari/537.36'
default_cover = "file://%s/servustv.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class sTVGenreScreen(MPScreen):

	def __init__(self, session, url = ''):
		self.url = url

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("ServusTV")
		self['ContentTitle'] = Label("Genre:")

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		if self.url:
			self.onLayoutFinish.append(self.loadPage)
		else:
			self.onLayoutFinish.append(self.layoutFinished)

	def loadPage(self):
		self._items = []
		self.keyLocked = True
		twAgentGetPage(self.url, agent=stvAgent).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		shows = MPfindall(self, 'class="component__card.*?href="(.*?)".*?class="card__image-container">.*?img\ssrc="(.*?\.(?:jpg|png)).*?".*?heading--two">(.*?)</', data, re.S)
		if shows:
			for (url, image, title) in shows:
				image = image + "?resize=600,413&crop_strategy=smart"
				url = url.replace(baseurl, '')
				self._items.append((decodeHtml(title), url, image))
			self._setList('_defaultlistleft', True)
			self.keyLocked = False
			self.showInfos()

	def showInfos(self):
		Image = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(Image)

	def layoutFinished(self):
		self._items.append(("Sendungen A-Z", "/sendungen-a-z/", default_cover))
		self._items.append(("Aktuelles", "/rubrik/aktuelles/", default_cover))
		self._items.append(("Kultur", "/rubrik/kultur/", default_cover))
		self._items.append(("Natur", "/rubrik/natur/", default_cover))
		self._items.append(("Sport", "/rubrik/sport/", default_cover))
		self._items.append(("Unterhaltung", "/rubrik/unterhaltung/", default_cover))
		self._items.append(("Volkskultur", "/rubrik/volkskultur/", default_cover))
		self._items.append(("Wissen", "/rubrik/wissen/", default_cover))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))

	def keyOK(self):
		name = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		url = baseurl + url
		if name == "Sendungen A-Z":
			self.session.open(sTVGenreScreen, url)
		else:
			self.session.open(sTVids, name, url)

class sTVids(MPScreen):

	def __init__(self, session, name, url):
		self.Link = url
		self.Name = name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok": self.keyOK,
			"0": self.closeAll,
			"cancel": self.keyCancel,
			"up": self.keyUp,
			"down": self.keyDown,
			"right": self.keyRight,
			"left": self.keyLeft,
			"nextBouquet": self.keyPageUp,
			"prevBouquet": self.keyPageDown,
		}, -1)

		self.keyLocked = True
		self['title'] = Label("ServusTV")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['name'] = Label(_("Please wait..."))
		self['Page'] = Label(_("Page:"))

		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		self.keyLocked = True
		url = self.Link + "page/" + str(self.page) + "/?video_type=full-episodes"
		twAgentGetPage(url, agent=stvAgent).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		self.getLastPage(data, 'class="pagination">(.*?)</ul>')
		parse = re.search('class="grid-container"(.*?)class="site-footer"', data, re.S)
		if not parse:
			parse = re.search('class="grid-container section">(.*?)class="site-footer"', data, re.S)
		shows = MPfindall(self, 'class="component__card media_asset.*?href="(https://www.servustv.com/(?:[\w\/]+|)videos/(.*?)/)".*?class="card__image-container">.*?img\ssrc="(.*?\.(?:jpg|jpeg|png)).*?".*?card__label">(.*?)</div.*?heading--two">(.*?)</.*?card__date\s{0,1}">(.*?)</div', parse.group(1), re.S)
		if shows:
			for (url, id, image, title, subtitle, date) in shows:
				id = id.upper()
				image = image + "?resize=600,413&crop_strategy=smart"
				title = title.strip() + " - " + subtitle.strip()
				self._items.append((decodeHtml(title), id, image, url, stripAllTags(date).strip()))
			self._setList('_defaultlistleft', True)
			self.ml.moveToIndex(0)
			self.keyLocked = False
			self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		pic = self['liste'].getCurrent()[0][2]
		url = self['liste'].getCurrent()[0][3]
		self.date = self['liste'].getCurrent()[0][4]
		self['name'].setText(title)
		CoverHelper(self['coverArt']).getCover(pic)
		self['handlung'].setText('')
		twAgentGetPage(url, agent=stvAgent).addCallback(self.getDescr).addErrback(self.dataError)

	def getDescr(self, data):
		descr = MPfindall(self, '<div id="media-asset-content-container".*?<p>(.*?)</p>', data, re.S)
		if descr:
			descr = decodeHtml(descr[0].replace('<br />', '\n'))
			descr = self.date + "\n\n" + descr
			self['handlung'].setText(descr)

	def keyOK(self):
		if self.keyLocked:
			return
		url = "https://auth.redbullmediahouse.com/token"
		postdata = {'grant_type': 'client_credentials'}
		twAgentGetPage(url, method='POST', postdata=urlencode(postdata), agent=stvAgent, headers={'Content-Type':'application/x-www-form-urlencoded','Authorization':'Basic SVgtMjJYNEhBNFdEM1cxMTpEdDRVSkFLd2ZOMG5IMjB1NGFBWTBmUFpDNlpoQ1EzNA=='}).addCallback(self.getToken).addErrback(self.dataError)

	def getToken(self, data):
		jsondata = json.loads(data)
		token = str(jsondata["access_token"])
		url = self['liste'].getCurrent()[0][1]
		url = 'https://sparkle-api.liiift.io/api/v1/stv/channels/international/assets/%s' % url
		twAgentGetPage(url, agent=stvAgent, headers={'Authorization':'Bearer %s' % token}).addCallback(self.getAsset).addErrback(self.dataError)

	def getAsset(self, data):
		jsondata = json.loads(data)
		if len(jsondata["resources"]) < 1:
			self.session.open(MessageBoxExt, _("This video is not available."), MessageBoxExt.TYPE_INFO, timeout=5)
		else:
			for node in jsondata["resources"]:
				if str(node["type"]) == "proxy_hd_720":
					url = str(node["url"])
					Name = self['liste'].getCurrent()[0][0]
					mp_globals.player_agent = stvAgent
					self.session.open(SimplePlayer, [(Name, url)], showPlaylist=False, ltype='servustv')
					break