﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
default_cover = "file://%s/netzkino.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36"

class netzKinoGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("Netzkino")
		self['ContentTitle'] = Label("Genre:")

		self._items = []
		self.suchString = ''
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self._items.append(('Suche', 'search'))
		self._items.append(('Neu bei Netzkino', 'neu'))
		self._items.append(('Netzkino Exklusiv', 'frontpage-exklusiv'))
		self._items.append(('NetzkinoPlus Highlights', 'netzkinoplus-highlights'))
		self._items.append(('Unsere Empfehlungen der Woche', 'empfehlungen_woche'))
		self._items.append(('Highlights', 'highlights'))
		self._items.append(('Beste Bewertung', 'beste-bewertung'))
		self._items.append(('Meistgesehene Filme', 'meisgesehene_filme'))
		self._items.append(('Filme mit Auszeichnungen', 'filme_mit_auszeichnungen'))
		self._items.append(('Letzte Chance - Nur noch kurze Zeit verfügbar', 'letzte-chance'))
		self._items.append(('Top 20', 'top-20-frontpage'))
		self._items.append(('Beliebte Animes', 'beliebte-animes'))
		self._items.append(('Die besten Kriegsfilme', 'kriegsfilme-frontpage'))
		self._items.append(('Mockbuster', 'mockbuster-frontpage'))
		#self._items.append(('Kurzfilme', 'frontpage-kurzfilme'))
		#self._items.append(('Starkino', 'starkino-frontpage'))
		self._items.append(('Themenkino', 'themenkino-frontpage'))
		self._items.append(('HD-Kino', 'hdkino'))
		self._items.append(('Animekino', 'animekino'))
		self._items.append(('Actionkino', 'actionkino'))
		self._items.append(('Dramakino', 'dramakino'))
		self._items.append(('Thrillerkino', 'thrillerkino'))
		self._items.append(('Liebesfilmkino', 'liebesfilmkino'))
		self._items.append(('Scifikino', 'scifikino'))
		self._items.append(('Arthousekino', 'arthousekino'))
		#self._items.append(('Queerkino', 'queerkino'))
		self._items.append(('Spaßkino', 'spasskino'))
		self._items.append(('Asiakino', 'asiakino'))
		self._items.append(('Horrorkino', 'horrorkino'))
		self._items.append(('Kinderkino', 'kinderkino'))
		#self._items.append(('Prickelkino', 'prickelkino'))
		self._items.append(('Kino ab 18', 'kinoab18'))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))

	def keyOK(self):
		Name = self['liste'].getCurrent()[0][0]
		genreID = self['liste'].getCurrent()[0][1]
		if Name == "Suche":
			self.suchen()
		else:
			self.session.open(netzKinoFilmeScreen, genreID, Name)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "Suche"
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '%20'))
			self.session.open(netzKinoFilmeScreen, Link, Name)

class netzKinoFilmeScreen(MPScreen):

	def __init__(self, session, genreID, Name):
		self.genreID = genreID
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("Netzkino")
		self['ContentTitle'] = Label("Film Auswahl: %s" % self.Name)
		self['name'] = Label(_("Selection:"))

		self.keyLocked = True

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		self['name'].setText(_("Please wait..."))
		if self.Name == "Suche":
			url = "http://api.netzkino.de.simplecache.net/capi-2.0a/search?q=%s&d=www&l=de-DE&v=v1.2.0" % self.genreID
		else:
			url = "http://api.netzkino.de.simplecache.net/capi-2.0a/categories/%s.json?d=www&l=de-DE&v=v1.2.0" % self.genreID
			if self.Name == "HD-Kino":
				url = url.split('?')[0]
		twAgentGetPage(url, agent=agent, headers={'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest', 'Origin': 'http://www.netzkino.de/', 'Referer': 'http://www.netzkino.de/'}).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		json_data = json.loads(data)
		for node in json_data["posts"]:
			if 'Streaming' in node["custom_fields"]:
				Title = str(node["title"])
				Inhalt = stripAllTags(str(node["content"]))
				if 'thumbnail' in node:
					Image = str(node["thumbnail"])
				else:
					Image = str(node["custom_fields"]["Artikelbild"][0])
				Stream = str(node["custom_fields"]["Streaming"][0])
				IMDb = str(node["custom_fields"]["IMDb-Bewertung"][0])
				FSK = str(node["custom_fields"]["FSK"][0])
				Jahr = str(node["custom_fields"]["Jahr"][0])
				if 'Regisseur' in node["custom_fields"]:
					Regie = str(node["custom_fields"]["Regisseur"][0])
				else:
					Regie = "---"
				if 'Stars' in node["custom_fields"]:
					Stars = str(node["custom_fields"]["Stars"][0])
				else:
					Stars = "---"
				Descr = "Jahr: "+Jahr+"\nIMDb-Rating: "+IMDb+"\nFSK: "+FSK+"\nRegie: "+Regie+"\nStars: "+Stars+"\n\n"+Inhalt
				Url = "http://pmd.netzkino-seite.netzkino.de/%s.mp4" % Stream
				self._items.append((Title, Url, Image, Descr))
		if len(self._items) == 0:
			self._items.append((_("No videos found!"), None, default_cover, ""))
		self._setList('_defaultlistleft', True)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Title = self['liste'].getCurrent()[0][0]
		Image = self['liste'].getCurrent()[0][2]
		Descr = self['liste'].getCurrent()[0][3]
		self['name'].setText(Title)
		self['handlung'].setText(Descr)
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		Title = self['liste'].getCurrent()[0][0]
		Image = self['liste'].getCurrent()[0][2]
		if Link:
			self.session.open(SimplePlayer, [(Title, Link, Image)], showPlaylist=False, ltype='netzkino', cover=True)