﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from builtins import map
from ...plugin import _
from ...resources.imports import *
default_cover = "file://%s/funk.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

headers = {
	'Authorization': 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJjbGllbnROYW1lIjoid2ViYXBwLXYzMSIsInNjb3BlIjoic3RhdGljLWNvbnRlbnQtYXBpLGN1cmF0aW9uLWFwaSxuZXh4LWNvbnRlbnQtYXBpLXYzMSx3ZWJhcHAtYXBpIn0.mbuG9wS9Yf5q6PqgR4fiaRFIagiHk9JhwoKES7ksVX4',
	'Accept-Encoding': 'deflate',
}

BASE_URL = 'https://www.funk.net/api/v4.0'

class funkGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self['title'] = Label("FUNK")
		self['ContentTitle'] = Label("Auswahl: Kanäle")
		self['name'] = Label(_("Selection:"))

		self.keyLocked = True

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.page = 1
		self.lastpage = 1

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		self.keyLocked = True
		url = BASE_URL + "/channels/?size=100&page=%s" % str(self.page-1)
		twAgentGetPage(url, headers=headers).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		json_data = json.loads(data)
		if 'page' in json_data:
			if int(json_data["page"]["totalPages"])>1:
				self.lastpage = int(json_data["page"]["totalPages"])
				self['Page'].setText(_("Page:"))
				self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
		for item in json_data["_embedded"]["channelDTOList"]:
			if 'imageUrlOrigin' in item and not "8415ad90686d2c75aca239372903a45e" in item["imageUrlOrigin"]:
				image = str(item["imageUrlOrigin"])
			elif 'imageUrlLandscape' in item and not "8415ad90686d2c75aca239372903a45e" in item["imageUrlLandscape"]:
				image = str(item["imageUrlLandscape"])
			elif 'imageUrlPortrait' in item and not "8415ad90686d2c75aca239372903a45e" in item["imageUrlPortrait"]:
				image = str(item["imageUrlPortrait"])
			elif 'imageUrlSquare' in item and not "8415ad90686d2c75aca239372903a45e" in item["imageUrlSquare"]:
				image = str(item["imageUrlSquare"])
			else:
				image = None
			title = decodeHtml(str(item["title"]))
			if 'description' in item:
				descr = decodeHtml(str(item["description"]))
			else:
				descr = ""
			url = BASE_URL + "/playlists/byChannelAlias/" + str(item["alias"]) + "?sort=language,ASC"
			if title not in ("Doctor Who", "Uncle", "Threesome", "Orange is the new Black", "The Job Lot"):
				self._items.append((title, url, image, descr))
		self._items.sort(key=lambda t : t[0].lower())
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Title = self['liste'].getCurrent()[0][0]
		Image = self['liste'].getCurrent()[0][2]
		descr = self['liste'].getCurrent()[0][3]
		self['name'].setText(Title)
		self['handlung'].setText(descr)
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		self.session.open(funkSeasonsScreen, url, Name)

class funkSeasonsScreen(MPScreen):

	def __init__(self, session, url, name):
		self.url = url
		self.Name = name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self['title'] = Label("FUNK")
		self['ContentTitle'] = Label("Auswahl: %s" % self.Name)
		self['name'] = Label(_("Selection:"))

		self.keyLocked = True

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.page = 1
		self.lastpage = 1

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		self.keyLocked = True
		url = self.url + "&page=%s" % str(self.page-1)
		twAgentGetPage(url, headers=headers).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		json_data = json.loads(data)
		if 'page' in json_data:
			if int(json_data["page"]["totalPages"])>1:
				self.lastpage = int(json_data["page"]["totalPages"])
				self['Page'].setText(_("Page:"))
				self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
		if '_embedded' not in json_data:
			if 'imageUrlOrigin' in json_data["parent"] and not "8415ad90686d2c75aca239372903a45e" in json_data["parent"]["imageUrlOrigin"]:
				image = str(json_data["parent"]["imageUrlOrigin"])
			elif 'imageUrlLandscape' in json_data["parent"] and not "8415ad90686d2c75aca239372903a45e" in json_data["parent"]["imageUrlLandscape"]:
				image = str(json_data["parent"]["imageUrlLandscape"])
			elif 'imageUrlPortrait' in json_data["parent"] and not "8415ad90686d2c75aca239372903a45e" in json_data["parent"]["imageUrlPortrait"]:
				image = str(json_data["parent"]["imageUrlPortrait"])
			elif 'imageUrlSquare' in json_data["parent"] and not "8415ad90686d2c75aca239372903a45e" in json_data["parent"]["imageUrlSquare"]:
				image = str(json_data["parent"]["imageUrlSquare"])
			else:
				image = None
			title = decodeHtml(str(json_data["parent"]["title"]))
			if 'description' in json_data["parent"]:
				descr = decodeHtml(str(json_data["parent"]["description"]))
			else:
				descr = ""
			url = BASE_URL + "/videos/byChannelAlias/" + str(json_data["parent"]["alias"]) + "?filterFsk=false&sort=creationDate,desc&size=100"
			self._items.append((title, url, image, descr))
		else:
			for item in json_data["_embedded"]["playlistDTOList"]:
				if 'imageUrlOrigin' in item and not "8415ad90686d2c75aca239372903a45e" in item["imageUrlOrigin"]:
					image = str(item["imageUrlOrigin"])
				elif 'imageUrlLandscape' in item and not "8415ad90686d2c75aca239372903a45e" in item["imageUrlLandscape"]:
					image = str(item["imageUrlLandscape"])
				elif 'imageUrlPortrait' in item and not "8415ad90686d2c75aca239372903a45e" in item["imageUrlPortrait"]:
					image = str(item["imageUrlPortrait"])
				elif 'imageUrlSquare' in item and not "8415ad90686d2c75aca239372903a45e" in item["imageUrlSquare"]:
					image = str(item["imageUrlSquare"])
				else:
					image = None
				title = decodeHtml(str(item["title"]))
				if 'description' in item:
					descr = decodeHtml(str(item["description"]))
				else:
					descr = ""
				url = BASE_URL + "/videos/byPlaylistAlias/" + str(item["alias"]) + "?filterFsk=false&size=100&sort=episodeNr,ASC"
				self._items.append((title, url, image, descr))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Title = self['liste'].getCurrent()[0][0]
		Image = self['liste'].getCurrent()[0][2]
		descr = self['liste'].getCurrent()[0][3]
		self['name'].setText(Title)
		self['handlung'].setText(descr)
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		Name = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		self.session.open(funkEpisodesScreen, url, Name)

class funkEpisodesScreen(MPScreen):

	def __init__(self, session, url, name):
		self.url = url
		self.Name = name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok" : self.keyOK,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
		}, -1)

		self['title'] = Label("FUNK")
		self['ContentTitle'] = Label("Auswahl: %s" % self.Name)
		self['name'] = Label(_("Selection:"))

		self.keyLocked = True

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.page = 1
		self.lastpage = 1

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		self.keyLocked = True
		url = self.url + "&page=%s" % str(self.page-1)
		twAgentGetPage(url, headers=headers).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		json_data = json.loads(data)
		if 'page' in json_data:
			if int(json_data["page"]["totalPages"])>1:
				self.lastpage = int(json_data["page"]["totalPages"])
				self['Page'].setText(_("Page:"))
				self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
		try:
			for item in json_data["_embedded"]["videoDTOList"]:
				if 'imageUrlOrigin' in item and not "8415ad90686d2c75aca239372903a45e" in item["imageUrlOrigin"]:
					image = str(item["imageUrlOrigin"])
				elif 'imageUrlLandscape' in item and not "8415ad90686d2c75aca239372903a45e" in item["imageUrlLandscape"]:
					image = str(item["imageUrlLandscape"])
				elif 'imageUrlPortrait' in item and not "8415ad90686d2c75aca239372903a45e" in item["imageUrlPortrait"]:
					image = str(item["imageUrlPortrait"])
				elif 'imageUrlSquare' in item and not "8415ad90686d2c75aca239372903a45e" in item["imageUrlSquare"]:
					image = str(item["imageUrlSquare"])
				else:
					image = None
				title = decodeHtml(str(item["title"]))
				if 'description' in item:
					descr = decodeHtml(str(item["description"]))
				else:
					descr = ""
				if 'duration' in item:
					duration = int(item["duration"])
					m, s = divmod(duration, 60)
					duration = "Laufzeit: %02d:%02d\n" % (m, s)
				else:
					duration = ""
				if 'episodeNr' in item:
					episode = int(item["episodeNr"])
				else:
					episode = ""
				if 'seasonNr' in item:
					season = int(item["seasonNr"])
				else:
					season = ""
				if season and episode:
					if (season and episode) > 0:
						epi = "Staffel: " + str(season) + " Episode: " + str(episode) + "\n"
					else:
						epi = ""
				else:
					epi = ""
				if 'entityId' in item:
					id = str(item["entityId"])
				else:
					id = None
				if 'downloadUrl' in item:
					downld = str(item["downloadUrl"])
				else:
					downld = None

				self._items.append((title, id, image, descr, epi, duration, downld))
		except Exception as e:
			printl(e, self, "E")
		if len(self._items) == 0:
			self._items.append((_('No episodes found!'), None, None, "", "", "", None))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Title = self['liste'].getCurrent()[0][0]
		Image = self['liste'].getCurrent()[0][2]
		descr = self['liste'].getCurrent()[0][3]
		epi = self['liste'].getCurrent()[0][4]
		dur = self['liste'].getCurrent()[0][5]
		self['name'].setText(Title)
		self['handlung'].setText(dur+epi+descr)
		CoverHelper(self['coverArt']).getCover(Image)

	def keyOK(self):
		if self.keyLocked:
			return
		id = self['liste'].getCurrent()[0][1]
		Title = self['liste'].getCurrent()[0][0]
		downld = self['liste'].getCurrent()[0][6]
		videourl = None
		if id:
			from ...resources import nexx
			videourl = nexx.getVideoUrl(id, downld)
		if videourl:
			self.session.open(SimplePlayer, [(Title, videourl)], showPlaylist=False, ltype='funk')