﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from builtins import range
from ...plugin import _
from ...resources.imports import *
from ...resources.choiceboxext import ChoiceBoxExt

config_mp.mediaportal.arte_country = ConfigText(default="de", fixed_size=False)
agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.141 Safari/537.36"

default_cover = "file://%s/arte.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class arteFirstScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"	: self.keyOK,
			"cancel": self.keyCancel,
			"blue" : self.keyCountry
		}, -1)

		self['title'] = Label("arte Mediathek")
		self['ContentTitle'] = Label(_("Genre:"))
		self['name'] = Label(_("Selection:"))

		self.keyLocked = True
		self.suchString = ''
		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.genreData)

	def genreData(self):
		self['F4'].setText(_("Language")+": "+config_mp.mediaportal.arte_country.value.upper())
		self._items = []
		self._items.append((_("Search"), "search"))
		self._items.append((_("Most Recent"), "MOST_RECENT"))
		self._items.append((_("Most Viewed"), "MOST_VIEWED"))
		self._items.append((_("Last Chance"), "LAST_CHANCE"))
		self._items.append((_("Programs A-Z"), "https://www.arte.tv/hbbtvv2/services/web/index.php/OPA/v3/magazines/%s" % config_mp.mediaportal.arte_country.value))
		self._items.append((_("Categories"), "by_channel"))
		if config_mp.mediaportal.arte_country.value in ['de', 'fr']:
			self._items.append((_("Date"), "by_date"))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		if Name == _("Search"):
			self.suchen()
		elif 'https://' in Link or Link in ['MOST_RECENT', 'MOST_VIEWED', 'LAST_CHANCE']:
			self.session.open(arteSecondScreen, Link, Name)
		else:
			self.session.open(arteSubGenreScreen, Link, Name)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = _("Search")
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '%20'))
			self.session.open(arteSecondScreen, Link, Name)

	def keyCountry(self):
		if self.keyLocked:
			return
		country_list = [ [_('German'), 'de'], [_('French'), 'fr'], [_('English'), 'en'], [_('Spanish'), 'es'], [_('Polish'), 'pl'], [_('Italian'), 'it'],]
		self.session.openWithCallback(self.keyCountryAction, ChoiceBoxExt, title=_('Select language'), list=country_list, keys=[])

	def keyCountryAction(self, result):
		if result:
			config_mp.mediaportal.arte_country.value = result[1]
			config_mp.mediaportal.arte_country.save()
			configfile_mp.save()
			self.genreData()

class arteSubGenreScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"	: self.keyOK,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("arte Mediathek")
		self['ContentTitle'] = Label(_("Genre:") + " %s" % Name)
		self['name'] = Label(_("Selection:"))

		self.keyLocked = True
		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		if self.Name == _("Date"):
			self.parseData('')
		else:
			url = "https://www.arte.tv/hbbtvv2/services/web/index.php/EMAC/teasers/categories/v2/%s" % config_mp.mediaportal.arte_country.value
			twAgentGetPage(url, agent=agent, headers={'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest', 'Referer': url}).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		if self.Name == _("Date"):
			today = datetime.date.today()
			for daynr in range(-21, 22):
				day1 = today -datetime.timedelta(days=daynr)
				dateselect =  day1.strftime('%Y-%m-%d')
				link = 'https://www.arte.tv/hbbtvv2/services/web/index.php/OPA/v3/programs/%s/%s' % (dateselect, config_mp.mediaportal.arte_country.value)
				self._items.append((dateselect, link))
			self.ml.setList(list(map(self._defaultlistcenter, self._items)))
			self.ml.moveToIndex(21)
		elif self.Name == _("Categories"):
			json_data = json.loads(data)
			for node in json_data["categories"]:
				title = str(node["title"])
				code = str(node["code"])

				url = 'https://www.arte.tv/hbbtvv2/services/web/index.php/EMAC/teasers/category/v2/%s/%s' % (code, config_mp.mediaportal.arte_country.value)
				if code in ['CIN', 'SER']:
					if config_mp.mediaportal.arte_country.value in ['de', 'fr']:
						self._items.append((title, url))
				else:
					self._items.append((title, url))
			self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		self.session.open(arteSecondScreen, Link, Name)

class arteSecondScreen(MPScreen):

	def __init__(self, session, Link, Name, subcollection=False):
		self.Link = Link
		self.Name = Name
		self.subcollection = subcollection
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0": self.closeAll,
			"ok": self.keyOK,
			"cancel": self.keyCancel,
			"up": self.keyUp,
			"down": self.keyDown,
			"right": self.keyRight,
			"left": self.keyLeft,
			"nextBouquet": self.keyPageUp,
			"prevBouquet": self.keyPageDown,
		}, -1)

		self['title'] = Label("arte Mediathek")
		self['ContentTitle'] = Label(_("Selection:") + " %s" % self.Name)

		self.page = 1
		self.lastpage = 1
		self.keyLocked = True
		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		self['name'].setText(_('Please wait...'))
		url = self.Link
		if self.Name == _("Search"):
			url = "https://www.arte.tv/guide/api/emac/v3/%s/web/data/SEARCH_LISTING/?imageFormats=landscape&mainZonePage=1&query=%s&page=%s&limit=22" % (config_mp.mediaportal.arte_country.value, url, str(self.page))
			twAgentGetPage(url, agent=agent, headers={'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest', 'Referer': url}).addCallback(self.parseData).addErrback(self.dataError)
		elif self.Link in ['MOST_RECENT', 'MOST_VIEWED', 'LAST_CHANCE']:
			url = "https://www.arte.tv/guide/api/emac/v3/%s/web/data/VIDEO_LISTING/?imageFormats=landscape&videoType=%s&page=%s&limit=22" % (config_mp.mediaportal.arte_country.value, url, str(self.page))
			twAgentGetPage(url, agent=agent, headers={'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest', 'Referer': url}).addCallback(self.parseData).addErrback(self.dataError)
		elif self.subcollection:
			self.Link = ''
			self.parseData(url)
		else:
			url = url.replace('$$PAGE$$', str(self.page))
			#if "/teasers/category/" in url:
			#	id = url.split('/')[-2]
			#	url2 = "https://www.arte.tv/hbbtvv2/services/web/index.php/EMAC/teasers/category/%s/%s" % (id, config_mp.mediaportal.arte_country.value)
			#	twAgentGetPage(url2, agent=agent, headers={'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest', 'Referer': url2}).addCallback(self.parseData).addErrback(self.dataError)
			twAgentGetPage(url, agent=agent, headers={'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest', 'Referer': url}).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		if self.subcollection:
			json_data = data
		else:
			json_data = json.loads(data)
		if "meta" in json_data and 'subCollections' in json_data:
			for node in json_data["subCollections"]:
				title = str(node['title'])
				if not title.strip():
					if 'subtitle' in json_data["meta"] and json_data["meta"]["subtitle"]:
						title = "%s - %s" % (str(json_data["meta"]['title']), str(json_data["meta"]['subtitle']))
					else:
						title = str(json_data["meta"]['title'])
				image = str(json_data["meta"]['imageUrl'])
				if 'fullDescription' in json_data["meta"] and json_data["meta"]['fullDescription']:
					descr = str(json_data["meta"]['fullDescription'])
				elif 'shortDescription' in json_data["meta"] and json_data["meta"]['shortDescription']:
					descr = str(json_data["meta"]['shortDescription'])
				elif 'teaserText' in json_data["meta"] and json_data["meta"]['teaserText']:
					descr = str(json_data["meta"]['teaserText'])
				else:
					descr = ""
				viddata = node
				self._items.append((decodeHtml(title), viddata, image, descr, 'subcollection'))
		elif "teasers" in self.Link:
			if 'category' in json_data:
				for node in json_data["category"]:
					if str(node["type"]) == "category":
						title = str(node["title"])
						code = str(node["code"])
						url = 'https://www.arte.tv/hbbtvv2/services/web/index.php/OPA/v3/videos/subcategory/%s/page/$$PAGE$$/limit/22/%s' % (code, config_mp.mediaportal.arte_country.value)
						self._items.append((decodeHtml(title), url, default_cover, "", "subcat"))
					elif str(node["type"]) in ["collection", "highlight", "magazine"]:
						title = str(node["title"])
						viddata = node
						self._items.append((decodeHtml(title), viddata, default_cover, "", "subcategory"))
					elif not node["type"]:
						title = str(node["title"])
						viddata = node
						self._items.append((decodeHtml(title), viddata, default_cover, "", "subcategory"))
			#if 'teasers' in json_data:
			#	if 'highlights' in json_data["teasers"] and len(json_data["teasers"]["highlights"]) > 0:
			#		for node in json_data["teasers"]["highlights"]:
			#			kind = str(node['kind'])
			#			if kind in ["SHOW", "BONUS"]:
			#				url = "https://api.arte.tv/api/player/v1/config/%s/%s" % (config_mp.mediaportal.arte_country.value, str(node['programId']))
			#			else:
			#				url = str(node['programId'])
			#			if 'subtitle' in node and node["subtitle"]:
			#				title = "%s - %s" % (str(node['title']), str(node['subtitle']))
			#			else:
			#				title = str(node['title'])
			#			title = _("Highlight:") + " " + title
			#			image = str(node['imageUrl'])
			#			if 'teaserText' in node and node['teaserText']:
			#				descr = str(node['teaserText'])
			#			else:
			#				descr = ""
			#			if 'stickers' in node and node['stickers'][0]["code"] != "TV_LIVE":
			#				self._items.append((decodeHtml(title), url, image, descr, kind))
			#		self._items.sort()
			#	if 'collections' in json_data["teasers"] and len(json_data["teasers"]["collections"]) > 0:
			#		for node in json_data["teasers"]["collections"]:
			#			kind = str(node['kind'])
			#			programid = str(node['programId'])
			#			if 'subtitle' in node and node["subtitle"]:
			#				title = "%s - %s" % (str(node['title']), str(node['subtitle']))
			#			else:
			#				title = str(node['title'])
			#			title = _("Collection:") + " " + title
			#			image = str(node['imageUrl'])
			#			if 'teaserText' in node and node['teaserText']:
			#				descr = str(node['teaserText'])
			#			else:
			#				descr = ""
			#			self._items.append((decodeHtml(title), programid, image, descr, kind))
			#		self._items.sort()
			#	if 'playlists' in json_data["teasers"] and len(json_data["teasers"]["playlists"]) > 0:
			#		for node in json_data["teasers"]["playlists"]:
			#			kind = str(node['kind'])
			#			programid = str(node['programId'])
			#			if 'subtitle' in node and node["subtitle"]:
			#				title = "%s - %s" % (str(node['title']), str(node['subtitle']))
			#			else:
			#				title = str(node['title'])
			#			title = _("Playlist:") + " " + title
			#			image = str(node['imageUrl'])
			#			if 'teaserText' in node and node['teaserText']:
			#				descr = str(node['teaserText'])
			#			else:
			#				descr = ""
			#			self._items.append((decodeHtml(title), programid, image, descr, kind))
			#		self._items.sort()
			#	if 'magazines' in json_data["teasers"] and len(json_data["teasers"]["magazines"]) > 0:
			#		for node in json_data["teasers"]["magazines"]:
			#			title = _("Program:") + " " + str(node["label"][config_mp.mediaportal.arte_country.value])
			#			url = str(node["url"])
			#			image = default_cover
			#			self._items.append((decodeHtml(title), url, image, "", "sendung"))
			#		self._items.sort()
		else:
			if "teasers" in json_data:
					for node in json_data["teasers"]:
						kind = str(node['kind'])
						if kind in ["SHOW", "BONUS", "MANUAL_CLIP"]:
							url = "https://api.arte.tv/api/player/v1/config/%s/%s" % (config_mp.mediaportal.arte_country.value, str(node['programId']))
						else:
							url = str(node['programId'])
						if 'subtitle' in node and node["subtitle"]:
							title = "%s - %s" % (str(node['title']), str(node['subtitle']))
						else:
							title = str(node['title'])
						if node['imageUrl']:
							image = str(node['imageUrl'])
						else:
							image = default_cover
						if 'durationSeconds' in node:
							m, s = divmod(node['durationSeconds'], 60)
							Runtime = _("Runtime:") + " %02d:%02d\n\n" % (m, s)
						else:
							Runtime = ""
						if 'broadcastBegin' in node and node['broadcastBegin']:
							date = str(node['broadcastBegin'])
							date = MPfindall(self, '.*?,\s(\d{2})\s(\w+)\s(\d{4})\s(.*?)\s\+', date)
							date = _("Date:") + " " + date[0][0] + ". " + date[0][1] + " " + date[0][2] + ", " + date[0][3] + "\n"
						else:
							date = ""
						if 'fullDescription' in node and node['fullDescription']:
							descr = str(node['fullDescription'])
						elif 'shortDescription' in node and node['shortDescription']:
							descr = str(node['shortDescription'])
						elif 'teaserText' in node and node['teaserText']:
							descr = str(node['teaserText'])
						else:
							descr = ""
						handlung = "%s%s%s" % (date, Runtime, descr)
						if 'stickers' in node and len(node["stickers"]) > 0 and node['stickers'][0]["code"] != "TV_LIVE":
							self._items.append((decodeHtml(title), url, image, handlung, kind))
			if 'programs' in json_data:
				for node in json_data["programs"]:
					if node['video']:
						if node['video']['kind'] in ["CLIP", "MANUAL_CLIP", "TRAILER", "WEEKLY_TEASER", "RENDEZ_VOUS", "PROMOTION", "PROMOTION_EVENING", "PREFACE", "TITLE_CARD"]:
							continue
						if 'subtitle' in node['video'] and node["video"]["subtitle"]:
							title = "%s - %s" % (str(node['video']['title']), str(node['video']['subtitle']))
						else:
							title = str(node['video']['title'])
						if 'durationSeconds' in node['video']:
							m, s = divmod(node['video']['durationSeconds'], 60)
							Runtime = _("Runtime:") + " %02d:%02d\n\n" % (m, s)
						else:
							Runtime = ""
						if 'broadcastBegin' in node['video'] and node['video']['broadcastBegin']:
							date = str(node['video']['broadcastBegin'])
							date = MPfindall(self, '.*?,\s(\d{2})\s(\w+)\s(\d{4})\s(.*?)\s\+', date)
							date = _("Date:") + " " + date[0][0] + ". " + date[0][1] + " " + date[0][2] + ", " + date[0][3] + "\n"
						else:
							date = ""
						if 'fullDescription' in node and node['fullDescription']:
							descr = str(node['fullDescription'])
						elif 'shortDescription' in node and node['shortDescription']:
							descr = str(node['shortDescription'])
						elif 'teaserText' in node and node['teaserText']:
							descr = str(node['teaserText'])
						else:
							descr = ""
						handlung = "%s%s%s" % (date, Runtime, descr)
						image = str(node['video']['imageUrl'])
						url = "https://api.arte.tv/api/player/v1/config/%s/%s" % (config_mp.mediaportal.arte_country.value, str(node['video']['programId']))
						self._items.append((decodeHtml(title), url, image, handlung, ""))
			elif 'videos' in json_data:
				if 'meta' in json_data:
					self.lastpage = json_data["meta"]["pages"]
					if self.lastpage > 1:
						self['Page'].setText(_("Page:"))
						self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
				for node in json_data["videos"]:
					if 'subtitle' in node and node["subtitle"]:
						title = "%s - %s" % (str(node['title']), str(node['subtitle']))
					else:
						title = str(node['title'])
					if 'durationSeconds' in node:
						m, s = divmod(node['durationSeconds'], 60)
						Runtime = _("Runtime:") + " %02d:%02d\n\n" % (m, s)
					else:
						Runtime = ""
					if 'broadcastBegin' in node and node['broadcastBegin']:
						date = str(node['broadcastBegin'])
						date = MPfindall(self, '.*?,\s(\d{2})\s(\w+)\s(\d{4})\s(.*?)\s\+', date)
						date = _("Date:") + " " + date[0][0] + ". " + date[0][1] + " " + date[0][2] + ", " + date[0][3] + "\n"
					else:
						date = ""
					if 'fullDescription' in node and node['fullDescription']:
						descr = str(node['fullDescription'])
					elif 'shortDescription' in node and node['shortDescription']:
						descr = str(node['shortDescription'])
					elif 'teaserText' in node and node['teaserText']:
						descr = str(node['teaserText'])
					else:
						descr = ""
					handlung = "%s%s%s" % (date, Runtime, descr)
					image = str(node['imageUrl'])
					url = "https://api.arte.tv/api/player/v1/config/%s/%s" % (config_mp.mediaportal.arte_country.value, str(node['programId']))
					self._items.append((decodeHtml(title), url, image, handlung, ""))
			elif 'magazines' in json_data:
				for node in json_data["magazines"]:
					if 'subtitle' in node and node["subtitle"]:
						title = "%s - %s" % (str(node['title']), str(node['subtitle']))
					else:
						title = str(node['title'])
					if 'fullDescription' in node and node['fullDescription']:
						descr = str(node['fullDescription'])
					elif 'shortDescription' in node and node['shortDescription']:
						descr = str(node['shortDescription'])
					elif 'teaserText' in node and node['teaserText']:
						descr = str(node['teaserText'])
					else:
						descr = ""
					image = str(node['imageUrl'])
					kind = str(node['kind'])
					url = str(node['programId'])
					self._items.append((decodeHtml(title), url, image, descr, kind))
			elif 'data' in json_data:
				if 'nextPage' in json_data:
					if json_data["nextPage"]:
						self.lastpage = self.page + 1
					if self.lastpage > 1:
						self['Page'].setText(_("Page:"))
						self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
				for node in json_data["data"]:
					if 'subtitle' in node and node["subtitle"]:
						title = "%s - %s" % (str(node['title']), str(node['subtitle']))
					else:
						title = str(node['title'])
					if 'duration' in node and node['duration']:
						m, s = divmod(node['duration'], 60)
						Runtime = _("Runtime:") + " %02d:%02d\n\n" % (m, s)
					else:
						Runtime = ""
					date = ""
					if 'availability' in node and node["availability"]:
						if 'upcomingDate' in node["availability"] and node["availability"]["upcomingDate"]:
							date = str(node["availability"]['upcomingDate'])
							date = MPfindall(self, '(\d{4})-(\d{2})-(\d{2})T(.*?)Z', date)
							date = _("Date:") + " " + date[0][2] + "." + date[0][1] + "." + date[0][0] + ", " + date[0][3] + "\n"
						else:
							date = ""
						if 'label' in node["availability"] and node["availability"]["label"]:
							label = str(node["availability"]['label']).replace('/','.') + "\n"
						else:
							label = ""
						if label:
							date = date + label
					if 'fullDescription' in node and node['fullDescription']:
						descr = str(node['fullDescription'])
					elif 'shortDescription' in node and node['shortDescription']:
						descr = str(node['shortDescription'])
					elif 'teaserText' in node and node['teaserText']:
						descr = str(node['teaserText'])
					else:
						descr = ""
					handlung = "%s%s%s" % (date, Runtime, descr)
					#printl(str(node['kind']['code']) + ': ' + title,self,'I')
					if node['kind']['isCollection']:
						kind = 'isCollection'
						url = str(node['programId'])
					else:
						kind = str(node['kind']['code'])
						url = "https://api.arte.tv/api/player/v1/config/%s/%s" % (config_mp.mediaportal.arte_country.value, str(node['programId']))
					self._items.append((decodeHtml(title), url, str(node['images']['landscape']['resolutions'][-1]['url']), handlung, kind))
		if len(self._items) == 0:
			self._items.append((_("No videos found!"), '', default_cover, '', '', ''))
		if len(self._items) > 0:
			self._setList('_defaultlistleft', True)
			self.ml.moveToIndex(0)
			self.keyLocked = False
			self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		self.ImageUrl = self['liste'].getCurrent()[0][2]
		handlung = self['liste'].getCurrent()[0][3]
		self['name'].setText(_(title))
		self['handlung'].setText(handlung)
		CoverHelper(self['coverArt']).getCover(self.ImageUrl)

	def keyOK(self):
		if self.keyLocked:
			return
		self.title = self['liste'].getCurrent()[0][0]
		link = self['liste'].getCurrent()[0][1]
		if not link:
			return
		kind = self['liste'].getCurrent()[0][4]
		if kind not in ["subcat", "subcollection", "subcategory"] and link.startswith('http'):
			twAgentGetPage(link, headers={'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest'}).addCallback(self.getStream).addErrback(self.dataError)
		else:
			id = self['liste'].getCurrent()[0][1]
			if kind in ["subcollection", "subcategory"]:
				self.session.open(arteSecondScreen, id, self.title, subcollection=True)
				return
			elif kind == "subcat":
				url = id
			elif kind in ["TV_SERIES", "MAGAZINE", "TOPIC", "isCollection"]:
				url = "https://www.arte.tv/hbbtvv2/services/web/index.php/EMAC/teasers/collection/v2/%s/%s" % (id, config_mp.mediaportal.arte_country.value)
			elif kind != "sendung":
				url = "https://www.arte.tv/hbbtvv2/services/web/index.php/OPA/v3/videos/collection/%s/%s/%s" % (kind, id, config_mp.mediaportal.arte_country.value)
			else:
				url = "https://www.arte.tv/hbbtvv2/services/web/index.php/%s/%s" % (id, config_mp.mediaportal.arte_country.value)
			self.session.open(arteSecondScreen, url, self.title)

	def getStream(self, data):
		json_data  = json.loads(data)
		if 'VSR' in json_data["videoJsonPlayer"]:
			try:
				url = str(json_data["videoJsonPlayer"]["VSR"]["HTTPS_SQ_1"]["url"])
			except:
				url = None
		else:
			url = None
		if url:
			self.session.open(SimplePlayer, [(self.title, url, self.ImageUrl)], showPlaylist=False, ltype='arte')
		else:
			self.session.open(MessageBoxExt, _("This video is not available."), MessageBoxExt.TYPE_INFO, timeout=5)