﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from builtins import range
from ...plugin import _
from ...resources.imports import *
from ...resources.keyboardext import VirtualKeyBoardExt
from ...resources.choiceboxext import ChoiceBoxExt

BASE_URL = "https://classic.ardmediathek.de"
agent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.102 Safari/537.36'
default_cover = "file://%s/ard.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class ARDGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("ARD Mediathek")
		self['ContentTitle'] = Label("Genre:")

		self._items = []
		self.suchString = ''
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		self._items.append(("Suche - TV", "1"))
		self._items.append(("Sendungen A bis Z - TV", "2"))
		self._items.append(("Sendung verpasst!? - TV", "3"))
		self._items.append(("Kategorien - TV", "4"))
		self._items.append(("Tagesschau - TV", "11"))
		self._items.append((400 * "—", "99"))
		self._items.append(("Suche - Radio", "6"))
		self._items.append(("Sendungen A bis Z - Radio", "7"))
		self._items.append(("Kategorien - Radio", "8"))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))

	def keyOK(self):
		self.gN = self['liste'].getCurrent()[0][0]
		self.gF = self['liste'].getCurrent()[0][1]
		if self.gF == "99":
			return
		elif self.gF == "1" or self.gF == "6":
			self.session.openWithCallback(self.searchCallback, VirtualKeyBoardExt, title = (_("Enter search criteria")), text = self.suchString, is_dialog=True)
		else:
			self.session.open(ARDPreSelect, self.gN, self.gF)

	def searchCallback(self, callback):
		self.gF = self['liste'].getCurrent()[0][1]
		if callback is not None and len(callback):
			self.suchString = callback
			searchStr = urllib.parse.quote(callback)
			genreName = "Suche - " + self.suchString
			if self.gF == "1":
				url = BASE_URL+"/suche?searchText="+searchStr+"&source=tv&sort="
			elif self.gF == "6":
				url = BASE_URL+"/suche?searchText="+searchStr+"&source=radio&sort="
			self.session.open(ARDStreamScreen, url, genreName, self.gF)

class ARDPreSelect(MPScreen):

	def __init__(self, session, genreName, genreFlag):
		self.gN = genreName
		self.gF = genreFlag
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self.keyLocked = True
		self['title'] = Label("ARD Mediathek")
		self['ContentTitle'] = Label(_("Selection:") + " %s" % self.gN)

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		if self.gF == "2" or self.gF == "7":
			self._items = []
			for c in range(26): # ABC, Radio & TV
				self._items.append((chr(ord('A') + c), None))
			self._items.insert(0, ('0-9', None))
		elif self.gF == "4" or self.gF == "8":
			self._items = []
			if self.gF == "4": # Extra-Kategorien, Radio & TV
				self._items.append(("TOP von Seite 1", "1"))
				self._items.append(("Neueste Videos", "2"))
				self._items.append(("Meistabgerufene Videos", "3"))
				self._items.append((400 * "—", "99"))
				self._items.append(("Alle Filme", "18"))
				self._items.append(("Alle Dokus & Reportagen", "19"))
				self._items.append(("Kinder & Familie", "7"))
				self._items.append(("Kultur", "13"))
				self._items.append(("Musik", "6"))
				self._items.append(("Politik", "12"))
				self._items.append(("Ratgeber", "14"))
				self._items.append(("Reise", "17"))
				self._items.append(("Sport", "15"))
				self._items.append(("Sportreportagen", "16"))
				self._items.append(("Tiere", "5"))
				self._items.append(("Unterhaltung & Comedy", "10"))
				self._items.append(("Wissen", "11"))
			if self.gF == "8": # Extra-Kategorien, nur Radio
				self._items.append(("Neueste Clips", "1"))
				self._items.append(("Meistabgerufene Clips", "2"))
				self._items.append((400 * "—", "99"))
				self._items.append(("Tipps der Redaktion", "3"))
				self._items.append(("Feature & Hintergrund", "6"))
				self._items.append(("Gespräch", "8"))
				self._items.append(("Hörspiel", "4"))
				self._items.append(("Kabarett & Comedy", "5"))
				self._items.append(("Wissen", "7"))
		elif self.gF == "3":	# Sendung verpasst?
			for q in range (0, 7):
				s2 = (datetime.date.today()+datetime.timedelta(days=-q)).strftime("%A %d. %B %Y")
				s3 = str(q)
				self._items.append((s2, s3))
		elif self.gF == "11":
			self._items = []
			self._items.append(("Tagesschau", "1"))
			self._items.append(("Tagesschau mit Gebärdensprache", "2"))
			self._items.append(("Tagesthemen", "3"))
			self._items.append(("Tagesschau24", "4"))

		self.keyLocked = False
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.showInfos()

	def keyOK(self):
		if self.keyLocked:
			return
		auswahl = self['liste'].getCurrent()[0][0]
		extra = self['liste'].getCurrent()[0][1]
		if extra == "99":
			return
		elif self.gF == "3":
			self.session.open(ARDPreSelectSender, auswahl, self.gF, extra)
		elif self.gF == "4":	# Kategorien TV
			if extra == '1': # TOP von Seite 1 - TV
				Link = "%s/tv" % BASE_URL
			elif extra == '2': # Neueste Videos
				Link = "%s/tv/Neueste-Videos/mehr?documentId=21282466" % BASE_URL
			elif extra == '3': # Meistabgerufene Videos
				Link = "%s/tv/Meistabgerufene-Videos/mehr?documentId=23644244" % BASE_URL
			elif extra == '5': # Tiere
				Link = "%s/tv/tiere" % BASE_URL
			elif extra == '6': # Musik
				Link = "%s/tv/musik" % BASE_URL
			elif extra == '7': # Kinder & Familie
				Link = "%s/tv/Kinder-Familie/mehr?documentId=21282542" % BASE_URL
			elif extra == '8': # "Must see" - was die Redaktion schaut
				Link = "%s/tv/mustsee" % BASE_URL
			elif extra == '9': # Kurzes für Zwischendurch
				Link = "%s/tv/Kurzes-für-Zwischendurch/mehr?documentId=45458112" % BASE_URL
			elif extra == '10': # Unterhaltung & Comedy
				Link = "%s/tv/unterhaltung" % BASE_URL
			elif extra == '11': # Wissen
				Link = "%s/tv/wissen" % BASE_URL
			elif extra == '12': # Politik
				Link = "%s/tv/politik" % BASE_URL
			elif extra == '13': # Kultur
				Link = "%s/tv/kultur" % BASE_URL
			elif extra == '14': # Ratgeber
				Link = "%s/tv/ratgeber" % BASE_URL
			elif extra == '15': # Sport
				Link = "%s/tv/sport" % BASE_URL
			elif extra == '16': # Sportreportagen
				Link = "%s/tv/Sportreportagen-dokus/Tipps?documentId=30366344" % BASE_URL
			elif extra == '17': # Reise
				Link = "%s/tv/reise" % BASE_URL
			elif extra == '18': # Alle Filme
				Link = "%s/tv/Alle-Filme/mehr?documentId=31610076" % BASE_URL
			elif extra == '19': # Alle Dokus & Reportagen
				Link = "%s/tv/Alle-Dokus-und-Reportagen/mehr?documentId=29897594" % BASE_URL
			self.session.open(ARDStreamScreen, Link, auswahl, self.gF)
		elif self.gF == "8": # Kategorien Radio
			if extra == '1': # Neueste Clips
				Link = "%s/radio/Neueste-Audios/mehr?documentId=21282450" % BASE_URL
			elif extra == '2': # Meistabgerufene Clips
				Link = "%s/radio/Meistabgerufene-Audios/mehr?documentId=21282452" % BASE_URL
			elif extra == '3': # Tipps der Redaktion
				Link = "%s/radio/Tipps-der-Redaktion/mehr?documentId=21301892" % BASE_URL
			elif extra == '4': # Hörspiel
				Link = "%s/radio/Hörspiele/mehr?documentId=21301890" % BASE_URL
			elif extra == '5': # Kabarett&Comedy
				Link = "%s/radio/Kabarett-Comedy/mehr?documentId=37915182" % BASE_URL
			elif extra == '6': # Feature&Hintergrund
				Link = "%s/radio/Feature-und-Hintergrund/mehr?documentId=34835938" % BASE_URL
			elif extra == '7': # Wissen
				Link = "%s/radio/Wissen/mehr?documentId=34836128" % BASE_URL
			elif extra == '8': # Gespräch
				Link = "%s/radio/Gespräch/mehr?documentId=35293220" % BASE_URL
			self.session.open(ARDStreamScreen, Link, auswahl, self.gF)
		elif self.gF == "11": # Tagesschau
			if extra == '1': # Tagesschau
				Link = "%s/tv/Tagesschau/Sendung?documentId=4326&bcastId=4326" % BASE_URL
			elif extra == '2': # Tagesschau mit Gebärdensprache
				Link = BASE_URL+"/tv/Tagesschau-mit-Geb%C3%A4rdensprache/Sendung?documentId=12722002&bcastId=12722002"
			elif extra == '3': # Tagesthemen
				Link = "%s/tv/Tagesthemen/Sendung?documentId=3914&bcastId=3914" % BASE_URL
			elif extra == '4': # Tagesschau24
				Link = "%s/tv/tagesschau24/Sendung?documentId=6753968&bcastId=6753968" % BASE_URL
			self.session.open(ARDStreamScreen, Link, auswahl, self.gF)
		else:
			if self.gF == "2" or self.gF == "7": # ABC (TV oder Radio)
				self.gN = auswahl
			else:
				self.gN = auswahl
				auswahl = extra
			self.session.open(ARDPostSelect, auswahl, self.gN, self.gF)

class ARDPreSelectSender(MPScreen):

	def __init__(self, session, genreName, genreFlag, sender):
		self.gN = genreName
		self.gF = genreFlag
		self.sender = sender
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self['title'] = Label("ARD Mediathek")
		self['ContentTitle'] = Label(_("Selection:") + " %s" % self.gN)

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items.append(("Das Erste", "208"))
		self._items.append(("BR", "2224"))
		self._items.append(("HR", "5884"))
		self._items.append(("MDR", "5882"))
		self._items.append(("MDR Thüringen", "1386988"))
		self._items.append(("MDR Sachsen-Anhalt", "1386898"))
		self._items.append(("MDR Sachsen", "1386804"))
		self._items.append(("NDR", "5906"))
		self._items.append(("RB", "5898"))
		self._items.append(("RBB", "5874"))
		self._items.append(("RBB Brandenburg", "21518356"))
		self._items.append(("RBB Berlin", "21518358"))
		self._items.append(("SR", "5870"))
		self._items.append(("SWR", "5310"))
		self._items.append(("SWR Rheinland-Pfalz", "5872"))
		self._items.append(("SWR Baden-Württemberg", "5904"))
		self._items.append(("WDR", "5902"))
		self._items.append(("tagesschau24", "5878"))
		self._items.append(("ARD alpha", "5868"))
		self._items.append(("ONE", "673348"))
		self._items.append(("KiKA", "5886"))
		self._items.append(("phoenix", "5888"))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.showInfos()

	def keyOK(self):
		auswahl = self['liste'].getCurrent()[0][0]
		extra = self['liste'].getCurrent()[0][1]
		url = "%s/tv/sendungVerpasst?tag=%s&kanal=%s" % (BASE_URL, self.sender, extra)	# "self.sender" kein Tippfehler!
		self.session.open(ARDStreamScreen, url, auswahl, self.gF)

class ARDPostSelect(MPScreen):

	def __init__(self, session, auswahl, genreName, genreFlag):
		self.auswahl = auswahl
		self.gN = genreName
		self.gF = genreFlag
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft
		}, -1)

		self.keyLocked = True
		self['title'] = Label("ARD Mediathek")
		self['ContentTitle'] = Label(_("Selection:") + " %s" % self.gN)

		self._items = []
		self.sendungen = ""
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		if self.gF == "2":	# ABC - TV
			url = "%s/tv/sendungen-a-z?buchstabe=%s&mcontent=page.1" % (BASE_URL, self.auswahl)
		if self.gF == "7":	# ABC - Radio
			url = "%s/radio/sendungen-a-z?buchstabe=%s&sendungsTyp=sendung&mcontent=page.1" % (BASE_URL, self.auswahl)
		twAgentGetPage(url, agent=agent).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		self._items = []
		self.sendungen = MPfindall(self, '<div class="box" .*?data-ctrl-image=.*?(https://img.*?)&#039;.*?textWrapper.*?<a\shref="(.*?)".*?headline">(.*?)<', data, re.S)
		if self.sendungen:
			for (image, url, title) in self.sendungen:
				url = BASE_URL+url.replace("&amp;", "&")
				if "|" in title:
					title = title.replace("|", "-")
				self._items.append((decodeHtml(title), url, image.replace('##width##', '800')))
			self.keyLocked = False
		if len(self._items) < 1:
			self._items.append((_('No videos found!'), None, None))
		self._setList('_defaultlistleft', True)
		if self['liste'].getCurrent()[0][1]:
			self.showInfos()

	def showInfos(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		streamPic = self['liste'].getCurrent()[0][2]
		self['name'].setText(Name)
		CoverHelper(self['coverArt']).getCover(streamPic)
		if self.gF != "10":
			url = self['liste'].getCurrent()[0][1]
			if url:
				twAgentGetPage(url, agent=agent).addCallback(self.handlePicAndTxt).addErrback(self.dataError)

	def handlePicAndTxt(self, data):
		if self.keyLocked:
			return
		handlung = ''
		streamPic = default_cover
		gefunden = MPfindall(self, '<meta name="description" content="(.*?)"/.*?<meta name="author" content="(.*?)".*?<meta name="gsaimg512" content="(.*?)"/>.*?<div class="box">.*?textWrapper.*?dachzeile">(.*?)[<|\s]', data, re.S)
		if gefunden:
			itxt = ''
			for (itxt, sender, streamPic, ausgaben) in gefunden:
				itxttmp = itxt.split("|")
				itxt = itxttmp[-2]
				itxt = decodeHtml(itxt)
				itxt = itxt.strip()
				if not ausgaben:
					ausgaben = ""
				url = self['liste'].getCurrent()[0][1]
				if "/tv/" in url:
					media = "TV"
				elif "/radio/" in url:
					media = "Radio"
				else:
					media = "?"
				handlung = "Media: %s\nSender: %s\nClips: %s" % (media, sender, ausgaben)
		streamHandlung = handlung+"\n\n"+itxt
		self['handlung'].setText(streamHandlung)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		if Link:
			self.session.open(ARDStreamScreen, Link, self.gN, self.gF)

class ARDStreamScreen(MPScreen):

	def __init__(self, session, Link, genreName, genreFlag):
		self.Link = Link
		self.gN = genreName
		self.gF = genreFlag
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0"		: self.closeAll,
			"ok"    : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"yellow" : self.keySort,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown
			}, -1)

		self.keyLocked = True
		self['title'] = Label("ARD Mediathek")
		self['ContentTitle'] = Label(_("Selection:") + " %s" % self.gN)
		self['name'] = Label(_("Please wait..."))
		if self.gF == "1" or self.gF == "6":
			self['F3'] = Label(_("Sort"))

		self.page = 1
		self.lastpage = 1
		self.suchTrigger = "score"
		self.folgen = ""
		self._items = []
		self.sendung = ""
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		if self.gF == "1" or self.gF =="6":	# Suche
			url = self.Link+self.suchTrigger+"&mresults=page."+str(self.page)	# Kein "%s" hier verwenden!! Gewandelte Umlaute aus searchCallBack enthalten "%"!
		elif self.gF == "4" or self.gF == "8":	# Kategorien
			url = "%s&mcontent=page.%s" % (self.Link, self.page)
		elif self.gF == "3":
			url = self.Link
		else:
			url = "%s&mcontents=page.%s" % (self.Link, self.page)

		if self.gN == "TOP von Seite 1":
			url = self.Link
		elif self.gN == 'Unterhaltung & Comedy':
			url = "%s?m39803570=page.%s" % (self.Link, self.page)
		elif self.gN == 'Wissen' and "/tv/" in self.Link:
			url = "%s?m39348662=page.%s" % (self.Link, self.page)
		elif self.gN == 'Politik':
			url = "%s?m39593042=page.%s" % (self.Link, self.page)
		elif self.gN == 'Kultur':
			url = "%s?m39594746=page.%s" % (self.Link, self.page)
		elif self.gN == 'Reise':
			url = "%s?m39618186=page.%s" % (self.Link, self.page)
		elif self.gN == 'Ratgeber':
			url = "%s?m39712440=page.%s" % (self.Link, self.page)
		elif self.gN == 'Sport':
			url = "%s?m30348620=page.%s" % (self.Link, self.page)
		elif self.gN == 'Sportreportagen':
			url = "%s&m27307124=page.%s" % (self.Link, self.page)
		elif self.gN == 'Tiere':
			url = "%s?m47626546=page.%s" % (self.Link, self.page)
		elif self.gN == 'Musik':
			url = "%s?m39087914=page.%s" % (self.Link, self.page)
		twAgentGetPage(url, agent=agent).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		if self.gN == "Sport":
			data = re.search('(.*?)Ausgewählte Dokus', data, re.S).group(1)
		self._items = []
		if self.page == 1:	# Gleich bei Seite 1 die maximale Seite merken. Danach nicht nochmal berechnen
			if "Loader-source" in data:
				try:
					max = MPfindall(self, 'Loader-source.*?<a.*?>\s+(.*?)\s+</a>', data, re.S)[-2]	# Der vorletzte Treffer ist die letzte Seite
				except IndexError:	#	Gab kein [-2]
					max = "x"
				max = [x for x in max if x.isdigit()]	#	Ziffer enthalten?
				if not max:	# Keine Ziffer gefunden
					self.lastpage = 1
				else:
					self.lastpage = int(max[-1])
			else: # Kein "Loader-source"; ergo: Gibt nur eine Seite
				self.lastpage = 1
		if self.lastpage > 1:
			self['Page'].setText(_("Page:"))
			self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))

		if (self.gF == "4" and self.gN == "TOP von Seite 1"): # TOP von Seite 1
			self.folgen = MPfindall(self, 'ModStageMediaPanel.*?data-ctrl-image=.*?(https://img.*?)&#039;.*?textWrapper.*?href="(.*?)" class="textLink">.*?headline">(.*?)</', data, re.S)
		else:
			if 'class="controls sliding"' in data:
				if self.gN == 'Musik':
					data = re.search('class="controls sliding"(.*)class="section onlyWithJs', data, re.S).group(1)
				else:
					data = re.search('.*?class="controls sliding"(.*?)$', data, re.S).group(1)
			self.folgen = MPfindall(self, '<div class="teaser"\s.*?data-ctrl-image=.*?(https://img.*?)&#039;.*?textWrapper.*?href="(.*?)" class="textLink">.*?headline">(.*?)</', data, re.S)
		if self.folgen:
			for (image, url, title) in self.folgen:
				if not "Livestream" in url and not "http:" in url and "bcastId" in url:
					url = BASE_URL+url.replace("&amp;", "&")
					sub = re.search('documentId=(.*?)($|&)', url, re.S)
					if sub:
						iD = sub.group(1)
						self._items.append((decodeHtml(title), url, image.replace('##width##', '800'), iD))
			self._setList('_defaultlistleft', True)
			self.ml.moveToIndex(0)
			self.keyLocked = False
		else:
			self._items.append((_('No videos found!'), None, None, None))
			self._setList('_defaultlistleft', True)
		if self['liste'].getCurrent()[0][1]:
			self.showInfos()

	def showInfos(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		streamPic = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(streamPic)
		if Link:
			twAgentGetPage(Link, agent=agent).addCallback(self.handlePicAndTxt).addErrback(self.dataError)

	def handlePicAndTxt(self, data):
		if self.keyLocked:
			return
		handlung = ''
		streamPic = default_cover
		if not "dcterms.date" in data:
			ergebnis = MPfindall(self, '<meta name="description" content="(.*?)"/>.*?author" content="(.*?)"/.*?<meta name="gsaimg512" content="(.*?)"/>.*?dcterms.title" content="(.*?)"/>.*?og:site_name" content="(.*?)"/>.*?<p class="subtitle">(.*?)</', data, re.S)
		if "dcterms.isPartOf" in data:
			ergebnis = MPfindall(self, '<meta name="description" content="(.*?)"/>.*?author" content="(.*?)"/.*?<meta name="gsaimg512" content="(.*?)"/>.*?dcterms.isPartOf" content="(.*?)"/>.*?dcterms.date" content="(.*?)"/>.*?<p class="subtitle">(.*?)</', data, re.S)
		else:
			ergebnis = MPfindall(self, '<meta name="description" content="(.*?)"/>.*?author" content="(.*?)"/.*?<meta name="gsaimg512" content="(.*?)"/>.*?dcterms.title" content="(.*?)"/>.*?dcterms.date" content="(.*?)"/>.*?<p class="subtitle">(.*?)</', data, re.S)
		if ergebnis:
			itxt = ''
			for (itxt, sender, streamPic, sendung, uhr, meta) in ergebnis:
				self.sendung = sendung
				title = self['liste'].getCurrent()[0][0]
				if title in itxt:
					itxttmp = itxt.split(title+":")
					itxt = itxttmp[-1].strip()
					itxt = decodeHtml(itxt)
				else:
					itxt = decodeHtml(itxt).strip()
				if "ARD" in uhr:	#	Fakeeintrag um Absturz zu verhindern
					uhr = " - Liegt in der Zukunft!"
				else:
					uhr = uhr.split("T")
					uhr = uhr[-1]
					uhr = ", "+uhr[:5]+" Uhr"
				meta = meta.split(" | ")
				airtime = meta[0]
				dur = meta[1]
			url = self['liste'].getCurrent()[0][1]
			handlung = "Sender: %s\nDatum: %s%s\nLaufzeit: %s" % (sender, airtime, uhr, dur)
		self['name'].setText(decodeHtml(self.sendung))
		streamHandlung = handlung+"\n\n"+itxt
		self['handlung'].setText(streamHandlung)

	def keySort(self):
		if self.keyLocked:
			return
		if not (self.gF == "1" or self.gF =="6"):
			return
		rangelist = [['Relevanz', 'score'], ['Datum', 'date']]
		self.session.openWithCallback(self.keySortAction, ChoiceBoxExt, title=_('Select Action'), list = rangelist)

	def keySortAction(self, result):
		if result:
			self.suchTrigger = result[1]
			self.loadPage()

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		self['name'].setText(_("Please wait..."))
		url = self['liste'].getCurrent()[0][1]
		if not url:
			self['name'].setText(Name)
		else:
			twAgentGetPage(url, agent=agent).addCallback(self.get_Link).addErrback(self.dataError)

	def get_Link(self, data):
		fsk = re.search('<div class="box fsk.*?"teasertext">\s+(.*?)\s+</p>', data, re.S)
		if fsk:
			message = self.session.open(MessageBoxExt, _(fsk.group(1)), MessageBoxExt.TYPE_INFO, timeout=7)
			Name = self['liste'].getCurrent()[0][0]
			self['name'].setText(Name)
			return
		else:
			mediaid = self['liste'].getCurrent()[0][3]
			url = BASE_URL+"/play/media/"+mediaid+"?devicetype=pc&features=flash"
			twAgentGetPage(url, agent=agent).addCallback(self.getStreams).addErrback(self.dataError)

	def getStreams(self, data):
		stream = None
		json_data = json.loads(data)
		if len(json_data["_mediaArray"]) > 1:
			stream_data = json_data["_mediaArray"][1]
		else:
			stream_data = json_data["_mediaArray"][0]
		if isinstance(stream_data["_mediaStreamArray"][-1]["_stream"], list):
			stream = str(stream_data["_mediaStreamArray"][-1]["_stream"][-1])
		else:
			stream = str(stream_data["_mediaStreamArray"][-1]["_stream"])

		if "960-" in stream: # Das Erste
			try:
				request = requests.head(stream.replace('960-', '1280-'))
				if request.status_code == 200:
					stream = stream.replace('960-', '1280-')
			except:
				pass

		if ".xl.mp4" in stream: # SWR
			try:
				request = requests.head(stream.replace('.xl.mp4', '.xxl.mp4'))
				if request.status_code == 200:
					stream = stream.replace('.xl.mp4', '.xxl.mp4')
			except:
				pass

		if "_sd.mp4" in stream: # DW
			try:
				request = requests.head(stream.replace('_sd.mp4', '_hd.mp4'))
				if request.status_code == 200:
					stream = stream.replace('_sd.mp4', '_hd.mp4')
			except:
				pass

		if stream:
			if stream.startswith('//'):
				stream = 'http:' + stream
			Name = self['liste'].getCurrent()[0][0]
			self['name'].setText(Name)
			self.session.open(SimplePlayer, [(Name, stream)], showPlaylist=False, ltype='ard')