﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.youtubeplayer import YoutubePlayer

default_cover = "file://%s/liveleak.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class LiveLeakScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label("LiveLeak.com")
		self['ContentTitle'] = Label("Genre:")
		self._items = []
		self.suchString = ''
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self._items.append(("--- Search ---", ""))
		self._items.append(("Featured", "browse?featured=1&page="))
		self._items.append(("Recent Items", "browse?page="))
		self._items.append(("Must See", "browse?in_bookmark_folder_id=2&container_id=module_container_1&hs=1&page="))
		self._items.append(("German", "browse?q=german&hs=1&page="))
		self._items.append(("News & Politics", "browse?tag_string=news%2C+politics%2C+trump&container_id=module_container_1&hs=1&page="))
		self._items.append(("Law Enforcement", "browse?tag_string=police%2C+law+enforcement%2C+cops%2C+bodycam&container_id=module_container_1&hs=1&page="))
		self._items.append(("Weather", "browse?tag_string=weather%2Cstorm%2Cthunder%2Cwind%2Churricane%2Ctornado%2Crainbow%2Chail%2Csnow%2Cice&container_id=module_container_1&hs=1&page="))
		self._items.append(("Entertainment", "browse?tag_string=entertainment&container_id=module_container_1&hs=1&page="))
		self._items.append(("WTF", "browse?tag_string=wtf&container_id=module_container_1&hs=1&page="))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = 'browse?q=%s&hs=1&page=' % urllib.parse.quote(self.suchString.replace(' ', '+'))
			self.session.open(LiveLeakClips, Link, Name)

	def keyOK(self):
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen()
		else:
			Link = self['liste'].getCurrent()[0][1]
			self.session.open(LiveLeakClips, Link, Name)

class LiveLeakClips(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"    : self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"up"    : self.keyUp,
			"down"  : self.keyDown,
			"left"  : self.keyLeft,
			"right" : self.keyRight,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self['title'] = Label("LiveLeak.com")
		self['ContentTitle'] = Label("Auswahl: %s" %self.Name)
		self['F2'] = Label(_("Page"))

 		self['Page'] = Label(_("Page:"))
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self._items = []
		self['name'].setText(_('Please wait...'))
		url = "https://www.liveleak.com/%s%s&safe_mode=off" % (self.Link, str(self.page))
		twAgentGetPage(url).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		self.getLastPage(data, 'class="pagination"(.*?)</ul>')
		vids = MPfindall(self, 'items_pic.*?img\ssrc="(.*?)"\salt="(.*?)".*?href="(.*?)".*?h3>(.*?)<div.*?(?:Added:|Leaked:)(.*?)(?:in:|\|).*?Views:\s(\d+)', data, re.S)
		if vids:
			for (image, title, url, descr, date, views) in vids:
				if image.startswith('//'):
					image = "https:" + image
				self._items.append((decodeHtml(title).strip(), url, image, decodeHtml(stripAllTags(descr)).strip(), date.strip(), views.strip()))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), None, None, '', '', ''))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		url = self['liste'].getCurrent()[0][1]
		Title = self['liste'].getCurrent()[0][0]
		Image = self['liste'].getCurrent()[0][2]
		self['name'].setText(Title)
		twAgentGetPage(url).addCallback(self.showInfos2).addErrback(self.dataError)
		CoverHelper(self['coverArt']).getCover(Image)

	def showInfos2(self, data):
		date = self['liste'].getCurrent()[0][4]
		views = self['liste'].getCurrent()[0][5]
		descr = MPfindall(self, 'step_outer">(.*?)<div', data, re.S)
		if descr:
			self['handlung'].setText("Added: %s\nViews: %s\n\n%s" % (date, views, decodeHtml(stripAllTags(descr[0])).strip()))

	def keyOK(self):
		if self.keyLocked:
			return
		url = self['liste'].getCurrent()[0][1]
		twAgentGetPage(url).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		title = self['liste'].getCurrent()[0][0]
		Stream = MPfindall(self, 'source\ssrc="(.*?)"', data, re.S)
		if Stream:
			self.session.open(SimplePlayer, [(title, Stream[0])], showPlaylist=False, ltype='liveleak')
		else:
			videoPage = MPfindall(self, '//www.youtube.com/(v|embed)/(.*?)\?.*?"', data, re.S)
			if videoPage:
				self.session.open(YoutubePlayer, [(title, videoPage[0][1], None)], playAll= False, showPlaylist=False, showCover=False)
			else:
				self.session.open(MessageBoxExt, _("No videos found!"), MessageBoxExt.TYPE_INFO, timeout=3)