﻿# -*- coding: utf-8 -*-
#######################################################################################################
#
#    MediaPortal for Dreambox OS
#
#    Coded by MediaPortal Team (c) 2013-2021
#
#  This plugin is open source but it is NOT free software.
#
#  This plugin may only be distributed to and executed on hardware which
#  is licensed by Dream Property GmbH. This includes commercial distribution.
#  In other words:
#  It's NOT allowed to distribute any parts of this plugin or its source code in ANY way
#  to hardware which is NOT licensed by Dream Property GmbH.
#  It's NOT allowed to execute this plugin and its source code or even parts of it in ANY way
#  on hardware which is NOT licensed by Dream Property GmbH.
#
#  This applies to the source code as a whole as well as to parts of it, unless explicitely
#  stated otherwise.
#
#  If you want to use or modify the code or parts of it, permission from the authors is necessary.
#  You have to keep OUR license and inform us about any modification, but it may NOT be distributed
#  other than under the conditions noted above.
#
#  As an exception regarding modifcations, you are NOT permitted to remove
#  any copy protections implemented in this plugin or change them for means of disabling
#  or working around the copy protections, unless the change has been explicitly permitted
#  by the original authors. Also decompiling and modification of the closed source
#  parts is NOT permitted.
#
#  Advertising with this plugin is NOT allowed.
#
#  For other uses, permission from the authors is necessary.
#
#######################################################################################################

from builtins import map
from ...plugin import _
from ...resources.imports import *
from ...resources.youtubeplayer import YoutubePlayer

default_cover = "file://%s/hornoxe.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

class hornoxeScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"0" : self.closeAll,
			"ok" : self.keyOK,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"left" : self.keyLeft,
			"right" : self.keyRight,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self.keyLocked = True
		self['title'] = Label("hornoxe.com")
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		url = "http://www.hornoxe.com/fun-clips/page/%s/" % str(self.page)
		twAgentGetPage(url).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		self.getLastPage(data, "class='wp-pagenavi'(.*?)</div>", '.*/page/(\d+)')
		Videos = MPfindall(self, 'class="storytitle"><a\shref="((?!http://www.hornoxe.com/den-picdump-von-morgen).*?)".*?img(?: loading="lazy"|)\ssrc=["|\'](.*?)["|\'].*?alt=["|\'](.*?)["|\'].*?</a>(.*?)</p', data, re.S)
		if Videos:
			self._items = []
			for (Url, Image, Title, Descr) in Videos:
				Descr = stripAllTags(Descr).strip()
				if ".gif" in Image:
					continue
				if ".png" in Image:
					continue
				self._items.append((decodeHtml(Title), Url, Image, decodeHtml(Descr)))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), None, None, ''))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		Title = self['liste'].getCurrent()[0][0]
		PicLink = self['liste'].getCurrent()[0][2]
		Descr = self['liste'].getCurrent()[0][3]
		self['name'].setText(Title)
		self['handlung'].setText(Descr)
		CoverHelper(self['coverArt']).getCover(PicLink)

	def keyOK(self):
		if self.keyLocked:
			return
		url = self['liste'].getCurrent()[0][1]
		twAgentGetPage(url).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		Title = self['liste'].getCurrent()[0][0]
		Stream = MPfindall(self, '<source type="video/mp4" src="(.*?)"', data)
		if Stream:
			Stream = Stream[0]
			self.session.open(SimplePlayer, [(Title, Stream)], showPlaylist=False, ltype='hornoxe')
		else:
			videoPage = MPfindall(self, 'www.youtube.com/(v|embed)/(.*?)"', data, re.S)
			if videoPage:
				self.session.open(YoutubePlayer, [(Title, videoPage[0][1], None)], playAll= False, showPlaylist=False, showCover=False)