# -*- coding: utf-8 -*-
from Components.Converter.Converter import Converter
from Components.Converter.Poll import Poll
from enigma import iServiceInformation, iPlayableService, iPlayableServicePtr
from Components.Element import cached
from os import path as os_path
from Plugins.Extensions.MediaPortal.resources.config import config_mp
MOVIE_EXTS = frozenset((".ts", ".avi", ".divx", ".mpg", ".mpeg", ".mkv", ".mp4", ".mov", ".iso"))

class MPServiceName(Poll, Converter, object):
	NAME = 0
	NAMELCD = 1

	def __init__(self, type):
		Converter.__init__(self, type)
		Poll.__init__(self)
		if type == "NameLCD":
			self.type = self.NAMELCD
		else:
			self.type = self.NAME
		self.poll_interval = 30*1000
		self.poll_enabled = True

	def getServiceInfoValue(self, info, what, ref=None):
		v = ref and info.getInfo(ref, what) or info.getInfo(what)
		if v != iServiceInformation.resIsString:
			return "N/A"
		return ref and info.getInfoString(ref, what) or info.getInfoString(what)

	@cached
	def getText(self):
		service = self.source.service

		if isinstance(service, iPlayableServicePtr):
			info = service and service.info()
			ref = None
		else: # reference
			info = service and self.source.info
			ref = service
		if info is None:
			return ""
		if self.type in [self.NAME, self.NAMELCD]:
			name = ref and info.getName(ref)
			if name is None:
				name = info.getName()
			sname, ext = os_path.splitext(name)
			if ext in MOVIE_EXTS:
				name = sname.replace("_", " ")
			serv_ref = self.getServiceInfoValue(info, iServiceInformation.sServiceref, ref)
			name = name.replace('\xc2\x86', '').replace('\xc2\x87', '')
			if config_mp.mediaportal.is_radio.value:
				sTitle=info.getInfoString(iServiceInformation.sTagTitle)
				if sTitle != '':
					if self.type == self.NAME:
						name = sTitle + " ("+name+")"
					else:
						name = sTitle
			return name

	text = property(getText)

	def changed(self, what):
		if what[0] == self.CHANGED_POLL or what[0] != self.CHANGED_SPECIFIC or what[1] in (iPlayableService.evStart,) or what[1] in (iPlayableService.evUpdatedInfo,):
			Converter.changed(self, what)