﻿# -*- coding: utf-8 -*-
from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *

class pandamovieGenreScreen(MPScreen):

	def __init__(self, session, mode, genre='Genres'):
		self.mode = mode
		self.genre = genre

		global default_cover
		if self.mode == "pandamovie":
			self.portal = "PandaMovie"
			self.baseurl = "https://pandamovies.pw"
			default_cover = "file://%s/pandamovie.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.mode == "netflixporno":
			if self.genre == "Genres":
				self.genre = "Categories"
			self.portal = "NetFlixPorno"
			self.baseurl = "https://netflixporno.net"
			default_cover = "file://%s/netflixporno.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label(self.portal)
		self['ContentTitle'] = Label("Genre:")
		self['name'] = Label(_("Please wait..."))

		self.keyLocked = True
		self.suchString = ''

		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self._items = []
		url = self.baseurl
		twAgentGetPage(url).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		parse = re.search('href="#">%s</a>(.*?)</ul>' % self.genre, data, re.S)
		if parse:
			raw = re.findall('href="(.*?)">(.*?)</a', parse.group(1), re.S)
			if raw:
				for (Url, Title) in raw:
					if Url.startswith('//'):
						Url = "https:" + Url
					Url = Url.strip('/') + "/page/"
					self._items.append((upperString(decodeHtml(Title)), Url))
				self._items.sort()
		if self.genre == "Genres":
			self._items.insert(0, ("Years", "Year", None))
			self._items.insert(0, ("Studios", "Studios", None))
			self._items.insert(0, ("HD", "%s/watch-hd-movies-online-free/page/" % self.baseurl, None))
			self._items.insert(0, ("Featured", "%s/watch-featured-movies-online-free/page/" % self.baseurl, None))
			self._items.insert(0, ("Clips & Scenes", "%s/watch-clips-scenes-porn-movies-online-free/page/" % self.baseurl, None))
			self._items.insert(0, ("Newest", "%s/movies/page/" % self.baseurl, None))
			self._items.insert(0, ("--- Search ---", "callSuchen", None))
		elif self.genre == "Categories":
			self._items.insert(0, ("Studios", "Studios", None))
			self._items.insert(0, ("Clips & Scenes", "%s/genre/clips-scenes/page/" % self.baseurl, None))
			self._items.insert(0, ("Newest", "%s/page/" % self.baseurl, None))
			self._items.insert(0, ("--- Search ---", "callSuchen", None))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.keyLocked = False
		self['name'].setText("")

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '+'))
			Name = self['liste'].getCurrent()[0][0]
			self.session.open(pandamovieListScreen, Link, Name, self.portal, self.baseurl)

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		if Name == "--- Search ---":
			self.suchen()
		else:
			Link = self['liste'].getCurrent()[0][1]
			if Name == "Studios" or Name == "Years":
				self.session.open(pandamovieGenreScreen, self.mode, Link)
			else:
				self.session.open(pandamovieListScreen, Link, Name, self.portal, self.baseurl)

class pandamovieListScreen(MPScreen):

	def __init__(self, session, Link, Name, portal, baseurl):
		self.Link = Link
		self.Name = Name
		self.portal = portal
		self.baseurl = baseurl

		global default_cover
		if self.portal == "PandaMovie":
			default_cover = "file://%s/pandamovie.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
		elif self.portal == "NetFlixPorno":
			default_cover = "file://%s/netflixporno.png" % (config_mp.mediaportal.iconcachepath.value + "logos")

		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label(self.portal)
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))

		self.keyLocked = True
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.page = 1
		self.lastpage = 1
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self['name'].setText(_("Please wait..."))
		self.keyLocked = True
		self._items = []
		if re.match(".*?Search", self.Name):
			if self.portal == "PandaMovie":
				url = "%s/page/%s?s=%s" % (self.baseurl, str(self.page), self.Link)
			elif self.portal == "NetFlixPorno":
				url = "%s/search/%s/page/%s" % (self.baseurl, self.Link, str(self.page))
		else:
			if self.page == 1 and self.Name == "Newest" and self.portal == "PandaMovie":
				url = self.Link + "0"
			else:
				url = self.Link + str(self.page)
		twAgentGetPage(url).addCallback(self.parseData).addErrback(self.dataError)

	def parseData(self, data):
		if "/director" in self.Link and self.portal == "PandaMovie":
			lastp = re.search('- Page \d+ of (\d+) -', data, re.S)
			if lastp:
				lastp = lastp.group(1)
				self.lastpage = int(lastp)
			else:
				self.lastpage = self.page + 1
			self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
		else:
			self.getLastPage(data, "(?:class='pagination'>|class=\"wp-pagenavi\">)(.*?)</div>", '.*[page\/|>]((?:\d+|)(?:,|)\d+)[\'|<]')
		raw = re.findall('class="ml-item.*?href="(.*?)".*?img\sdata-original="(.*?)".*?mli-info">(.*?)</span', data, re.S)
		if not raw:
			raw = re.findall('class="TPostMv.*?href="(.*?)".*?img.*?src="(.*?)".*?class="Title">(.*?)</div>', data, re.S)
		if raw:
			for (link, image, title) in raw:
				title = stripAllTags(title).strip()
				self._items.append((decodeHtml(title), link, image))
			self._setList('_defaultlistleft', True)
			self.ml.moveToIndex(0)
		if len(self._items) == 0:
			self._items.append((_('No movies found!'), None, None))
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		self['name'].setText(title)
		coverUrl = self['liste'].getCurrent()[0][2]
		CoverHelper(self['coverArt']).getCover(coverUrl)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][0]
		if Link:
			Title = self['liste'].getCurrent()[0][1]
			Cover = self['liste'].getCurrent()[0][2]
			self.session.open(StreamAuswahl, Link, Title, Cover, self.portal)

class StreamAuswahl(MPScreen):

	def __init__(self, session, Title, Link, Cover, portal):
		self.Link = Link
		self.Title = Title
		self.Cover = Cover
		self.portal = portal
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok"	: self.keyOK,
			"0" : self.closeAll,
			"cancel": self.keyCancel
		}, -1)

		self['title'] = Label(self.portal)
		self['ContentTitle'] = Label("%s" %self.Title)
		self['name'] = Label(_("Please wait..."))

		self._items = []
		self.keyLocked = True
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml
		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		CoverHelper(self['coverArt']).getCover(self.Cover)
		self.keyLocked = True
		url = self.Link
		twAgentGetPage(url).addCallback(self.loadPageData).addErrback(self.dataError)

	def loadPageData(self, data):
		parse = re.search('div id="pettabs">(.*?)</div', data, re.S)
		streams = re.findall('href=[\'|"](http[s]?://(?!(pandamovie.\w+|pandanetwork.\w+))(.*?)\/.*?)[\'|"|\&|<]', parse.group(1), re.S|re.I)
		if streams:
			for (stream, dummy, hostername) in streams:
				check = isSupportedHoster(hostername)
				if check:
					self._items.append((check, stream))
			# remove duplicates
			self._items = list(set(self._items))
		if len(self._items) == 0:
			self._items.append((_('No supported streams found!'), None))
		self.ml.setList(list(map(self._defaultlisthoster, self._items)))
		self.keyLocked = False
		self['name'].setText("")

	def keyOK(self):
		if self.keyLocked:
			return
		url = self['liste'].getCurrent()[0][1]
		if url:
			if ".pandanetwork.club" in url:
				tw_agent_hlp = TwAgentHelper()
				tw_agent_hlp.getRedirectedUrl(url).addCallback(self.getStream).addErrback(self.dataError)
			else:
				get_stream_link(self.session).check_link(url, self.got_link)

	def getStream(self, url):
		get_stream_link(self.session).check_link(url, self.got_link)

	def got_link(self, stream_url):
		title = self.Title
		self.session.open(SimplePlayer, [(self.Title, stream_url, self.Cover)], showPlaylist=False, ltype='pandamovie', cover=True)