﻿# -*- coding: utf-8 -*-
from future import standard_library
standard_library.install_aliases()
from builtins import map
from ...plugin import _
from ...resources.imports import *

agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36'
default_cover = "file://%s/absoluporn.png" % (config_mp.mediaportal.iconcachepath.value + "logos")
cookies = CookieJar()

class absolupornGenreScreen(MPScreen):

	def __init__(self, session):
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel
		}, -1)

		self['title'] = Label("AbsoluPorn.com")
		self['ContentTitle'] = Label("Genre:")
		self.keyLocked = True
		self.suchString = ''

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.layoutFinished)

	def layoutFinished(self):
		self.keyLocked = True
		url = "http://www.absoluporn.com/en/lettre-tag.html"
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		parse = re.search('class="bloc-menu-gauche(.*?)All tags</a>', data, re.S)
		if parse:
			Cats = re.findall('<a\shref="(.*?)"\sclass="link1b">(.*?)</a', parse.group(1), re.S)
			if Cats:
				for (Url, Title) in Cats:
					Url = "http://www.absoluporn.com" + Url.replace('..', '')
					Url = Url.replace('-1.html', '-$$PAGE$$.html')
					Title = Title.replace('Actrices fr', 'French Actresses')
					Title = upperString(Title)
					self._items.append((Title, Url))
		self._items.sort()
		self._items.insert(0, ("Random", "http://www.absoluporn.com/en/wall-random-1.html", default_cover))
		self._items.insert(0, ("Longest", "http://www.absoluporn.com/en/wall-time-$$PAGE$$.html", default_cover))
		self._items.insert(0, ("Top Rated", "http://www.absoluporn.com/en/wall-note-$$PAGE$$.html", default_cover))
		self._items.insert(0, ("Most Viewed", "http://www.absoluporn.com/en/wall-main-$$PAGE$$.html", default_cover))
		self._items.insert(0, ("Newest", "http://www.absoluporn.com/en/wall-date-$$PAGE$$.html", default_cover))
		self._items.insert(0, ("--- Search ---", "callSuchen", default_cover))
		self.ml.setList(list(map(self._defaultlistcenter, self._items)))
		self.ml.moveToIndex(0)
		self.keyLocked = False

	def keyOK(self):
		if self.keyLocked:
			return
		Name = self['liste'].getCurrent()[0][0]
		Link = self['liste'].getCurrent()[0][1]
		if Name == "--- Search ---":
			self.suchen()
		else:
			self.session.open(absolupornFilmScreen, Link, Name)

	def SuchenCallback(self, callback = None):
		if callback is not None and len(callback):
			Name = "--- Search ---"
			self.suchString = callback
			Link = urllib.parse.quote(self.suchString.replace(' ', '%20'))
			self.session.open(absolupornFilmScreen, Link, Name)

class absolupornFilmScreen(MPScreen):

	def __init__(self, session, Link, Name):
		self.Link = Link
		self.Name = Name
		MPScreen.__init__(self, session, skin='MP_Plugin', default_cover=default_cover)

		self["actions"] = ActionMap(["MP_Actions"], {
			"ok" : self.keyOK,
			"0" : self.closeAll,
			"cancel" : self.keyCancel,
			"up" : self.keyUp,
			"down" : self.keyDown,
			"right" : self.keyRight,
			"left" : self.keyLeft,
			"nextBouquet" : self.keyPageUp,
			"prevBouquet" : self.keyPageDown,
			"green" : self.keyPageNumber
		}, -1)

		self['title'] = Label("AbsoluPorn.com")
		self['ContentTitle'] = Label("Genre: %s" % self.Name)
		self['F2'] = Label(_("Page"))

		self['Page'] = Label(_("Page:"))
		self.keyLocked = True
		self.page = 1
		self.lastpage = 1

		self._items = []
		self.ml = MenuList([], enableWrapAround=True, content=eListboxPythonMultiContent)
		self['liste'] = self.ml

		self.onLayoutFinish.append(self.loadPage)

	def loadPage(self):
		self.keyLocked = True
		self['name'].setText(_('Please wait...'))
		self._items = []
		if re.match(".*Search", self.Name):
			url = "http://www.absoluporn.com/en/search-%s-$$PAGE$$.html" % self.Link
			url = url.replace('$$PAGE$$', str(self.page))
		else:
			url = self.Link.replace('$$PAGE$$', str(self.page))
		twAgentGetPage(url, agent=agent, cookieJar=cookies).addCallback(self.genreData).addErrback(self.dataError)

	def genreData(self, data):
		lastp = re.search('&nbsp;on&nbsp;(\d+)&nbsp;videos', data, re.S)
		if lastp:
			lastp = lastp.group(1)
			cat = self.Link
			lastp = round((float(lastp) / 60) + 0.5)
			self.lastpage = int(lastp)
			self['page'].setText(str(self.page) + ' / ' + str(self.lastpage))
		else:
			self.getLastPage(data, 'class="pagination">(.*?)class="bloc-thumb')
		Movies = re.findall(' class="thumb-main">.*?href="(.*?)".*?title="(.*?)".*?<img.*?src="(.*?)".*?class="time">(.*?)</div>', data, re.S)
		if Movies:
			for (Url, Title, Image, Runtime) in Movies:
				Url = "http://www.absoluporn.com" + Url.replace('..', '').replace(' ', '%20')
				self._items.append((decodeHtml(Title), Url, Image, Runtime))
		if len(self._items) == 0:
			self._items.append((_('No videos found!'), None, None, ''))
		self._setList('_defaultlistleft', True)
		self.ml.moveToIndex(0)
		self.keyLocked = False
		self.showInfos()

	def showInfos(self):
		title = self['liste'].getCurrent()[0][0]
		url = self['liste'].getCurrent()[0][1]
		pic = self['liste'].getCurrent()[0][2]
		runtime = self['liste'].getCurrent()[0][3]
		self['name'].setText(title)
		self['handlung'].setText("Runtime: %s" % runtime)
		CoverHelper(self['coverArt']).getCover(pic)

	def keyOK(self):
		if self.keyLocked:
			return
		Link = self['liste'].getCurrent()[0][1]
		if Link:
			twAgentGetPage(Link, cookieJar=cookies, agent=agent).addCallback(self.parseVideo).addErrback(self.dataError)

	def parseVideo(self, data):
		streams = re.findall('<source src="(.*?)"', data, re.S)
		if streams:
			Title = self['liste'].getCurrent()[0][0]
			self.session.open(SimplePlayer, [(Title, streams[-1])], showPlaylist=False, ltype='absoluporn')