#!/bin/sh
CAM="mgcamd_1.35a"
OSD="MGcamd 1.35a"
PID=`pidof $CAM`
Action=$1

cam_clean () {
		rm -rf /tmp/*.info*	/tmp/*.tmp*
}

cam_handle () {
		if test	-z "${PID}"	; then
				cam_up;
		else
				cam_down;
		fi;
}

cam_down ()	{
		killall	$CAM
		sleep 2
		cam_clean
}

cam_up () {
		/usr/bin/cam/$CAM &
}

if test	"$Action" =	"cam_startup" ;	then
	if test	-z "${PID}" ; then
		cam_down
		cam_up
	else
		echo "$CAM already running, exiting..."
	fi
elif test	"$Action" =	"cam_res" ;	then
		cam_down
		cam_up
elif test "$Action"	= "cam_down" ; then
		cam_down
elif test "$Action"	= "cam_up" ; then
		cam_up
else
		cam_handle
fi

exit 0
