# -*- coding: utf-8 -*-
#------------------------------------------------------------
# streamondemand - XBMC Plugin
# Conector para streame
# http://www.mimediacenter.info/foro/viewforum.php?f=36
#------------------------------------------------------------

import re

from core import logger
from core import scrapertools

def test_video_exists( page_url ):
    logger.info("streamondemand.servers.streame test_video_exists(page_url='%s')" % page_url)
    
    data = scrapertools.cache_page( page_url )
    if ("File was deleted" or "Not Found") in data: return False, "[Streame] El archivo no existe o ha sido borrado"

    return True,""

def get_video_url( page_url , premium = False , user="" , password="", video_password="" ):
    logger.info("streamondemand.servers.streame url="+page_url)
    
    data = scrapertools.cache_page( page_url )
    media_urls = scrapertools.find_multiple_matches(data,'\{file:"([^"]+)",label:"([^"]+)"\}')
    video_urls = []
    for media_url, label in media_urls:
        video_urls.append( [ scrapertools.get_filename_from_url(media_url)[-4:]+" ("+label+") [streame]",media_url])

    for video_url in video_urls:
        logger.info("streamondemand.servers.streame %s - %s" % (video_url[0],video_url[1]))

    return video_urls

# Encuentra vídeos del servidor en el texto pasado
def find_videos(data):
    encontrados = set()
    devuelve = []

    # http://streame.net/jdfscsa5uoy4
    patronvideos  = "streame.net/(?:embed-|)([a-z0-9]+)"
    logger.info("streamondemand.servers.streame find_videos #"+patronvideos+"#")
    matches = re.compile(patronvideos,re.DOTALL).findall(data)

    for match in matches:
        titulo = "[streame]"
        url = "http://streame.net/embed-%s.html" % match
        if url not in encontrados:
            logger.info("  url="+url)
            devuelve.append( [ titulo , url , 'streame' ] )
            encontrados.add(url)
        else:
            logger.info("  url duplicada="+url)

    return devuelve